/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.abi;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.abi.tools.api.v2.KlibTarget;
import org.jetbrains.kotlin.gradle.tasks.abi.KotlinLegacyAbiCheckTaskImpl;
import org.jetbrains.kotlin.gradle.tasks.abi.KotlinLegacyAbiDumpTaskImpl;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0010J\u000e\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u0014\u0010\u0016\u001a\u00020\r2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018J\u0014\u0010\u001a\u001a\u00020\r2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018J\u000e\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/abi/AbiValidationTaskSet;", "", "project", "Lorg/gradle/api/Project;", "variantName", "", "(Lorg/gradle/api/Project;Ljava/lang/String;)V", "legacyCheckDumpTaskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "Lorg/jetbrains/kotlin/gradle/tasks/abi/KotlinLegacyAbiCheckTaskImpl;", "legacyDumpTaskProvider", "Lorg/jetbrains/kotlin/gradle/tasks/abi/KotlinLegacyAbiDumpTaskImpl;", "addJvmTarget", "", "targetName", "classfiles", "Lorg/gradle/api/file/FileCollection;", "addKlibTarget", "klibTarget", "Lorg/jetbrains/kotlin/abi/tools/api/v2/KlibTarget;", "klibFiles", "addSingleJvmTarget", "keepUnsupportedTargets", "keep", "Lorg/gradle/api/provider/Provider;", "", "klibEnabled", "isEnabled", "setClasspath", "toolClasspath", "Lorg/gradle/api/artifacts/Configuration;", "unsupportedTarget", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nAbiValidationTaskSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbiValidationTaskSet.kt\norg/jetbrains/kotlin/gradle/plugin/abi/AbiValidationTaskSet\n+ 2 ObjectCollectionExt.kt\norg/jetbrains/kotlin/gradle/utils/ObjectCollectionExtKt\n*L\n1#1,100:1\n20#2:101\n20#2:102\n*S KotlinDebug\n*F\n+ 1 AbiValidationTaskSet.kt\norg/jetbrains/kotlin/gradle/plugin/abi/AbiValidationTaskSet\n*L\n24#1:101\n26#1:102\n*E\n"})
public final class AbiValidationTaskSet {
    @NotNull
    private final TaskProvider<KotlinLegacyAbiDumpTaskImpl> legacyDumpTaskProvider;
    @NotNull
    private final TaskProvider<KotlinLegacyAbiCheckTaskImpl> legacyCheckDumpTaskProvider;

    public AbiValidationTaskSet(@NotNull Project project, @NotNull String variantName) {
        TaskCollection $this$named$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        TaskContainer taskContainer = project.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
        TaskCollection taskCollection = (TaskCollection)taskContainer;
        String name$iv = KotlinLegacyAbiDumpTaskImpl.Companion.nameForVariant(variantName);
        boolean $i$f$named = false;
        TaskProvider taskProvider2 = $this$named$iv.named(name$iv, KotlinLegacyAbiDumpTaskImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider2, (String)"this as TaskCollection<T\u2026amed(name, T::class.java)");
        this.legacyDumpTaskProvider = taskProvider2;
        TaskContainer taskContainer2 = project.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer2, (String)"project.tasks");
        $this$named$iv = (TaskCollection)taskContainer2;
        name$iv = KotlinLegacyAbiCheckTaskImpl.Companion.nameForVariant(variantName);
        $i$f$named = false;
        TaskProvider taskProvider3 = $this$named$iv.named(name$iv, KotlinLegacyAbiCheckTaskImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider3, (String)"this as TaskCollection<T\u2026amed(name, T::class.java)");
        this.legacyCheckDumpTaskProvider = taskProvider3;
    }

    public final void addSingleJvmTarget(@NotNull FileCollection classfiles2) {
        Intrinsics.checkNotNullParameter((Object)classfiles2, (String)"classfiles");
        this.legacyDumpTaskProvider.configure(new Action(classfiles2){
            final /* synthetic */ FileCollection $classfiles;
            {
                this.$classfiles = $classfiles;
            }

            public final void execute(KotlinLegacyAbiDumpTaskImpl it) {
                it.getJvm().add((Object)new KotlinLegacyAbiDumpTaskImpl.JvmTargetInfo("", this.$classfiles));
            }
        });
    }

    public final void addJvmTarget(@NotNull String targetName, @NotNull FileCollection classfiles2) {
        Intrinsics.checkNotNullParameter((Object)targetName, (String)"targetName");
        Intrinsics.checkNotNullParameter((Object)classfiles2, (String)"classfiles");
        this.legacyDumpTaskProvider.configure(new Action(targetName, classfiles2){
            final /* synthetic */ String $targetName;
            final /* synthetic */ FileCollection $classfiles;
            {
                this.$targetName = $targetName;
                this.$classfiles = $classfiles;
            }

            public final void execute(KotlinLegacyAbiDumpTaskImpl it) {
                it.getJvm().add((Object)new KotlinLegacyAbiDumpTaskImpl.JvmTargetInfo(this.$targetName, this.$classfiles));
            }
        });
    }

    public final void addKlibTarget(@NotNull KlibTarget klibTarget, @NotNull FileCollection klibFiles) {
        Intrinsics.checkNotNullParameter((Object)klibTarget, (String)"klibTarget");
        Intrinsics.checkNotNullParameter((Object)klibFiles, (String)"klibFiles");
        this.legacyDumpTaskProvider.configure(new Action(klibTarget, klibFiles){
            final /* synthetic */ KlibTarget $klibTarget;
            final /* synthetic */ FileCollection $klibFiles;
            {
                this.$klibTarget = $klibTarget;
                this.$klibFiles = $klibFiles;
            }

            public final void execute(KotlinLegacyAbiDumpTaskImpl it) {
                it.getKlibInput().add((Object)new KotlinLegacyAbiDumpTaskImpl.KlibTargetInfo(this.$klibTarget.getConfigurableName(), this.$klibTarget.getTargetName(), this.$klibFiles));
            }
        });
    }

    public final void keepUnsupportedTargets(@NotNull Provider<Boolean> keep) {
        Intrinsics.checkNotNullParameter(keep, (String)"keep");
        this.legacyDumpTaskProvider.configure(new Action(keep){
            final /* synthetic */ Provider<Boolean> $keep;
            {
                this.$keep = $keep;
            }

            public final void execute(KotlinLegacyAbiDumpTaskImpl it) {
                it.getKeepUnsupportedTargets().set(this.$keep);
            }
        });
    }

    public final void klibEnabled(@NotNull Provider<Boolean> isEnabled) {
        Intrinsics.checkNotNullParameter(isEnabled, (String)"isEnabled");
        this.legacyDumpTaskProvider.configure(new Action(isEnabled){
            final /* synthetic */ Provider<Boolean> $isEnabled;
            {
                this.$isEnabled = $isEnabled;
            }

            public final void execute(KotlinLegacyAbiDumpTaskImpl it) {
                it.getKlibIsEnabled().set(this.$isEnabled);
            }
        });
    }

    public final void unsupportedTarget(@NotNull KlibTarget klibTarget) {
        Intrinsics.checkNotNullParameter((Object)klibTarget, (String)"klibTarget");
        this.legacyDumpTaskProvider.configure(new Action(klibTarget){
            final /* synthetic */ KlibTarget $klibTarget;
            {
                this.$klibTarget = $klibTarget;
            }

            public final void execute(KotlinLegacyAbiDumpTaskImpl it) {
                it.getUnsupportedTargets().add((Object)this.$klibTarget);
            }
        });
    }

    public final void setClasspath(@NotNull Configuration toolClasspath) {
        Intrinsics.checkNotNullParameter((Object)toolClasspath, (String)"toolClasspath");
        this.legacyDumpTaskProvider.configure(new Action(toolClasspath){
            final /* synthetic */ Configuration $toolClasspath;
            {
                this.$toolClasspath = $toolClasspath;
            }

            public final void execute(KotlinLegacyAbiDumpTaskImpl it) {
                Object[] objectArray = new Object[]{this.$toolClasspath};
                it.getToolsClasspath().from(objectArray);
            }
        });
        this.legacyCheckDumpTaskProvider.configure(new Action(toolClasspath){
            final /* synthetic */ Configuration $toolClasspath;
            {
                this.$toolClasspath = $toolClasspath;
            }

            public final void execute(KotlinLegacyAbiCheckTaskImpl it) {
                Object[] objectArray = new Object[]{this.$toolClasspath};
                it.getToolsClasspath().from(objectArray);
            }
        });
    }
}

