/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.org.objectweb.asm.util;

import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.util.CheckMethodAdapter;

public class CheckAnnotationAdapter
extends AnnotationVisitor {
    private final boolean useNamedValue;
    private boolean visitEndCalled;

    public CheckAnnotationAdapter(AnnotationVisitor annotationVisitor) {
        this(annotationVisitor, true);
    }

    CheckAnnotationAdapter(AnnotationVisitor annotationVisitor, boolean useNamedValues) {
        super(589824, annotationVisitor);
        this.useNamedValue = useNamedValues;
    }

    public void visit(String name2, Object value2) {
        this.checkVisitEndNotCalled();
        this.checkName(name2);
        if (!(value2 instanceof Byte || value2 instanceof Boolean || value2 instanceof Character || value2 instanceof Short || value2 instanceof Integer || value2 instanceof Long || value2 instanceof Float || value2 instanceof Double || value2 instanceof String || value2 instanceof Type || value2 instanceof byte[] || value2 instanceof boolean[] || value2 instanceof char[] || value2 instanceof short[] || value2 instanceof int[] || value2 instanceof long[] || value2 instanceof float[] || value2 instanceof double[])) {
            throw new IllegalArgumentException("Invalid annotation value");
        }
        if (value2 instanceof Type && ((Type)value2).getSort() == 11) {
            throw new IllegalArgumentException("Invalid annotation value");
        }
        super.visit(name2, value2);
    }

    public void visitEnum(String name2, String descriptor2, String value2) {
        this.checkVisitEndNotCalled();
        this.checkName(name2);
        CheckMethodAdapter.checkDescriptor(49, descriptor2, false);
        if (value2 == null) {
            throw new IllegalArgumentException("Invalid enum value");
        }
        super.visitEnum(name2, descriptor2, value2);
    }

    public AnnotationVisitor visitAnnotation(String name2, String descriptor2) {
        this.checkVisitEndNotCalled();
        this.checkName(name2);
        CheckMethodAdapter.checkDescriptor(49, descriptor2, false);
        return new CheckAnnotationAdapter(super.visitAnnotation(name2, descriptor2));
    }

    public AnnotationVisitor visitArray(String name2) {
        this.checkVisitEndNotCalled();
        this.checkName(name2);
        return new CheckAnnotationAdapter(super.visitArray(name2), false);
    }

    public void visitEnd() {
        this.checkVisitEndNotCalled();
        this.visitEndCalled = true;
        super.visitEnd();
    }

    private void checkName(String name2) {
        if (this.useNamedValue && name2 == null) {
            throw new IllegalArgumentException("Annotation value name must not be null");
        }
    }

    private void checkVisitEndNotCalled() {
        if (this.visitEndCalled) {
            throw new IllegalStateException("Cannot call a visit method after visitEnd has been called");
        }
    }
}

