/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.hash;

import java.lang.reflect.Field;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.jetbrains.kotlin.com.google.common.hash.ElementTypesAreNonnullByDefault;
import org.jetbrains.kotlin.com.google.common.primitives.Longs;
import sun.misc.Unsafe;

@ElementTypesAreNonnullByDefault
final class LittleEndianByteArray {
    private static final LittleEndianBytes byteArray;

    static long load64(byte[] input, int offset) {
        assert (input.length >= offset + 8);
        return byteArray.getLongLittleEndian(input, offset);
    }

    static long load64Safely(byte[] input, int offset, int length) {
        long result2 = 0L;
        int limit = Math.min(length, 8);
        for (int i2 = 0; i2 < limit; ++i2) {
            result2 |= ((long)input[offset + i2] & 0xFFL) << i2 * 8;
        }
        return result2;
    }

    static void store64(byte[] sink, int offset, long value2) {
        assert (offset >= 0 && offset + 8 <= sink.length);
        byteArray.putLongLittleEndian(sink, offset, value2);
    }

    static int load32(byte[] source2, int offset) {
        return source2[offset] & 0xFF | (source2[offset + 1] & 0xFF) << 8 | (source2[offset + 2] & 0xFF) << 16 | (source2[offset + 3] & 0xFF) << 24;
    }

    static boolean usingUnsafe() {
        return byteArray instanceof UnsafeByteArray;
    }

    private LittleEndianByteArray() {
    }

    static {
        Enum theGetter = JavaLittleEndianBytes.INSTANCE;
        try {
            String arch = System.getProperty("os.arch");
            if ("amd64".equals(arch) || "aarch64".equals(arch)) {
                theGetter = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN) ? UnsafeByteArray.UNSAFE_LITTLE_ENDIAN : UnsafeByteArray.UNSAFE_BIG_ENDIAN;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        byteArray = theGetter;
    }

    private static interface LittleEndianBytes {
        public long getLongLittleEndian(byte[] var1, int var2);

        public void putLongLittleEndian(byte[] var1, int var2, long var3);
    }

    private static enum UnsafeByteArray implements LittleEndianBytes
    {
        UNSAFE_LITTLE_ENDIAN{

            @Override
            public long getLongLittleEndian(byte[] array2, int offset) {
                return theUnsafe.getLong(array2, (long)offset + (long)BYTE_ARRAY_BASE_OFFSET);
            }

            @Override
            public void putLongLittleEndian(byte[] array2, int offset, long value2) {
                theUnsafe.putLong(array2, (long)offset + (long)BYTE_ARRAY_BASE_OFFSET, value2);
            }
        }
        ,
        UNSAFE_BIG_ENDIAN{

            @Override
            public long getLongLittleEndian(byte[] array2, int offset) {
                long bigEndian = theUnsafe.getLong(array2, (long)offset + (long)BYTE_ARRAY_BASE_OFFSET);
                return Long.reverseBytes(bigEndian);
            }

            @Override
            public void putLongLittleEndian(byte[] array2, int offset, long value2) {
                long littleEndianValue = Long.reverseBytes(value2);
                theUnsafe.putLong(array2, (long)offset + (long)BYTE_ARRAY_BASE_OFFSET, littleEndianValue);
            }
        };

        private static final Unsafe theUnsafe;
        private static final int BYTE_ARRAY_BASE_OFFSET;

        private static Unsafe getUnsafe() {
            try {
                return Unsafe.getUnsafe();
            }
            catch (SecurityException securityException) {
                try {
                    return AccessController.doPrivileged(() -> {
                        Class<Unsafe> k = Unsafe.class;
                        for (Field f : k.getDeclaredFields()) {
                            f.setAccessible(true);
                            Object x = f.get(null);
                            if (!k.isInstance(x)) continue;
                            return (Unsafe)k.cast(x);
                        }
                        throw new NoSuchFieldError("the Unsafe");
                    });
                }
                catch (PrivilegedActionException e) {
                    throw new RuntimeException("Could not initialize intrinsics", e.getCause());
                }
            }
        }

        static {
            theUnsafe = UnsafeByteArray.getUnsafe();
            BYTE_ARRAY_BASE_OFFSET = theUnsafe.arrayBaseOffset(byte[].class);
            if (theUnsafe.arrayIndexScale(byte[].class) != 1) {
                throw new AssertionError();
            }
        }
    }

    private static enum JavaLittleEndianBytes implements LittleEndianBytes
    {
        INSTANCE{

            @Override
            public long getLongLittleEndian(byte[] source2, int offset) {
                return Longs.fromBytes(source2[offset + 7], source2[offset + 6], source2[offset + 5], source2[offset + 4], source2[offset + 3], source2[offset + 2], source2[offset + 1], source2[offset]);
            }

            @Override
            public void putLongLittleEndian(byte[] sink, int offset, long value2) {
                long mask = 255L;
                for (int i2 = 0; i2 < 8; ++i2) {
                    sink[offset + i2] = (byte)((value2 & mask) >> i2 * 8);
                    mask <<= 8;
                }
            }
        };

    }
}

