/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.logging;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.buildtools.api.KotlinLogger;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0016J\u001a\u0010\u000e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0016J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0016J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u001a\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/gradle/logging/GradleKotlinLogger;", "Lorg/jetbrains/kotlin/buildtools/api/KotlinLogger;", "log", "Lorg/gradle/api/logging/Logger;", "prefix", "", "addLevelAsPrefix", "", "(Lorg/gradle/api/logging/Logger;Ljava/lang/String;Z)V", "isDebugEnabled", "()Z", "debug", "", "msg", "error", "throwable", "", "info", "lifecycle", "transformMessage", "warn", "kotlin-gradle-plugin_common"})
public final class GradleKotlinLogger
implements KotlinLogger {
    @NotNull
    private final Logger log;
    @Nullable
    private final String prefix;
    private final boolean addLevelAsPrefix;

    public GradleKotlinLogger(@NotNull Logger log, @Nullable String prefix, boolean addLevelAsPrefix) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this.log = log;
        this.prefix = prefix;
        this.addLevelAsPrefix = addLevelAsPrefix;
    }

    public /* synthetic */ GradleKotlinLogger(Logger logger2, String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        this(logger2, string, bl);
    }

    private final String transformMessage(String msg) {
        CharSequence charSequence = this.prefix;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return msg;
        }
        return this.prefix + msg;
    }

    public void debug(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        String payload = this.addLevelAsPrefix ? "v: " + msg : msg;
        this.log.debug(this.transformMessage(payload));
    }

    public void error(@NotNull String msg, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        String payload = this.addLevelAsPrefix ? "e: " + msg : msg;
        this.log.error(this.transformMessage(payload), throwable);
    }

    public void info(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        String payload = this.addLevelAsPrefix ? "i: " + msg : msg;
        this.log.info(this.transformMessage(payload));
    }

    public void warn(@NotNull String msg, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        String payload = this.addLevelAsPrefix ? "w: " + msg : msg;
        this.log.warn(this.transformMessage(payload), throwable);
    }

    public void lifecycle(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.log.lifecycle(this.transformMessage(msg));
    }

    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }
}

