/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.mpp.apple.swiftexport.internal;

import java.io.File;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.mpp.apple.SerializationTools;
import org.jetbrains.kotlin.gradle.plugin.mpp.apple.swiftexport.internal.GradleSwiftExportModules;
import org.jetbrains.kotlin.gradle.plugin.mpp.apple.swiftexport.internal.SwiftExportAction;
import org.jetbrains.kotlin.gradle.plugin.mpp.apple.swiftexport.internal.SwiftExportActionKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.apple.swiftexport.internal.SwiftExportTaskParameters;
import org.jetbrains.kotlin.gradle.plugin.mpp.apple.swiftexport.internal.SwiftExportedModule;
import org.jetbrains.kotlin.gradle.utils.FileUtilsKt;
import org.jetbrains.kotlin.konan.target.Distribution;
import org.jetbrains.kotlin.konan.target.KonanTarget;
import org.jetbrains.kotlin.swiftexport.standalone.InputModule;
import org.jetbrains.kotlin.swiftexport.standalone.SwiftExportLogger;
import org.jetbrains.kotlin.swiftexport.standalone.SwiftExportRunnerKt;
import org.jetbrains.kotlin.swiftexport.standalone.config.SwiftExportConfig;
import org.jetbrains.kotlin.swiftexport.standalone.config.SwiftModuleConfig;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000=\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002*\u0001\u0005\b \u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0003J.\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0010\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/apple/swiftexport/internal/SwiftExportAction;", "Lorg/gradle/workers/WorkAction;", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/apple/swiftexport/internal/SwiftExportAction$SwiftExportWorkParameters;", "()V", "swiftExportLogger", "org/jetbrains/kotlin/gradle/plugin/mpp/apple/swiftexport/internal/SwiftExportAction$swiftExportLogger$1", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/apple/swiftexport/internal/SwiftExportAction$swiftExportLogger$1;", "createModuleConfig", "Lorg/jetbrains/kotlin/swiftexport/standalone/config/SwiftModuleConfig;", "flattenPackage", "", "shouldBeFullyExported", "", "settings", "", "createSwiftExportConfig", "Lorg/jetbrains/kotlin/swiftexport/standalone/config/SwiftExportConfig;", "execute", "", "SwiftExportWorkParameters", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nSwiftExportAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwiftExportAction.kt\norg/jetbrains/kotlin/gradle/plugin/mpp/apple/swiftexport/internal/SwiftExportAction\n+ 2 SerializationTools.kt\norg/jetbrains/kotlin/gradle/plugin/mpp/apple/SerializationTools\n*L\n1#1,121:1\n30#2:122\n*S KotlinDebug\n*F\n+ 1 SwiftExportAction.kt\norg/jetbrains/kotlin/gradle/plugin/mpp/apple/swiftexport/internal/SwiftExportAction\n*L\n59#1:122\n*E\n"})
public abstract class SwiftExportAction
implements WorkAction<SwiftExportWorkParameters> {
    @NotNull
    private final swiftExportLogger.1 swiftExportLogger = new SwiftExportLogger(){
        private final Logger logger;
        {
            this.logger = Logger.getLogger(this.getClass().getName());
        }

        public void report(SwiftExportLogger.Severity severity, String message2) {
            Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            this.logger.log(this.logType(severity), message2);
        }

        private final Level logType(SwiftExportLogger.Severity $this$logType) {
            Level level;
            switch (swiftExportLogger.WhenMappings.$EnumSwitchMapping$0[$this$logType.ordinal()]) {
                case 1: {
                    Level level2 = Level.INFO;
                    level = level2;
                    Intrinsics.checkNotNullExpressionValue((Object)level2, (String)"INFO");
                    break;
                }
                case 2: {
                    Level level3 = Level.WARNING;
                    level = level3;
                    Intrinsics.checkNotNullExpressionValue((Object)level3, (String)"WARNING");
                    break;
                }
                case 3: {
                    Level level4 = Level.SEVERE;
                    level = level4;
                    Intrinsics.checkNotNullExpressionValue((Object)level4, (String)"SEVERE");
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return level;
        }
    };

    public void execute() {
        MapProperty<String, String> exportSettings = ((SwiftExportWorkParameters)this.getParameters()).getSwiftExportSettings();
        Set exportModules2 = (Set)((SwiftExportWorkParameters)this.getParameters()).getSwiftModules().zip((Provider)exportSettings, new BiFunction(this){
            final /* synthetic */ SwiftExportAction this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public final Set<InputModule> apply(List<SwiftExportedModule> modules2, Map<String, String> settings) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullExpressionValue(modules2, (String)"modules");
                Iterable iterable = modules2;
                SwiftExportAction swiftExportAction = this.this$0;
                boolean $i$f$map = false;
                void var6_6 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void module2;
                    SwiftExportedModule swiftExportedModule = (SwiftExportedModule)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"module");
                    String string = module2.getFlattenPackage();
                    boolean bl2 = module2.getShouldBeFullyExported();
                    Intrinsics.checkNotNullExpressionValue(settings, (String)"settings");
                    collection.add(SwiftExportActionKt.access$toInputModule((SwiftExportedModule)module2, SwiftExportAction.access$createModuleConfig(swiftExportAction, string, bl2, settings)));
                }
                return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            }
        }).get();
        Intrinsics.checkNotNullExpressionValue((Object)exportModules2, (String)"exportModules");
        Object object = SwiftExportRunnerKt.runSwiftExport((Set)exportModules2, (SwiftExportConfig)this.createSwiftExportConfig());
        ResultKt.throwOnFailure((Object)object);
        GradleSwiftExportModules modules2 = new GradleSwiftExportModules(SwiftExportActionKt.toPlainList((Set)object), Instant.now().toEpochMilli());
        SerializationTools this_$iv = SerializationTools.INSTANCE;
        boolean $i$f$writeToJson = false;
        String string = SerializationTools.access$getGson(this_$iv).toJson(modules2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gson.toJson(objects)");
        String json = string;
        FilesKt.writeText$default((File)FileUtilsKt.getFile((Provider<RegularFile>)((Provider)((SwiftExportWorkParameters)this.getParameters()).getSwiftModulesFile())), (String)json, null, (int)2, null);
    }

    private final SwiftModuleConfig createModuleConfig(String flattenPackage, boolean shouldBeFullyExported, Map<String, String> settings) {
        Object object = ((SwiftExportWorkParameters)this.getParameters()).getBridgeModuleName().getOrElse((Object)"KotlinBridges");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.bridgeModuleN\u2026FAULT_BRIDGE_MODULE_NAME)");
        return new SwiftModuleConfig((String)object, flattenPackage, null, settings, shouldBeFullyExported, 4, null);
    }

    private final SwiftExportConfig createSwiftExportConfig() {
        Path path = FileUtilsKt.getDirectoryAsFile((Provider<Directory>)((Provider)((SwiftExportWorkParameters)this.getParameters()).getOutputPath())).toPath();
        Boolean bl = (Boolean)((SwiftExportWorkParameters)this.getParameters()).getStableDeclarationsOrder().getOrElse((Object)true);
        Distribution distribution2 = (Distribution)((SwiftExportWorkParameters)this.getParameters()).getKonanDistribution().get();
        Boolean bl2 = (Boolean)((SwiftExportWorkParameters)this.getParameters()).getRenderDocComments().getOrElse((Object)false);
        swiftExportLogger.1 var5_5 = this.swiftExportLogger;
        KonanTarget konanTarget2 = (KonanTarget)((SwiftExportWorkParameters)this.getParameters()).getKonanTarget().get();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath()");
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"getOrElse(true)");
        boolean bl3 = bl;
        Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"getOrElse(false)");
        boolean bl4 = bl2;
        Intrinsics.checkNotNullExpressionValue((Object)distribution2, (String)"get()");
        Intrinsics.checkNotNullExpressionValue((Object)konanTarget2, (String)"get()");
        return new SwiftExportConfig(path, bl3, bl4, distribution2, konanTarget2, null, null, (SwiftExportLogger)var5_5, 96, null);
    }

    public static final /* synthetic */ SwiftModuleConfig access$createModuleConfig(SwiftExportAction $this, String flattenPackage, boolean shouldBeFullyExported, Map settings) {
        return $this.createModuleConfig(flattenPackage, shouldBeFullyExported, settings);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b`\u0018\u00002\u00020\u00012\u00020\u0002R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/apple/swiftexport/internal/SwiftExportAction$SwiftExportWorkParameters;", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/apple/swiftexport/internal/SwiftExportTaskParameters;", "Lorg/gradle/workers/WorkParameters;", "konanDistribution", "Lorg/gradle/api/provider/Property;", "Lorg/jetbrains/kotlin/konan/target/Distribution;", "getKonanDistribution", "()Lorg/gradle/api/provider/Property;", "kotlin-gradle-plugin_common"})
    public static interface SwiftExportWorkParameters
    extends SwiftExportTaskParameters,
    WorkParameters {
        @NotNull
        public Property<Distribution> getKonanDistribution();
    }
}

