/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.util.concurrency;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import org.jetbrains.kotlin.org.eclipse.aether.util.concurrency.RunnableErrorForwarder$$Lambda$0;

public final class RunnableErrorForwarder {
    private final Thread thread = Thread.currentThread();
    private final AtomicInteger counter = new AtomicInteger();
    private final AtomicReference<Throwable> error = new AtomicReference();

    public Runnable wrap(Runnable runnable) {
        Objects.requireNonNull(runnable, "runnable cannot be null");
        this.counter.incrementAndGet();
        Runnable runnable2 = runnable;
        RunnableErrorForwarder runnableErrorForwarder = this;
        return new RunnableErrorForwarder$$Lambda$0(runnableErrorForwarder, runnable2);
    }

    public void await() {
        this.awaitTerminationOfAllRunnables();
        Throwable error = this.error.get();
        if (error != null) {
            if (error instanceof RuntimeException) {
                throw (RuntimeException)error;
            }
            if (error instanceof ThreadDeath) {
                throw new IllegalStateException(error);
            }
            if (error instanceof Error) {
                throw (Error)error;
            }
            throw new IllegalStateException(error);
        }
    }

    private void awaitTerminationOfAllRunnables() {
        if (!this.thread.equals(Thread.currentThread())) {
            throw new IllegalStateException("wrong caller thread, expected " + this.thread + " and not " + Thread.currentThread());
        }
        boolean interrupted = false;
        while (this.counter.get() > 0) {
            LockSupport.park();
            if (!Thread.interrupted()) continue;
            interrupted = true;
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    private /* synthetic */ void lambda$wrap$0(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Error | RuntimeException e) {
            this.error.compareAndSet(null, e);
            throw e;
        }
        finally {
            this.counter.decrementAndGet();
            LockSupport.unpark(this.thread);
        }
    }

    static /* synthetic */ void accessor$RunnableErrorForwarder$lambda0(RunnableErrorForwarder runnableErrorForwarder, Runnable runnable) {
        runnableErrorForwarder.lambda$wrap$0(runnable);
    }
}

