/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmTypeFactoryImpl;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmPrimitiveType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JvmType {
    @NotNull
    private static final Primitive BOOLEAN;
    @NotNull
    private static final Primitive CHAR;
    @NotNull
    private static final Primitive BYTE;
    @NotNull
    private static final Primitive SHORT;
    @NotNull
    private static final Primitive INT;
    @NotNull
    private static final Primitive FLOAT;
    @NotNull
    private static final Primitive LONG;
    @NotNull
    private static final Primitive DOUBLE;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public String toString() {
        return JvmTypeFactoryImpl.INSTANCE.toString(this);
    }

    private JvmType() {
    }

    static {
        Companion = new Companion(null);
        BOOLEAN = new Primitive(JvmPrimitiveType.BOOLEAN);
        CHAR = new Primitive(JvmPrimitiveType.CHAR);
        BYTE = new Primitive(JvmPrimitiveType.BYTE);
        SHORT = new Primitive(JvmPrimitiveType.SHORT);
        INT = new Primitive(JvmPrimitiveType.INT);
        FLOAT = new Primitive(JvmPrimitiveType.FLOAT);
        LONG = new Primitive(JvmPrimitiveType.LONG);
        DOUBLE = new Primitive(JvmPrimitiveType.DOUBLE);
    }

    public /* synthetic */ JvmType(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    public static final class Primitive
    extends JvmType {
        @Nullable
        private final JvmPrimitiveType jvmPrimitiveType;

        @Nullable
        public final JvmPrimitiveType getJvmPrimitiveType() {
            return this.jvmPrimitiveType;
        }

        public Primitive(@Nullable JvmPrimitiveType jvmPrimitiveType) {
            super(null);
            this.jvmPrimitiveType = jvmPrimitiveType;
        }
    }

    public static final class Object
    extends JvmType {
        @NotNull
        private final String internalName;

        @NotNull
        public final String getInternalName() {
            return this.internalName;
        }

        public Object(@NotNull String internalName) {
            Intrinsics.checkNotNullParameter((java.lang.Object)internalName, (String)"internalName");
            super(null);
            this.internalName = internalName;
        }
    }

    public static final class Array
    extends JvmType {
        @NotNull
        private final JvmType elementType;

        @NotNull
        public final JvmType getElementType() {
            return this.elementType;
        }

        public Array(@NotNull JvmType elementType) {
            Intrinsics.checkNotNullParameter((java.lang.Object)elementType, (String)"elementType");
            super(null);
            this.elementType = elementType;
        }
    }

    public static final class Companion {
        @NotNull
        public final Primitive getBOOLEAN$descriptors_jvm() {
            return BOOLEAN;
        }

        @NotNull
        public final Primitive getCHAR$descriptors_jvm() {
            return CHAR;
        }

        @NotNull
        public final Primitive getBYTE$descriptors_jvm() {
            return BYTE;
        }

        @NotNull
        public final Primitive getSHORT$descriptors_jvm() {
            return SHORT;
        }

        @NotNull
        public final Primitive getINT$descriptors_jvm() {
            return INT;
        }

        @NotNull
        public final Primitive getFLOAT$descriptors_jvm() {
            return FLOAT;
        }

        @NotNull
        public final Primitive getLONG$descriptors_jvm() {
            return LONG;
        }

        @NotNull
        public final Primitive getDOUBLE$descriptors_jvm() {
            return DOUBLE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

