/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.types.CustomTypeVariable;
import kotlin.reflect.jvm.internal.impl.types.DelegatingSimpleType;
import kotlin.reflect.jvm.internal.impl.types.FlexibleType;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypesKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.SpecialTypesKt;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.checker.NewCapturedType;
import kotlin.reflect.jvm.internal.impl.types.checker.NewTypeVariableConstructor;
import kotlin.reflect.jvm.internal.impl.types.checker.NullabilityChecker;
import kotlin.reflect.jvm.internal.impl.types.model.DefinitelyNotNullTypeMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DefinitelyNotNullType
extends DelegatingSimpleType
implements CustomTypeVariable,
DefinitelyNotNullTypeMarker {
    @NotNull
    private final SimpleType original;
    private final boolean useCorrectedNullabilityForTypeParameters;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    protected SimpleType getDelegate() {
        return this.original;
    }

    @Override
    public boolean isMarkedNullable() {
        return false;
    }

    @Override
    public boolean isTypeVariable() {
        return this.getDelegate().getConstructor() instanceof NewTypeVariableConstructor || this.getDelegate().getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor;
    }

    @Override
    @NotNull
    public KotlinType substitutionResult(@NotNull KotlinType replacement) {
        Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
        return SpecialTypesKt.makeDefinitelyNotNullOrNotNull(replacement.unwrap(), this.useCorrectedNullabilityForTypeParameters);
    }

    @Override
    @NotNull
    public DefinitelyNotNullType replaceAnnotations(@NotNull Annotations newAnnotations) {
        Intrinsics.checkNotNullParameter((Object)newAnnotations, (String)"newAnnotations");
        return new DefinitelyNotNullType(this.getDelegate().replaceAnnotations(newAnnotations), this.useCorrectedNullabilityForTypeParameters);
    }

    @Override
    @NotNull
    public SimpleType makeNullableAsSpecified(boolean newNullability) {
        return newNullability ? this.getDelegate().makeNullableAsSpecified(newNullability) : (SimpleType)this;
    }

    @Override
    @NotNull
    public String toString() {
        return this.getDelegate() + "!!";
    }

    @Override
    @NotNull
    public DefinitelyNotNullType replaceDelegate(@NotNull SimpleType delegate) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        return new DefinitelyNotNullType(delegate, this.useCorrectedNullabilityForTypeParameters);
    }

    @NotNull
    public final SimpleType getOriginal() {
        return this.original;
    }

    private DefinitelyNotNullType(SimpleType original, boolean useCorrectedNullabilityForTypeParameters) {
        this.original = original;
        this.useCorrectedNullabilityForTypeParameters = useCorrectedNullabilityForTypeParameters;
    }

    public /* synthetic */ DefinitelyNotNullType(SimpleType original, boolean useCorrectedNullabilityForTypeParameters, DefaultConstructorMarker $constructor_marker) {
        this(original, useCorrectedNullabilityForTypeParameters);
    }

    public static final class Companion {
        @Nullable
        public final DefinitelyNotNullType makeDefinitelyNotNull$descriptors(@NotNull UnwrappedType type2, boolean useCorrectedNullabilityForTypeParameters) {
            DefinitelyNotNullType definitelyNotNullType;
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            if (type2 instanceof DefinitelyNotNullType) {
                definitelyNotNullType = (DefinitelyNotNullType)type2;
            } else if (this.makesSenseToBeDefinitelyNotNull(type2, useCorrectedNullabilityForTypeParameters)) {
                if (type2 instanceof FlexibleType) {
                    boolean bl = Intrinsics.areEqual((Object)((FlexibleType)type2).getLowerBound().getConstructor(), (Object)((FlexibleType)type2).getUpperBound().getConstructor());
                    boolean bl2 = false;
                    if (_Assertions.ENABLED && !bl) {
                        boolean bl3 = false;
                        String string = "DefinitelyNotNullType for flexible type (" + type2 + ") can be created only from type variable with the same constructor for bounds";
                        throw (Throwable)((Object)new AssertionError((Object)string));
                    }
                }
                definitelyNotNullType = new DefinitelyNotNullType(FlexibleTypesKt.lowerIfFlexible(type2), useCorrectedNullabilityForTypeParameters, null);
            } else {
                definitelyNotNullType = null;
            }
            return definitelyNotNullType;
        }

        private final boolean makesSenseToBeDefinitelyNotNull(UnwrappedType type2, boolean useCorrectedNullabilityForFlexibleTypeParameters) {
            if (!this.canHaveUndefinedNullability(type2)) {
                return false;
            }
            if (useCorrectedNullabilityForFlexibleTypeParameters && type2.getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor) {
                return TypeUtils.isNullableType(type2);
            }
            return !NullabilityChecker.INSTANCE.isSubtypeOfAny(type2);
        }

        private final boolean canHaveUndefinedNullability(UnwrappedType $this$canHaveUndefinedNullability) {
            return $this$canHaveUndefinedNullability.getConstructor() instanceof NewTypeVariableConstructor || $this$canHaveUndefinedNullability.getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor || $this$canHaveUndefinedNullability instanceof NewCapturedType;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

