/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration;

import java.io.Serializable;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class IncludeExcludePatterns
implements Serializable {
    private static final String[] EMPTY_PATTERN = new String[0];
    public static final IncludeExcludePatterns EMPTY = new IncludeExcludePatterns(EMPTY_PATTERN, EMPTY_PATTERN);
    private String[] includePatterns;
    private String[] excludePatterns;

    public IncludeExcludePatterns() {
        this((String[])null, null);
    }

    public IncludeExcludePatterns(String includePatterns, String excludePatterns) {
        this.includePatterns = this.splitPatterns(includePatterns);
        this.excludePatterns = this.splitPatterns(excludePatterns);
    }

    public IncludeExcludePatterns(String[] includePatterns, String[] excludePatterns) {
        this.includePatterns = includePatterns != null ? includePatterns : EMPTY_PATTERN;
        this.excludePatterns = excludePatterns != null ? excludePatterns : EMPTY_PATTERN;
    }

    private String[] splitPatterns(String patterns) {
        if (StringUtils.isNotBlank(patterns)) {
            return StringUtils.split(patterns, ", ");
        }
        return EMPTY_PATTERN;
    }

    public void addIncludePatterns(String includePatterns) {
        this.includePatterns = ArrayUtils.addAll(this.includePatterns, this.splitPatterns(includePatterns));
    }

    public void addExcludePatterns(String excludePatterns) {
        this.excludePatterns = ArrayUtils.addAll(this.excludePatterns, this.splitPatterns(excludePatterns));
    }

    public String[] getIncludePatterns() {
        return ArrayUtils.clone(this.includePatterns);
    }

    public String[] getExcludePatterns() {
        return ArrayUtils.clone(this.excludePatterns);
    }
}

