/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.maven;

import org.apache.commons.lang3.StringUtils;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.jfrog.build.extractor.Proxy;
import org.jfrog.build.extractor.ProxySelector;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;
import org.jfrog.build.extractor.maven.Maven3BuildInfoLogger;

@Component(role=ArtifactoryManagerBuilder.class)
public class ArtifactoryManagerBuilder {
    @Requirement
    private Logger logger;

    public ArtifactoryManager resolveProperties(ArtifactoryClientConfiguration clientConf) {
        ArtifactoryManager artifactoryManager = this.resolveClientProps(clientConf);
        this.resolveTimeout(clientConf, artifactoryManager);
        this.resolveProxy(clientConf, artifactoryManager);
        this.resolveRetriesParams(clientConf, artifactoryManager);
        this.resolveInsecureTls(clientConf, artifactoryManager);
        return artifactoryManager;
    }

    private ArtifactoryManager resolveClientProps(ArtifactoryClientConfiguration clientConf) {
        String contextUrl = clientConf.publisher.getContextUrl();
        if (StringUtils.isBlank(contextUrl)) {
            throw new IllegalArgumentException("Unable to resolve Artifactory Build Info Client properties: no context URL was found.");
        }
        this.logResolvedProperty(clientConf.publisher.getPrefix() + "." + "contextUrl", contextUrl);
        String username = clientConf.publisher.getUsername();
        String password = clientConf.publisher.getPassword();
        if (StringUtils.isNotBlank(username)) {
            this.logResolvedProperty("username", username);
            return new ArtifactoryManager(contextUrl, username, password, new Maven3BuildInfoLogger(this.logger));
        }
        return new ArtifactoryManager(contextUrl, new Maven3BuildInfoLogger(this.logger));
    }

    private void resolveTimeout(ArtifactoryClientConfiguration clientConf, ArtifactoryManager artifactoryManager) {
        if (clientConf.getTimeout() == null) {
            return;
        }
        int timeout = clientConf.getTimeout();
        this.logResolvedProperty("timeout", String.valueOf(timeout));
        artifactoryManager.setConnectionTimeout(timeout);
    }

    private void resolveRetriesParams(ArtifactoryClientConfiguration clientConf, ArtifactoryManager artifactoryManager) {
        if (clientConf.getConnectionRetries() == null) {
            return;
        }
        int configMaxRetries = clientConf.getConnectionRetries();
        this.logResolvedProperty("connectionRetries", String.valueOf(configMaxRetries));
        artifactoryManager.setConnectionRetries(configMaxRetries);
    }

    private void resolveInsecureTls(ArtifactoryClientConfiguration clientConf, ArtifactoryManager artifactoryManager) {
        artifactoryManager.setInsecureTls(clientConf.getInsecureTls());
    }

    private void resolveProxy(ArtifactoryClientConfiguration clientConf, ArtifactoryManager artifactoryManager) {
        ProxySelector proxySelector = new ProxySelector(clientConf.proxy.getHost(), clientConf.proxy.getPort(), clientConf.proxy.getUsername(), clientConf.proxy.getPassword(), clientConf.httpsProxy.getHost(), clientConf.httpsProxy.getPort(), clientConf.httpsProxy.getUsername(), clientConf.httpsProxy.getPassword(), clientConf.proxy.getNoProxy());
        Proxy proxy = proxySelector.getProxy(clientConf.publisher.getContextUrl());
        if (proxy != null) {
            artifactoryManager.setProxyConfiguration(proxy.getHost(), proxy.getPort(), proxy.getUsername(), proxy.getPassword());
        }
    }

    private void logResolvedProperty(String key, String value) {
        this.logger.debug("Artifactory Client Property Resolver: " + key + " = " + value);
    }
}

