/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.maven.resolver;

import java.lang.reflect.Field;
import java.util.Properties;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.plugin.internal.DefaultPluginDependenciesResolver;
import org.apache.maven.project.DefaultProjectDependenciesResolver;
import org.apache.maven.repository.internal.DefaultArtifactDescriptorReader;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.eclipse.aether.AbstractRepositoryListener;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.internal.impl.DefaultRepositorySystem;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.jfrog.build.extractor.maven.BuildInfoRecorder;
import org.jfrog.build.extractor.maven.resolver.ArtifactoryEclipseArtifactResolver;
import org.jfrog.build.extractor.maven.resolver.ArtifactoryEclipseMetadataResolver;
import org.jfrog.build.extractor.maven.resolver.ResolutionHelper;

@Component(role=RepositoryListener.class)
public class ArtifactoryEclipseRepositoryListener
extends AbstractRepositoryListener
implements Contextualizable {
    @Requirement
    private DefaultProjectDependenciesResolver pojectDependenciesResolver;
    @Requirement
    private DefaultPluginDependenciesResolver pluginDependenciesResolver;
    @Requirement
    private ArtifactoryEclipseArtifactResolver artifactResolver;
    @Requirement
    private ArtifactoryEclipseMetadataResolver metadataResolver;
    @Requirement
    private DefaultArtifactDescriptorReader descriptorReader;
    @Requirement
    private DefaultRepositorySystem repositorySystem;
    @Requirement
    private BuildInfoRecorder buildInfoRecorder;
    @Requirement
    private Logger logger;
    private final MutableBoolean artifactoryRepositoriesEnforced = new MutableBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enforceArtifactoryResolver() throws NoSuchFieldException, IllegalAccessException {
        this.logger.debug("Enforcing Artifactory artifact resolver");
        this.descriptorReader.setArtifactResolver((ArtifactResolver)this.artifactResolver);
        this.repositorySystem.setArtifactResolver(this.artifactResolver);
        this.repositorySystem.setMetadataResolver(this.metadataResolver);
        Field repoSystemProjectField = this.pojectDependenciesResolver.getClass().getDeclaredField("repoSystem");
        repoSystemProjectField.setAccessible(true);
        repoSystemProjectField.set(this.pojectDependenciesResolver, this.repositorySystem);
        Field repoSystemPluginField = this.pluginDependenciesResolver.getClass().getDeclaredField("repoSystem");
        repoSystemPluginField.setAccessible(true);
        repoSystemPluginField.set(this.pluginDependenciesResolver, this.repositorySystem);
        this.artifactoryRepositoriesEnforced.setValue(true);
        MutableBoolean mutableBoolean = this.artifactoryRepositoriesEnforced;
        synchronized (mutableBoolean) {
            this.artifactoryRepositoriesEnforced.notifyAll();
        }
    }

    private BuildInfoRecorder getBuildInfoRecorder() {
        return this.buildInfoRecorder;
    }

    @Override
    public void metadataDownloading(RepositoryEvent event) {
        this.verifyArtifactoryResolutionEnforced(event);
    }

    @Override
    public void artifactDownloading(RepositoryEvent event) {
        this.verifyArtifactoryResolutionEnforced(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForResolutionToBeSet() {
        if (!this.artifactoryRepositoriesEnforced.booleanValue()) {
            MutableBoolean mutableBoolean = this.artifactoryRepositoriesEnforced;
            synchronized (mutableBoolean) {
                if (!this.artifactoryRepositoriesEnforced.booleanValue()) {
                    try {
                        this.artifactoryRepositoriesEnforced.wait();
                    }
                    catch (InterruptedException e) {
                        this.logger.error("Failed while waiting for Artifactory repositories enforcement", (Throwable)e);
                    }
                }
            }
        }
    }

    private void verifyArtifactoryResolutionEnforced(RepositoryEvent event) {
        boolean snapshot;
        RemoteRepository artifactoryReleaseRepo;
        RemoteRepository artifactorySnapshotRepo;
        this.initResolutionHelper(event.getSession());
        if (!this.getBuildInfoRecorder().getResolutionHelper().resolutionRepositoriesConfigured()) {
            return;
        }
        if (event.getArtifact() == null && event.getMetadata() == null) {
            return;
        }
        if (!(event.getRepository() instanceof RemoteRepository)) {
            return;
        }
        RemoteRepository repo = (RemoteRepository)event.getRepository();
        this.waitForResolutionToBeSet();
        this.artifactResolver.initResolutionRepositories(event.getSession());
        if (event.getArtifact() != null) {
            artifactorySnapshotRepo = this.artifactResolver.getSnapshotRepository(event.getSession());
            artifactoryReleaseRepo = this.artifactResolver.getReleaseRepository(event.getSession());
            snapshot = event.getArtifact().isSnapshot();
        } else {
            artifactorySnapshotRepo = this.metadataResolver.getSnapshotRepository(event.getSession());
            artifactoryReleaseRepo = this.metadataResolver.getReleaseRepository(event.getSession());
            snapshot = event.getMetadata().getNature() == Metadata.Nature.SNAPSHOT;
        }
        try {
            if (snapshot && !repo.getUrl().equals(artifactorySnapshotRepo.getUrl()) && repo.getPolicy(true).isEnabled()) {
                this.logger.debug("Replacing resolution repository URL: " + repo + " with: " + artifactorySnapshotRepo.getUrl());
                this.copyRepositoryFields(artifactorySnapshotRepo, repo);
                this.setRepositoryPolicy(repo);
            } else if (!snapshot && !repo.getUrl().equals(artifactoryReleaseRepo.getUrl()) && repo.getPolicy(false).isEnabled()) {
                this.logger.debug("Replacing resolution repository URL: " + repo + " with: " + artifactoryReleaseRepo.getUrl());
                this.copyRepositoryFields(artifactoryReleaseRepo, repo);
                this.setRepositoryPolicy(repo);
            }
        }
        catch (Exception e) {
            this.logger.error("Failed while replacing resolution repository URL", (Throwable)e);
        }
    }

    private void initResolutionHelper(RepositorySystemSession session) {
        ResolutionHelper helper = this.getBuildInfoRecorder().getResolutionHelper();
        if (helper.isInitialized()) {
            return;
        }
        Properties allMavenProps = new Properties();
        allMavenProps.putAll(session.getSystemProperties());
        allMavenProps.putAll(session.getUserProperties());
        helper.init(allMavenProps);
    }

    private void copyRepositoryFields(RemoteRepository fromRepo, RemoteRepository toRepo) throws IllegalAccessException, NoSuchFieldException {
        Field url = RemoteRepository.class.getDeclaredField("url");
        url.setAccessible(true);
        url.set(toRepo, fromRepo.getUrl());
        if (fromRepo.getAuthentication() != null) {
            Field authentication = RemoteRepository.class.getDeclaredField("authentication");
            authentication.setAccessible(true);
            authentication.set(toRepo, fromRepo.getAuthentication());
        }
        if (fromRepo.getProxy() != null) {
            Field proxy = RemoteRepository.class.getDeclaredField("proxy");
            proxy.setAccessible(true);
            proxy.set(toRepo, fromRepo.getProxy());
        }
    }

    private void setRepositoryPolicy(RemoteRepository repo) throws NoSuchFieldException, IllegalAccessException {
        RepositoryPolicy policy = new RepositoryPolicy(true, "daily", "warn");
        Field releasePolicyField = RemoteRepository.class.getDeclaredField("releasePolicy");
        Field snapshotPolicyField = RemoteRepository.class.getDeclaredField("snapshotPolicy");
        releasePolicyField.setAccessible(true);
        snapshotPolicyField.setAccessible(true);
        releasePolicyField.set(repo, policy);
        snapshotPolicyField.set(repo, policy);
    }

    @Override
    public void artifactResolved(RepositoryEvent event) {
        this.waitForResolutionToBeSet();
        String requestContext = ((ArtifactRequest)event.getTrace().getData()).getRequestContext();
        String scope = this.getBuildInfoRecorder().getResolutionHelper().getScopeByRequestContext(requestContext);
        org.apache.maven.artifact.Artifact artifact = this.toMavenArtifact(event.getArtifact(), scope);
        if (event.getRepository() != null) {
            this.logger.debug("[buildinfo] Resolved artifact: " + artifact + " from: " + event.getRepository() + " Context is: " + requestContext);
            this.getBuildInfoRecorder().artifactResolved(artifact);
        } else {
            this.logger.debug("[buildinfo] Could not resolve artifact: " + artifact);
        }
        super.artifactResolved(event);
    }

    private org.apache.maven.artifact.Artifact toMavenArtifact(Artifact art, String scope) {
        if (art == null) {
            return null;
        }
        String classifier = art.getClassifier();
        classifier = classifier == null ? "" : classifier;
        DefaultArtifact artifact = new DefaultArtifact(art.getGroupId(), art.getArtifactId(), art.getVersion(), scope, art.getExtension(), classifier, null);
        artifact.setFile(art.getFile());
        return artifact;
    }

    public void contextualize(Context context) {
        try {
            this.enforceArtifactoryResolver();
        }
        catch (Exception e) {
            this.logger.error("Failed while enforcing Artifactory artifact resolver", (Throwable)e);
        }
    }
}

