/*
 * Decompiled with CFR 0.152.
 */
package org.jinq.orm.stream;

import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class NextOnlyIterator<T>
implements Iterator<T> {
    boolean hasMore = false;
    boolean isEof = false;
    T peek;

    @Override
    public boolean hasNext() {
        if (!this.hasMore && !this.isEof) {
            this.generateNext();
        }
        if (this.hasMore) {
            return true;
        }
        if (this.isEof) {
            return false;
        }
        throw new IllegalArgumentException("generateNext() did not find a new element");
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.hasMore = false;
        return this.peek;
    }

    protected abstract void generateNext();

    protected void nextElement(T el) {
        assert (!this.hasMore && !this.isEof);
        this.peek = el;
        this.hasMore = true;
    }

    protected void noMoreElements() {
        assert (!this.hasMore && !this.isEof);
        this.isEof = true;
    }
}

