/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.support.jmx;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.OpenMBeanAttributeInfo;
import javax.management.openmbean.OpenMBeanParameterInfo;
import javax.management.openmbean.OpenType;
import org.jolokia.json.JSONStructure;
import org.jolokia.server.core.service.serializer.SerializeOptions;
import org.jolokia.server.core.service.serializer.Serializer;

class JsonDynamicMBeanImpl
implements DynamicMBean,
MBeanRegistration {
    public static final String STRING_TYPE = String.class.getName();
    private static final Set<String> DIRECT_TYPES = new HashSet<String>();
    private final Serializer serializer;
    private MBeanInfo wrappedMBeanInfo;
    private MBeanServer jolokiaMBeanServer;
    private ObjectName objectName;
    private Map<String, MBeanAttributeInfo> attributeInfoMap;
    private Map<String, List<OperationMapInfo>> operationInfoMap;
    private final SerializeOptions serializeOptions;

    JsonDynamicMBeanImpl(MBeanServer pJolokiaMBeanServer, ObjectName pObjectName, MBeanInfo pInfo, Serializer pSerializer, SerializeOptions pConvertOptions) {
        this.jolokiaMBeanServer = pJolokiaMBeanServer;
        this.serializer = pSerializer;
        this.objectName = pObjectName;
        this.serializeOptions = pConvertOptions != null ? pConvertOptions : SerializeOptions.DEFAULT;
        this.attributeInfoMap = new HashMap<String, MBeanAttributeInfo>();
        this.operationInfoMap = new HashMap<String, List<OperationMapInfo>>();
        this.wrappedMBeanInfo = this.getWrappedInfo(pInfo);
    }

    @Override
    public Object getAttribute(String pAttribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        try {
            if (!this.attributeInfoMap.containsKey(pAttribute)) {
                return this.jolokiaMBeanServer.getAttribute(this.objectName, pAttribute);
            }
            return this.toJson(this.jolokiaMBeanServer.getAttribute(this.objectName, pAttribute));
        }
        catch (InstanceNotFoundException e) {
            AttributeNotFoundException exp = new AttributeNotFoundException("MBean " + this.objectName + " not found for attribute " + pAttribute);
            exp.initCause(e);
            throw exp;
        }
    }

    @Override
    public void setAttribute(Attribute pAttribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        try {
            if (!this.attributeInfoMap.containsKey(pAttribute.getName())) {
                this.jolokiaMBeanServer.setAttribute(this.objectName, pAttribute);
            } else {
                String name = pAttribute.getName();
                MBeanAttributeInfo info = this.attributeInfoMap.get(name);
                Object value = info instanceof OpenMBeanAttributeInfo ? this.fromJson(((OpenMBeanAttributeInfo)((Object)info)).getOpenType(), (String)pAttribute.getValue()) : this.fromJson(info.getType(), (String)pAttribute.getValue());
                Attribute attr = new Attribute(name, value);
                this.jolokiaMBeanServer.setAttribute(this.objectName, attr);
            }
        }
        catch (InstanceNotFoundException e) {
            AttributeNotFoundException exp = new AttributeNotFoundException("MBean " + this.objectName + " not found for attribute " + pAttribute);
            exp.initCause(e);
            throw exp;
        }
    }

    @Override
    public Object invoke(String pOperation, Object[] pParams, String[] pSignature) throws MBeanException, ReflectionException {
        OperationMapInfo opMapInfo = this.getOperationMapInfo(pOperation, pSignature);
        try {
            if (opMapInfo == null) {
                return this.jolokiaMBeanServer.invoke(this.objectName, pOperation, pParams, pSignature);
            }
            return this.mapAndInvoke(pOperation, pParams, pSignature, opMapInfo);
        }
        catch (InstanceNotFoundException e) {
            throw new IllegalStateException("Internal: Could find MBean " + this.objectName + " on Jolokia MBeanServer. Should be in sync", e);
        }
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList ret = new AttributeList(attributes.length);
        for (String attrName : attributes) {
            try {
                Object attrValue = this.getAttribute(attrName);
                ret.add(new Attribute(attrName, attrValue));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        AttributeList ret = new AttributeList(attributes.size());
        for (Object o : attributes) {
            Attribute attr = (Attribute)o;
            try {
                this.setAttribute(attr);
                ret.add(new Attribute(attr.getName(), this.getAttribute(attr.getName())));
            }
            catch (Exception exception) {}
        }
        return ret;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.wrappedMBeanInfo;
    }

    private Object toJson(Object pValue) {
        try {
            Object ret = this.serializer.serialize(pValue, null, this.serializeOptions);
            return ret instanceof JSONStructure ? ((JSONStructure)ret).toJSONString() : ret.toString();
        }
        catch (AttributeNotFoundException exp) {
            return "";
        }
    }

    private Object fromJson(String pType, String pValue) {
        return this.serializer.deserialize(pType, (Object)pValue);
    }

    private Object fromJson(OpenType<?> pType, String pValue) {
        return this.serializer.deserializeOpenType(pType, (Object)pValue);
    }

    private Object mapAndInvoke(String pOperation, Object[] pParams, String[] pSignature, OperationMapInfo pOpMapInfo) throws InstanceNotFoundException, MBeanException, ReflectionException {
        Object[] realParams = new Object[pSignature.length];
        String[] realSignature = new String[pSignature.length];
        for (int i = 0; i < pSignature.length; ++i) {
            if (pOpMapInfo.isParamMapped(i)) {
                String origType = pOpMapInfo.getOriginalType(i);
                OpenType<?> openType = pOpMapInfo.getOpenMBeanType(i);
                realParams[i] = openType != null ? this.fromJson(openType, (String)pParams[i]) : this.fromJson(origType, (String)pParams[i]);
                realSignature[i] = origType;
                continue;
            }
            realParams[i] = pParams[i];
            realSignature[i] = pSignature[i];
        }
        Object ret = this.jolokiaMBeanServer.invoke(this.objectName, pOperation, realParams, realSignature);
        return pOpMapInfo.isRetTypeMapped() ? this.toJson(ret) : ret;
    }

    private OperationMapInfo getOperationMapInfo(String pOperation, String[] pSignature) {
        List<OperationMapInfo> opMapInfoList = this.operationInfoMap.get(pOperation);
        OperationMapInfo opMapInfo = null;
        if (opMapInfoList != null) {
            for (OperationMapInfo i : opMapInfoList) {
                if (!i.matchSignature(pSignature)) continue;
                opMapInfo = i;
                break;
            }
        }
        return opMapInfo;
    }

    private boolean isDirectlySupported(String pType) {
        return DIRECT_TYPES.contains(pType);
    }

    private MBeanInfo getWrappedInfo(MBeanInfo pMBeanInfo) {
        MBeanAttributeInfo[] attrInfo = this.getWrappedAttributeInfo(pMBeanInfo);
        MBeanOperationInfo[] opInfo = this.getWrappedOperationInfo(pMBeanInfo);
        return new MBeanInfo(pMBeanInfo.getClassName(), pMBeanInfo.getDescription(), attrInfo, null, opInfo, pMBeanInfo.getNotifications());
    }

    private MBeanAttributeInfo[] getWrappedAttributeInfo(MBeanInfo pMBeanInfo) {
        MBeanAttributeInfo[] origAttrInfo = pMBeanInfo.getAttributes();
        MBeanAttributeInfo[] attrInfo = new MBeanAttributeInfo[origAttrInfo.length];
        for (int i = 0; i < origAttrInfo.length; ++i) {
            String attrType;
            MBeanAttributeInfo aInfo = origAttrInfo[i];
            String clazz = aInfo.getType();
            if (this.isDirectlySupported(clazz)) {
                attrType = clazz;
            } else {
                attrType = STRING_TYPE;
                this.attributeInfoMap.put(aInfo.getName(), aInfo);
            }
            attrInfo[i] = new MBeanAttributeInfo(aInfo.getName(), attrType, aInfo.getDescription(), aInfo.isReadable(), aInfo.isWritable(), aInfo.isIs(), aInfo.getDescriptor());
        }
        return attrInfo;
    }

    private MBeanOperationInfo[] getWrappedOperationInfo(MBeanInfo pMBeanInfo) {
        MBeanOperationInfo[] origOpInfo = pMBeanInfo.getOperations();
        MBeanOperationInfo[] opInfo = new MBeanOperationInfo[origOpInfo.length];
        for (int i = 0; i < origOpInfo.length; ++i) {
            OperationMapInfo opMapInfo;
            String retType;
            MBeanOperationInfo oInfo = origOpInfo[i];
            if (this.isDirectlySupported(oInfo.getReturnType())) {
                retType = oInfo.getReturnType();
                opMapInfo = new OperationMapInfo(oInfo, false);
            } else {
                retType = STRING_TYPE;
                opMapInfo = new OperationMapInfo(oInfo, true);
            }
            MBeanParameterInfo[] paramInfo = this.getWrappedParameterInfo(oInfo, opMapInfo);
            if (opMapInfo.containsMapping()) {
                String name = oInfo.getName();
                List infos = this.operationInfoMap.computeIfAbsent(name, k -> new ArrayList());
                infos.add(opMapInfo);
            }
            opInfo[i] = new MBeanOperationInfo(oInfo.getName(), oInfo.getDescription(), paramInfo, retType, oInfo.getImpact(), oInfo.getDescriptor());
        }
        return opInfo;
    }

    private MBeanParameterInfo[] getWrappedParameterInfo(MBeanOperationInfo pOInfo, OperationMapInfo pMapInfo) {
        MBeanParameterInfo[] origParamInfo = pOInfo.getSignature();
        MBeanParameterInfo[] paramInfo = new MBeanParameterInfo[origParamInfo.length];
        for (int j = 0; j < origParamInfo.length; ++j) {
            String pType;
            MBeanParameterInfo pInfo = origParamInfo[j];
            if (this.isDirectlySupported(pInfo.getType())) {
                pType = pInfo.getType();
                pMapInfo.pushParamTypes(pType, null, null);
            } else {
                pType = STRING_TYPE;
                if (pInfo instanceof OpenMBeanParameterInfo) {
                    pMapInfo.pushParamTypes(STRING_TYPE, pInfo.getType(), ((OpenMBeanParameterInfo)((Object)pInfo)).getOpenType());
                } else {
                    pMapInfo.pushParamTypes(STRING_TYPE, pInfo.getType(), null);
                }
            }
            paramInfo[j] = new MBeanParameterInfo(pInfo.getName(), pType, pInfo.getDescription(), pInfo.getDescriptor());
        }
        return paramInfo;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) {
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() {
    }

    @Override
    public void postDeregister() {
        this.jolokiaMBeanServer = null;
        this.wrappedMBeanInfo = null;
        this.objectName = null;
        this.attributeInfoMap = null;
        this.operationInfoMap = null;
    }

    static {
        Collections.addAll(DIRECT_TYPES, Byte.class.getName(), "byte", Integer.class.getName(), "int", Long.class.getName(), "long", Short.class.getName(), "short", Double.class.getName(), "double", Float.class.getName(), "float", Boolean.class.getName(), "boolean", Character.class.getName(), "char", String.class.getName());
    }

    private static final class OperationMapInfo {
        private final boolean retTypeMapped;
        private final String[] signature;
        private final String[] origTypes;
        private final OpenType<?>[] openMBeanTypes;
        private int idx;
        private boolean paramMapped;

        private OperationMapInfo(MBeanOperationInfo pInfo, boolean pRetTypeMapped) {
            this.retTypeMapped = pRetTypeMapped;
            this.origTypes = new String[pInfo.getSignature().length];
            this.openMBeanTypes = new OpenType[pInfo.getSignature().length];
            this.signature = new String[pInfo.getSignature().length];
            this.idx = 0;
            this.paramMapped = false;
        }

        private void pushParamTypes(String pNewType, String pOrigType, OpenType<?> pOpenType) {
            this.signature[this.idx] = pNewType;
            this.origTypes[this.idx] = pOrigType;
            this.openMBeanTypes[this.idx] = pOpenType;
            ++this.idx;
            if (pOrigType != null || pOpenType != null) {
                this.paramMapped = true;
            }
        }

        private boolean isParamMapped(int pIdx) {
            return this.origTypes[pIdx] != null;
        }

        private String getOriginalType(int pIdx) {
            return this.origTypes[pIdx];
        }

        private OpenType<?> getOpenMBeanType(int pIdx) {
            return this.openMBeanTypes[pIdx];
        }

        private boolean isRetTypeMapped() {
            return this.retTypeMapped;
        }

        private boolean containsMapping() {
            return this.retTypeMapped || this.paramMapped;
        }

        private boolean matchSignature(String[] pSignature) {
            return Arrays.equals(this.signature, pSignature);
        }
    }
}

