/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.mariadb;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Param;
import org.jooq.Record;
import org.jooq.SQLDialect;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.jooq.meta.DefaultDataTypeDefinition;
import org.jooq.meta.DefaultSequenceDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.SequenceDefinition;
import org.jooq.meta.mysql.MySQLDatabase;
import org.jooq.meta.mysql.information_schema.tables.Tables;
import org.jooq.util.mariadb.MariaDBDataType;

public class MariaDBDatabase
extends MySQLDatabase {
    private static final long DEFAULT_SEQUENCE_MAXVALUE = 0x7FFFFFFFFFFFFFFEL;
    private static final long DEFAULT_SEQUENCE_CACHE = 1000L;

    @Override
    protected DSLContext create0() {
        return DSL.using((Connection)this.getConnection(), (SQLDialect)SQLDialect.MARIADB);
    }

    @Override
    protected List<SequenceDefinition> getSequences0() throws SQLException {
        ArrayList<SequenceDefinition> result = new ArrayList<SequenceDefinition>();
        for (Record record : this.create().select(Tables.TABLE_SCHEMA, Tables.TABLE_NAME).from((TableLike)Tables.TABLES).where(Tables.TABLE_TYPE.eq((Object)"SEQUENCE"))) {
            SchemaDefinition schema = this.getSchema((String)record.get(Tables.TABLE_SCHEMA));
            if (schema == null) continue;
            String name = (String)record.get(Tables.TABLE_NAME);
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this, schema, MariaDBDataType.BIGINT.getTypeName());
            Field startWith = DSL.nullif((Field)DSL.field((String)"start_value", Long.class), (Field)DSL.inline((long)1L));
            Field incrementBy = DSL.nullif((Field)DSL.field((String)"increment", Long.class), (Field)DSL.inline((long)1L));
            Param minValue = DSL.inline((Object)DSL.field((String)"minimum_value", Long.class), (Field)DSL.inline((long)1L));
            Field maxValue = DSL.nullif((Field)DSL.field((String)"maximum_value", Long.class), (Field)DSL.inline((long)0x7FFFFFFFFFFFFFFEL));
            Field cycle = DSL.field((String)"cycle_option", Boolean.class);
            Field cache = DSL.nullif((Field)DSL.field((String)"cache_size", Long.class), (Field)DSL.inline((long)1000L));
            Record flagsRecord = this.create().select((SelectField)startWith, (SelectField)incrementBy, (SelectField)minValue, (SelectField)maxValue, (SelectField)cycle, (SelectField)cache).from(DSL.name((String[])new String[]{schema.getName(), name})).fetchOne();
            result.add(new DefaultSequenceDefinition(schema, name, type, null, (Number)flagsRecord.get(startWith), (Number)flagsRecord.get(incrementBy), (Number)flagsRecord.get((Field)minValue), (Number)flagsRecord.get(maxValue), (Boolean)flagsRecord.get(cycle), (Number)flagsRecord.get(cache)));
        }
        return result;
    }
}

