/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.shading;

public class BitReader {
    private int p;
    private int pos;
    private final byte[] data;
    private final boolean hasSmallBits;
    private int bufferSize;
    private int buffer;
    private final int totalBitLen;

    public BitReader(byte[] data, boolean hasSmallBits) {
        this.hasSmallBits = hasSmallBits;
        this.data = data;
        this.totalBitLen = this.data.length * 8;
    }

    private int readBits(int lenToRead) {
        if (this.hasSmallBits) {
            while (this.bufferSize < lenToRead) {
                int b = this.data[this.pos] & 0xFF;
                ++this.pos;
                this.buffer = this.buffer << 8 | b;
                this.bufferSize += 8;
            }
            this.bufferSize -= lenToRead;
            this.p += lenToRead;
            return this.buffer >>> this.bufferSize & (1 << lenToRead) - 1;
        }
        int retVal = 0;
        int len = lenToRead / 8;
        for (int i = 0; i < len; ++i) {
            retVal <<= 8;
            retVal |= this.data[this.p / 8] & 0xFF;
            this.p += 8;
        }
        return retVal;
    }

    public int getPositive(int bitLen) {
        return this.readBits(bitLen);
    }

    public float getFloat(int bitLen) {
        int value = this.readBits(bitLen);
        byte[] temp = new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
        float number = 0.0f;
        switch (bitLen) {
            case 1: 
            case 2: 
            case 4: {
                number = (float)temp[3] / 15.0f;
                break;
            }
            case 8: {
                number = (float)(temp[3] & 0xFF) / 256.0f;
                break;
            }
            case 16: {
                number = (float)(temp[2] & 0xFF) / 256.0f;
                number += (float)(temp[3] & 0xFF) / 65536.0f;
                break;
            }
            case 24: {
                number = (float)(temp[1] & 0xFF) / 256.0f;
                number += (float)(temp[2] & 0xFF) / 65536.0f;
                number += (float)(temp[3] & 0xFF) / 1.6777216E7f;
                break;
            }
            case 32: {
                number = (float)(temp[0] & 0xFF) / 256.0f;
                number += (float)(temp[1] & 0xFF) / 65536.0f;
                number += (float)(temp[2] & 0xFF) / 1.6777216E7f;
                number += (float)(temp[3] & 0xFF) / 4.2949673E9f;
            }
        }
        return number;
    }

    public int getPointer() {
        return this.p;
    }

    public int getTotalBitLen() {
        return this.totalBitLen;
    }
}

