/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.shading;

import com.idrsolutions.pdf.color.shading.AxialContext;
import com.idrsolutions.pdf.color.shading.AxialShadeContext;
import com.idrsolutions.pdf.color.shading.CoonsContext;
import com.idrsolutions.pdf.color.shading.FreeFormContext;
import com.idrsolutions.pdf.color.shading.FunctionContext;
import com.idrsolutions.pdf.color.shading.LatticeFormContext;
import com.idrsolutions.pdf.color.shading.RadialContext;
import com.idrsolutions.pdf.color.shading.Shape67;
import com.idrsolutions.pdf.color.shading.TensorContext;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.io.Serializable;
import java.util.ArrayList;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfPaint;
import org.jpedal.function.FunctionFactory;
import org.jpedal.function.PDFFunction;
import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.FunctionObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.DecoderOptions;

public class ShadedPaint
implements PdfPaint,
Paint,
Serializable {
    public static final int FUNCTION = 1;
    public static final int AXIAL = 2;
    public static final int RADIAL = 3;
    public static final int FREEFORM = 4;
    public static final int LATTICEFORM = 5;
    public static final int COONS = 6;
    public static final int TENSOR = 7;
    private static final boolean debug = false;
    private int renderingType = 3;
    protected PDFFunction[] function;
    protected GenericColorSpace shadingColorSpace;
    private PdfObject Shading;
    protected float[] coords;
    protected int shadingType;
    protected float[] domain = new float[]{0.0f, 1.0f};
    private int type;
    private boolean[] isExtended = new boolean[2];
    private boolean colorsReversed;
    public float scaling;
    public int cropX;
    public int textX;
    public int textY;
    public int cropH;
    private float[] background;
    public boolean isPrinting;
    float[][] matrix;
    private ArrayList<Shape67> shapesList = new ArrayList();

    public ShadedPaint(PdfObject Shading, boolean isPrinting, GenericColorSpace shadingColorSpace, PdfObjectReader currentPdfFile, float[][] matrix, boolean colorsReversed) {
        this.isPrinting = isPrinting;
        this.colorsReversed = colorsReversed;
        this.type = Shading.getInt(1487255197);
        this.matrix = matrix;
        this.init(Shading, shadingColorSpace, currentPdfFile, matrix);
    }

    public ShadedPaint() {
    }

    private void init(PdfObject Shading, GenericColorSpace shadingColorSpace, PdfObjectReader currentPdfFile, float[][] matrix) {
        float[] Coords;
        boolean[] extension = Shading.getBooleanArray(1144345468);
        if (extension != null) {
            this.isExtended = extension;
        }
        this.shadingColorSpace = shadingColorSpace;
        this.Shading = Shading;
        this.shadingType = Shading.getInt(1487255197);
        this.background = Shading.getFloatArray(1921025959);
        PdfObject functionObj = Shading.getDictionary(1518239089);
        byte[][] keys = Shading.getKeyArray(1518239089);
        if (functionObj != null) {
            this.function = new PDFFunction[1];
            this.function[0] = FunctionFactory.getFunction(functionObj, currentPdfFile);
        } else if (keys != null) {
            int functionCount = 0;
            if (keys != null) {
                functionCount = keys.length;
            }
            if (keys != null) {
                PdfObject[] subFunction = new PdfObject[functionCount];
                for (int i = 0; i < functionCount; ++i) {
                    FunctionObject functionsObj;
                    String id = new String(keys[i]);
                    if (id.startsWith("<<")) {
                        functionsObj = new FunctionObject(1);
                        ObjectDecoder objectDecoder = new ObjectDecoder(currentPdfFile.getObjectReader());
                        objectDecoder.readDictionaryAsObject(functionsObj, 0, keys[i]);
                    } else {
                        functionsObj = new FunctionObject(id);
                        currentPdfFile.readObject(functionsObj);
                    }
                    subFunction[i] = functionsObj;
                }
                this.function = new PDFFunction[subFunction.length];
                int imax = subFunction.length;
                for (int i1 = 0; i1 < imax; ++i1) {
                    this.function[i1] = FunctionFactory.getFunction(subFunction[i1], currentPdfFile);
                }
            }
        }
        float[] newDomain = Shading.getFloatArray(1026641277);
        if (newDomain != null) {
            this.domain = newDomain;
        }
        if ((Coords = Shading.getFloatArray(1061308290)) != null) {
            int len = Coords.length;
            this.coords = new float[len];
            System.arraycopy(Coords, 0, this.coords, 0, len);
            if (matrix != null) {
                float a = matrix[0][0];
                float b = matrix[0][1];
                float c = matrix[1][0];
                float d = matrix[1][1];
                float tx = matrix[2][0];
                float ty = matrix[2][1];
                if (this.type == 2) {
                    float x = this.coords[0];
                    float y = this.coords[1];
                    float x1 = this.coords[2];
                    float y1 = this.coords[3];
                    this.coords[0] = a * x + c * y + tx;
                    this.coords[1] = b * x + d * y + ty;
                    this.coords[2] = a * x1 + c * y1 + tx;
                    this.coords[3] = b * x1 + d * y1 + ty;
                }
            } else if (this.type == 2 && DecoderOptions.isRunningOnMac && this.coords[1] > this.coords[3]) {
                this.colorsReversed = true;
            }
        }
    }

    @Override
    public PaintContext createContext(ColorModel cm, Rectangle db, Rectangle2D ub, AffineTransform xform, RenderingHints hints) {
        int offY;
        int offX;
        PaintContext pt = null;
        if (!this.isPrinting) {
            offX = (int)(xform.getTranslateX() + (double)this.cropX - (double)((float)this.textX * this.scaling));
            offY = (int)(xform.getTranslateY() - (double)this.cropH + (double)((float)this.textY * this.scaling));
        } else {
            offX = (int)xform.getTranslateX();
            offY = (int)xform.getTranslateY();
            this.scaling = (float)xform.getScaleY();
        }
        switch (this.type) {
            case 1: {
                pt = new FunctionContext(this.cropH, (float)(1.0 / xform.getScaleX()), this.shadingColorSpace, this.colorsReversed, this.function);
                break;
            }
            case 2: {
                if (this.cropH == 0) {
                    pt = new AxialShadeContext(xform, this.shadingColorSpace, this.background, this.Shading, this.matrix, this.function, this.textX, this.textY);
                    break;
                }
                pt = new AxialContext(xform, this.renderingType, this.isPrinting, offX, offY, this.cropX, this.cropH, 1.0f / this.scaling, this.isExtended, this.domain, this.coords, this.shadingColorSpace, this.colorsReversed, this.background, this.function);
                break;
            }
            case 3: {
                pt = new RadialContext(xform, this.isPrinting, this.shadingColorSpace, this.background, this.Shading, this.matrix, this.function);
                break;
            }
            case 4: {
                pt = new FreeFormContext(this.shadingColorSpace, null, this.Shading, this.matrix, this.cropH, this.scaling, offX, offY);
                break;
            }
            case 5: {
                pt = new LatticeFormContext(this.shadingColorSpace, null, this.Shading, this.matrix, this.cropH, this.scaling, offX, offY);
                break;
            }
            case 6: {
                if (!this.shapesList.isEmpty()) {
                    pt = new CoonsContext(xform, this.shapesList, this.background, this.cropH, 1.0f / this.scaling, offX, offY);
                    break;
                }
                CoonsContext ct = new CoonsContext(xform, this.shadingColorSpace, this.background, this.Shading, this.matrix, this.cropH, 1.0f / this.scaling, offX, offY, this.function);
                this.shapesList = ct.getShapes();
                pt = ct;
                break;
            }
            case 7: {
                if (!this.shapesList.isEmpty()) {
                    pt = new TensorContext(xform, this.shapesList, this.background, this.cropH, 1.0f / this.scaling, offX, offY);
                    break;
                }
                TensorContext tt = new TensorContext(xform, this.shadingColorSpace, this.background, this.Shading, this.matrix, this.cropH, 1.0f / this.scaling, offX, offY, this.function);
                this.shapesList = tt.getShapes();
                pt = tt;
            }
        }
        return pt;
    }

    @Override
    public int getTransparency() {
        return 0;
    }

    @Override
    public void setScaling(double cropX, double cropH, float scaling, float textX, float textY) {
        this.scaling = scaling;
        this.cropX = (int)cropX;
        this.cropH = (int)cropH;
        this.textX = (int)textX;
        this.textY = (int)textY;
    }

    @Override
    public boolean isPattern() {
        return true;
    }

    @Override
    public int getRGB() {
        return 0;
    }

    @Override
    public void setRenderingType(int type) {
        this.renderingType = type;
    }

    @Override
    public boolean isTexture() {
        return false;
    }
}

