/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javafx.application.Platform;
import javafx.embed.swing.SwingFXUtils;
import javafx.geometry.Rectangle2D;
import javafx.scene.Cursor;
import javafx.scene.Group;
import javafx.scene.SnapshotParameters;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.ScrollPane;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javax.print.attribute.SetOfIntegerSyntax;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jpedal.DevFlags;
import org.jpedal.FileAccess;
import org.jpedal.Parser;
import org.jpedal.PdfDecoderInt;
import org.jpedal.constants.JPedalSettings;
import org.jpedal.display.Display;
import org.jpedal.display.DisplayOffsets;
import org.jpedal.display.GUIModes;
import org.jpedal.display.GUIThumbnailPanel;
import org.jpedal.display.PageOffsets;
import org.jpedal.display.javafx.SingleDisplayFX;
import org.jpedal.examples.viewer.commands.javafx.JavaFXPreferences;
import org.jpedal.examples.viewer.gui.FXAdditionalData;
import org.jpedal.examples.viewer.gui.JavaFxGUI;
import org.jpedal.examples.viewer.gui.javafx.JavaFXMouseFunctionality;
import org.jpedal.examples.viewer.gui.javafx.JavaFXMouseListener;
import org.jpedal.exception.PdfException;
import org.jpedal.external.ExternalHandlers;
import org.jpedal.external.FXExternalHandlers;
import org.jpedal.external.PluginHandler;
import org.jpedal.fonts.FontMappings;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.gui.UIViewerInt;
import org.jpedal.gui.ViewerInt;
import org.jpedal.io.DecryptionFactory;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.io.StatusBar;
import org.jpedal.objects.Javascript;
import org.jpedal.objects.PdfData;
import org.jpedal.objects.PdfFileInformation;
import org.jpedal.objects.PdfImageData;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.PdfResources;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.objects.acroforms.actions.ActionHandler;
import org.jpedal.objects.acroforms.actions.JavaFXDefaultActionHandler;
import org.jpedal.objects.javascript.ExpressionEngine;
import org.jpedal.objects.layers.PdfLayerList;
import org.jpedal.objects.outlines.OutlineData;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.parser.DecoderResults;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.render.FXDisplay;
import org.jpedal.text.TextLines;
import org.jpedal.utils.DPIFactory;
import org.jpedal.utils.LogWriter;
import org.w3c.dom.Document;

public class PdfDecoderFX
extends Pane
implements Printable,
Pageable,
PdfDecoderInt {
    private Image previewImage;
    private String previewText;
    private int curThumbPage = 1;
    private final DecoderOptions options = new DecoderOptions();
    private final ExternalHandlers externalHandlers = new FXExternalHandlers(GUIModes.JAVAFX);
    private final PdfResources res = new PdfResources();
    final FileAccess fileAccess = new FileAccess(this.externalHandlers, this.res, this.options);
    private final DecoderResults resultsFromDecode = new DecoderResults();
    final Parser parser = new Parser(this.externalHandlers, this.options, this.fileAccess, this.res, this.resultsFromDecode);
    private final DPIFactory scalingdpi = new DPIFactory();
    public boolean useNewGraphicsMode = true;
    public Display pages;
    private boolean isBorderPresent = true;
    private final DisplayOffsets displayOffsets = new DisplayOffsets();
    private ActionHandler formsActionHandler;
    private ActionHandler userActionHandler;
    private int scrollInterval = 10;
    private boolean isNewRotationSet;
    int displayRotation;
    int x_size = 100;
    int y_size = 100;
    int max_x;
    int max_y;
    float scaling = 1.0f;
    protected Border myBorder;
    private Rectangle imageHighlighter;
    private StatusBar statusBar;
    Canvas previewThumbnail;
    protected int specialMode = -1;
    public int textPrint;
    public final Pane highlightsPane = new Pane();
    private static int color;
    private static float opacity;
    private static javafx.scene.paint.Color highlights;

    @Override
    public boolean isOpen() {
        return this.fileAccess.isOpen();
    }

    private void drawPreviewImage(Graphics2D g2, java.awt.Rectangle visibleRect) {
        if (this.previewImage != null) {
            GraphicsContext context = this.previewThumbnail.getGraphicsContext2D();
            context.setFill((Paint)new javafx.scene.paint.Color(0.25, 0.25, 0.25, 1.0));
            context.fillRect(0.0, 0.0, this.previewThumbnail.getWidth(), this.previewThumbnail.getHeight());
            context.drawImage(this.previewImage, 10.0, 10.0);
            context.setStroke((Paint)new javafx.scene.paint.Color(1.0, 1.0, 1.0, 1.0));
            context.strokeText(this.previewText, 10.0, this.previewThumbnail.getHeight() - 10.0);
            ScrollPane pane = (ScrollPane)this.getParent().getParent().getParent().getParent();
            Group group = (Group)this.getParent();
            double groupX = group.getBoundsInParent().getMinX();
            double viewW = pane.getViewportBounds().getWidth();
            double viewH = pane.getViewportBounds().getHeight();
            double pdfW = this.getBoundsInParent().getWidth();
            double thumW = this.previewThumbnail.getBoundsInLocal().getWidth();
            double thumH = this.previewThumbnail.getBoundsInLocal().getHeight();
            double x = pdfW + (viewW - groupX - pdfW - thumW - 10.0);
            double y = (viewH - thumH) / (double)this.getPageCount() * (double)(this.curThumbPage - 1);
            this.previewThumbnail.setLayoutX(x);
            this.previewThumbnail.setLayoutY(y);
        }
    }

    @Override
    public Document getMarkedContent() {
        throw new RuntimeException("Not implemented in PdfDecoderFX - use PdfDecoderServer");
    }

    @Override
    public ExternalHandlers getExternalHandler() {
        return this.externalHandlers;
    }

    protected PdfResources getRes() {
        return this.res;
    }

    @Override
    public int getDisplayRotation() {
        return this.displayRotation;
    }

    DecoderOptions getOptions() {
        return this.options;
    }

    @Override
    public int getPageNumber() {
        return this.fileAccess.getPageNumber();
    }

    public void setPageNumber(int newPage) {
        this.fileAccess.setPageNumber(newPage);
    }

    @Override
    public void setDisplayRotation(int newRotation) {
        this.displayRotation = newRotation;
    }

    @Override
    public Display getPages() {
        return this.pages;
    }

    @Override
    public int getlastPageDecoded() {
        return this.fileAccess.getLastPageDecoded();
    }

    @Override
    public Iterator getPageInfo(int type) {
        return this.resultsFromDecode.getPageInfo(type);
    }

    @Override
    public OutlineData getOutlineData() {
        return this.res.getOutlineData();
    }

    @Override
    public boolean isLoadingLinearizedPDF() {
        return this.fileAccess.linearParser.linearizedBackgroundReaderer != null && this.fileAccess.linearParser.linearizedBackgroundReaderer.isAlive();
    }

    @Override
    public boolean useNewGraphicsMode() {
        return this.useNewGraphicsMode;
    }

    @Override
    public void useNewGraphicsMode(boolean b) {
        this.useNewGraphicsMode = b;
    }

    @Override
    public int getSpecialMode() {
        return this.specialMode;
    }

    public void scrollRectToVisible(java.awt.Rectangle rectangle) {
        ScrollPane customFXHandle = ((JavaFxGUI)this.getExternalHandler(4)).getPageContainer();
        double width = this.getWidth();
        double height = this.getHeight();
        customFXHandle.setVvalue((double)rectangle.y / height);
        customFXHandle.setHvalue((double)rectangle.x / width);
    }

    @Override
    public void resetViewableArea() {
        throw new RuntimeException("resetViewableArea called in PdfDecoderFx");
    }

    @Override
    @Deprecated
    public AffineTransform setViewableArea(java.awt.Rectangle viewport) throws PdfException {
        return null;
    }

    @Override
    public int getPageAlignment() {
        return this.options.getPageAlignment();
    }

    public static void init(boolean newEmbedWidthData) {
        DecoderOptions.embedWidthData = newEmbedWidthData;
    }

    public PdfDecoderFX(boolean newRender) {
        this.pages = new SingleDisplayFX(this, this.options);
        this.options.setRenderPage(newRender);
        if (!FontMappings.fontsInitialised) {
            FontMappings.initFonts();
            FontMappings.fontsInitialised = true;
        }
        if (newRender) {
            // empty if block
        }
        this.setId("PdfDecoderFX");
    }

    public PdfDecoderFX(int specialMode, UIViewerInt viewer) {
        this.specialMode = specialMode;
        this.pages = new SingleDisplayFX(this, this.options);
        this.options.setRenderPage(true);
        if (!FontMappings.fontsInitialised) {
            FontMappings.initFonts();
            FontMappings.fontsInitialised = true;
        }
        this.setId("PdfDecoderFX");
    }

    public void setPageDisplayMode(int pageDisplayMode) {
        this.specialMode = pageDisplayMode;
    }

    public static UIViewerInt getUIViewer() {
        return null;
    }

    public PdfDecoderFX() {
        this.pages = new SingleDisplayFX(this, this.options);
        this.options.setRenderPage(true);
        if (!FontMappings.fontsInitialised) {
            FontMappings.initFonts();
            FontMappings.fontsInitialised = true;
        }
        this.setId("PdfDecoderFX");
    }

    public PdfDecoderFX(UIViewerInt uiViewer, ViewerInt viewer, int pageCount) {
        this.fileAccess.setPageCount(pageCount);
        this.pages = new SingleDisplayFX(this, this.options);
        this.options.setRenderPage(true);
        this.setId("PdfDecoderFX");
    }

    public static void disposeAllStatic() {
        StandardFonts.dispose();
        FontMappings.dispose();
    }

    @Override
    public final void dispose() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.parser.disposeObjects();
        } else {
            Runnable doPaintComponent = new Runnable(){

                @Override
                public void run() {
                    PdfDecoderFX.this.parser.disposeObjects();
                }
            };
            SwingUtilities.invokeLater(doPaintComponent);
        }
    }

    @Override
    public final void closePdfFile() {
        if (this.pages != null) {
            this.pages.stopGeneratingPage();
        }
        this.pages.disableScreen();
        this.fileAccess.closePdfFile();
    }

    public final PdfData getPdfBackgroundData() {
        return this.parser.getPdfBackgroundData();
    }

    @Override
    public final PdfData getPdfData() throws PdfException {
        return this.parser.getPdfData();
    }

    @Override
    public final boolean hasOutline() {
        return this.res.hasOutline();
    }

    @Override
    public final Document getOutlineAsXML() {
        return this.res.getOutlineAsXML(this.getIO());
    }

    @Override
    public final PdfPageData getPdfPageData() {
        return this.fileAccess.getPdfPageData();
    }

    public void setPagePrintRange(int start, int end) throws PdfException {
    }

    public void setTextPrint(int textPrint) {
        this.textPrint = textPrint;
    }

    public void useLogicalPrintOffset(int pagesPrinted) {
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int page) throws PrinterException {
        return -1;
    }

    @Override
    public synchronized BufferedImage getPageAsHiRes(int pageIndex) throws PdfException {
        return this.getPageAsHiRes(pageIndex, false);
    }

    @Override
    public synchronized BufferedImage getPageAsHiRes(int pageIndex, Map params) throws PdfException {
        if (params != null) {
            this.modifyNonstaticJPedalParameters(params);
        }
        return this.getPageAsHiRes(pageIndex);
    }

    @Override
    public synchronized BufferedImage getPageAsHiRes(int pageIndex, Map params, boolean isTransparent) throws PdfException {
        if (params != null) {
            this.options.set(params);
        }
        return this.getPageAsHiRes(pageIndex, isTransparent);
    }

    @Override
    public synchronized BufferedImage getPageAsHiRes(int pageIndex, boolean isTransparent) throws PdfException {
        return this.parser.getPageAsHiRes(pageIndex, isTransparent);
    }

    @Override
    public BufferedImage getPageAsImage(int pageIndex) throws PdfException {
        return this.getPageAsImage(pageIndex, false);
    }

    @Override
    public BufferedImage getPageAsTransparentImage(int pageIndex) throws PdfException {
        return this.getPageAsImage(pageIndex, true);
    }

    private BufferedImage getPageAsImage(int pageIndex, boolean imageIsTransparent) throws PdfException {
        this.parser.setParms(this.displayRotation, this.scaling, 0, this.specialMode);
        return this.parser.getPageAsImage(pageIndex, imageIsTransparent);
    }

    @Override
    public float getHiResUpscaleFactor() {
        return this.parser.getHiResUpscaleFactor();
    }

    @Override
    public final void flushObjectValues(boolean reinit) {
        this.parser.flushObjectValues(reinit);
    }

    @Override
    public final PdfImageData getPdfImageData() {
        return this.parser.getPdfImageData();
    }

    public final PdfImageData getPdfBackgroundImageData() {
        return this.parser.getPdfBackgroundImageData();
    }

    @Override
    public final void setRenderMode(int mode) {
        this.parser.setRenderMode(mode);
    }

    @Override
    public final void setExtractionMode(int mode) {
        this.parser.setExtractionMode(mode);
    }

    @Override
    public void modifyNonstaticJPedalParameters(Map values) throws PdfException {
        this.options.set(values);
        if (values.containsKey(JPedalSettings.DISPLAY_BACKGROUND)) {
            // empty if block
        }
    }

    public static void modifyJPedalParameters(Map values) throws PdfException {
        if (values != null) {
            DecoderOptions.modifyJPedalParameters(values);
        }
    }

    @Override
    public final PdfFileInformation getFileInformationData() {
        return this.res.getMetaData(this.getIO());
    }

    @Override
    public final void setExtractionMode(int mode, float scaling) {
        this.scaling = scaling;
        this.parser.setExtractionMode(mode, scaling);
    }

    @Override
    public DPIFactory getDPIFactory() {
        return this.scalingdpi;
    }

    @Override
    public void setPageParameters(float scaling, int pageNumber) {
        boolean layersChanged;
        PdfLayerList layers;
        this.fileAccess.setPageNumber(pageNumber);
        this.parser.resetMultiplyer();
        if (this.getDisplayView() == 5 && scaling == -100.0f) {
            return;
        }
        if (scaling > 0.0f) {
            this.scaling = scaling;
        } else {
            scaling = this.scaling;
        }
        if (this.pages != null) {
            this.pages.setScaling(scaling);
        }
        if ((layers = this.res.getPdfLayerList()) != null && (layersChanged = layers.setZoom(this.scalingdpi.removeScaling(scaling)))) {
            this.decodePage(-1);
        }
        PdfPageData pageData = this.fileAccess.getPdfPageData();
        pageData.setScalingValue(scaling);
        int mediaW = pageData.getMediaBoxWidth(pageNumber);
        this.max_y = pageData.getMediaBoxHeight(pageNumber);
        this.max_x = pageData.getMediaBoxWidth(pageNumber);
        int cropW = pageData.getCropBoxWidth(pageNumber);
        int cropH = pageData.getCropBoxHeight(pageNumber);
        this.x_size = (int)((float)cropW * scaling);
        this.y_size = (int)((float)cropH * scaling);
        if (!this.isNewRotationSet && this.getDisplayView() != 5) {
            this.displayRotation = pageData.getRotation(pageNumber);
        } else {
            this.isNewRotationSet = false;
        }
        DynamicVectorRenderer currentDisplay = this.fileAccess.getDynamicRenderer();
        currentDisplay.init(mediaW, this.max_y, this.options.getPageColor());
        if (!currentDisplay.isHTMLorSVG()) {
            currentDisplay.setValue(1, this.options.getPageColor().getRGB());
            if (this.options.getTextColor() != null) {
                currentDisplay.setValue(2, this.options.getTextColor().getRGB());
                if (this.options.getChangeTextAndLine()) {
                    currentDisplay.setValue(3, 1);
                } else {
                    currentDisplay.setValue(3, 0);
                }
            }
        }
        this.pages.setPageRotation(this.displayRotation);
        AcroRenderer formRenderer = this.externalHandlers.getFormRenderer();
        if (formRenderer != null) {
            formRenderer.getCompData().setForceRedraw(true);
        }
    }

    @Override
    public void setPageParameters(float scaling, int pageNumber, int newRotation) {
        this.isNewRotationSet = true;
        this.displayRotation = newRotation;
        if (this.getDisplayView() == 5) {
            this.pages.init(0.0f, this.displayRotation, 0, null, false);
        } else {
            this.setPageParameters(scaling, pageNumber);
        }
    }

    @Override
    public void setStatusBarObject(StatusBar statusBar) {
        this.statusBar = statusBar;
    }

    @Override
    public void waitForDecodingToFinish() {
        this.fileAccess.waitForDecodingToFinish();
    }

    @Override
    public DynamicVectorRenderer getDynamicRenderer() {
        return this.fileAccess.getDynamicRenderer();
    }

    @Override
    public DynamicVectorRenderer getDynamicRenderer(boolean reset) {
        return this.fileAccess.getDynamicRenderer();
    }

    public void setDefaultCursor(Cursor c) {
        if (SingleDisplayFX.allowChangeCursor) {
            this.setCursor(c);
        }
    }

    @Override
    public final void decodePage(final int rawPage) {
        boolean isPageAvailable = this.isPageAvailable(rawPage);
        PdfObject pdfObject = this.fileAccess.linearParser.getLinearPageObject();
        boolean hasLayersChanged = this.res.getPdfLayerList() != null ? this.res.getPdfLayerList().getChangesMade() : false;
        if (!isPageAvailable) {
            return;
        }
        if (isPageAvailable && pdfObject != null) {
            this.fileAccess.readAllPageReferences(true, pdfObject, new HashMap(1000), new HashMap(1000), rawPage, this.getFormRenderer(), this.res, this.options.getInsetW(), this.options.getInsetH());
        }
        this.parser.setStatusBar(this.statusBar);
        this.parser.setParms(this.displayRotation, this.scaling, (int)this.pages.getIndent(), this.specialMode);
        this.pages.setCursorBoxOnScreen(null, rawPage == this.fileAccess.getLastPageDecoded());
        final FXDisplay currentDisplay = new FXDisplay(rawPage, this.getObjectStore(), false);
        this.fileAccess.setDVR(currentDisplay);
        this.parser.decodePage(rawPage);
        if (hasLayersChanged) {
            this.externalHandlers.getFormRenderer().getCompData().resetScaledLocation(this.pages.getOldScaling(), this.displayRotation, 0);
        }
        if (Platform.isFxApplicationThread()) {
            color = DecoderOptions.highlightColor.getRGB();
            opacity = DecoderOptions.highlightComposite;
            this.highlightsPane.getChildren().clear();
            this.pages.init(this.scaling, this.displayRotation, rawPage, currentDisplay, true);
            this.pages.refreshDisplay();
        } else {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    color = DecoderOptions.highlightColor.getRGB();
                    opacity = DecoderOptions.highlightComposite;
                    PdfDecoderFX.this.highlightsPane.getChildren().clear();
                    PdfDecoderFX.this.pages.init(PdfDecoderFX.this.scaling, PdfDecoderFX.this.displayRotation, rawPage, currentDisplay, true);
                    PdfDecoderFX.this.pages.refreshDisplay();
                }
            });
        }
    }

    @Override
    public synchronized boolean isPageAvailable(int rawPage) {
        return this.parser.isPageAvailable(rawPage);
    }

    public void printAdditionalObjectsOverPage(int page, int[] type, Color[] colors, Object[] obj) throws PdfException {
    }

    public void printAdditionalObjectsOverAllPages(int[] type, Color[] colors, Object[] obj) throws PdfException {
    }

    @Override
    public void drawAdditionalObjectsOverPage(int page, int[] type, Color[] colors, Object[] obj) throws PdfException {
        if (page == this.getPageNumber()) {
            FXAdditionalData additionaValuesforPage = (FXAdditionalData)this.externalHandlers.getExternalHandler(33);
            if (additionaValuesforPage != null) {
                additionaValuesforPage.setType(type);
                additionaValuesforPage.setObj(obj);
            } else {
                DynamicVectorRenderer currentDisplay = this.fileAccess.getDynamicRenderer();
                currentDisplay.drawAdditionalObjectsOverPage(type, colors, obj);
                this.pages.refreshDisplay();
            }
        }
    }

    @Override
    public void flushAdditionalObjectsOnPage(int page) throws PdfException {
        if (page == this.getPageNumber()) {
            this.fileAccess.setLastPageDecoded(-page);
            this.decodePage(page);
        }
    }

    @Override
    public boolean isHiResScreenDisplay() {
        return this.options.useHiResImageForDisplay();
    }

    @Override
    public void useHiResScreenDisplay(boolean value) {
        this.options.useHiResImageForDisplay(value);
    }

    @Override
    public final synchronized void decodePageInBackground(int i) throws Exception {
        this.parser.decodePageInBackground(i);
    }

    @Override
    public final int getPageCount() {
        return this.fileAccess.getPageCount();
    }

    @Override
    public final boolean isEncrypted() {
        return this.fileAccess.isEncrypted();
    }

    @Override
    public final boolean isPasswordSupplied() {
        return this.fileAccess.isPasswordSupplied(this.getIO());
    }

    @Override
    public boolean isFileViewable() {
        return this.fileAccess.isFileViewable(this.getIO());
    }

    @Override
    public boolean isExtractionAllowed() {
        if (this.getIO() != null) {
            PdfFileReader objectReader = this.getIO().getObjectReader();
            DecryptionFactory decryption = objectReader.getDecryptionObject();
            return decryption == null || decryption.getBooleanValue(103);
        }
        return false;
    }

    @Override
    public final void setEncryptionPassword(String password) throws PdfException {
        if (this.getIO() == null) {
            throw new PdfException("Must open PdfDecoder file first");
        }
        this.getIO().getObjectReader().setPassword(password);
        if (this.getIO() != null) {
            try {
                this.preOpen();
                this.fileAccess.openPdfFile();
                this.postOpen();
            }
            catch (PdfException e) {
                LogWriter.writeLog("Exception " + e + " opening file");
            }
        }
    }

    @Override
    public final void openPdfArray(byte[] data, String password) throws PdfException {
        if (data == null) {
            throw new RuntimeException("Attempting to open null byte stream");
        }
        this.preOpen();
        if (this.fileAccess.isOpen) {
            this.closePdfFile();
        }
        this.fileAccess.openPdfArray(data, password);
        this.postOpen();
    }

    @Override
    public final void openPdfArray(byte[] data) throws PdfException {
        if (data == null) {
            throw new RuntimeException("Attempting to open null byte stream");
        }
        this.preOpen();
        if (this.fileAccess.isOpen) {
            this.closePdfFile();
        }
        this.fileAccess.openPdfArray(data);
        this.postOpen();
    }

    @Override
    public void openPdfFile(String filename, Certificate certificate, PrivateKey key) throws PdfException {
        this.fileAccess.setUserEncryption(certificate, key);
        this.openPdfFile(filename);
    }

    @Override
    public final void openPdfFileFromStream(Object filename, String password) throws PdfException {
        this.preOpen();
        this.fileAccess.openPdfFileFromStream(filename, password);
        this.postOpen();
    }

    @Override
    public final void openPdfFile(String filename) throws PdfException {
        if (this.fileAccess.isOpen && this.fileAccess.linearParser.linearizedBackgroundReaderer == null) {
            this.closePdfFile();
        }
        this.preOpen();
        this.fileAccess.openPdfFile(filename);
        this.postOpen();
    }

    @Override
    public final void openPdfFile(String filename, String password) throws PdfException {
        if (this.fileAccess.isOpen) {
            this.closePdfFile();
        }
        this.preOpen();
        this.fileAccess.openPdfFile(filename, password);
        this.postOpen();
    }

    @Override
    public final boolean openPdfFileFromURL(String pdfUrl, boolean supportLinearized) throws PdfException {
        this.preOpen();
        InputStream is = null;
        String rawFileName = null;
        try {
            URL url = new URL(pdfUrl);
            rawFileName = url.getPath().substring(url.getPath().lastIndexOf(47) + 1);
            is = url.openStream();
        }
        catch (IOException e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        boolean flag = this.fileAccess.readFile(supportLinearized, is, rawFileName, null);
        this.postOpen();
        return flag;
    }

    @Override
    public final boolean openPdfFileFromURL(String pdfUrl, boolean supportLinearized, String password) throws PdfException {
        InputStream is = null;
        String rawFileName = null;
        try {
            URL url = new URL(pdfUrl);
            rawFileName = url.getPath().substring(url.getPath().lastIndexOf(47) + 1);
            is = url.openStream();
        }
        catch (IOException e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        this.preOpen();
        boolean flag = this.fileAccess.readFile(supportLinearized, is, rawFileName, password);
        this.postOpen();
        return flag;
    }

    @Override
    public final boolean openPdfFileFromInputStream(InputStream is, boolean supportLinearized) throws PdfException {
        String rawFileName = "inputstream" + System.currentTimeMillis() + '-' + this.fileAccess.getObjectStore().getKey() + ".pdf";
        this.preOpen();
        boolean flag = this.fileAccess.readFile(supportLinearized, is, rawFileName, null);
        this.postOpen();
        return flag;
    }

    @Override
    public final boolean openPdfFileFromInputStream(InputStream is, boolean supportLinearized, String password) throws PdfException {
        String rawFileName = "inputstream" + System.currentTimeMillis() + '-' + this.fileAccess.getObjectStore().getKey() + ".pdf";
        this.preOpen();
        boolean flag = this.fileAccess.readFile(supportLinearized, is, rawFileName, password);
        this.postOpen();
        return flag;
    }

    private void postOpen() {
        if (this.fileAccess.getPageCount() < 2) {
            this.options.setDisplayView(1);
        } else {
            this.options.setDisplayView(this.options.getPageMode());
        }
        this.formsActionHandler.init(this, this.externalHandlers.getJavaScript(), this.getFormRenderer());
        PluginHandler customPluginHandle = (PluginHandler)this.externalHandlers.getExternalHandler(-4);
        if (customPluginHandle != null) {
            customPluginHandle.setFileName(this.fileAccess.getFilename());
        }
    }

    private void preOpen() {
        this.pages.disableScreen();
        this.pages.stopGeneratingPage();
        this.fileAccess.setDecoding(true);
        if (this.options.getCurrentOffsets() == null) {
            this.options.setCurrentOffsets(new PageOffsets(this.fileAccess.getPageCount(), this.getPdfPageData()));
        }
        this.fileAccess.setDecoding(false);
        this.parser.resetOnOpen();
        ExpressionEngine userExpressionEngine = (ExpressionEngine)this.externalHandlers.getExternalHandler(6);
        this.externalHandlers.openPdfFile(userExpressionEngine);
        AcroRenderer formRenderer = this.externalHandlers.getFormRenderer();
        this.formsActionHandler = this.userActionHandler != null ? this.userActionHandler : new JavaFXDefaultActionHandler(null);
        formRenderer.resetHandler(this.formsActionHandler, this.scalingdpi.getDpi(), this.externalHandlers.getJavaScript());
        formRenderer.getCompData().setRootDisplayComponent(this);
    }

    @Override
    public Object getJPedalObject(int id) {
        return this.parser.getJPedalObject(id);
    }

    @Override
    public void setPageMode(int mode) {
        this.options.setPageMode(mode);
    }

    @Override
    public boolean isXMLExtraction() {
        return this.options.isXMLExtraction();
    }

    @Override
    public void useTextExtraction() {
        this.options.setXMLExtraction(false);
    }

    @Override
    public void useXMLExtraction() {
        this.options.setXMLExtraction(true);
    }

    public void clearScreen() {
        DynamicVectorRenderer currentDisplay = this.fileAccess.getDynamicRenderer();
        currentDisplay.flush();
        this.pages.refreshDisplay();
    }

    @Override
    public void setStreamCacheSize(int size) {
        this.fileAccess.setStreamCacheSize(size);
    }

    @Override
    public boolean hasEmbeddedFonts() {
        return this.resultsFromDecode.hasEmbeddedFonts();
    }

    @Override
    public int getPageFromObjectRef(String ref) {
        return this.getIO().convertObjectToPageNumber(ref);
    }

    @Override
    public String getInfo(int type) {
        return this.parser.getInfo(type);
    }

    @Override
    public AcroRenderer getFormRenderer() {
        return this.externalHandlers.getFormRenderer();
    }

    @Override
    public Javascript getJavaScript() {
        return this.externalHandlers.getJavaScript();
    }

    public static boolean isPageSuccessful() {
        return false;
    }

    @Override
    public String getPageDecodeReport() {
        return this.parser.getPageDecodeReport();
    }

    public static String getPageFailureMessage() {
        return null;
    }

    @Override
    public BufferedImage getSelectedRectangleOnscreen(float t_x1, float t_y1, float t_x2, float t_y2, float scaling) {
        int pagenumber = this.getPageNumber();
        int height = this.getPdfPageData().getCropBoxHeight(pagenumber);
        int cry = this.getPdfPageData().getCropBoxY(pagenumber);
        int crx = this.getPdfPageData().getCropBoxX(pagenumber);
        t_y1 -= (float)cry;
        t_y2 -= (float)cry;
        t_x1 -= (float)crx;
        t_x2 -= (float)crx;
        t_y1 = (float)height - t_y1;
        t_y2 = (float)height - t_y2;
        double borderInset = -this.getBoundsInParent().getMinX();
        float scalingFactor = scaling / 100.0f;
        SnapshotParameters para = new SnapshotParameters();
        Rectangle2D r = new Rectangle2D(this.getBoundsInParent().getMinX() + (double)(scalingFactor * t_x1) + borderInset, this.getBoundsInParent().getMinY() + (double)(scalingFactor * t_y1) + borderInset, (double)(scalingFactor * (t_x2 - t_x1)), (double)(scalingFactor * (t_y2 - t_y1)));
        para.setViewport(r);
        WritableImage image = this.snapshot(para, null);
        BufferedImage bi = new BufferedImage((int)r.getWidth(), (int)r.getHeight(), 2);
        bi = SwingFXUtils.fromFXImage((Image)image, (BufferedImage)bi);
        return bi;
    }

    @Override
    public ObjectStore getObjectStore() {
        return this.fileAccess.getObjectStore();
    }

    @Override
    public void setObjectStore(ObjectStore newStore) {
        this.fileAccess.setObjectStore(newStore);
    }

    @Override
    public DecoderOptions getDecoderOptions() {
        return this.options;
    }

    @Override
    public PdfGroupingAlgorithms getGroupingObject() throws PdfException {
        return this.parser.getGroupingObject();
    }

    @Override
    public PdfGroupingAlgorithms getBackgroundGroupingObject() {
        return this.parser.getBackgroundGroupingObject();
    }

    @Override
    public final String getPDFVersion() {
        if (this.getIO() == null) {
            return "";
        }
        return this.getIO().getObjectReader().getType();
    }

    @Override
    public void resetForNonPDFPage(int pageCount) {
        DynamicVectorRenderer currentDisplay = this.fileAccess.getDynamicRenderer();
        currentDisplay.setHiResImageForDisplayMode(false);
        this.parser.resetFontsInFile();
        this.fileAccess.setPageCount(pageCount);
        AcroRenderer formRenderer = this.externalHandlers.getFormRenderer();
        if (formRenderer != null) {
            formRenderer.removeDisplayComponentsFromScreen();
        }
        this.fileAccess.setPageData(new PdfPageData());
    }

    public boolean hasAllImages() {
        return this.resultsFromDecode.getImagesProcessedFully();
    }

    @Override
    public boolean getPageDecodeStatus(int status) {
        if (DevFlags.testing && status == 4) {
            return false;
        }
        return this.resultsFromDecode.getPageDecodeStatus(status);
    }

    @Override
    public DisplayOffsets getDisplayOffsets() {
        return this.displayOffsets;
    }

    @Override
    public String getPageDecodeStatusReport(int status) {
        return this.resultsFromDecode.getPageDecodeStatusReport(status);
    }

    public void setPrintAutoRotateAndCenter(boolean value) {
    }

    public void setPrintCurrentView(boolean value) {
    }

    @Override
    public void addExternalHandler(Object newHandler, int type) {
        switch (type) {
            case 5: {
                this.userActionHandler = (ActionHandler)newHandler;
                break;
            }
            case 26: {
                JavaFXMouseListener.setCustomMouseFunctions((JavaFXMouseFunctionality)newHandler);
                break;
            }
            case 8: {
                this.pages.setThumbnailPanel((GUIThumbnailPanel)newHandler);
                break;
            }
            default: {
                this.externalHandlers.addExternalHandler(newHandler, type);
            }
        }
    }

    @Override
    public Object getExternalHandler(int type) {
        switch (type) {
            case 16: {
                return this.pages;
            }
            case 17: {
                return this.fileAccess.getOffset();
            }
            case 37: {
                return this.displayOffsets;
            }
            case 35: {
                return this.fileAccess;
            }
        }
        return this.externalHandlers.getExternalHandler(type);
    }

    @Override
    public PdfObjectReader getIO() {
        return this.parser.getIO();
    }

    @Override
    public String getFileName() {
        return this.fileAccess.getFilename();
    }

    @Override
    public boolean isForm() {
        return this.res.isForm();
    }

    @Override
    public Printable getPrintable(int page) throws IndexOutOfBoundsException {
        return this;
    }

    public void setAllowDifferentPrintPageSizes(boolean allowDifferentPrintPageSizes) {
    }

    @Override
    public TextLines getTextLines() {
        return this.parser.getTextLines();
    }

    @Override
    public final void setInset(int width, int height) {
        this.options.setInset(width, height);
        AcroRenderer formRenderer = this.externalHandlers.getFormRenderer();
        if (formRenderer != null) {
            formRenderer.setInsets(width, height);
        }
    }

    public void setPrintIndent(int oddPages, int evenPages) {
    }

    @Override
    public void setUserOffsets(int x, int y, int mode) {
        this.displayOffsets.setUserOffsets(x, y, (int)this.getHeight(), mode);
    }

    public Point getUserOffsets(int mode) {
        return this.displayOffsets.getUserOffsets(mode);
    }

    public final int[] getMaximumSize() {
        int[] pageSize = null;
        int displayView = this.options.getDisplayView();
        if (displayView != 1) {
            pageSize = this.pages.getPageSize(displayView);
        }
        int insetW = this.options.getInsetW();
        int insetH = this.options.getInsetH();
        if (pageSize == null) {
            pageSize = this.displayRotation == 90 || this.displayRotation == 270 ? new int[]{this.y_size + insetW + insetW, this.x_size + insetH + insetH} : new int[]{this.x_size + insetW + insetW, this.y_size + insetH + insetH};
        }
        if (pageSize == null) {
            pageSize = this.getMinimumSize();
        }
        return pageSize;
    }

    private int[] getMinimumSize() {
        return new int[]{100 + this.options.getInsetW(), 100 + this.options.getInsetH()};
    }

    @Override
    @Deprecated
    public final void updateCursorBoxOnScreen(java.awt.Rectangle newOutlineRectangle, Color outlineColor) {
        if (this.options.getDisplayView() != 1) {
            return;
        }
        throw new RuntimeException(" updateCursorBoxOnScreen called in PdfDecoderFxm please call updateCursorBoxOnScreenFX instead");
    }

    @Override
    public final void updateCursorBoxOnScreen(int[] rectParams, int outlineColor) {
        if (this.options.getDisplayView() != 1) {
            return;
        }
        this.pages.updateCursorBoxOnScreen(rectParams, outlineColor, this.getPageNumber(), this.x_size, this.y_size);
    }

    @Override
    public final int getPDFWidth() {
        int insetW = this.options.getInsetW();
        if (this.displayRotation == 90 || this.displayRotation == 270) {
            return this.y_size + insetW + insetW;
        }
        return this.x_size + insetW + insetW;
    }

    @Override
    public final int getPDFHeight() {
        int insetH = this.options.getInsetH();
        if (this.displayRotation == 90 || this.displayRotation == 270) {
            return this.x_size + insetH + insetH;
        }
        return this.y_size + insetH + insetH;
    }

    @Override
    public final void setPDFBorder(Border newBorder) {
        this.myBorder = newBorder;
    }

    @Override
    public void setHardwareAccelerationforScreen(boolean useAcceleration) {
        this.options.useHardwareAcceleration(useAcceleration);
    }

    @Override
    public int getScrollInterval() {
        return this.scrollInterval;
    }

    @Override
    public void setScrollInterval(int scrollInterval) {
        this.scrollInterval = scrollInterval;
    }

    @Override
    public int getDisplayView() {
        return this.options.getDisplayView();
    }

    public void setPrintPageScalingMode(int pageScalingMode) {
    }

    public void setUsePDFPaperSize(boolean usePDFPaperSize) {
    }

    @Override
    public float getScaling() {
        return this.scaling;
    }

    @Override
    public int getInsetH() {
        return this.options.getInsetH();
    }

    @Override
    public int getInsetW() {
        return this.options.getInsetW();
    }

    @Override
    public int getNumberOfPages() {
        return -1;
    }

    @Override
    public PageFormat getPageFormat(int p) throws IndexOutOfBoundsException {
        return null;
    }

    public static PageFormat getUserSetPageFormat(int p) throws IndexOutOfBoundsException {
        return null;
    }

    public void setCenterOnScaling(boolean center) {
    }

    public void setPrintAutoRotate(boolean rotate) {
    }

    public void setPageFormat(int p, PageFormat pf) {
    }

    public void setPageFormat(PageFormat pf) {
    }

    public static void setPagePrintRange(SetOfIntegerSyntax range) throws PdfException {
        if (range == null) {
            throw new PdfException("[PDF] null page range entered");
        }
    }

    public void setPrintPageMode(int mode) {
    }

    public final void stopPrinting() {
    }

    public static int getCurrentPrintPage() {
        return -2;
    }

    public void resetCurrentPrintPage() {
        this.getFormRenderer().getCompData().resetAfterPrinting();
    }

    @Override
    public void setScaling(float x) {
        this.scaling = x;
    }

    @Override
    public int[] getMaxSizeWH() {
        return this.getMaximumSize();
    }

    @Override
    public int[] getPaneBounds() {
        int[] boundsArr = new int[]{(int)this.getBoundsInLocal().getWidth(), (int)this.getBoundsInLocal().getHeight()};
        return boundsArr;
    }

    @Override
    public void repaintPane(int page) {
        this.curThumbPage = page;
        Map areas = this.parser.getTextLines().getAllHighlights();
        if (areas != null) {
            int[][] rawRects = (int[][])areas.get(page);
            if (rawRects != null) {
                highlights = JavaFXPreferences.shiftColorSpaceToFX(color);
                Object[] rects = new Rectangle[rawRects.length];
                for (int i = 0; i < rects.length; ++i) {
                    rects[i] = new Rectangle((double)rawRects[i][0], (double)rawRects[i][1], (double)rawRects[i][2], (double)rawRects[i][3]);
                    rects[i].setFill((Paint)highlights);
                    rects[i].setOpacity((double)opacity);
                }
                this.highlightsPane.getChildren().clear();
                this.highlightsPane.getChildren().addAll(rects);
            }
        } else {
            this.highlightsPane.getChildren().clear();
        }
        this.drawHighlightsForImage();
        this.drawPreviewImage(null, new java.awt.Rectangle((int)this.getBoundsInLocal().getMinX(), (int)this.getBoundsInLocal().getMinY(), (int)this.getBoundsInLocal().getWidth(), (int)this.getBoundsInLocal().getHeight()));
    }

    private void drawHighlightsForImage() {
        int[] highlight = this.pages.getHighlightedImage();
        if (highlight == null) {
            if (this.imageHighlighter != null) {
                this.highlightsPane.getChildren().remove((Object)this.imageHighlighter);
                this.imageHighlighter = null;
            }
        } else if (highlight.length > 0) {
            if (highlight[0] < 0) {
                highlight[0] = 0;
            }
            if (highlight[1] < 0) {
                highlight[1] = 0;
            }
            if (highlight[0] + highlight[2] > this.max_x) {
                highlight[2] = this.max_x - highlight[0];
            }
            if (highlight[1] + highlight[3] > this.max_y) {
                highlight[3] = this.max_y - highlight[1];
            }
            this.imageHighlighter = new Rectangle((double)highlight[0], (double)highlight[1], (double)highlight[2], (double)highlight[3]);
            this.imageHighlighter.setStroke((Paint)javafx.scene.paint.Color.BLACK);
            this.imageHighlighter.setFill((Paint)javafx.scene.paint.Color.rgb((int)0, (int)0, (int)0, (double)0.25));
            this.highlightsPane.getChildren().add((Object)this.imageHighlighter);
        }
    }

    @Override
    public void setBorderPresent(boolean borderPresent) {
        this.isBorderPresent = borderPresent;
    }

    @Override
    public boolean isBorderPresent() {
        return this.isBorderPresent;
    }

    @Override
    public void setPreviewThumbnail(BufferedImage previewImage, String previewText) {
        Group group;
        if (this.previewThumbnail == null) {
            this.previewThumbnail = new Canvas((double)(previewImage.getWidth() + 20), (double)(previewImage.getHeight() + 40));
        }
        if (!(group = (Group)this.getParent()).getChildren().contains((Object)this.previewThumbnail)) {
            group.getChildren().add((Object)this.previewThumbnail);
        }
        this.previewImage = SwingFXUtils.toFXImage((BufferedImage)previewImage, null);
        this.previewText = previewText;
    }

    @Override
    public int getTextPrint() {
        return this.textPrint;
    }

    @Override
    public void repaint() {
    }

    @Override
    public java.awt.Rectangle getVisibleRect() {
        return null;
    }

    static {
        String name = System.getProperty("os.name");
        if (name.equals("Mac OS X")) {
            DecoderOptions.isRunningOnMac = true;
        } else if (name.startsWith("Windows")) {
            DecoderOptions.isRunningOnWindows = true;
        } else if (name.startsWith("AIX")) {
            DecoderOptions.isRunningOnAIX = true;
        } else if (name.equals("Linux")) {
            DecoderOptions.isRunningOnLinux = true;
        }
        try {
            DecoderOptions.javaVersion = Float.parseFloat(System.getProperty("java.specification.version"));
        }
        catch (NumberFormatException e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        if (LogWriter.isRunningFromIDE) {
            DevFlags.addShutdownHook();
        }
        color = DecoderOptions.highlightColor.getRGB();
        opacity = DecoderOptions.highlightComposite;
    }
}

