/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import org.jpedal.PdfDecoderInt;
import org.jpedal.exception.PdfException;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.utils.LogWriter;

public class ThumbnailDecoder {
    private final PdfDecoderInt decode_pdf;

    public ThumbnailDecoder(PdfDecoderInt decode_pdf) {
        this.decode_pdf = decode_pdf;
    }

    public final synchronized BufferedImage getPageAsThumbnail(int pageNumber, int height) {
        BufferedImage newImg = null;
        try {
            AcroRenderer formRenderer = this.decode_pdf.getFormRenderer();
            boolean originalRasterize = formRenderer.getCompData().formsRasterizedForDisplay();
            boolean formsAlreadyDecoded = formRenderer.getCompData().getFormList(true)[pageNumber] != null;
            formRenderer.getCompData().setRasterizeForms(true);
            float scaling = this.decode_pdf.getScaling();
            if (scaling > 0.5f) {
                this.decode_pdf.setScaling(0.5f);
            }
            BufferedImage pageImage = this.decode_pdf.getPageAsImage(pageNumber);
            if (scaling > 0.5f) {
                this.decode_pdf.setScaling(scaling);
            }
            formRenderer.getCompData().setRasterizeForms(originalRasterize);
            if (!formsAlreadyDecoded) {
                formRenderer.getCompData().getFormList((boolean)true)[pageNumber] = null;
                formRenderer.getCompData().getFormList((boolean)false)[pageNumber] = null;
            }
            int imgHeight = pageImage.getHeight();
            double scale = (double)height / (double)imgHeight;
            int width = (int)((double)pageImage.getWidth() * scale);
            newImg = new BufferedImage(width, height, 2);
            Graphics g = newImg.getGraphics();
            g.drawImage(pageImage, 0, 0, width, height, null);
            g.dispose();
        }
        catch (PdfException e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        return newImg;
    }
}

