/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfColor;

public class CalRGBColorSpace
extends GenericColorSpace {
    private static final long serialVersionUID = 4569336292751894930L;
    private int r;
    private int g;
    private int b;
    private static final double cs00 = 3.240449;
    private static final double cs01 = -1.537136;
    private static final double cs02 = -0.498531;
    private static final double cs10 = -0.969265;
    private static final double cs11 = 1.876011;
    private static final double cs12 = 0.041556;
    private static final double cs20 = 0.055643;
    private static final double cs21 = -0.204026;
    private static final double cs22 = 1.057229;
    private float lastC = -255.0f;
    private float lastI = -255.0f;
    private float lastE = -255.0f;

    public CalRGBColorSpace(float[] whitepoint, float[] matrix, float[] gamma) {
        this.cs = ColorSpace.getInstance(1001);
        this.setCIEValues(whitepoint, null, matrix, gamma);
        this.setType(1008872003);
    }

    @Override
    public byte[] dataToRGBByteArray(byte[] data, int w, int h, boolean arrayInverted) {
        int size = w * h;
        for (int i = 0; i < size * 3; i += 3) {
            float cl = data[i] & 0xFF;
            float ca = data[i + 1] & 0xFF;
            float cb = data[i + 2] & 0xFF;
            this.convertToRGB(cl, ca, cb);
            data[i] = (byte)this.r;
            data[i + 1] = (byte)this.g;
            data[i + 2] = (byte)this.b;
        }
        return data;
    }

    @Override
    public final BufferedImage dataToRGB(byte[] data, int width, int height) {
        data = this.dataToRGBByteArray(data, width, height, false);
        DataBufferByte db = new DataBufferByte(data, data.length);
        int[] bands = new int[]{0, 1, 2};
        BufferedImage image = new BufferedImage(width, height, 1);
        WritableRaster raster = Raster.createInterleavedRaster(db, width, height, width * 3, 3, bands, null);
        image.setData(raster);
        return image;
    }

    @Override
    public final void setColor(String[] number_values, int items) {
        float[] colValues = new float[items];
        for (int ii = 0; ii < items; ++ii) {
            colValues[ii] = Float.parseFloat(number_values[ii]);
        }
        this.setColor(colValues, items);
    }

    @Override
    public final void reset() {
        this.lastC = -255.0f;
        this.lastI = -255.0f;
        this.lastE = -255.0f;
        this.r = 0;
        this.g = 0;
        this.b = 0;
        this.currentColor = new PdfColor(0, 0, 0);
    }

    @Override
    public final void setColor(float[] number_values, int items) {
        float[] A = new float[]{1.0f, 1.0f, 1.0f};
        if (items == 3) {
            for (int i = 0; i < items; ++i) {
                A[i] = number_values[i];
                if (!(A[i] > 1.0f)) continue;
                return;
            }
            this.convertToRGB(A[0], A[1], A[2]);
            this.currentColor = new PdfColor(this.r, this.g, this.b);
        } else if (items == 1 && this.getIndexedMap() != null) {
            int ptr = (int)(number_values[0] * 3.0f);
            byte[] cmap = this.getIndexedMap();
            A[0] = (float)(cmap[ptr] & 0xFF) / 255.0f;
            A[1] = (float)(cmap[ptr + 1] & 0xFF) / 255.0f;
            A[2] = (float)(cmap[ptr + 2] & 0xFF) / 255.0f;
            this.convertToRGB(A[0], A[1], A[2]);
            this.currentColor = new PdfColor(this.r, this.g, this.b);
        }
    }

    private void convertToRGB(float C, float I, float E) {
        if (this.lastC != C || this.lastI != I || this.lastE != E) {
            double ag = Math.pow(C, this.G[0]);
            double bg = Math.pow(I, this.G[1]);
            double cg = Math.pow(E, this.G[2]);
            double X = (double)this.Ma[0] * ag + (double)this.Ma[3] * bg + (double)this.Ma[6] * cg;
            double Y = (double)this.Ma[1] * ag + (double)this.Ma[4] * bg + (double)this.Ma[7] * cg;
            double Z = (double)this.Ma[2] * ag + (double)this.Ma[5] * bg + (double)this.Ma[8] * cg;
            double rawR = 3.240449 * X + -1.537136 * Y + -0.498531 * Z;
            double rawG = -0.969265 * X + 1.876011 * Y + 0.041556 * Z;
            double rawB = 0.055643 * X + -0.204026 * Y + 1.057229 * Z;
            double kr = 1.0 / (3.240449 * (double)this.W[0] + -1.537136 * (double)this.W[1] + -0.498531 * (double)this.W[2]);
            double kg = 1.0 / (-0.969265 * (double)this.W[0] + 1.876011 * (double)this.W[1] + 0.041556 * (double)this.W[2]);
            double kb = 1.0 / (0.055643 * (double)this.W[0] + -0.204026 * (double)this.W[1] + 1.057229 * (double)this.W[2]);
            this.r = (int)(255.0 * Math.pow(CalRGBColorSpace.clip(rawR * kr), 0.5));
            this.g = (int)(255.0 * Math.pow(CalRGBColorSpace.clip(rawG * kg), 0.5));
            this.b = (int)(255.0 * Math.pow(CalRGBColorSpace.clip(rawB * kb), 0.5));
            this.lastC = C;
            this.lastI = I;
            this.lastE = E;
        }
    }

    static double clip(double v) {
        if (v > 1.0) {
            return 1.0;
        }
        return v;
    }
}

