/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.RenderingHints;
import java.lang.reflect.Field;
import org.jpedal.utils.LogWriter;

public class ColorSpaces {
    public static final int ICC = 1247168582;
    public static final int CalGray = 391471749;
    public static final int DeviceGray = 1568372915;
    public static final int DeviceN = 960981604;
    public static final int Separation = -2073385820;
    public static final int Pattern = 1146450818;
    public static final int Lab = 1847602;
    public static final int Indexed = 895578984;
    public static final int DeviceRGB = 1785221209;
    public static final int CalRGB = 1008872003;
    public static final int DeviceCMYK = 1498837125;
    public static final RenderingHints hints = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);

    public static final int convertNameToID(String name) {
        int id = -1;
        if (name.contains("Indexed")) {
            id = 895578984;
        } else if (name.contains("Separation")) {
            id = -2073385820;
        } else if (name.contains("DeviceN")) {
            id = 960981604;
        } else if (name.contains("DeviceCMYK") || name.contains("CMYK")) {
            id = 1498837125;
        } else if (name.contains("CalGray")) {
            id = 391471749;
        } else if (name.contains("CalRGB")) {
            id = 1008872003;
        } else if (name.contains("Lab")) {
            id = 1847602;
        } else if (name.contains("ICCBased")) {
            id = 1247168582;
        } else if (name.contains("Pattern")) {
            id = 1146450818;
        } else if (name.contains("DeviceRGB") || name.contains("RGB")) {
            id = 1785221209;
        } else if (name.contains("DeviceGray") || name.indexOf(71) != -1) {
            id = 1568372915;
        }
        return id;
    }

    public static String showAsConstant(int parameterConstant) {
        Field[] ts = ColorSpaces.class.getFields();
        int count = ts.length;
        String type = null;
        for (int ii = 0; ii < count; ++ii) {
            try {
                int t = ts[ii].getInt(new ColorSpaces());
                if (t != parameterConstant) continue;
                type = "ColorSpaces." + ts[ii].getName();
                count = ii;
                continue;
            }
            catch (IllegalAccessException e) {
                LogWriter.writeLog("Exception: " + e.getMessage());
                continue;
            }
            catch (IllegalArgumentException ee) {
                LogWriter.writeLog("Exception: " + ee.getMessage());
            }
        }
        return type;
    }

    public static String IDtoString(int id) {
        switch (id) {
            case 1247168582: {
                return "ICC";
            }
            case 391471749: {
                return "CalGray";
            }
            case 1568372915: {
                return "DeviceGray";
            }
            case 960981604: {
                return "DeviceN";
            }
            case -2073385820: {
                return "Separation";
            }
            case 1146450818: {
                return "Pattern";
            }
            case 1847602: {
                return "Lab";
            }
            case 895578984: {
                return "Indexed";
            }
            case 1785221209: {
                return "DeviceRGB";
            }
            case 1008872003: {
                return "CalRGB";
            }
            case 1498837125: {
                return "DeviceCMYK";
            }
        }
        return "unknown";
    }

    static {
        hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        hints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        hints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
    }
}

