/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import org.jpedal.JDeliHelper;
import org.jpedal.color.CMYKtoRGB;
import org.jpedal.color.ColorSpaces;
import org.jpedal.color.JPEGDecoder;
import org.jpedal.color.PdfColor;
import org.jpedal.color.PdfPaint;
import org.jpedal.examples.handlers.DefaultImageHelper;
import org.jpedal.exception.PdfException;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;
import org.w3c.dom.NodeList;

public class GenericColorSpace
implements Cloneable,
Serializable {
    boolean isConverted;
    float[] rawValues;
    Map patterns;
    float[][] CTM;
    private int size;
    float c = -1.0f;
    float y = -1.0f;
    float m = -1.0f;
    float k = -1.0f;
    float[] W;
    float[] G;
    float[] Ma;
    float[] R;
    static ColorSpace rgbCS;
    public static final String cb = "<color ";
    public static final String ce = "</color>";
    private int value = 1785221209;
    static ColorConvertOp CSToRGB;
    ColorSpace cs;
    int type;
    PdfPaint currentColor = new PdfColor(0, 0, 0);
    static ColorModel rgbModel;
    private static ICC_Profile ICCProfileForRGB;
    public static boolean fasterPNG;
    boolean failed;
    int alternative = -1;
    private PdfObject decodeParms;
    private boolean hasYCCKimages;
    boolean isPrinting;
    private static final int[] bands4;
    private int rawCSType;
    int r;
    int g;
    int b;
    byte[] IndexedColorMap;
    String pantoneName;
    int componentCount = 3;
    GraphicsState gs;
    int pageWidth;
    int pageHeight;

    public void setPrinting(boolean isPrinting) {
        this.isPrinting = isPrinting;
    }

    protected static void initCMYKColorspace() throws PdfException {
        try {
            if (ICCProfileForRGB == null) {
                rgbModel = new ComponentColorModel(rgbCS, new int[]{8, 8, 8}, false, false, 1, 0);
            } else {
                int compCount = rgbCS.getNumComponents();
                int[] values = new int[compCount];
                for (int i = 0; i < compCount; ++i) {
                    values[i] = 8;
                }
                rgbModel = new ComponentColorModel(rgbCS, values, false, false, 1, 0);
            }
            ICC_Profile p = ICC_Profile.getInstance(GenericColorSpace.class.getResourceAsStream("/org/jpedal/res/cmm/cmyk.icm"));
            ICC_ColorSpace cmykCS = new ICC_ColorSpace(p);
            CSToRGB = new ColorConvertOp(cmykCS, rgbCS, ColorSpaces.hints);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e.getMessage() + " initialising color components");
            throw new PdfException("[PDF] Unable to create CMYK colorspace. Check cmyk.icm in jar file");
        }
    }

    public void reset() {
        this.currentColor = new PdfColor(0, 0, 0);
    }

    public boolean isInvalid() {
        return this.failed;
    }

    public int getIndexSize() {
        return this.size;
    }

    public PdfPaint getColor() {
        return this.currentColor;
    }

    public ColorSpace getColorSpace() {
        return this.cs;
    }

    GenericColorSpace() {
        this.cs = rgbCS;
    }

    protected void setAlternateColorSpace(int alt) {
        this.alternative = alt;
    }

    public int getAlternateColorSpace() {
        return this.alternative;
    }

    public void restoreColorStatus() {
        this.currentColor = new PdfColor(this.r, this.g, this.b);
    }

    public Object clone() {
        Object o;
        try {
            o = super.clone();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to clone object " + e);
        }
        return o;
    }

    protected final BufferedImage nonRGBJPEGToRGBImage(byte[] data, int w, int h, float[] decodeArray, int pX, int pY) {
        ImageInputStream iin;
        ImageReader iir;
        ByteArrayInputStream in;
        BufferedImage image;
        block34: {
            boolean isProcessed = false;
            image = null;
            in = null;
            iir = null;
            iin = null;
            try {
                Raster ras;
                int cmykType;
                block33: {
                    if (CSToRGB == null) {
                        GenericColorSpace.initCMYKColorspace();
                    }
                    CSToRGB = new ColorConvertOp(this.cs, rgbCS, ColorSpaces.hints);
                    in = new ByteArrayInputStream(data);
                    cmykType = GenericColorSpace.getJPEGTransform(data);
                    try {
                        ImageReader o;
                        Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName("JPEG");
                        while (iterator.hasNext() && !(iir = (o = iterator.next())).canReadRaster()) {
                        }
                    }
                    catch (Exception e) {
                        LogWriter.writeLog("Unable to find jars on classpath " + e);
                        return null;
                    }
                    ImageIO.setUseCache(false);
                    iin = ImageIO.createImageInputStream(in);
                    iir.setInput(iin, true);
                    ras = iir.readRaster(0, null);
                    if (decodeArray != null) {
                        if (decodeArray.length == 6 && decodeArray[0] == 1.0f && decodeArray[1] == 0.0f && decodeArray[2] == 1.0f && decodeArray[3] == 0.0f && decodeArray[4] == 1.0f && decodeArray[5] == 0.0f || decodeArray.length > 2 && decodeArray[0] == 1.0f && decodeArray[1] == 0.0f) {
                            DataBuffer buf = ras.getDataBuffer();
                            int count = buf.getSize();
                            for (int ii = 0; ii < count; ++ii) {
                                buf.setElem(ii, 255 - buf.getElem(ii));
                            }
                        } else if ((decodeArray.length != 6 || decodeArray[0] != 0.0f || decodeArray[1] != 1.0f || decodeArray[2] != 0.0f || decodeArray[3] != 1.0f || decodeArray[4] != 0.0f || decodeArray[5] != 1.0f) && decodeArray != null && decodeArray.length > 0) {
                            LogWriter.writeLog("CMYK decode array " + Arrays.toString(decodeArray) + " not implemented");
                        }
                    }
                    if (this.cs.getNumComponents() == 1 && cmykType == 0) {
                        image = JPEGDecoder.grayJPEGToRGBImage(data, pX, pY, false);
                        if (image != null) {
                            isProcessed = true;
                        }
                    } else if (this.cs.getNumComponents() == 4) {
                        isProcessed = true;
                        try {
                            if (cmykType == 2) {
                                this.hasYCCKimages = true;
                                image = ColorSpaceConvertor.iccConvertCMYKImageToRGB(((DataBufferByte)ras.getDataBuffer()).getData(), w, h);
                                break block33;
                            }
                            ras = GenericColorSpace.cleanupRaster(ras, pX, pY, 4);
                            w = ras.getWidth();
                            h = ras.getHeight();
                            image = CMYKtoRGB.convert(ras, w, h);
                        }
                        catch (Exception e) {
                            LogWriter.writeLog("Problem with JPEG conversion " + e);
                        }
                    } else if (cmykType != 0) {
                        image = iir.read(0);
                        image = GenericColorSpace.cleanupImage(image, pX, pY);
                        isProcessed = true;
                    }
                }
                if (isProcessed) break block34;
                if (cmykType == 4) {
                    ras = GenericColorSpace.cleanupRaster(ras, pX, pY, 4);
                    int width = ras.getWidth();
                    int height = ras.getHeight();
                    WritableRaster rgbRaster = rgbModel.createCompatibleWritableRaster(width, height);
                    CSToRGB.filter(ras, rgbRaster);
                    image = new BufferedImage(width, height, 1);
                    image.setData(rgbRaster);
                    break block34;
                }
                boolean isYCC = false;
                try {
                    IIOMetadata metadata = iir.getImageMetadata(0);
                    String metadataFormat = metadata.getNativeMetadataFormatName();
                    IIOMetadataNode iioNode = (IIOMetadataNode)metadata.getAsTree(metadataFormat);
                    NodeList children = iioNode.getElementsByTagName("app14Adobe");
                    if (children.getLength() > 0) {
                        isYCC = true;
                    }
                }
                catch (Exception ee) {
                    LogWriter.writeLog("[PDF] Unable to read metadata on Jpeg " + ee);
                }
                LogWriter.writeLog("COLOR_ID_YCbCr image");
                image = isYCC ? DefaultImageHelper.read(data) : ColorSpaceConvertor.algorithmicConvertYCbCrToRGB(((DataBufferByte)ras.getDataBuffer()).getData(), w, h);
                image = GenericColorSpace.cleanupImage(image, pX, pY);
                image = ColorSpaceConvertor.convertToRGB(image);
            }
            catch (Exception ee) {
                image = null;
                LogWriter.writeLog("Couldn't read JPEG, not even raster: " + ee);
            }
            catch (Error err) {
                LogWriter.writeLog("JPeg error " + err);
                if (iir != null) {
                    iir.dispose();
                }
                if (iin == null) break block34;
                try {
                    iin.flush();
                }
                catch (IOException e) {
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
            }
        }
        try {
            if (in != null) {
                in.close();
            }
            if (iir != null) {
                iir.dispose();
            }
            if (iin != null) {
                iin.close();
            }
        }
        catch (Exception ee) {
            LogWriter.writeLog("Problem closing  " + ee);
        }
        return image;
    }

    protected static BufferedImage cleanupImage(BufferedImage image, int pX, int pY) {
        try {
            int imageType = image.getType();
            if (GenericColorSpace.getSampling(image.getWidth(), image.getHeight(), pX, pY) <= 1 || imageType == 0) {
                return image;
            }
            if (imageType == 5) {
                return GenericColorSpace.cleanupBGRImage(image, pX, pY);
            }
            if (imageType == 5) {
                image = ColorSpaceConvertor.convertToRGB(image);
            }
            Raster ras = GenericColorSpace.cleanupRaster(image.getData(), pX, pY, image.getColorModel().getNumColorComponents());
            image = new BufferedImage(ras.getWidth(), ras.getHeight(), image.getType());
            image.setData(ras);
            return image;
        }
        catch (Error err) {
            LogWriter.writeLog("[PDF] Error in cleanupImage " + err);
            return image;
        }
    }

    private static int getSampling(int w, int h, int pX, int pY) {
        int sampling = 1;
        int newW = w;
        if (pX > 0 && pY > 0) {
            int scaleY;
            int smallestH = pY << 2;
            int smallestW = pX << 2;
            for (int newH = h; newW > smallestW && newH > smallestH; newW >>= 1, newH >>= 1) {
                sampling <<= 1;
            }
            int scaleX = w / pX;
            if (scaleX < 1) {
                scaleX = 1;
            }
            if ((scaleY = h / pY) < 1) {
                scaleY = 1;
            }
            if ((sampling = scaleX) > scaleY) {
                sampling = scaleY;
            }
        }
        return sampling;
    }

    protected static Raster cleanupRaster(Raster ras, int pX, int pY, int comp) {
        int newH;
        String avoidCleanupRaster = System.getProperty("org.jpedal.avoidCleanupRaster");
        if (avoidCleanupRaster != null && avoidCleanupRaster.toLowerCase().contains("true")) {
            return ras;
        }
        byte[] buffer = null;
        int[] intBuffer = null;
        DataBuffer data = ras.getDataBuffer();
        boolean type = data instanceof DataBufferInt;
        if (type) {
            intBuffer = ((DataBufferInt)data).getData();
        } else {
            int layerCount = ras.getNumBands();
            if (layerCount == comp) {
                buffer = ((DataBufferByte)data).getData();
            } else if (layerCount == 1) {
                byte[] rawBuffer = ((DataBufferByte)ras.getDataBuffer()).getData();
                int size = rawBuffer.length;
                int realSize = size * comp;
                int j = 0;
                int i = 0;
                buffer = new byte[realSize];
                do {
                    for (int a = 0; a < comp; ++a) {
                        buffer[j] = rawBuffer[i];
                        ++j;
                    }
                } while (++i < size);
            } else if (LogWriter.isRunningFromIDE) {
                throw new RuntimeException("Unknown case " + layerCount + " in GenericColorspace");
            }
        }
        int sampling = 1;
        int w = ras.getWidth();
        int h = ras.getHeight();
        int newW = w;
        if (pX > 0 && pY > 0) {
            int scaleY;
            int smallestH = pY << 2;
            int smallestW = pX << 2;
            for (newH = h; newW > smallestW && newH > smallestH; newW >>= 1, newH >>= 1) {
                sampling <<= 1;
            }
            int scaleX = w / pX;
            if (scaleX < 1) {
                scaleX = 1;
            }
            if ((scaleY = h / pY) < 1) {
                scaleY = 1;
            }
            if ((sampling = scaleX) > scaleY) {
                sampling = scaleY;
            }
        }
        if (sampling > 1) {
            newW = w / sampling;
            newH = h / sampling;
            int origLineLength = w;
            try {
                byte[] newData = new byte[newW * newH * comp];
                if (!type) {
                    origLineLength = w * comp;
                }
                for (int y = 0; y < newH; ++y) {
                    for (int x = 0; x < newW; ++x) {
                        int wCount = sampling;
                        int hCount = sampling;
                        int wGapLeft = w - x;
                        int hGapLeft = h - y;
                        if (wCount > wGapLeft) {
                            wCount = wGapLeft;
                        }
                        if (hCount > hGapLeft) {
                            hCount = hGapLeft;
                        }
                        for (int jj = 0; jj < comp; ++jj) {
                            int byteTotal = 0;
                            int count = 0;
                            for (int yy = 0; yy < hCount; ++yy) {
                                for (int xx = 0; xx < wCount; ++xx) {
                                    byteTotal = !type ? (byteTotal += buffer[(yy + y * sampling) * origLineLength + (x * sampling * comp + xx * comp + jj)] & 0xFF) : (byteTotal += intBuffer[(yy + y * sampling) * origLineLength + x * sampling + xx] >> 8 * (2 - jj) & 0xFF);
                                    ++count;
                                }
                            }
                            if (count <= 0) continue;
                            newData[jj + x * comp + newW * y * comp] = (byte)(byteTotal / count);
                        }
                    }
                }
                int[] bands = new int[comp];
                for (int jj2 = 0; jj2 < comp; ++jj2) {
                    bands[jj2] = jj2;
                }
                ras = Raster.createInterleavedRaster(new DataBufferByte(newData, newData.length), newW, newH, newW * comp, comp, bands, null);
            }
            catch (Exception e) {
                LogWriter.writeLog("Problem with Image " + e);
            }
        }
        return ras;
    }

    private static BufferedImage cleanupBGRImage(BufferedImage img, int pX, int pY) {
        int newH;
        String avoidCleanupRaster = System.getProperty("org.jpedal.avoidCleanupRaster");
        if (avoidCleanupRaster != null && avoidCleanupRaster.toLowerCase().contains("true")) {
            return img;
        }
        if (System.getProperty("java.version").startsWith("1.5")) {
            return img;
        }
        Raster ras = img.getData();
        int comp = img.getColorModel().getNumColorComponents();
        byte[] buffer = null;
        int[] intBuffer = null;
        DataBuffer data = ras.getDataBuffer();
        boolean type = data instanceof DataBufferInt;
        if (type) {
            intBuffer = ((DataBufferInt)data).getData();
        } else {
            int layerCount = ras.getNumBands();
            if (layerCount == comp) {
                buffer = ((DataBufferByte)data).getData();
            } else if (layerCount == 1) {
                byte[] rawBuffer = ((DataBufferByte)ras.getDataBuffer()).getData();
                int size = rawBuffer.length;
                int realSize = size * comp;
                int j = 0;
                int i = 0;
                buffer = new byte[realSize];
                do {
                    for (int a = 0; a < comp; ++a) {
                        buffer[j] = rawBuffer[i];
                        ++j;
                    }
                } while (++i < size);
            } else if (LogWriter.isRunningFromIDE) {
                throw new RuntimeException("Unknown case in GenericColorspace");
            }
        }
        int sampling = 1;
        int w = ras.getWidth();
        int h = ras.getHeight();
        int newW = w;
        if (pX > 0 && pY > 0) {
            int scaleY;
            int smallestH = pY << 2;
            int smallestW = pX << 2;
            for (newH = h; newW > smallestW && newH > smallestH; newW >>= 1, newH >>= 1) {
                sampling <<= 1;
            }
            int scaleX = w / pX;
            if (scaleX < 1) {
                scaleX = 1;
            }
            if ((scaleY = h / pY) < 1) {
                scaleY = 1;
            }
            if ((sampling = scaleX) > scaleY) {
                sampling = scaleY;
            }
        }
        if (sampling > 1) {
            WritableRaster newRas = (WritableRaster)ras;
            newW = w / sampling;
            newH = h / sampling;
            int origLineLength = w;
            try {
                int[] newData = new int[comp];
                if (!type) {
                    origLineLength = w * comp;
                }
                for (int y = 0; y < newH; ++y) {
                    for (int x = 0; x < newW; ++x) {
                        int wCount = sampling;
                        int hCount = sampling;
                        int wGapLeft = w - x;
                        int hGapLeft = h - y;
                        if (wCount > wGapLeft) {
                            wCount = wGapLeft;
                        }
                        if (hCount > hGapLeft) {
                            hCount = hGapLeft;
                        }
                        block11: for (int jj = 0; jj < comp; ++jj) {
                            int byteTotal = 0;
                            int count = 0;
                            for (int yy = 0; yy < hCount; ++yy) {
                                for (int xx = 0; xx < wCount; ++xx) {
                                    byteTotal = !type ? (byteTotal += buffer[(yy + y * sampling) * origLineLength + (x * sampling * comp + xx * comp + jj)] & 0xFF) : (byteTotal += intBuffer[(yy + y * sampling) * origLineLength + x * sampling + xx] >> 8 * (2 - jj) & 0xFF);
                                    ++count;
                                }
                            }
                            if (count <= 0) continue;
                            switch (jj) {
                                case 0: {
                                    newData[2] = byteTotal / count;
                                    continue block11;
                                }
                                case 2: {
                                    newData[0] = byteTotal / count;
                                    continue block11;
                                }
                                default: {
                                    newData[jj] = byteTotal / count;
                                }
                            }
                        }
                        newRas.setPixels(x, y, 1, 1, newData);
                    }
                }
                img = new BufferedImage(newW, newH, img.getType());
                img.setData(newRas);
            }
            catch (Exception e) {
                LogWriter.writeLog("Problem with Image " + e);
            }
        }
        return img;
    }

    private static int getJPEGTransform(byte[] data) {
        int xform = 0;
        int dataLength = data.length;
        int i = 0;
        int imax = dataLength - 2;
        block0: while (i < imax) {
            int type = data[i + 1] & 0xFF;
            i += 2;
            if (type == 1 || 208 <= type && type <= 218) continue;
            if (type == 218) {
                i = i + ((data[i] & 0xFF) << 8) + (data[i + 1] & 0xFF);
                while (true) {
                    if (i < imax && ((data[i] & 0xFF) != 255 || data[i + 1] == 0)) {
                        ++i;
                        continue;
                    }
                    int rst = data[i + 1] & 0xFF;
                    if (208 > rst || rst > 215) continue block0;
                    i += 2;
                }
            }
            if (i + 1 >= dataLength) continue;
            if (type == 238 && data[i + 2] == 65 && data[i + 3] == 100 && data[i + 4] == 111 && data[i + 5] == 98 && data[i + 6] == 101) {
                xform = data[i + 13] & 0xFF;
                break;
            }
            i = i + ((data[i] & 0xFF) << 8) + (data[i + 1] & 0xFF);
        }
        return xform;
    }

    public void setIndex(byte[] IndexedColorMap, int size) {
        this.IndexedColorMap = IndexedColorMap;
        this.size = size;
    }

    protected int getIndexedColorComponent(int count) {
        int value = 255;
        if (this.IndexedColorMap != null && (value = this.IndexedColorMap[count]) < 0) {
            value = 256 + value;
        }
        return value;
    }

    public byte[] getIndexedMap() {
        if (this.IndexedColorMap == null) {
            return null;
        }
        int size = this.IndexedColorMap.length;
        byte[] copy = new byte[size];
        System.arraycopy(this.IndexedColorMap, 0, copy, 0, size);
        return copy;
    }

    public void setColor(String[] value, int operandCount) {
    }

    public void setColor(float[] value, int operandCount) {
        if (LogWriter.isRunningFromIDE) {
            throw new RuntimeException(" called setColor(float[] in Generic for " + this);
        }
    }

    public BufferedImage JPEGToRGBImage(byte[] data, int w, int h, float[] decodeArray, int pX, int pY, boolean arrayInverted, PdfObject XObject2) {
        BufferedImage image;
        if (this.decodeParms != null && this.decodeParms.getInt(-1263544861) == 1 && this.value != 1568372915) {
            return JPEGDecoder.JPEGToRGBImageFromLUV(data, pX, pY);
        }
        try {
            image = DefaultImageHelper.read(data);
            if (image != null && !fasterPNG) {
                if (this.value != 1568372915) {
                    image = GenericColorSpace.cleanupImage(image, pX, pY);
                }
                if (this.value != 1568372915) {
                    image = ColorSpaceConvertor.convertToRGB(image);
                }
            }
        }
        catch (Exception ee) {
            image = null;
            LogWriter.writeLog("Problem reading JPEG: " + ee);
        }
        if (image == null) {
            image = JPEGDecoder.JPEGToRGBImageFromLUV(data, pX, pY);
        }
        if (arrayInverted && this.value == 1568372915) {
            DataBufferByte rgb = (DataBufferByte)image.getRaster().getDataBuffer();
            byte[] rawData = rgb.getData();
            for (int aa = 0; aa < rawData.length; ++aa) {
                rawData[aa] = (byte)(rawData[aa] ^ 0xFF);
            }
            image.setData(Raster.createRaster(image.getSampleModel(), new DataBufferByte(rawData, rawData.length), null));
        }
        return image;
    }

    public BufferedImage JPEG2000ToRGBImage(byte[] data, int w, int h, float[] decodeArray, int pX, int pY, int d) throws PdfException {
        BufferedImage image;
        try {
            image = JDeliHelper.JPEG2000ToRGBImage(data);
        }
        catch (Exception ex) {
            throw new PdfException(ex.getMessage());
        }
        if (image != null) {
            this.IndexedColorMap = null;
            byte[] index = this.getIndexedMap();
            if (index != null) {
                if (this.value != 1785221209) {
                    index = this.convertIndexToRGB(index);
                    int count = index.length;
                    for (int i = 0; i < count; i = (int)((byte)(i + 1))) {
                        index[i] = (byte)(index[i] ^ 0xFF);
                    }
                }
                data = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                image = ColorSpaceConvertor.convertIndexedToFlat(d, w, h, data, index, false, false);
            }
            if ((image = GenericColorSpace.cleanupImage(image, pX, pY)).getType() == 13) {
                BufferedImage oldImage = image;
                int newW = image.getWidth();
                int newH = image.getHeight();
                image = new BufferedImage(newW, newH, 1);
                Graphics2D g2 = (Graphics2D)image.getGraphics();
                g2.setPaint(Color.WHITE);
                g2.fillRect(0, 0, newW, newH);
                g2.drawImage((Image)oldImage, 0, 0, null);
            }
            ColorSpace cSpace = image.getColorModel().getColorSpace();
            int csType = cSpace.getType();
            int trnsType = image.getColorModel().getTransferType();
            if (image.getType() == 0 && (csType == 1000 || csType == 5) && trnsType == 0) {
                BufferedImage temp = new BufferedImage(image.getWidth(), image.getHeight(), 1);
                int[] tempData = ((DataBufferInt)temp.getRaster().getDataBuffer()).getData();
                byte[] imgData = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                int p = 0;
                for (int i = 0; i < tempData.length; ++i) {
                    int rgb;
                    tempData[i] = rgb = (imgData[p] & 0xFF) << 16 | (imgData[p + 1] & 0xFF) << 8 | imgData[p + 2] & 0xFF;
                    p += 3;
                }
                image = temp;
            } else {
                image = ColorSpaceConvertor.convertToRGB(image);
            }
        }
        return image;
    }

    public byte[] dataToRGBByteArray(byte[] data, int w, int h, boolean arrayInverted) {
        return data;
    }

    public BufferedImage dataToRGB(byte[] data, int w, int h) {
        BufferedImage image = new BufferedImage(w, h, 1);
        Raster raster = ColorSpaceConvertor.createInterleavedRaster(data, w, h);
        image.setData(raster);
        return image;
    }

    public int getID() {
        return this.value;
    }

    public final void setCIEValues(float[] W, float[] R, float[] Ma, float[] G2) {
        this.cs = ColorSpace.getInstance(1001);
        this.G = G2;
        this.Ma = Ma;
        this.W = W;
        this.R = R;
    }

    byte[] convert4Index(byte[] data) {
        int compCount = 4;
        if (this.value == 1498837125) {
            int len = data.length;
            byte[] rgb = new byte[len * 3 / 4];
            int j2 = 0;
            for (int ii = 0; ii < len; ii += 4) {
                float[] vals = new float[4];
                for (int j = 0; j < 4; ++j) {
                    vals[j] = (float)(data[ii + j] & 0xFF) / 255.0f;
                }
                this.setColor(vals, 4);
                int foreground = this.currentColor.getRGB();
                rgb[j2] = (byte)(foreground >> 16 & 0xFF);
                rgb[j2 + 1] = (byte)(foreground >> 8 & 0xFF);
                rgb[j2 + 2] = (byte)(foreground & 0xFF);
                j2 += 3;
                if (len - 4 - ii >= 4) continue;
                ii = len;
            }
            return rgb;
        }
        try {
            int width = data.length / 4;
            boolean height = true;
            DataBufferByte db = new DataBufferByte(data, data.length);
            WritableRaster raster = Raster.createInterleavedRaster(db, width, 1, width * 4, 4, bands4, null);
            if (CSToRGB == null) {
                GenericColorSpace.initCMYKColorspace();
                CSToRGB = new ColorConvertOp(this.cs, rgbCS, ColorSpaces.hints);
            }
            WritableRaster rgbRaster = rgbModel.createCompatibleWritableRaster(width, 1);
            CSToRGB.filter(raster, rgbRaster);
            DataBuffer convertedData = rgbRaster.getDataBuffer();
            int size = width * 1 * 3;
            data = new byte[size];
            for (int ii = 0; ii < size; ++ii) {
                data[ii] = (byte)convertedData.getElem(ii);
            }
        }
        catch (Exception ee) {
            LogWriter.writeLog("Exception  " + ee + " converting colorspace");
        }
        return data;
    }

    public byte[] convertIndexToRGB(byte[] index) {
        return index;
    }

    public String getXMLColorToken() {
        String colorToken;
        if (this.c == -1.0f) {
            if (this.currentColor instanceof Color) {
                Color col = (Color)((Object)this.currentColor);
                float c = (float)(255 - col.getRed()) / 255.0f;
                float m = (float)(255 - col.getGreen()) / 255.0f;
                float y = (float)(255 - col.getBlue()) / 255.0f;
                float k = c;
                if (k < m) {
                    k = m;
                }
                if (k < y) {
                    k = y;
                }
                colorToken = this.pantoneName == null ? "<color C='" + c + "' M='" + m + "' Y='" + y + "' K='" + k + "' >" : "<color C='" + c + "' M='" + m + "' Y='" + y + "' K='" + k + "' pantoneName='" + this.pantoneName + "' >";
            } else {
                colorToken = "<color type='shading'>";
            }
        } else {
            colorToken = this.pantoneName == null ? "<color C='" + this.c + "' M='" + this.m + "' Y='" + this.y + "' K='" + this.k + "' >" : "<color C='" + this.c + "' M='" + this.m + "' Y='" + this.y + "' K='" + this.k + "' pantoneName='" + this.pantoneName + "' >";
        }
        return colorToken;
    }

    public void setPattern(Map patterns, int pageWidth, int pageHeight, float[][] CTM) {
        this.patterns = patterns;
        this.pageWidth = pageWidth;
        this.pageHeight = pageHeight;
        this.CTM = CTM;
    }

    public void setColor(PdfPaint col) {
        this.currentColor = col;
    }

    public int getColorComponentCount() {
        return this.componentCount;
    }

    public void setGS(GraphicsState currentGraphicsState) {
        this.gs = currentGraphicsState;
    }

    public float[] getRawValues() {
        return this.rawValues;
    }

    public boolean isImageYCCK() {
        return this.hasYCCKimages;
    }

    public void setDecodeParms(PdfObject parms) {
        this.decodeParms = parms;
    }

    public boolean isIndexConverted() {
        return this.isConverted;
    }

    public void clearCache() {
    }

    public static ColorSpace getColorSpaceInstance() {
        ColorSpace rgbCS = ColorSpace.getInstance(1000);
        String profile = System.getProperty("org.jpedal.RGBprofile");
        if (profile != null) {
            try {
                rgbCS = new ICC_ColorSpace(ICC_Profile.getInstance(new FileInputStream(profile)));
                System.out.println("use " + profile);
            }
            catch (Exception e) {
                LogWriter.writeLog("[PDF] Problem " + e.getMessage() + " with ICC data ");
            }
        }
        return rgbCS;
    }

    int getType() {
        return this.type;
    }

    void setType(int rawValue) {
        this.value = rawValue;
        this.rawCSType = rawValue;
    }

    void setRawColorSpace(int rawType) {
        this.rawCSType = rawType;
    }

    public int getRawColorSpacePDFType() {
        return this.rawCSType;
    }

    public BufferedImage JPEG2000ToImage(byte[] data, int pX, int pY) throws PdfException {
        BufferedImage image;
        try {
            image = JDeliHelper.JPEG2000ToRGBImage(data);
            if (image != null) {
                image = GenericColorSpace.cleanupImage(image, pX, pY);
            }
        }
        catch (Exception ex) {
            throw new PdfException(ex.getMessage());
        }
        return image;
    }

    static {
        block3: {
            bands4 = new int[]{0, 1, 2, 3};
            String fasterPNG = System.getProperty("org.jpedal.fasterPNG");
            GenericColorSpace.fasterPNG = fasterPNG != null && fasterPNG.equalsIgnoreCase("true");
            String profile = System.getProperty("org.jpedal.RGBprofile");
            if (profile != null) {
                try {
                    ICCProfileForRGB = ICC_Profile.getInstance(new FileInputStream(profile));
                }
                catch (Exception e) {
                    LogWriter.writeLog("[PDF] Problem " + e.getMessage() + " with ICC data ");
                    if (ICCProfileForRGB != null) break block3;
                    throw new RuntimeException("Problem wth RGB profile " + profile + ' ' + e.getMessage());
                }
            }
        }
        rgbCS = ICCProfileForRGB != null ? new ICC_ColorSpace(ICCProfileForRGB) : ColorSpace.getInstance(1000);
    }
}

