/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.jpedal.JDeliHelper;
import org.jpedal.color.DeviceNColorSpace;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.examples.handlers.DefaultImageHelper;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.objects.raw.MaskObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.image.utils.ArrayUtils;
import org.jpedal.utils.LogWriter;

public class JPEGDecoder {
    static BufferedImage JPEGToRGBImageFromLUV(byte[] data, int pX, int pY) {
        BufferedImage image;
        try {
            Raster ras = DefaultImageHelper.readRasterFromJPeg(data);
            if (ras == null) {
                return null;
            }
            ras = GenericColorSpace.cleanupRaster(ras, pX, pY, 3);
            int width = ras.getWidth();
            int height = ras.getHeight();
            int imgSize = width * height;
            byte[] iData = ((DataBufferByte)ras.getDataBuffer()).getData();
            float r = 0.0f;
            float g = 0.0f;
            float b = 0.0f;
            float last_y = -1.0f;
            float last_cb = -1.0f;
            float last_cr = -1.0f;
            for (int i = 0; i < imgSize * 3; i += 3) {
                float y = iData[i] & 0xFF;
                float cb = iData[i + 1] & 0xFF;
                float cr = iData[i + 2] & 0xFF;
                if (y != last_y || cb != last_cb || cr != last_cr) {
                    r = y + 1.402f * (cr - 128.0f);
                    if (r < 0.0f) {
                        r = 0.0f;
                    } else if (r > 255.0f) {
                        r = 255.0f;
                    }
                    g = y - 0.344f * (cb - 128.0f) - 0.714f * (cr - 128.0f);
                    if (g < 0.0f) {
                        g = 0.0f;
                    } else if (g > 255.0f) {
                        g = 255.0f;
                    }
                    b = y + 1.772f * (cb - 128.0f);
                    if (b < 0.0f) {
                        b = 0.0f;
                    } else if (b > 255.0f) {
                        b = 255.0f;
                    }
                    last_y = y;
                    last_cb = cb;
                    last_cr = cr;
                }
                iData[i] = (byte)r;
                iData[i + 1] = (byte)g;
                iData[i + 2] = (byte)b;
            }
            DataBufferByte db = new DataBufferByte(iData, iData.length);
            int[] bands = new int[]{0, 1, 2};
            image = new BufferedImage(width, height, 1);
            WritableRaster raster = Raster.createInterleavedRaster(db, width, height, width * 3, 3, bands, null);
            image.setData(raster);
        }
        catch (Exception ee) {
            image = null;
            LogWriter.writeLog("Couldn't read JPEG, not even raster: " + ee);
        }
        return image;
    }

    public static void write(BufferedImage image, String type, String des) {
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(new File(des)));
            ImageIO.write((RenderedImage)image, type, bos);
            bos.flush();
            bos.close();
        }
        catch (IOException e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
    }

    public static void write(BufferedImage image, String type, OutputStream bos) {
        try {
            ImageIO.write((RenderedImage)image, type, bos);
            bos.flush();
            bos.close();
        }
        catch (IOException e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
    }

    public static Raster getRasterFromJPEG(byte[] data, String type) {
        ImageReader iir = null;
        Raster ras = null;
        try {
            ImageReader o;
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(type);
            while (iterator.hasNext() && !(iir = (o = iterator.next())).canReadRaster()) {
            }
            ImageIO.setUseCache(false);
            ImageInputStream iin = ImageIO.createImageInputStream(in);
            iir.setInput(iin, true);
            ras = iir.readRaster(0, null);
            in.close();
            iir.dispose();
            iin.close();
        }
        catch (Exception ee) {
            LogWriter.writeLog("Problem closing  " + ee);
        }
        return ras;
    }

    static BufferedImage grayJPEGToRGBImage(byte[] data, int pX, int pY, boolean arrayInverted) {
        BufferedImage image = null;
        try {
            Raster ras = JPEGDecoder.getRasterFromJPEG(data, "JPEG");
            if (ras != null) {
                ras = GenericColorSpace.cleanupRaster(ras, pX, pY, 1);
                int w = ras.getWidth();
                int h = ras.getHeight();
                DataBufferByte rgb = (DataBufferByte)ras.getDataBuffer();
                byte[] rawData = rgb.getData();
                int byteLength = rawData.length;
                byte[] rgbData = new byte[byteLength * 3];
                int ptr = 0;
                for (int ii = 0; ii < byteLength; ++ii) {
                    if (arrayInverted) {
                        rawData[ii] = (byte)(rawData[ii] ^ 0xFF);
                    }
                    rgbData[ptr] = rawData[ii];
                    rgbData[++ptr] = rawData[ii];
                    rgbData[++ptr] = rawData[ii];
                    ++ptr;
                }
                int[] bands = new int[]{0, 1, 2};
                image = new BufferedImage(w, h, 1);
                WritableRaster raster = Raster.createInterleavedRaster(new DataBufferByte(rgbData, rgbData.length), w, h, w * 3, 3, bands, null);
                image.setData(raster);
            }
        }
        catch (Exception ee) {
            image = null;
            LogWriter.writeLog("Couldn't read JPEG, not even raster: " + ee);
        }
        return image;
    }

    private static byte[] getBytesFromJPEGWithImageIO(byte[] data, GenericColorSpace decodeColorData, PdfObject XObject2) {
        byte[] db;
        block7: {
            db = null;
            Raster ras = null;
            try {
                BufferedImage img = decodeColorData.JPEGToRGBImage(data, XObject2.getInt(959726687), XObject2.getInt(959926393), null, -1, -1, false, XObject2);
                if (img.getType() == 1) {
                    if ((img = ColorSpaceConvertor.convertColorspace(img, 5)) != null) {
                        ras = img.getData();
                    }
                    db = ((DataBufferByte)ras.getDataBuffer()).getData();
                    for (int i = 0; i < db.length; i += 3) {
                        byte r;
                        byte b = db[i];
                        byte g = db[i + 1];
                        db[i] = r = db[i + 2];
                        db[i + 1] = g;
                        db[i + 2] = b;
                    }
                } else {
                    if (img != null) {
                        ras = img.getData();
                    }
                    db = ((DataBufferByte)ras.getDataBuffer()).getData();
                }
            }
            catch (Exception e) {
                if (!LogWriter.isOutput()) break block7;
                LogWriter.writeLog("Exception " + e + " with JPeg Image ");
            }
        }
        return db;
    }

    public static byte[] getBytesFromJPEG(byte[] data, GenericColorSpace decodeColorData, PdfObject XObject2) {
        byte[] db = null;
        try {
            boolean isInverted = ArrayUtils.isArrayInverted(XObject2.getFloatArray(859785322));
            boolean isMask = XObject2 instanceof MaskObject;
            boolean isDeviceN = decodeColorData instanceof DeviceNColorSpace;
            if (!isDeviceN) {
                db = JDeliHelper.getBytesFromJPEG(isInverted, data, isMask);
            }
            if (db == null) {
                db = JPEGDecoder.getBytesFromJPEGWithImageIO(data, decodeColorData, XObject2);
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception with JPeg Image " + e);
        }
        return db;
    }
}

