/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.display;

import org.jpedal.display.GUIDisplay;
import org.jpedal.objects.PdfPageData;
import org.jpedal.utils.LogWriter;

public class MultiDisplayOptions {
    private boolean turnoverOn = GUIDisplay.default_turnoverOn;
    private boolean separateCover = GUIDisplay.default_separateCover;
    private int[] xReached;
    private int[] yReached;
    private int[] pageW;
    private int[] pageH;
    private boolean isGeneratingOtherPages;
    private boolean running;
    private int startViewPage = 1;
    private int endViewPage;
    private int pageNumber;
    private final PdfPageData pageData = new PdfPageData();

    public boolean isTurnoverOn() {
        return this.turnoverOn;
    }

    public void setTurnoverOn(boolean turnoverOn) {
        this.turnoverOn = turnoverOn;
    }

    public boolean isSeparateCover() {
        return this.separateCover;
    }

    public void setSeparateCover(boolean separateCover) {
        this.separateCover = separateCover;
    }

    void resetValues(int pageCount) {
        this.setxReached(new int[pageCount + 1]);
        this.setyReached(new int[pageCount + 1]);
        this.setPageW(new int[pageCount + 1]);
        this.setPageH(new int[pageCount + 1]);
    }

    public void setReachedToNull() {
        this.setxReached(null);
    }

    public void setPageValuesToNull() {
        this.setPageH(null);
        this.setPageW(null);
    }

    public int[] getPageH() {
        return this.pageH;
    }

    public int getPageH(int i) {
        return this.pageH[i];
    }

    public void setPageH(int[] pageH) {
        this.pageH = pageH;
    }

    public int[] getPageW() {
        return this.pageW;
    }

    public int getPageW(int i) {
        return this.pageW[i];
    }

    public void setPageW(int[] pageW) {
        this.pageW = pageW;
    }

    public int[] getyReached() {
        return this.yReached;
    }

    public int getyReached(int i) {
        return this.yReached[i];
    }

    public void setyReached(int[] yReached) {
        this.yReached = yReached;
    }

    public int[] getxReached() {
        return this.xReached;
    }

    public int getxReached(int i) {
        return this.xReached[i];
    }

    public void setxReached(int[] xReached) {
        this.xReached = xReached;
    }

    public boolean isIsGeneratingOtherPages() {
        return this.isGeneratingOtherPages;
    }

    public void setIsGeneratingOtherPages(boolean isGeneratingOtherPages) {
        this.isGeneratingOtherPages = isGeneratingOtherPages;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public int getStartViewPage() {
        return this.startViewPage;
    }

    public void setStartViewPage(int startViewPage) {
        this.startViewPage = startViewPage;
    }

    public int getEndViewPage() {
        return this.endViewPage;
    }

    public void setEndViewPage(int endViewPage) {
        this.endViewPage = endViewPage;
    }

    public void calcDisplayRangeForFacing() {
        int pageCount = this.pageData.getPageCount();
        if (this.separateCover) {
            if (pageCount == 2) {
                this.startViewPage = 1;
                this.endViewPage = 2;
            } else {
                this.startViewPage = this.pageNumber;
                if (this.startViewPage == 1) {
                    this.endViewPage = 1;
                } else if ((this.startViewPage & 1) != 1) {
                    this.startViewPage = this.pageNumber;
                    this.endViewPage = this.pageNumber + 1;
                } else {
                    this.startViewPage = this.pageNumber - 1;
                    this.endViewPage = this.pageNumber;
                }
            }
        } else {
            this.startViewPage = this.pageNumber - (1 - (this.pageNumber & 1));
            this.endViewPage = this.startViewPage + 1;
        }
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public void waitToDieThred() {
        while (this.running) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
    }
}

