/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.display;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Semaphore;
import org.jpedal.FileAccess;
import org.jpedal.PdfDecoderInt;
import org.jpedal.display.DisplayOffsets;
import org.jpedal.display.GUIModes;
import org.jpedal.display.MultiDisplayOptions;
import org.jpedal.display.MultiPagesDisplay;
import org.jpedal.external.RenderChangeListener;
import org.jpedal.gui.GUIFactory;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.objects.raw.PageObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.text.TextLines;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.generic.Vector_Rectangle_Int;

public abstract class MultiPageDecoder {
    private final Semaphore semaphore = new Semaphore(1);
    final GUIFactory gui;
    private Thread worker;
    public final Map currentPageViews = new HashMap();
    private final FileAccess fileAccess;
    private final PdfObjectReader currentPdfFile;
    private final AcroRenderer formRenderer;
    private int displayView;
    private Map cachedPageViews = new WeakHashMap();
    private final MultiPagesDisplay display;
    private RenderChangeListener customRenderChangeListener;
    private final BufferedImage[] facingDragCachedImages = new BufferedImage[4];
    private BufferedImage facingDragTempLeftImg;
    private BufferedImage facingDragTempRightImg;
    private int facingDragTempLeftNo;
    private int facingDragTempRightNo;
    private final MultiDisplayOptions multiDisplayOptions;
    public final PdfDecoderInt pdf;
    private final PdfPageData pageData;
    final DecoderOptions options;
    final DisplayOffsets offsets;

    public MultiPageDecoder(GUIFactory gui, PdfDecoderInt pdf, PdfPageData pageData, MultiPagesDisplay display, MultiDisplayOptions multiDisplayOptions, DynamicVectorRenderer currentDisplay, int pageNumber, FileAccess fileAccess, PdfObjectReader io, AcroRenderer formRenderer, DecoderOptions options) {
        this.gui = gui;
        this.pdf = pdf;
        this.pageData = pageData;
        this.display = display;
        this.multiDisplayOptions = multiDisplayOptions;
        this.fileAccess = fileAccess;
        this.currentPdfFile = io;
        this.formRenderer = formRenderer;
        this.options = options;
        this.offsets = (DisplayOffsets)pdf.getExternalHandler(37);
        if (currentDisplay != null) {
            this.currentPageViews.put(pageNumber, currentDisplay);
        }
    }

    public void decodeOtherPages(int pageNumber, int pageCount, int displayView) {
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException ex) {
            LogWriter.writeLog("Exception: " + ex.getMessage());
        }
        this.displayView = displayView;
        if (pageNumber < 1) {
            pageNumber = 1;
        }
        int oldPN = this.multiDisplayOptions.getPageNumber();
        this.multiDisplayOptions.setPageNumber(pageNumber);
        if (displayView == 4 && this.multiDisplayOptions.isTurnoverOn()) {
            int lp = this.multiDisplayOptions.isSeparateCover() ? oldPN / 2 * 2 : oldPN - (1 - (oldPN & 1));
            if (this.offsets.getDragLeft()) {
                this.facingDragTempLeftImg = this.facingDragCachedImages[0];
                this.facingDragTempLeftNo = lp - 2;
                this.facingDragTempRightImg = this.facingDragCachedImages[1];
                this.facingDragTempRightNo = lp - 1;
            } else {
                this.facingDragTempLeftImg = this.facingDragCachedImages[2];
                this.facingDragTempLeftNo = lp + 2;
                this.facingDragTempRightImg = this.facingDragCachedImages[3];
                this.facingDragTempRightNo = lp + 3;
            }
        }
        this.facingDragCachedImages[0] = null;
        this.facingDragCachedImages[1] = null;
        this.facingDragCachedImages[2] = null;
        this.facingDragCachedImages[3] = null;
        this.calcDisplayedRange();
        while (this.multiDisplayOptions.isRunning()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        if (this.worker != null && this.worker.getState() == Thread.State.TERMINATED) {
            this.worker = null;
        }
        if (!(this.worker != null && this.worker.getState() != Thread.State.NEW || this.worker != null && this.multiDisplayOptions.isRunning())) {
            this.multiDisplayOptions.setRunning(true);
            this.worker = new Thread(){

                @Override
                public void run() {
                    try {
                        MultiPageDecoder.this.decodeOtherPages();
                        MultiPageDecoder.this.multiDisplayOptions.setRunning(false);
                        if (MultiPageDecoder.this.customRenderChangeListener != null) {
                            MultiPageDecoder.this.customRenderChangeListener.renderingWorkerFinished();
                        }
                    }
                    catch (Exception e) {
                        MultiPageDecoder.this.multiDisplayOptions.setRunning(false);
                        LogWriter.writeLog("Exception: " + e.getMessage());
                    }
                    catch (Error err) {
                        MultiPageDecoder.this.multiDisplayOptions.setRunning(false);
                        LogWriter.writeLog("Error: " + err.getMessage());
                    }
                    finally {
                        MultiPageDecoder.this.semaphore.release();
                    }
                }
            };
            this.worker.setDaemon(true);
            this.worker.start();
        }
    }

    void decodeOtherPages() {
        int pageCount = this.pageData.getPageCount();
        this.multiDisplayOptions.setIsGeneratingOtherPages(true);
        int page = this.multiDisplayOptions.getStartViewPage();
        int originalStart = this.multiDisplayOptions.getStartViewPage();
        int originalEnd = this.multiDisplayOptions.getEndViewPage() + 1;
        int firstFacing = 1;
        int lastFacing = 1;
        if (this.multiDisplayOptions.isTurnoverOn() && this.displayView == 4) {
            firstFacing = originalStart - 2;
            lastFacing = firstFacing + 6;
            if (firstFacing < 1) {
                firstFacing = 1;
            }
            if (lastFacing > pageCount + 1) {
                lastFacing = pageCount + 1;
            }
        }
        int facingCount = lastFacing - firstFacing;
        this.resetPageCaches(this.multiDisplayOptions.getStartViewPage(), this.multiDisplayOptions.getEndViewPage() + 1);
        while (this.multiDisplayOptions.isIsGeneratingOtherPages()) {
            if (originalStart != this.multiDisplayOptions.getStartViewPage() && originalEnd != this.multiDisplayOptions.getEndViewPage()) {
                page = this.multiDisplayOptions.getStartViewPage();
                originalEnd = this.multiDisplayOptions.getEndViewPage() + 1;
                if (page == 0) {
                    // empty if block
                }
                originalStart = ++page;
                if (this.multiDisplayOptions.isTurnoverOn() && this.displayView == 4) {
                    firstFacing = originalStart - 2;
                    lastFacing = firstFacing + 6;
                    if (firstFacing < 1) {
                        firstFacing = 1;
                    }
                    if (lastFacing > pageCount + 1) {
                        lastFacing = pageCount + 1;
                    }
                    facingCount = lastFacing - firstFacing;
                }
                this.resetPageCaches(originalStart, originalEnd);
            }
            if (this.multiDisplayOptions.isTurnoverOn() && this.displayView == 4 && facingCount == 0 || (!this.multiDisplayOptions.isTurnoverOn() || this.displayView != 4) && page == originalEnd || originalStart > originalEnd) break;
            if (page > 0 && page < this.pdf.getPageCount() + 1) {
                this.decodeMorePages(page, originalStart, originalEnd);
            }
            if (this.displayView == 4 && this.multiDisplayOptions.isTurnoverOn()) {
                int ref;
                int leftPage = this.multiDisplayOptions.getPageNumber();
                if (this.multiDisplayOptions.isSeparateCover() && (leftPage & 1) == 1) {
                    --leftPage;
                }
                if (!this.multiDisplayOptions.isSeparateCover() && (leftPage & 1) == 0) {
                    --leftPage;
                }
                if ((ref = page - leftPage + 2) <= 1 || ref >= 4) {
                    if (ref > 1) {
                        ref -= 2;
                    }
                    int[] pageW = this.multiDisplayOptions.getPageW();
                    int[] pageH = this.multiDisplayOptions.getPageH();
                    if (ref < 4 && ref > -1 && this.facingDragCachedImages[ref] == null) {
                        BufferedImage image = new BufferedImage(pageW[page], pageH[page], 2);
                        Graphics2D pg = (Graphics2D)image.getGraphics();
                        int displayRotation = this.display.getDisplayRotation();
                        pg.rotate((double)displayRotation * Math.PI / 180.0);
                        try {
                            switch (displayRotation) {
                                case 90: {
                                    pg.translate(0, -pageW[page]);
                                    pg.drawImage(this.pdf.getPageAsImage(page), 0, 0, pageH[page] + 1, pageW[page] + 1, null);
                                    break;
                                }
                                case 180: {
                                    pg.translate(-pageW[page], -pageH[page]);
                                    pg.drawImage(this.pdf.getPageAsImage(page), 0, 0, pageW[page] + 1, pageH[page] + 1, null);
                                    break;
                                }
                                case 270: {
                                    pg.translate(-pageH[page], 0);
                                    pg.drawImage(this.pdf.getPageAsImage(page), 0, 0, pageH[page] + 1, pageW[page] + 1, null);
                                    break;
                                }
                                default: {
                                    pg.drawImage(this.pdf.getPageAsImage(page), 0, 0, pageW[page] + 1, pageH[page] + 1, null);
                                    break;
                                }
                            }
                        }
                        catch (Exception e) {
                            LogWriter.writeLog("Exception: " + e.getMessage());
                        }
                        this.facingDragCachedImages[ref] = image;
                    }
                }
            }
            --facingCount;
            if (!this.multiDisplayOptions.isTurnoverOn() || this.displayView != 4 || ++page != lastFacing) continue;
            page = firstFacing;
        }
    }

    public void decodeMorePages(int page, int originalStart, int originalEnd) {
        if (this.currentPageViews.get(page) == null) {
            this.decodePage(page, originalStart, originalEnd);
        }
        this.repaint();
    }

    public void decodePage(int page, int originalStart, int originalEnd) {
        Integer key;
        Object currentView;
        String currentPageOffset;
        AcroRenderer formRenderer = this.pdf.getFormRenderer();
        if (this.displayView == 2 || this.displayView == 3) {
            PdfStreamDecoder current = (PdfStreamDecoder)this.currentPageViews.get(page);
            formRenderer.createDisplayComponentsForPage(page, current);
            if (this.pdf.getSpecialMode() != -1 && this.pdf.getSpecialMode() != 1 && page != this.pdf.getPageCount()) {
                formRenderer.createDisplayComponentsForPage(page + 1, current);
            }
        }
        if (((currentPageOffset = this.pdf.getIO().getReferenceforPage(page)) != null || formRenderer.isXFA() && formRenderer.useXFA()) && (currentView = this.currentPageViews.get(key = Integer.valueOf(page))) == null && this.multiDisplayOptions.isIsGeneratingOtherPages()) {
            this.display.forceRedraw();
            this.getPageView(currentPageOffset, page);
        }
    }

    private void getPageView(String currentPageOffset, int pageNumber) {
        PageObject pdfObject = new PageObject(currentPageOffset);
        pdfObject.setPageNumber(pageNumber);
        this.currentPdfFile.readObject(pdfObject);
        PdfObject Resources = ((PdfObject)pdfObject).getDictionary(2004251818);
        DynamicVectorRenderer currentDisplay = this.getNewDisplay(pageNumber);
        currentDisplay.setHiResImageForDisplayMode(this.pdf.isHiResScreenDisplay());
        int val = 0;
        if (this.pdf.getDisplayView() == 2 && this.pdf.getDisplayView() == 3) {
            val = 1;
        }
        PdfStreamDecoder current = this.formRenderer.getStreamDecoder(this.currentPdfFile, this.pdf.isHiResScreenDisplay(), this.fileAccess.getRes().getPdfLayerList(), true);
        if (this.formRenderer != null && this.pdf.isForm()) {
            this.formRenderer.createDisplayComponentsForPage(pageNumber, current);
        }
        current.setParameters(true, true, 7, val, false, this.pdf.getExternalHandler().getMode().equals((Object)GUIModes.JAVAFX));
        current.setXMLExtraction(this.pdf.isXMLExtraction());
        this.pdf.getExternalHandler().addHandlers(current);
        current.setObjectValue(-9, this.fileAccess.getFilename());
        current.setObjectValue(-8, this.pdf.getObjectStore());
        current.setObjectValue(-18, this.pageData);
        current.setIntValue(-10, pageNumber);
        current.setRenderer(currentDisplay);
        try {
            currentDisplay.init(this.pageData.getMediaBoxWidth(pageNumber), this.pageData.getMediaBoxHeight(pageNumber), this.options.getPageColor());
            currentDisplay.setValue(1, this.options.getPageColor().getRGB());
            if (this.options.getTextColor() != null) {
                currentDisplay.setValue(2, this.options.getTextColor().getRGB());
                if (this.options.getChangeTextAndLine()) {
                    currentDisplay.setValue(3, 1);
                } else {
                    currentDisplay.setValue(3, 0);
                }
            }
            this.fileAccess.getRes().setupResources(current, false, Resources, pageNumber, this.currentPdfFile);
            current.decodePageContent(pdfObject);
            TextLines textLines = this.pdf.getTextLines();
            if (textLines != null) {
                Vector_Rectangle_Int vr = (Vector_Rectangle_Int)current.getObjectValue(-21);
                vr.trim();
                int[][] pageTextAreas = vr.get();
                Vector_Int vi = (Vector_Int)current.getObjectValue(22);
                vi.trim();
                int[] pageTextDirections = vi.get();
                for (int k = 0; k != pageTextAreas.length; ++k) {
                    textLines.addToLineAreas(pageTextAreas[k], pageTextDirections[k], pageNumber);
                }
            }
            currentDisplay.flagDecodingFinished();
        }
        catch (Exception ex) {
            LogWriter.writeLog("Exception: " + ex.getMessage());
        }
        catch (Error err) {
            LogWriter.writeLog("Exception: " + err.getMessage());
        }
        this.currentPageViews.put(pageNumber, currentDisplay);
        this.display.setCurrentDisplay(currentDisplay);
    }

    void resetPageCaches(int startPage, int endPage) {
        Object obj;
        int keyValue;
        Integer currentKey;
        for (Object o : this.cachedPageViews.keySet()) {
            currentKey = (Integer)o;
            keyValue = currentKey;
            if (keyValue < startPage || keyValue > endPage || (obj = this.cachedPageViews.get(currentKey)) == null) continue;
            this.currentPageViews.put(currentKey, obj);
        }
        Iterator keys = this.currentPageViews.keySet().iterator();
        HashMap<Integer, String> keysToTrash = new HashMap<Integer, String>();
        while (keys.hasNext()) {
            currentKey = (Integer)keys.next();
            keyValue = currentKey;
            if (keyValue >= startPage && keyValue <= endPage) continue;
            obj = this.currentPageViews.get(currentKey);
            if (obj != null) {
                this.cachedPageViews.put(currentKey, obj);
            }
            keysToTrash.put(currentKey, "x");
        }
        keys = keysToTrash.keySet().iterator();
        while (keys.hasNext()) {
            this.currentPageViews.remove(keys.next());
        }
    }

    private synchronized void calcDisplayedRange() {
        int pageCount = this.pageData.getPageCount();
        if (this.displayView == 1) {
            return;
        }
        this.display.getDisplayedRectangle();
        if (this.displayView == 4) {
            this.multiDisplayOptions.calcDisplayRangeForFacing();
        } else {
            int newPage = this.updatePageDisplayed();
            this.fileAccess.setPageNumber(newPage);
            if (newPage != -1) {
                this.gui.setPage(newPage);
            }
        }
        if (this.multiDisplayOptions.getEndViewPage() > pageCount) {
            this.multiDisplayOptions.setEndViewPage(pageCount);
        }
        if (this.displayView != 4) {
            this.display.refreshDisplay();
        }
    }

    public void flushPageCaches() {
        this.currentPageViews.clear();
        this.cachedPageViews.clear();
    }

    public DynamicVectorRenderer getCurrentPageView(int i) {
        return (DynamicVectorRenderer)this.currentPageViews.get(i);
    }

    public void dispose() {
        this.cachedPageViews = null;
    }

    private int updatePageDisplayed() {
        int newPage = -1;
        int pageCount = this.pageData.getPageCount();
        int[] yReached = this.multiDisplayOptions.getyReached();
        int[] pageH = this.multiDisplayOptions.getPageH();
        int ry = this.display.getRy();
        int rh = this.display.getRh();
        boolean debug = false;
        int largestH = 0;
        int firstVisiblePage = 0;
        int lastVisiblePage = 0;
        for (int i = 1; i <= pageCount; ++i) {
            int gap2;
            int pageTop = yReached[i];
            int pageBottom = yReached[i] + pageH[i];
            int viewBottom = ry + rh;
            if (pageTop > viewBottom || pageBottom < ry) continue;
            if (newPage == -1) {
                newPage = i;
                firstVisiblePage = i;
            }
            lastVisiblePage = i;
            int midPt = ry + rh / 2;
            int gap = midPt - yReached[i];
            if (gap < 0 || gap > pageH[i]) {
                gap = 0;
            }
            if ((gap2 = yReached[i] + pageH[i] - midPt) < 0 || gap2 > pageH[i]) {
                gap2 = 0;
            }
            if (gap2 > gap) {
                gap = gap2;
            }
            if (gap <= 0 || gap <= largestH) continue;
            largestH = gap;
            newPage = i;
        }
        if (newPage == -1) {
            newPage = 1;
            firstVisiblePage = 1;
            lastVisiblePage = 1;
        }
        this.multiDisplayOptions.setStartViewPage(firstVisiblePage);
        this.multiDisplayOptions.setEndViewPage(lastVisiblePage);
        if (this.multiDisplayOptions.getEndViewPage() > pageCount) {
            this.multiDisplayOptions.setEndViewPage(pageCount);
        }
        return newPage;
    }

    public void resetCachedFacingImages() {
        for (int i = 0; i < 4; ++i) {
            this.facingDragCachedImages[i] = null;
        }
    }

    public BufferedImage[] getFacingDragImages() {
        return this.facingDragCachedImages;
    }

    public BufferedImage getfacingDragTempLeftImg() {
        return this.facingDragTempLeftImg;
    }

    public BufferedImage getfacingDragTempRightImg() {
        return this.facingDragTempRightImg;
    }

    public int getFacingDragTempLeftNo() {
        return this.facingDragTempLeftNo;
    }

    public int getFacingDragTempRightNo() {
        return this.facingDragTempRightNo;
    }

    public void setCustomRenderChangeListener(RenderChangeListener customRenderChangeListener) {
        this.customRenderChangeListener = customRenderChangeListener;
    }

    public void repaint() {
        throw new UnsupportedOperationException("repaint Not supported yet.");
    }

    public DynamicVectorRenderer getNewDisplay(int pageNumber) {
        throw new UnsupportedOperationException(this + "Not supported yet.");
    }
}

