/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.display;

import org.jpedal.display.MultiDisplayOptions;
import org.jpedal.objects.PdfPageData;

public class PageOffsets {
    private int width;
    private int height;
    private int totalSingleWidth;
    private int totalDoubleWidth;
    private int gaps;
    private int doubleGaps;
    private int totalSingleHeight;
    private int totalDoubleHeight;
    protected int maxW;
    protected int maxH;
    public static final int pageGap = 10;
    private int doublePageWidth;
    private int doublePageHeight;
    private int biggestWidth;
    private int biggestHeight;
    private int widestPageNR;
    private int widestPageR;

    public PageOffsets(int pageCount, PdfPageData pageData) {
        int facingW = 0;
        int facingH = 0;
        int greatestW = 0;
        int greatestH = 0;
        this.totalSingleHeight = 0;
        this.totalSingleWidth = 0;
        int widestLeftPage = 0;
        int widestRightPage = 0;
        int highestLeftPage = 0;
        int highestRightPage = 0;
        this.widestPageR = 0;
        this.widestPageNR = 0;
        this.totalDoubleWidth = 0;
        this.totalDoubleHeight = 0;
        this.gaps = 0;
        this.doubleGaps = 0;
        this.biggestWidth = 0;
        this.biggestHeight = 0;
        for (int i = 1; i < pageCount + 1; ++i) {
            int pageW = pageData.getCropBoxWidth(i);
            int pageH = pageData.getCropBoxHeight(i);
            int rotation = pageData.getRotation(i);
            if (rotation == 90 || rotation == 270) {
                int tmp = pageW;
                pageW = pageH;
                pageH = tmp;
            }
            if (pageW > this.maxW) {
                this.maxW = pageW;
            }
            if (pageH > this.maxH) {
                this.maxH = pageH;
            }
            this.gaps += 10;
            this.totalSingleWidth += pageW;
            this.totalSingleHeight += pageH;
            if ((i & 1) == 1) {
                if (widestRightPage < pageW) {
                    widestRightPage = pageW;
                }
                if (highestRightPage < pageH) {
                    highestRightPage = pageH;
                }
            } else {
                if (widestLeftPage < pageW) {
                    widestLeftPage = pageW;
                }
                if (highestLeftPage < pageH) {
                    highestLeftPage = pageH;
                }
            }
            if (this.widestPageNR < pageW) {
                this.widestPageNR = pageW;
            }
            if (this.widestPageR < pageH) {
                this.widestPageR = pageH;
            }
            if (pageW > this.biggestWidth) {
                this.biggestWidth = pageW;
            }
            if (pageH > this.biggestHeight) {
                this.biggestHeight = pageH;
            }
            if ((i & 1) == 1) {
                if (greatestW < pageW) {
                    greatestW = pageW;
                }
                if (greatestH < pageH) {
                    greatestH = pageH;
                }
                if (i == 1) {
                    this.totalDoubleWidth = pageW;
                    this.totalDoubleHeight = pageH;
                } else {
                    this.totalDoubleWidth += greatestW;
                    this.totalDoubleHeight += greatestH;
                }
                this.doubleGaps += 10;
                facingW = pageW;
                facingH = pageH;
                continue;
            }
            facingW += pageW;
            facingH += pageH;
            greatestW = pageW;
            greatestH = pageH;
            if (i != pageCount) continue;
            this.totalDoubleWidth = this.totalDoubleWidth + greatestW + 10;
            this.totalDoubleHeight = this.totalDoubleHeight + greatestH + 10;
        }
        this.doublePageWidth = widestLeftPage + widestRightPage + 10;
        this.doublePageHeight = highestLeftPage + highestRightPage + 10;
        this.totalSingleWidth -= 10;
        this.totalSingleHeight -= 10;
    }

    public int getMaxH() {
        return this.maxH;
    }

    public int getMaxW() {
        return this.maxW;
    }

    public int getWidestPageR() {
        return this.widestPageR;
    }

    public int getWidestPageNR() {
        return this.widestPageNR;
    }

    public int getTotalSingleWidth() {
        return this.totalSingleWidth;
    }

    public void setTotalSingleWidth(int totalSingleWidth) {
        this.totalSingleWidth = totalSingleWidth;
    }

    public int getGaps() {
        return this.gaps;
    }

    public void setGaps(int gaps) {
        this.gaps = gaps;
    }

    public int getDoubleGaps() {
        return this.doubleGaps;
    }

    public void setDoubleGaps(int doubleGaps) {
        this.doubleGaps = doubleGaps;
    }

    public int getTotalDoubleWidth() {
        return this.totalDoubleWidth;
    }

    public void setTotalDoubleWidth(int totalDoubleWidth) {
        this.totalDoubleWidth = totalDoubleWidth;
    }

    public int getTotalSingleHeight() {
        return this.totalSingleHeight;
    }

    public void setTotalSingleHeight(int totalSingleHeight) {
        this.totalSingleHeight = totalSingleHeight;
    }

    public int getTotalDoubleHeight() {
        return this.totalDoubleHeight;
    }

    public void setTotalDoubleHeight(int totalDoubleHeight) {
        this.totalDoubleHeight = totalDoubleHeight;
    }

    public int getDoublePageWidth() {
        return this.doublePageWidth;
    }

    public void setDoublePageWidth(int doublePageWidth) {
        this.doublePageWidth = doublePageWidth;
    }

    public int getDoublePageHeight() {
        return this.doublePageHeight;
    }

    public void setDoublePageHeight(int doublePageHeight) {
        this.doublePageHeight = doublePageHeight;
    }

    public int getBiggestWidth() {
        return this.biggestWidth;
    }

    public void setBiggestWidth(int biggestWidth) {
        this.biggestWidth = biggestWidth;
    }

    public int getBiggestHeight() {
        return this.biggestHeight;
    }

    public void setBiggestHeight(int biggestHeight) {
        this.biggestHeight = biggestHeight;
    }

    public void setWidestPageNR(int widestPageNR) {
        this.widestPageNR = widestPageNR;
    }

    public void setWidestPageR(int widestPageR) {
        this.widestPageR = widestPageR;
    }

    public void calculateCombinedPageSizes(int displayView, int pageNumber, int displayRotation, MultiDisplayOptions multiDisplayOptions, PdfPageData pageData, float scaling, int insetW, int insetH) {
        int biggestFacingHeight = 0;
        if (displayView == 4 && multiDisplayOptions.getPageW() != null) {
            int p2;
            int p1;
            if (multiDisplayOptions.isSeparateCover()) {
                p1 = pageNumber;
                if ((p1 & 1) == 1) {
                    --p1;
                }
                p2 = p1 + 1;
            } else {
                p1 = pageNumber;
                if ((p1 & 1) == 0) {
                    --p1;
                }
                p2 = p1 + 1;
            }
            biggestFacingHeight = multiDisplayOptions.getPageH(p1);
            if (p2 < multiDisplayOptions.getPageH().length && biggestFacingHeight < multiDisplayOptions.getPageH(p2)) {
                biggestFacingHeight = multiDisplayOptions.getPageH(p2);
            }
        }
        int gaps = this.gaps;
        int doubleGaps = this.doubleGaps;
        switch (displayView) {
            case 4: {
                int firstW = (displayRotation + pageData.getRotation(pageNumber)) % 180 == 90 ? pageData.getCropBoxHeight(pageNumber) : pageData.getCropBoxWidth(pageNumber);
                int pageCount = pageData.getPageCount();
                int secondW = pageNumber + 1 > pageCount || pageNumber == 1 && pageCount != 2 ? firstW : ((displayRotation + pageData.getRotation(pageNumber + 1)) % 180 == 90 ? pageData.getCropBoxHeight(pageNumber + 1) : pageData.getCropBoxWidth(pageNumber + 1));
                int totalW = firstW + secondW;
                this.width = (int)((float)totalW * scaling) + 10;
                this.height = biggestFacingHeight;
                break;
            }
            case 2: {
                if (displayRotation == 90 | displayRotation == 270) {
                    this.width = (int)((float)this.biggestHeight * scaling);
                    this.height = (int)((float)this.totalSingleWidth * scaling) + gaps + insetH;
                    break;
                }
                this.width = (int)((float)this.biggestWidth * scaling);
                this.height = (int)((float)this.totalSingleHeight * scaling) + gaps + insetH;
                break;
            }
            case 3: {
                if (displayRotation == 90 | displayRotation == 270) {
                    this.width = (int)((float)this.doublePageHeight * scaling) + insetW * 2 + doubleGaps;
                    this.height = (int)((float)this.totalDoubleWidth * scaling) + doubleGaps + insetH;
                    break;
                }
                this.width = (int)((float)this.doublePageWidth * scaling) + insetW * 2;
                this.height = (int)((float)this.totalDoubleHeight * scaling) + doubleGaps + insetH;
            }
        }
    }

    public int getPageWidth() {
        return this.width;
    }

    public int getPageHeight() {
        return this.height;
    }
}

