/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.display.javafx;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.scene.Node;
import org.jpedal.PdfDecoderFX;
import org.jpedal.PdfDecoderInt;
import org.jpedal.display.Display;
import org.jpedal.display.GUIThumbnailPanel;
import org.jpedal.display.PageFlowFX;
import org.jpedal.display.PageOffsets;
import org.jpedal.examples.viewer.gui.JavaFxGUI;
import org.jpedal.exception.PdfException;
import org.jpedal.gui.GUIFactory;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.text.TextLines;
import org.jpedal.utils.Messages;

public class PageFlowDisplayFX
implements Display {
    final PageFlowFX pageFlowFX;
    final JavaFxGUI fxGUI;

    public PageFlowDisplayFX(final GUIFactory currentGUI, PdfDecoderInt pdf) {
        this.fxGUI = (JavaFxGUI)currentGUI;
        this.pageFlowFX = new PageFlowFX(pdf, true);
        this.pageFlowFX.getPageNumber().addListener(new ChangeListener(){

            public void changed(ObservableValue o, Object oldVal, Object newVal) {
                PageFlowDisplayFX.this.fxGUI.setPage((int)PageFlowDisplayFX.this.pageFlowFX.getPageNumber().doubleValue());
                if (PageFlowDisplayFX.this.pageFlowFX.isUpdateMemory()) {
                    PageFlowDisplayFX.this.fxGUI.showMessageDialog(PageFlowDisplayFX.this.pageFlowFX.getMemoryMessage());
                }
            }
        });
        this.pageFlowFX.setCursors(this.fxGUI.getGUICursor().getCursorImageForFX(1), this.fxGUI.getGUICursor().getCursorImageForFX(2));
        ((PdfDecoderFX)pdf).getChildren().clear();
        ListChangeListener lcl = new ListChangeListener(){

            public void onChanged(ListChangeListener.Change change) {
                double width = ((Node)PageFlowDisplayFX.this.fxGUI.getDisplayPane().getItems().get(1)).getBoundsInLocal().getWidth();
                double height = ((Node)PageFlowDisplayFX.this.fxGUI.getDisplayPane().getItems().get(1)).getBoundsInLocal().getHeight();
                PageFlowDisplayFX.this.pageFlowFX.setMinSize(width, height);
            }
        };
        this.fxGUI.getDisplayPane().getItems().addListener(lcl);
        double width = ((Node)this.fxGUI.getDisplayPane().getItems().get(1)).getBoundsInLocal().getWidth();
        double height = ((Node)this.fxGUI.getDisplayPane().getItems().get(1)).getBoundsInLocal().getHeight();
        this.pageFlowFX.setMinSize(width, height);
        try {
            this.fxGUI.getDisplayPane().getItems().add((Object)this.pageFlowFX);
            this.fxGUI.getDisplayPane().getItems().remove((Object)this.fxGUI.getPageContainer());
            this.fxGUI.enableCursor(true, false);
            this.fxGUI.enableMemoryBar(true, true);
            this.fxGUI.setMultibox(new int[0]);
        }
        catch (IllegalArgumentException e) {
            this.fxGUI.showMessageDialog(Messages.getMessage("PdfViewer.PageFlowIllegalArgument") + e);
            if (Platform.isFxApplicationThread()) {
                currentGUI.setDisplayView(1, 2);
            }
            Runnable doPaintComponent = new Runnable(){

                @Override
                public void run() {
                    currentGUI.setDisplayView(1, 2);
                }
            };
            Platform.runLater((Runnable)doPaintComponent);
        }
    }

    @Override
    public double getIndent() {
        throw new UnsupportedOperationException("getIndent Not supported yet.");
    }

    @Override
    @Deprecated
    public Rectangle getCursorBoxOnScreen() {
        throw new UnsupportedOperationException("getCursorBoxOnScreen Not supported yet.");
    }

    @Override
    public int[] getCursorBoxOnScreenAsArray() {
        throw new UnsupportedOperationException("getCursorBoxOnScreenAsArray Not supported yet.");
    }

    @Override
    public void setCursorBoxOnScreen(Rectangle cursorBoxOnScreen, boolean isSamePage) {
        throw new UnsupportedOperationException("setCursorBoxOnScreen Not supported yet.");
    }

    @Override
    public void forceRedraw() {
    }

    @Override
    public void setPageRotation(int displayRotation) {
    }

    @Override
    public void resetViewableArea() {
    }

    @Override
    public void paintPage(Object box, AcroRenderer formRenderer, TextLines textLines) {
    }

    @Override
    public void paintPage(Graphics2D g2, AcroRenderer formRenderer, TextLines textLines) {
    }

    @Override
    public void updateCursorBoxOnScreen(int[] newOutlineRectangle, int outlineColor, int pageNumber, int x_size, int y_size) {
    }

    @Override
    @Deprecated
    public void updateCursorBoxOnScreen(Rectangle newOutlineRectangle, Color outlineColor, int pageNumber, int x_size, int y_size) {
    }

    @Override
    public void drawCursor(Graphics g, float scaling) {
    }

    @Override
    @Deprecated
    public AffineTransform setViewableArea(Rectangle viewport) throws PdfException {
        return null;
    }

    @Override
    public AffineTransform setViewableArea(int[] viewport) throws PdfException {
        return null;
    }

    @Override
    public void drawFacing(Rectangle visibleRect) {
    }

    @Override
    public int[] getPageSize(int displayView) {
        int[] pageSize = new int[]{(int)((PdfDecoderFX)this.pageFlowFX.getPdfDecoderInt()).getWidth(), (int)((PdfDecoderFX)this.pageFlowFX.getPdfDecoderInt()).getHeight()};
        return pageSize;
    }

    @Override
    public void decodeOtherPages(int pageNumber, int pageCount) {
    }

    @Override
    public void stopGeneratingPage() {
        this.pageFlowFX.stop();
    }

    @Override
    public void refreshDisplay() {
    }

    @Override
    public void disableScreen() {
    }

    @Override
    public void flushPageCaches() {
    }

    @Override
    public void init(float scaling, int displayRotation, int pageNumber, DynamicVectorRenderer currentDisplay, boolean isInit) {
        this.pageFlowFX.setRotation(displayRotation);
    }

    @Override
    public void drawBorder() {
    }

    @Override
    public void setup(boolean useAcceleration, PageOffsets currentOffset) {
    }

    @Override
    public int getYCordForPage(int page) {
        return 0;
    }

    @Override
    public int getYCordForPage(int page, float scaling) {
        return 0;
    }

    @Override
    public int getXCordForPage(int currentPage) {
        return 0;
    }

    @Override
    public void setThumbnailPanel(GUIThumbnailPanel thumbnails) {
    }

    @Override
    public void setScaling(float scaling) {
        if ((double)this.pageFlowFX.getPdfDecoderInt().getPageNumber() != this.pageFlowFX.getPageNumber().doubleValue()) {
            this.pageFlowFX.goTo(this.pageFlowFX.getPdfDecoderInt().getPageNumber());
        }
    }

    @Override
    public void setPageOffsets(int page) {
    }

    @Override
    public void dispose() {
        this.fxGUI.getDisplayPane().getItems().add((Object)this.fxGUI.getPageContainer());
        this.fxGUI.getDisplayPane().getItems().remove((Object)this.pageFlowFX);
    }

    @Override
    public void setAcceleration(boolean enable) {
    }

    @Override
    public void setAccelerationAlwaysRedraw(boolean enable) {
    }

    @Override
    public void setObjectValue(int type, Object newValue) {
    }

    @Override
    public int[] getHighlightedImage() {
        return new int[0];
    }

    @Override
    public void setHighlightedImage(int[] i) {
    }

    @Override
    public float getOldScaling() {
        return 0.0f;
    }

    @Override
    public boolean getBoolean(Display.BoolValue option) {
        return false;
    }

    @Override
    public void setBoolean(Display.BoolValue option, boolean value) {
        throw new UnsupportedOperationException("Attempting to set unknown boolean in PageFlowDisplay.");
    }

    @Override
    public Rectangle getDisplayedRectangle() {
        throw new UnsupportedOperationException("getDisplayedRectangle Not supported yet.");
    }
}

