/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.baseviewer;

import java.io.File;
import java.util.List;
import javafx.animation.Transition;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextField;
import javafx.scene.control.ToolBar;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.text.Text;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import org.jpedal.PdfDecoderFX;
import org.jpedal.examples.viewer.gui.javafx.FXViewerTransitions;
import org.jpedal.examples.viewer.gui.javafx.dialog.FXInputDialog;
import org.jpedal.exception.PdfException;
import org.jpedal.external.PluginHandler;
import org.jpedal.objects.PdfPageData;
import org.jpedal.parser.DecoderOptions;

public class BaseViewerFX
extends Application {
    private final PdfDecoderFX pdf = new PdfDecoderFX();
    PluginHandler customPluginHandle;
    String PDFfile;
    File file;
    private String password;
    private boolean closePasswordPrompt;
    private VBox top;
    private HBox bottom;
    private ScrollPane center;
    private Group group;
    private Text fileLoc;
    private float scale = 1.0f;
    private final float[] scalings = new float[]{0.01f, 0.1f, 0.25f, 0.5f, 0.75f, 1.0f, 1.25f, 1.5f, 2.0f, 4.0f, 7.5f, 10.0f};
    private int currentScaling = 5;
    private static final float insetX = 25.0f;
    private static final float insetY = 25.0f;
    private int currentPage = 1;
    Stage stage;
    Scene scene;
    static final int FXscaling = 1;
    FitToPage zoomMode = FitToPage.AUTO;
    private FXViewerTransitions.TransitionType transitionType = FXViewerTransitions.TransitionType.None;

    public static void main(String[] args) {
        DecoderOptions.javaVersion = Float.parseFloat(System.getProperty("java.specification.version"));
        System.out.println("JAVA VERSION : " + DecoderOptions.javaVersion);
        if (DecoderOptions.javaVersion < 1.8f) {
            throw new RuntimeException("You need to Run Java 1.8+");
        }
        BaseViewerFX.launch((String[])args);
    }

    public void start(Stage stage) {
        String pageNum;
        stage.setTitle("Base Viewer FX - 6.9b21");
        String trans = System.getProperty("org.jpedal.fxtransition");
        if (trans != null) {
            trans = trans.substring(0, 1).toUpperCase() + trans.substring(1).toLowerCase();
            this.transitionType = FXViewerTransitions.TransitionType.valueOf(trans);
        }
        if ((pageNum = System.getProperty("org.jpedal.page")) != null) {
            this.currentPage = Integer.parseInt(pageNum);
        }
        this.stage = stage;
        this.scene = this.setupViewer(800, 600);
        List args = this.getParameters().getUnnamed();
        stage.setScene(this.scene);
        stage.show();
        if (args.size() == 1) {
            String input = (String)args.get(0);
            this.file = new File(input);
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    BaseViewerFX.this.loadPDF(BaseViewerFX.this.file);
                    if (System.getProperty("org.jpedal.page") != null) {
                        System.setProperty("org.jpedal.page", "");
                    }
                }
            });
        }
        this.addListeners();
    }

    public Scene setupViewer(int w, int h) {
        BorderPane root = new BorderPane();
        this.top = new VBox();
        root.setTop((Node)this.top);
        this.top.getChildren().add((Object)this.setupToolBar());
        this.bottom = new HBox();
        this.bottom.setPadding(new Insets(0.0, 10.0, 0.0, 10.0));
        root.setBottom((Node)this.bottom);
        this.center = new ScrollPane();
        this.center.setPannable(true);
        this.center.setHbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        this.center.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        this.group = new Group();
        this.group.getChildren().add((Object)this.pdf);
        this.center.setContent((Node)this.group);
        root.setCenter((Node)this.center);
        this.center.viewportBoundsProperty().addListener((ChangeListener)new ChangeListener<Bounds>(){

            public void changed(ObservableValue<? extends Bounds> ov, Bounds ob, Bounds nb) {
                BaseViewerFX.this.adjustPagePosition(nb);
            }
        });
        this.fileLoc = new Text("No PDF Selected");
        this.fileLoc.setId("file_location");
        this.bottom.getChildren().add((Object)this.fileLoc);
        this.scene = new Scene((Parent)root, (double)(w * 1), (double)(h * 1));
        return this.scene;
    }

    public void addListeners() {
        this.scene.widthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number oldSceneWidth, Number newSceneWidth) {
                BaseViewerFX.this.fitToX(BaseViewerFX.this.zoomMode);
            }
        });
        this.scene.heightProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number oldSceneHeight, Number newSceneHeight) {
                BaseViewerFX.this.fitToX(BaseViewerFX.this.zoomMode);
            }
        });
        this.scene.setOnDragOver((EventHandler)new EventHandler<DragEvent>(){

            public void handle(DragEvent event) {
                Dragboard db = event.getDragboard();
                if (db.hasFiles()) {
                    event.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
                } else {
                    event.consume();
                }
            }
        });
        this.scene.setOnDragDropped((EventHandler)new EventHandler<DragEvent>(){

            public void handle(DragEvent event) {
                Dragboard db = event.getDragboard();
                boolean success = false;
                if (db.hasFiles()) {
                    success = true;
                    BaseViewerFX.this.file = (File)db.getFiles().get(0);
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            BaseViewerFX.this.loadPDF(BaseViewerFX.this.file);
                        }
                    });
                }
                event.setDropCompleted(success);
                event.consume();
            }
        });
    }

    private ToolBar setupToolBar() {
        ToolBar toolbar = new ToolBar();
        Button open = new Button("Open");
        Button back = new Button("Back");
        ComboBox pages = new ComboBox();
        Label pageCount = new Label();
        Button forward = new Button("Forward");
        Button zoomIn = new Button("Zoom in");
        Button zoomOut = new Button("Zoom out");
        Button fitWidth = new Button("Fit to Width");
        Button fitHeight = new Button("Fit to Height");
        Button fitPage = new Button("Fit to Page");
        ComboBox transitionList = new ComboBox();
        open.setId("open");
        back.setId("back");
        pageCount.setId("pgCount");
        pages.setId("pages");
        forward.setId("forward");
        zoomIn.setId("zoomIn");
        zoomOut.setId("zoomOut");
        fitWidth.setId("fitWidth");
        fitHeight.setId("fitHeight");
        fitPage.setId("fitPage");
        open.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                File existDirectory;
                FileChooser chooser = new FileChooser();
                chooser.setTitle("Open PDF file");
                if (BaseViewerFX.this.file != null && (existDirectory = BaseViewerFX.this.file.getParentFile()).exists()) {
                    chooser.setInitialDirectory(existDirectory);
                }
                FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("PDF files (*.pdf)", new String[]{"*.pdf"});
                chooser.getExtensionFilters().add((Object)extFilter);
                BaseViewerFX.this.file = chooser.showOpenDialog(null);
                if (BaseViewerFX.this.file != null) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            BaseViewerFX.this.loadPDF(BaseViewerFX.this.file);
                        }
                    });
                }
            }
        });
        pages.getSelectionModel().selectedIndexProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number oldVal, Number newVal) {
                if (newVal.intValue() != -1 && newVal.intValue() + 1 != BaseViewerFX.this.currentPage) {
                    int newPage = newVal.intValue() + 1;
                    BaseViewerFX.this.goToPage(newPage);
                }
            }
        });
        back.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                if (BaseViewerFX.this.currentPage > 1) {
                    BaseViewerFX.this.goToPage(BaseViewerFX.this.currentPage - 1);
                }
            }
        });
        forward.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                if (BaseViewerFX.this.currentPage < BaseViewerFX.this.pdf.getPageCount()) {
                    BaseViewerFX.this.goToPage(BaseViewerFX.this.currentPage + 1);
                }
            }
        });
        zoomIn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                BaseViewerFX.this.zoomMode = FitToPage.NONE;
                if (BaseViewerFX.this.currentScaling < BaseViewerFX.this.scalings.length - 1) {
                    BaseViewerFX.this.currentScaling = BaseViewerFX.findClosestIndex(BaseViewerFX.this.scale, BaseViewerFX.this.scalings);
                    if (BaseViewerFX.this.scale >= BaseViewerFX.this.scalings[BaseViewerFX.findClosestIndex(BaseViewerFX.this.scale, BaseViewerFX.this.scalings)]) {
                        BaseViewerFX.this.currentScaling++;
                    }
                    BaseViewerFX.this.scale = BaseViewerFX.this.scalings[BaseViewerFX.this.currentScaling];
                }
                BaseViewerFX.this.pdf.setPageParameters(BaseViewerFX.this.scale, BaseViewerFX.this.currentPage);
                BaseViewerFX.this.adjustPagePosition(BaseViewerFX.this.center.getViewportBounds());
            }
        });
        zoomOut.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                BaseViewerFX.this.zoomMode = FitToPage.NONE;
                if (BaseViewerFX.this.currentScaling > 0) {
                    BaseViewerFX.this.currentScaling = BaseViewerFX.findClosestIndex(BaseViewerFX.this.scale, BaseViewerFX.this.scalings);
                    if (BaseViewerFX.this.scale <= BaseViewerFX.this.scalings[BaseViewerFX.findClosestIndex(BaseViewerFX.this.scale, BaseViewerFX.this.scalings)]) {
                        BaseViewerFX.this.currentScaling--;
                    }
                    BaseViewerFX.this.scale = BaseViewerFX.this.scalings[BaseViewerFX.this.currentScaling];
                }
                BaseViewerFX.this.pdf.setPageParameters(BaseViewerFX.this.scale, BaseViewerFX.this.currentPage);
                BaseViewerFX.this.adjustPagePosition(BaseViewerFX.this.center.getViewportBounds());
            }
        });
        fitWidth.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                BaseViewerFX.this.zoomMode = FitToPage.WIDTH;
                BaseViewerFX.this.fitToX(FitToPage.WIDTH);
            }
        });
        fitHeight.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                BaseViewerFX.this.zoomMode = FitToPage.HEIGHT;
                BaseViewerFX.this.fitToX(FitToPage.HEIGHT);
            }
        });
        fitPage.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                BaseViewerFX.this.zoomMode = FitToPage.AUTO;
                BaseViewerFX.this.fitToX(FitToPage.AUTO);
            }
        });
        Region spacerLeft = new Region();
        Region spacerRight = new Region();
        HBox.setHgrow((Node)spacerLeft, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)spacerRight, (Priority)Priority.ALWAYS);
        ObservableList options = FXCollections.observableArrayList();
        for (FXViewerTransitions.TransitionType transition : FXViewerTransitions.TransitionType.values()) {
            options.add((Object)transition.name());
        }
        if (!options.isEmpty()) {
            transitionList = new ComboBox(options);
            transitionList.valueProperty().addListener((ChangeListener)new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> ov, String oldVal, String newVal) {
                    BaseViewerFX.this.transitionType = FXViewerTransitions.TransitionType.valueOf(newVal);
                }
            });
            transitionList.setValue(options.get(this.transitionType.ordinal()));
        }
        toolbar.getItems().addAll((Object[])new Node[]{open, spacerLeft, back, pages, pageCount, forward, zoomIn, zoomOut, spacerRight, transitionList});
        return toolbar;
    }

    public void loadPDF(File input) {
        if (input == null) {
            return;
        }
        this.scale = 1.0f;
        this.PDFfile = input.getAbsolutePath();
        this.fileLoc.setText(this.PDFfile);
        this.openFile(input, null, false);
    }

    public void loadPDF(String input) {
        if (input == null) {
            return;
        }
        this.scale = 1.0f;
        this.PDFfile = input;
        this.fileLoc.setText(this.PDFfile);
        if (input.startsWith("http")) {
            this.openFile(null, input, true);
        } else {
            this.openFile(new File(input), null, false);
        }
    }

    private void openFile(File input, String url, boolean isURL) {
        try {
            if (isURL) {
                this.pdf.openPdfFileFromURL(url, false);
            } else {
                this.pdf.openPdfFile(input.getAbsolutePath());
            }
            if (this.customPluginHandle != null) {
                if (isURL) {
                    this.customPluginHandle.setFileName(url);
                } else {
                    this.customPluginHandle.setFileName(input.getAbsolutePath());
                }
            }
            if (System.getProperty("org.jpedal.page") != null && !System.getProperty("org.jpedal.page").isEmpty()) {
                this.currentPage = this.currentPage < 1 ? 1 : this.currentPage;
                this.currentPage = this.currentPage > this.pdf.getPageCount() ? this.pdf.getPageCount() : this.currentPage;
            } else {
                this.currentPage = 1;
            }
            if (this.pdf.isEncrypted()) {
                int passwordCount = 0;
                this.closePasswordPrompt = false;
                while (!this.pdf.isFileViewable() && !this.closePasswordPrompt) {
                    if (System.getProperty("org.jpedal.password") != null) {
                        this.password = System.getProperty("org.jpedal.password");
                    } else if (!this.closePasswordPrompt) {
                        this.showPasswordPrompt(passwordCount);
                    }
                    if (this.password != null) {
                        if (isURL) {
                            this.pdf.openPdfFileFromURL(url, false, this.password);
                        } else {
                            this.pdf.openPdfFile(input.getAbsolutePath());
                        }
                    }
                    ++passwordCount;
                }
            }
            ((Label)this.top.lookup("#pgCount")).setText("/" + this.pdf.getPageCount());
            ComboBox pages = (ComboBox)this.top.lookup("#pages");
            pages.getItems().clear();
            for (int i = 1; i <= this.pdf.getPageCount(); ++i) {
                pages.getItems().add((Object)String.valueOf(i));
            }
            this.goToPage(this.currentPage);
        }
        catch (PdfException ex) {
            ex.printStackTrace();
        }
    }

    private void showPasswordPrompt(int passwordCount) {
        Text titleText = new Text("Password Request");
        TextField inputPasswordField = new TextField("Please Enter Password");
        if (passwordCount >= 1) {
            titleText.setText("Incorrect Password");
            inputPasswordField.setText("Please Try Again");
        }
        FXInputDialog passwordInput = new FXInputDialog(this.stage, titleText.getText()){

            @Override
            protected void positiveClose() {
                super.positiveClose();
                BaseViewerFX.this.closePasswordPrompt = true;
            }
        };
        this.password = passwordInput.showInputDialog();
    }

    private void fitToX(FitToPage fitToPage) {
        if (fitToPage == FitToPage.NONE) {
            return;
        }
        float pageW = this.pdf.getPdfPageData().getCropBoxWidth2D(this.currentPage);
        float pageH = this.pdf.getPdfPageData().getCropBoxHeight2D(this.currentPage);
        int rotation = this.pdf.getPdfPageData().getRotation(this.currentPage);
        if (fitToPage == FitToPage.AUTO && pageW < pageH) {
            if (this.pdf.getPDFWidth() < this.pdf.getPDFHeight()) {
                this.fitToX(FitToPage.HEIGHT);
            } else {
                this.fitToX(FitToPage.WIDTH);
            }
        }
        if (fitToPage == FitToPage.WIDTH) {
            float width = (float)this.scene.getWidth();
            this.scale = rotation == 90 || rotation == 270 ? (width - 25.0f - 25.0f) / pageH : (width - 25.0f - 25.0f) / pageW;
        } else if (fitToPage == FitToPage.HEIGHT) {
            float height = (float)(this.scene.getHeight() - this.top.getBoundsInLocal().getHeight() - this.bottom.getHeight());
            this.scale = rotation == 90 || rotation == 270 ? (height - 25.0f - 25.0f) / pageW : (height - 25.0f - 25.0f) / pageH;
        }
        this.pdf.setPageParameters(this.scale, this.currentPage);
    }

    private static int findClosestIndex(float scale, float[] scalings) {
        float currentMinDiff = Float.MAX_VALUE;
        int closest = 0;
        for (int i = 0; i < scalings.length - 1; ++i) {
            float diff = Math.abs(scalings[i] - scale);
            if (!(diff < currentMinDiff)) continue;
            currentMinDiff = diff;
            closest = i;
        }
        return closest;
    }

    private void decodePage() {
        try {
            PdfPageData pageData = this.pdf.getPdfPageData();
            int rotation = pageData.getRotation(this.currentPage);
            if (rotation == 0 || rotation == 180) {
                this.pdf.setPageParameters(this.scale, this.currentPage);
            }
            this.pdf.decodePage(this.currentPage);
            this.pdf.waitForDecodingToFinish();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.fitToX(FitToPage.AUTO);
        this.updateNavButtons();
        this.setBorder();
        this.adjustPagePosition(this.center.getViewportBounds());
    }

    private void updateNavButtons() {
        if (this.currentPage > 1) {
            this.top.lookup("#back").setDisable(false);
        } else {
            this.top.lookup("#back").setDisable(true);
        }
        if (this.currentPage < this.pdf.getPageCount()) {
            this.top.lookup("#forward").setDisable(false);
        } else {
            this.top.lookup("#forward").setDisable(true);
        }
        ((ComboBox)this.top.lookup("#pages")).getSelectionModel().select(this.currentPage - 1);
    }

    private void goToPage(int newPage) {
        FXViewerTransitions.TransitionDirection direction = this.transitionType != FXViewerTransitions.TransitionType.Fade || this.transitionType != FXViewerTransitions.TransitionType.None ? (newPage > this.currentPage ? FXViewerTransitions.TransitionDirection.LEFT : FXViewerTransitions.TransitionDirection.RIGHT) : FXViewerTransitions.TransitionDirection.NONE;
        switch (this.transitionType) {
            case Fade: {
                this.startTransition(newPage, direction);
                break;
            }
            case Scale: {
                this.startTransition(newPage, direction);
                break;
            }
            case Rotate: {
                this.startTransition(newPage, direction);
                break;
            }
            case CardStack: {
                this.startTransition(newPage, direction);
                break;
            }
            default: {
                this.currentPage = newPage;
                this.decodePage();
            }
        }
    }

    private void startTransition(final int newPage, final FXViewerTransitions.TransitionDirection direction) {
        Transition exitTransition = FXViewerTransitions.exitTransition(this.pdf, this.transitionType, direction);
        if (exitTransition != null) {
            exitTransition.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent t) {
                    BaseViewerFX.this.currentPage = newPage;
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            BaseViewerFX.this.decodePage();
                        }
                    });
                    FXViewerTransitions.TransitionDirection entryDirection = direction;
                    if (direction != FXViewerTransitions.TransitionDirection.NONE) {
                        entryDirection = direction == FXViewerTransitions.TransitionDirection.LEFT ? FXViewerTransitions.TransitionDirection.RIGHT : FXViewerTransitions.TransitionDirection.LEFT;
                    }
                    Transition entryTransition = FXViewerTransitions.entryTransition(BaseViewerFX.this.pdf, BaseViewerFX.this.transitionType, entryDirection);
                    entryTransition.play();
                }
            });
            exitTransition.play();
        }
    }

    public String getPDFfilename() {
        return this.PDFfile;
    }

    private void adjustPagePosition(Bounds nb) {
        double adjustment = nb.getWidth() / 2.0 - this.group.getBoundsInLocal().getWidth() / 2.0;
        if (adjustment < 0.0) {
            adjustment = 0.0;
        }
        this.group.setTranslateX(adjustment);
    }

    private void setBorder() {
        int rotation = this.pdf.getPdfPageData().getRotation(this.currentPage);
        double x = rotation == 90 || rotation == 270 ? 40.0 : 0.0;
        double y = rotation == 90 || rotation == 270 ? 0.0 : 40.0;
        DropShadow pdfBorder = new DropShadow(0.0, x, y, Color.TRANSPARENT);
        this.pdf.setEffect((Effect)pdfBorder);
    }

    public void addExternalHandler(PluginHandler customPluginHandle) {
        this.customPluginHandle = customPluginHandle;
    }

    public static enum FitToPage {
        AUTO,
        WIDTH,
        HEIGHT,
        NONE;

    }
}

