/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer;

import java.util.List;
import javafx.animation.FadeTransition;
import javafx.application.Application;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.Duration;
import org.jpedal.examples.viewer.OpenViewerFX;
import org.jpedal.parser.DecoderOptions;

public class FXStartup
extends Application {
    private ProgressBar loadProgress;
    private Label progressText;
    OpenViewerFX viewer;
    private Pane splashLayout;
    private final Stage splashStage = new Stage();
    private static final int SPLASH_WIDTH = 600;
    private static final int SPLASH_HEIGHT = 200;

    public static void main(String[] args) {
        DecoderOptions.javaVersion = Float.parseFloat(System.getProperty("java.specification.version"));
        OpenViewerFX.checkUserJavaVersion();
        FXStartup.launch((String[])args);
    }

    public void init() {
        String barColour;
        String imgPath;
        if (!OpenViewerFX.isOpenFX) {
            imgPath = "/org/jpedal/examples/viewer/res/viewerFXSplash.png";
            barColour = "-fx-accent: blue;";
        } else {
            imgPath = "/org/jpedal/examples/viewer/res/OSFXSplash.png";
            barColour = "-fx-accent: purple;";
        }
        ImageView splash = new ImageView(((Object)((Object)this)).getClass().getResource(imgPath).toExternalForm());
        this.loadProgress = new ProgressBar();
        this.loadProgress.setPrefWidth(600.0);
        this.progressText = new Label("All modules are loaded.");
        this.loadProgress.setStyle(barColour);
        this.splashLayout = new VBox();
        this.splashLayout.getChildren().addAll((Object[])new Node[]{splash, this.loadProgress, this.progressText});
        this.progressText.setAlignment(Pos.CENTER);
        this.splashLayout.setEffect((Effect)new DropShadow());
    }

    public void start(final Stage initstage) {
        boolean showSplashScreen = false;
        if (showSplashScreen) {
            System.out.println("Starting the SplashScreen");
            Task loadModsTask = new Task(){

                protected ObservableList<String> call() throws InterruptedException {
                    ObservableList loadMods = FXCollections.observableArrayList();
                    ObservableList availableFriends = FXCollections.observableArrayList((Object[])new String[]{"Network Module", "User Module", "User Interface", "User Controls"});
                    this.updateMessage("Loading. . .");
                    for (int i = 0; i < availableFriends.size(); ++i) {
                        Thread.sleep(900L);
                        this.updateProgress(i + 1, availableFriends.size());
                        String nextFriend = (String)availableFriends.get(i);
                        loadMods.add((Object)nextFriend);
                        this.updateMessage("Loading . . .  " + nextFriend);
                    }
                    Thread.sleep(500L);
                    this.updateMessage("All Modules are loaded.");
                    return loadMods;
                }
            };
            this.showSplash(loadModsTask);
            loadModsTask.setOnSucceeded(new EventHandler(){

                public void handle(Event event) {
                    FXStartup.this.startNew(initstage);
                }
            });
            new Thread((Runnable)loadModsTask).start();
        } else {
            this.startNew(initstage);
        }
    }

    public void startNew(Stage stage) {
        List args = this.getParameters().getUnnamed();
        this.viewer = new OpenViewerFX(stage, args.toArray(new String[args.size()]));
        this.viewer.setupViewer();
    }

    private void showSplash(Task task) {
        this.progressText.textProperty().bind((ObservableValue)task.messageProperty());
        this.loadProgress.progressProperty().bind((ObservableValue)task.progressProperty());
        task.stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

            public void changed(ObservableValue<? extends Worker.State> observableValue, Worker.State oldState, Worker.State newState) {
                if (newState == Worker.State.SUCCEEDED) {
                    FXStartup.this.loadProgress.progressProperty().unbind();
                    FXStartup.this.loadProgress.setProgress(1.0);
                    FXStartup.this.splashStage.toFront();
                    FadeTransition fadeSplash = new FadeTransition(Duration.seconds((double)1.2), (Node)FXStartup.this.splashLayout);
                    fadeSplash.setFromValue(1.0);
                    fadeSplash.setToValue(0.0);
                    fadeSplash.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

                        public void handle(ActionEvent actionEvent) {
                            FXStartup.this.splashStage.hide();
                        }
                    });
                    fadeSplash.play();
                }
            }
        });
        Scene splashScene = new Scene((Parent)this.splashLayout);
        this.splashStage.initStyle(StageStyle.UNDECORATED);
        Rectangle2D bounds = Screen.getPrimary().getBounds();
        this.splashStage.setScene(splashScene);
        this.splashStage.setX(bounds.getMinX() + bounds.getWidth() / 2.0 - 300.0);
        this.splashStage.setY(bounds.getMinY() + bounds.getHeight() / 2.0 - 100.0);
        this.splashStage.show();
    }

    public OpenViewerFX getViewer() {
        return this.viewer;
    }
}

