/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer;

import java.util.Stack;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.MenuItem;
import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.viewer.RecentDocuments;
import org.jpedal.examples.viewer.RecentDocumentsFactory;
import org.jpedal.examples.viewer.SharedViewer;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.utils.Printer;
import org.jpedal.examples.viewer.utils.PropertiesFile;
import org.jpedal.gui.GUIFactory;
import org.jpedal.utils.Messages;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JavaFXRecentDocuments
implements RecentDocumentsFactory {
    final int noOfRecentDocs;
    private final Stack previousFiles = new Stack();
    private final Stack nextFiles = new Stack();
    public final MenuItem[] recentDocuments;

    public JavaFXRecentDocuments(int noOfRecentDocs) {
        this.noOfRecentDocs = noOfRecentDocs;
        this.recentDocuments = new MenuItem[noOfRecentDocs];
    }

    @Override
    public String getPreviousDocument() {
        String fileToOpen = null;
        if (this.previousFiles.size() > 1) {
            this.nextFiles.push(this.previousFiles.pop());
            fileToOpen = (String)this.previousFiles.pop();
        }
        return fileToOpen;
    }

    @Override
    public String getNextDocument() {
        String fileToOpen = null;
        if (!this.nextFiles.isEmpty()) {
            fileToOpen = (String)this.nextFiles.pop();
        }
        return fileToOpen;
    }

    @Override
    public void addToFileList(String selectedFile) {
        this.previousFiles.push(selectedFile);
    }

    @Override
    public void enableRecentDocuments(boolean enable) {
        if (this.recentDocuments == null) {
            return;
        }
        for (int i = 0; i < this.recentDocuments.length; ++i) {
            if (this.recentDocuments[i] == null || this.recentDocuments[i].getText().equals(i + 1 + ": ")) continue;
            this.recentDocuments[i].setVisible(enable);
            this.recentDocuments[i].setDisable(!enable);
        }
    }

    @Override
    public void updateRecentDocuments(String[] recentDocs) {
        if (recentDocs == null) {
            return;
        }
        for (int i = 0; i < recentDocs.length; ++i) {
            if (recentDocs[i] == null) continue;
            String shortenedFileName = RecentDocuments.getShortenedFileName(recentDocs[i]);
            if (this.recentDocuments[i] == null) {
                this.recentDocuments[i] = new MenuItem();
            }
            this.recentDocuments[i].setText(i + 1 + ": " + shortenedFileName);
            if (this.recentDocuments[i].getText().equals(i + 1 + ": ")) {
                this.recentDocuments[i].setVisible(false);
            } else {
                this.recentDocuments[i].setVisible(true);
            }
            this.recentDocuments[i].setId(recentDocs[i]);
        }
    }

    @Override
    public void clearRecentDocuments(PropertiesFile properties) {
        NodeList nl = properties.getDoc().getElementsByTagName("recentfiles");
        if (nl != null && nl.getLength() > 0) {
            NodeList allRecentDocs = ((Element)nl.item(0)).getElementsByTagName("*");
            for (int i = 0; i < allRecentDocs.getLength(); ++i) {
                Node item = allRecentDocs.item(i);
                nl.item(0).removeChild(item);
            }
        }
        for (int i = 0; i < this.noOfRecentDocs; ++i) {
            this.recentDocuments[i].setText(i + 1 + ": ");
            this.recentDocuments[i].setVisible(false);
        }
    }

    @Override
    public void createMenuItems(String fileNameToAdd, int position, final GUIFactory currentGUI, Values commonValues, PdfDecoderInt decode_pdf) {
        String shortenedFileName = RecentDocuments.getShortenedFileName(fileNameToAdd);
        this.recentDocuments[position] = new MenuItem(position + 1 + ": " + shortenedFileName);
        if (this.recentDocuments[position].getText().equals(position + 1 + ": ")) {
            this.recentDocuments[position].setVisible(false);
        }
        this.recentDocuments[position].setId(fileNameToAdd);
        this.recentDocuments[position].setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (Printer.isPrinting()) {
                    currentGUI.showMessageDialog(Messages.getMessage("PdfViewerPrintWait.message"));
                } else if (Values.isProcessing()) {
                    currentGUI.showMessageDialog(Messages.getMessage("PdfViewerDecodeWait.message"));
                } else {
                    System.out.println("SaveForm in JavaFXCommands recentDocumentsOption is not yet implemented for FX");
                    MenuItem item = (MenuItem)event.getSource();
                    String fileName = item.getId();
                    if (!fileName.isEmpty()) {
                        if (!SharedViewer.closeCalled) {
                            currentGUI.open(fileName);
                        } else {
                            throw new RuntimeException("No resource to open document, call to close() disposes viewer resources");
                        }
                    }
                }
            }
        });
        currentGUI.getMenuItems().addToMenu(this.recentDocuments[position], 317);
    }
}

