/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer;

import java.util.Locale;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.scene.Parent;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import org.jpedal.PdfDecoderFX;
import org.jpedal.examples.viewer.JavaFXCommands;
import org.jpedal.examples.viewer.SharedViewer;
import org.jpedal.examples.viewer.ViewerInt;
import org.jpedal.examples.viewer.gui.JavaFxGUI;
import org.jpedal.examples.viewer.gui.javafx.JavaFXSearchWindow;
import org.jpedal.examples.viewer.gui.javafx.JavaFXThumbnailPanel;
import org.jpedal.examples.viewer.objects.FXClientExternalHandler;
import org.jpedal.examples.viewer.utils.FXPrinter;
import org.jpedal.objects.acroforms.actions.JavaFXDefaultActionHandler;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class OpenViewerFX
extends SharedViewer
implements ViewerInt {
    public static boolean isOpenFX = OpenViewerFX.class.getResourceAsStream("/org/jpedal/examples/viewer/OpenViewerFX.class") != null;
    private Stage stage;
    private String[] args;

    public OpenViewerFX(Stage stage, String[] args) {
        this.stage = stage;
        this.args = args;
        this.init();
    }

    public OpenViewerFX(Parent parentPane, String preferencesPath) {
        DecoderOptions.showErrorMessages = true;
        if (preferencesPath != null && !preferencesPath.isEmpty()) {
            try {
                this.properties.loadProperties(preferencesPath);
            }
            catch (Exception e) {
                System.err.println("Specified Preferrences file not found at " + preferencesPath + ". If this file is within a jar ensure filename has jar: at the begining.\n\nLoading default properties. " + e);
                this.properties.loadProperties();
            }
        } else {
            this.properties.loadProperties();
        }
        this.init();
        this.setRootContainer(parentPane);
    }

    @Override
    public void setupViewer() {
        super.setupViewer();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                OpenViewerFX.this.handleArguments(OpenViewerFX.this.args);
                if (OpenViewerFX.this.stage != null) {
                    OpenViewerFX.this.stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

                        public void handle(WindowEvent t) {
                            OpenViewerFX.this.currentCommands.executeCommand(7, null);
                        }
                    });
                }
            }
        });
    }

    void init() {
        try {
            Messages.setBundle(ResourceBundle.getBundle("org.jpedal.international.messages"));
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " loading resource bundle.\n" + "Also check you have a file in org.jpedal.international.messages to support Locale=" + Locale.getDefault());
        }
        if (!isOpenFX) {
            this.currentPrinter = new FXPrinter();
        }
        this.decode_pdf = new PdfDecoderFX();
        this.thumbnails = new JavaFXThumbnailPanel(this.decode_pdf);
        this.currentGUI = new JavaFxGUI(this.stage, this.decode_pdf, this.commonValues, this.thumbnails, this.properties);
        this.decode_pdf.addExternalHandler(new JavaFXDefaultActionHandler(this.currentGUI), 5);
        this.decode_pdf.addExternalHandler(new FXClientExternalHandler(), 39);
        this.searchFrame = new JavaFXSearchWindow(this.currentGUI);
        this.currentCommands = new JavaFXCommands(this.commonValues, this.currentGUI, this.decode_pdf, this.thumbnails, this.properties, this.searchFrame, this.currentPrinter);
        DecoderOptions.showErrorMessages = true;
        String prefFile = System.getProperty("org.jpedal.Viewer.Prefs");
        if (prefFile != null) {
            this.properties.loadProperties(prefFile);
        } else {
            this.properties.loadProperties();
        }
    }

    @Override
    public void handleArguments(final String[] args) {
        if (Platform.isFxApplicationThread()) {
            if (args != null && args.length > 0) {
                this.openDefaultFile(args[0]);
            } else if (this.properties.getValue("openLastDocument").toLowerCase().equals("true") && this.properties.getRecentDocuments() != null && this.properties.getRecentDocuments().length > 1) {
                int lastPageViewed = Integer.parseInt(this.properties.getValue("lastDocumentPage"));
                if (lastPageViewed < 0) {
                    lastPageViewed = 1;
                }
                this.openDefaultFileAtPage(this.properties.getRecentDocuments()[0], lastPageViewed);
            }
        } else {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    if (args.length > 0) {
                        OpenViewerFX.this.openDefaultFile(args[0]);
                    } else if (OpenViewerFX.this.properties.getValue("openLastDocument").toLowerCase().equals("true") && OpenViewerFX.this.properties.getRecentDocuments() != null && OpenViewerFX.this.properties.getRecentDocuments().length > 1) {
                        int lastPageViewed = Integer.parseInt(OpenViewerFX.this.properties.getValue("lastDocumentPage"));
                        if (lastPageViewed < 0) {
                            lastPageViewed = 1;
                        }
                        OpenViewerFX.this.openDefaultFileAtPage(OpenViewerFX.this.properties.getRecentDocuments()[0], lastPageViewed);
                    }
                }
            };
            Platform.runLater((Runnable)run);
        }
    }

    public void close() {
        SharedViewer.closeCalled = true;
        this.currentCommands.executeCommand(7, null);
    }

    @Deprecated
    public OpenViewerFX(String[] args) {
        this(null, args);
    }

    public BorderPane getRoot() {
        return ((JavaFxGUI)this.currentGUI).getRoot();
    }

    protected static void checkUserJavaVersion() {
        if (Float.parseFloat(System.getProperty("java.specification.version")) < 1.8f) {
            throw new RuntimeException("To run the JPedal FX Viewer, you must have Java8 or above installed");
        }
    }

    static {
        OpenViewerFX.checkUserJavaVersion();
        isFX = true;
    }
}

