/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands;

import java.beans.PropertyVetoException;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import org.jpedal.gui.GUIFactory;
import org.jpedal.utils.LogWriter;

public class Cascade {
    public static void execute(Object[] args, GUIFactory currentGUI) {
        if (args == null) {
            Cascade.cascade(currentGUI);
        }
    }

    private static void cascade(GUIFactory currentGUI) {
        JDesktopPane desktopPane = (JDesktopPane)currentGUI.getMultiViewerFrames();
        JInternalFrame[] frames = desktopPane.getAllFrames();
        int left = 0;
        for (int right = frames.length - 1; left < right; ++left, --right) {
            JInternalFrame temp = frames[left];
            frames[left] = frames[right];
            frames[right] = temp;
        }
        int x = 0;
        int y = 0;
        int width = desktopPane.getWidth() / 2;
        int height = desktopPane.getHeight() / 2;
        for (JInternalFrame frame : frames) {
            if (frame.isIcon()) continue;
            try {
                frame.setMaximum(false);
                frame.reshape(x, y, width, height);
                frame.setSelected(true);
                y += 25;
                if ((x += 25) + width > desktopPane.getWidth()) {
                    x = 0;
                }
                if (y + height <= desktopPane.getHeight()) continue;
                y = 0;
            }
            catch (PropertyVetoException e) {
                LogWriter.writeLog("Exception attempting to set size" + e);
            }
        }
    }
}

