/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.viewer.Values;
import org.jpedal.fonts.FontMappings;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.gui.GUIFactory;
import org.jpedal.objects.PdfFileInformation;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.objects.acroforms.ReturnValues;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfDictionary;
import org.jpedal.parser.image.ImageCommands;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class DocInfo {
    private static final Font textFont = new Font("Serif", 0, 12);
    private static final Font headFont = new Font("SansSerif", 1, 14);
    private static boolean sortFontsByDir = true;
    private static final String user_dir = System.getProperty("user.dir");
    private static final JScrollPane fontScrollPane = new JScrollPane();

    public static void execute(Object[] args, GUIFactory currentGUI, Values commonValues, PdfDecoderInt decode_pdf) {
        if (args == null) {
            if (!commonValues.isPDF()) {
                currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.ImageSearch"));
            } else if (commonValues.getSelectedFile() == null) {
                currentGUI.showMessageDialog((Object)Messages.getMessage("PdfVieweremptyFile.message"), Messages.getMessage("PdfViewerTooltip.pageSize"), -1);
            } else {
                DocInfo.getDocumentProperties(commonValues.getSelectedFile(), commonValues.getFileSize(), commonValues.getPageCount(), commonValues.getCurrentPage(), decode_pdf, currentGUI);
            }
        }
    }

    private static void getDocumentProperties(String selectedFile, long size, int pageCount, int currentPage, PdfDecoderInt decode_pdf, GUIFactory currentGUI) {
        PdfFileInformation currentFileInformation;
        String xmlText;
        int ptr;
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.setBackground(Color.WHITE);
        if (LogWriter.isRunningFromIDE) {
            tabbedPane.setName("docProp");
        }
        if ((ptr = selectedFile.lastIndexOf(92)) == -1) {
            ptr = selectedFile.lastIndexOf(47);
        }
        String file = selectedFile.substring(ptr + 1, selectedFile.length());
        String path = selectedFile.substring(0, ptr + 1);
        int ii = 0;
        tabbedPane.add(DocInfo.getPropertiesBox(file, path, user_dir, size, pageCount, currentPage, decode_pdf));
        tabbedPane.setTitleAt(ii++, Messages.getMessage("PdfViewerTab.Properties"));
        tabbedPane.add(DocInfo.getFontInfoBox(decode_pdf.getInfo(373243460)));
        tabbedPane.setTitleAt(ii++, Messages.getMessage("PdfViewerTab.Fonts"));
        if (ImageCommands.trackImages) {
            tabbedPane.add(DocInfo.getImageInfoBox(decode_pdf));
            tabbedPane.setTitleAt(ii++, Messages.getMessage("PdfViewerTab.Images"));
        }
        tabbedPane.add(DocInfo.getFontsFoundInfoBox());
        tabbedPane.setTitleAt(ii++, "Available");
        tabbedPane.add(DocInfo.getFontsAliasesInfoBox());
        tabbedPane.setTitleAt(ii++, "Aliases");
        int nextTab = ii;
        if (DocInfo.getFormList(decode_pdf) != null) {
            tabbedPane.add(DocInfo.getFormList(decode_pdf));
            tabbedPane.setTitleAt(nextTab, "Forms");
            ++nextTab;
        }
        if (!(xmlText = (currentFileInformation = decode_pdf.getFileInformationData()).getFileXMLMetaData()).isEmpty()) {
            tabbedPane.add(DocInfo.getXMLInfoBox(xmlText));
            tabbedPane.setTitleAt(nextTab, "XML");
        }
        currentGUI.showMessageDialog((Object)tabbedPane, Messages.getMessage("PdfViewerTab.DocumentProperties"), -1);
    }

    private static JScrollPane getPropertiesBox(String file, String path, String user_dir, long size, int pageCount, int currentPage, PdfDecoderInt decode_pdf) {
        PdfFileInformation currentFileInformation = decode_pdf.getFileInformationData();
        if (currentFileInformation != null) {
            JPanel details = new JPanel();
            details.setOpaque(true);
            details.setBackground(Color.white);
            details.setLayout(new BoxLayout(details, 1));
            JScrollPane scrollPane = new JScrollPane();
            scrollPane.setPreferredSize(new Dimension(400, 300));
            scrollPane.getViewport().add(details);
            scrollPane.setVerticalScrollBarPolicy(20);
            scrollPane.setHorizontalScrollBarPolicy(30);
            JLabel header1 = new JLabel(Messages.getMessage("PdfViewerGeneral"));
            header1.setFont(headFont);
            header1.setOpaque(false);
            details.add(header1);
            JLabel g1 = new JLabel(Messages.getMessage("PdfViewerFileName") + file);
            g1.setFont(textFont);
            g1.setOpaque(false);
            details.add(g1);
            JLabel g2 = new JLabel(Messages.getMessage("PdfViewerFilePath") + path);
            g2.setFont(textFont);
            g2.setOpaque(false);
            details.add(g2);
            JLabel g3 = new JLabel(Messages.getMessage("PdfViewerCurrentWorkingDir") + ' ' + user_dir);
            g3.setFont(textFont);
            g3.setOpaque(false);
            details.add(g3);
            JLabel g4 = new JLabel(Messages.getMessage("PdfViewerFileSize") + size + " K");
            g4.setFont(textFont);
            g4.setOpaque(false);
            details.add(g4);
            JLabel g5 = new JLabel(Messages.getMessage("PdfViewerPageCount") + pageCount);
            g5.setOpaque(false);
            g5.setFont(textFont);
            details.add(g5);
            StringBuilder g6Text = new StringBuilder("PDF ");
            g6Text.append(decode_pdf.getPDFVersion());
            if (decode_pdf.getJPedalObject(2004845231) != null) {
                g6Text.append(" (").append(Messages.getMessage("PdfViewerLinearized.text")).append(") ");
            }
            JLabel g6 = new JLabel(g6Text.toString());
            g6.setOpaque(false);
            g6.setFont(textFont);
            details.add(g6);
            details.add(Box.createVerticalStrut(10));
            JLabel header2 = new JLabel(Messages.getMessage("PdfViewerProperties"));
            header2.setFont(headFont);
            header2.setOpaque(false);
            details.add(header2);
            String[] values = currentFileInformation.getFieldValues();
            String[] fields = PdfFileInformation.getFieldNames();
            int count = fields.length;
            JLabel[] displayValues = new JLabel[count];
            for (int i = 0; i < count; ++i) {
                if (values[i].isEmpty()) continue;
                displayValues[i] = new JLabel(fields[i] + " = " + values[i]);
                displayValues[i].setFont(textFont);
                displayValues[i].setOpaque(false);
                details.add(displayValues[i]);
            }
            details.add(Box.createVerticalStrut(10));
            PdfPageData currentPageSize = decode_pdf.getPdfPageData();
            if (currentPageSize != null) {
                JLabel header3 = new JLabel(Messages.getMessage("PdfViewerCoords.text"));
                header3.setFont(headFont);
                details.add(header3);
                JLabel g7 = new JLabel(Messages.getMessage("PdfViewermediaBox.text") + currentPageSize.getMediaValue(currentPage));
                g7.setFont(textFont);
                details.add(g7);
                JLabel g8 = new JLabel(Messages.getMessage("PdfViewercropBox.text") + currentPageSize.getCropValue(currentPage));
                g8.setFont(textFont);
                details.add(g8);
                JLabel g9 = new JLabel(Messages.getMessage("PdfViewerLabel.Rotation") + currentPageSize.getRotation(currentPage));
                g9.setFont(textFont);
                details.add(g9);
            }
            details.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            return scrollPane;
        }
        return new JScrollPane();
    }

    private static JScrollPane getFontInfoBox(String xmlTxt) {
        JPanel details = new JPanel();
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setPreferredSize(new Dimension(400, 300));
        scrollPane.getViewport().add(details);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setHorizontalScrollBarPolicy(30);
        details.setOpaque(true);
        details.setBackground(Color.white);
        details.setEnabled(false);
        details.setLayout(new BoxLayout(details, 3));
        StringBuilder xmlText = new StringBuilder("Font Substitution mode: ");
        switch (FontMappings.getFontSubstitutionMode()) {
            case 1: {
                xmlText.append("using file name");
                break;
            }
            case 2: {
                xmlText.append("using PostScript name");
                break;
            }
            case 3: {
                xmlText.append("using family name");
                break;
            }
            case 4: {
                xmlText.append("using the full font name");
                break;
            }
            default: {
                xmlText.append("Unknown FontSubstitutionMode");
            }
        }
        xmlText.append('\n');
        if (!xmlTxt.isEmpty()) {
            JTextArea xml = new JTextArea();
            JLabel mode = new JLabel();
            mode.setAlignmentX(0.5f);
            mode.setText(xmlText.toString());
            mode.setForeground(Color.BLUE);
            xml.setLineWrap(false);
            xml.setForeground(Color.BLACK);
            xml.setText('\n' + xmlTxt);
            details.add(mode);
            details.add(xml);
            xml.setCaretPosition(0);
            xml.setOpaque(false);
        }
        return scrollPane;
    }

    private static JScrollPane getImageInfoBox(PdfDecoderInt decode_pdf) {
        JPanel details = new JPanel();
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setPreferredSize(new Dimension(400, 300));
        scrollPane.getViewport().add(details);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setHorizontalScrollBarPolicy(30);
        details.setOpaque(true);
        details.setBackground(Color.white);
        details.setEnabled(false);
        details.setLayout(new BoxLayout(details, 3));
        String xmlTxt = decode_pdf.getInfo(1026635598);
        if (!xmlTxt.isEmpty()) {
            JTextArea xml = new JTextArea();
            xml.setLineWrap(false);
            xml.setForeground(Color.BLACK);
            xml.setText('\n' + xmlTxt);
            details.add(xml);
            xml.setCaretPosition(0);
            xml.setOpaque(false);
        }
        return scrollPane;
    }

    private static void displayAvailableFonts(DefaultMutableTreeNode fontlist) {
        fontScrollPane.getViewport().removeAll();
        JPanel jp = new JPanel(new BorderLayout());
        jp.setBackground(Color.WHITE);
        jp.add((Component)new JTree(fontlist), "West");
        fontScrollPane.getViewport().add(jp);
    }

    private static DefaultMutableTreeNode populateAvailableFonts(DefaultMutableTreeNode top, String filter) {
        block10: {
            if (FontMappings.fontSubstitutionTable == null) break block10;
            Set fonts = FontMappings.fontSubstitutionTable.keySet();
            Iterator fontList = FontMappings.fontSubstitutionTable.keySet().iterator();
            int fontCount = fonts.size();
            ArrayList<String> fontNames = new ArrayList<String>(fontCount);
            while (fontList.hasNext()) {
                fontNames.add(fontList.next().toString());
            }
            Collections.sort(fontNames);
            if (sortFontsByDir) {
                ArrayList<String> location = new ArrayList<String>();
                ArrayList<DefaultMutableTreeNode> locationNode = new ArrayList<DefaultMutableTreeNode>();
                for (int ii = 0; ii < fontCount; ++ii) {
                    Object nextFont = fontNames.get(ii);
                    String current = (String)FontMappings.fontSubstitutionLocation.get(nextFont);
                    int ptr = current.lastIndexOf(System.getProperty("file.separator"));
                    if (ptr == -1 && current.indexOf(47) != -1) {
                        ptr = current.lastIndexOf(47);
                    }
                    if (ptr != -1) {
                        current = current.substring(0, ptr);
                    }
                    if (filter != null && !((String)nextFont).toLowerCase().contains(filter.toLowerCase())) continue;
                    if (!location.contains(current)) {
                        location.add(current);
                        DefaultMutableTreeNode loc = new DefaultMutableTreeNode(new DefaultMutableTreeNode(current));
                        top.add(loc);
                        locationNode.add(loc);
                    }
                    DefaultMutableTreeNode FontTop = new DefaultMutableTreeNode(nextFont + " = " + FontMappings.fontSubstitutionLocation.get(nextFont));
                    int pos = location.indexOf(current);
                    ((DefaultMutableTreeNode)locationNode.get(pos)).add(FontTop);
                    String loc = (String)FontMappings.fontPropertiesTable.get(nextFont + "_path");
                    Integer type = (Integer)FontMappings.fontPropertiesTable.get(nextFont + "_type");
                    Map properties = StandardFonts.getFontDetails(type, loc);
                    if (properties == null) continue;
                    for (Object key : properties.keySet()) {
                        Object value = properties.get(key);
                        DefaultMutableTreeNode FontDetails = new DefaultMutableTreeNode(key + " = " + value);
                        FontTop.add(FontDetails);
                    }
                }
            } else {
                for (int ii = 0; ii < fontCount; ++ii) {
                    Object nextFont = fontNames.get(ii);
                    if (filter != null && !((String)nextFont).toLowerCase().contains(filter.toLowerCase())) continue;
                    DefaultMutableTreeNode FontTop = new DefaultMutableTreeNode(nextFont + " = " + FontMappings.fontSubstitutionLocation.get(nextFont));
                    top.add(FontTop);
                    Map properties = (Map)FontMappings.fontPropertiesTable.get(nextFont);
                    if (properties == null) continue;
                    for (Object key : properties.keySet()) {
                        Object value = properties.get(key);
                        DefaultMutableTreeNode FontDetails = new DefaultMutableTreeNode(key + " = " + value);
                        FontTop.add(FontDetails);
                    }
                }
            }
        }
        return top;
    }

    private static JScrollPane getFontsAliasesInfoBox() {
        JPanel details = new JPanel();
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setPreferredSize(new Dimension(400, 300));
        scrollPane.getViewport().add(details);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setHorizontalScrollBarPolicy(30);
        details.setOpaque(true);
        details.setBackground(Color.white);
        details.setEnabled(false);
        details.setLayout(new BoxLayout(details, 3));
        StringBuilder fullList = new StringBuilder();
        for (Object nextFont : FontMappings.fontSubstitutionAliasTable.keySet()) {
            fullList.append(nextFont);
            fullList.append(" ==> ");
            fullList.append(FontMappings.fontSubstitutionAliasTable.get(nextFont));
            fullList.append('\n');
        }
        String xmlText = fullList.toString();
        if (!xmlText.isEmpty()) {
            JTextArea xml = new JTextArea();
            xml.setLineWrap(false);
            xml.setText(xmlText);
            details.add(xml);
            xml.setCaretPosition(0);
            xml.setOpaque(false);
            details.add(Box.createRigidArea(new Dimension(0, 5)));
        }
        return scrollPane;
    }

    private static JPanel getFontsFoundInfoBox() {
        JPanel fontDetails = new JPanel(new BorderLayout());
        fontDetails.setBackground(Color.WHITE);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBackground(Color.WHITE);
        fontScrollPane.setBackground(Color.WHITE);
        fontScrollPane.getViewport().setBackground(Color.WHITE);
        fontScrollPane.setPreferredSize(new Dimension(400, 300));
        fontScrollPane.getViewport().add(fontDetails);
        fontScrollPane.setVerticalScrollBarPolicy(20);
        fontScrollPane.setHorizontalScrollBarPolicy(30);
        JPanel filterTitlePane = new JPanel();
        filterTitlePane.setBackground(Color.WHITE);
        JLabel filterTitle = new JLabel("Filter Font List");
        filterTitlePane.add(filterTitle);
        ButtonGroup bg = new ButtonGroup();
        JRadioButton folder = new JRadioButton("Sort By Folder");
        folder.setBackground(Color.WHITE);
        JRadioButton name = new JRadioButton("Sort By Name");
        name.setBackground(Color.WHITE);
        final JTextField filter = new JTextField();
        if (sortFontsByDir) {
            folder.setSelected(true);
        } else {
            name.setSelected(true);
        }
        bg.add(folder);
        bg.add(name);
        JPanel buttons = new JPanel(new BorderLayout());
        buttons.setBackground(Color.WHITE);
        buttons.add((Component)filterTitlePane, "North");
        buttons.add((Component)folder, "West");
        buttons.add((Component)filter, "Center");
        buttons.add((Component)name, "East");
        folder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!sortFontsByDir) {
                    DefaultMutableTreeNode fontlist = new DefaultMutableTreeNode("Fonts");
                    sortFontsByDir = true;
                    fontlist = DocInfo.populateAvailableFonts(fontlist, filter.getText());
                    DocInfo.displayAvailableFonts(fontlist);
                }
            }
        });
        name.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (sortFontsByDir) {
                    DefaultMutableTreeNode fontlist = new DefaultMutableTreeNode("Fonts");
                    sortFontsByDir = false;
                    fontlist = DocInfo.populateAvailableFonts(fontlist, filter.getText());
                    DocInfo.displayAvailableFonts(fontlist);
                }
            }
        });
        filter.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                DefaultMutableTreeNode fontlist = new DefaultMutableTreeNode("Fonts");
                DocInfo.populateAvailableFonts(fontlist, ((JTextField)e.getSource()).getText());
                DocInfo.displayAvailableFonts(fontlist);
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        DefaultMutableTreeNode top = new DefaultMutableTreeNode("Fonts");
        top = DocInfo.populateAvailableFonts(top, null);
        JTree fontTree = new JTree(top);
        fontDetails.add((Component)fontTree, "West");
        panel.add((Component)buttons, "North");
        panel.add((Component)fontScrollPane, "Center");
        panel.setPreferredSize(new Dimension(400, 300));
        return panel;
    }

    private static JScrollPane getFormList(PdfDecoderInt decode_pdf) {
        Object[] formsOnPage;
        JScrollPane scroll = null;
        AcroRenderer formRenderer = decode_pdf.getFormRenderer();
        if (formRenderer != null && (formsOnPage = formRenderer.getFormComponents(null, ReturnValues.FORM_NAMES, decode_pdf.getPageNumber())) != null) {
            int formCount = formsOnPage.length;
            JPanel formPanel = new JPanel();
            scroll = new JScrollPane();
            scroll.setPreferredSize(new Dimension(400, 300));
            scroll.getViewport().add(formPanel);
            scroll.setVerticalScrollBarPolicy(20);
            scroll.setHorizontalScrollBarPolicy(30);
            formPanel.setLayout(new BoxLayout(formPanel, 1));
            JLabel formHeader = new JLabel("This page contains " + formCount + " form objects");
            formHeader.setFont(headFont);
            formPanel.add(formHeader);
            formPanel.add(Box.createRigidArea(new Dimension(10, 10)));
            for (Object aFormsOnPage : formsOnPage) {
                Object[] rawFormData;
                String formName = (String)aFormsOnPage;
                Object[] comp = formRenderer.getFormComponents(formName, ReturnValues.GUI_FORMS_FROM_NAME, -1);
                if (comp == null) continue;
                FormObject formObj = null;
                StringBuilder PDFrefs = new StringBuilder("PDF ref=");
                for (Object aRawFormData : rawFormData = formRenderer.getFormComponents(formName, ReturnValues.FORMOBJECTS_FROM_NAME, -1)) {
                    formObj = (FormObject)aRawFormData;
                    PDFrefs.append(' ').append(formObj.getObjectRefAsString());
                }
                JLabel ref = new JLabel(PDFrefs.toString());
                JLabel header = new JLabel(formName);
                JLabel type = new JLabel();
                type.setText("Type=" + PdfDictionary.showAsConstant(formObj.getParameterConstant(608780341)) + " Subtype=" + PdfDictionary.showAsConstant(formObj.getParameterConstant(1147962727)));
                String standardDetails = "java class=" + comp[0].getClass();
                JLabel details = new JLabel(standardDetails);
                header.setFont(headFont);
                header.setForeground(Color.blue);
                type.setFont(textFont);
                type.setForeground(Color.blue);
                details.setFont(textFont);
                details.setForeground(Color.blue);
                ref.setFont(textFont);
                ref.setForeground(Color.blue);
                formPanel.add(header);
                formPanel.add(type);
                formPanel.add(details);
                formPanel.add(ref);
            }
        }
        return scroll;
    }

    private static JScrollPane getXMLInfoBox(String xmlText) {
        JPanel details = new JPanel();
        details.setLayout(new BoxLayout(details, 3));
        details.setOpaque(true);
        details.setBackground(Color.white);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setPreferredSize(new Dimension(400, 300));
        scrollPane.getViewport().add(details);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setHorizontalScrollBarPolicy(30);
        JTextArea xml = new JTextArea();
        xml.setRows(5);
        xml.setColumns(15);
        xml.setLineWrap(true);
        xml.setText(xmlText);
        details.add(new JScrollPane(xml));
        xml.setCaretPosition(0);
        xml.setOpaque(true);
        xml.setBackground(Color.white);
        return scrollPane;
    }
}

