/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands;

import java.awt.Container;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import org.jpedal.DevFlags;
import org.jpedal.PdfDecoderInt;
import org.jpedal.display.GUIThumbnailPanel;
import org.jpedal.examples.viewer.SharedViewer;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.commands.SaveForm;
import org.jpedal.examples.viewer.gui.GUI;
import org.jpedal.examples.viewer.utils.Printer;
import org.jpedal.examples.viewer.utils.PropertiesFile;
import org.jpedal.gui.GUIFactory;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class Exit {
    public static void execute(Object[] args, GUIThumbnailPanel thumbnails, GUIFactory currentGUI, Values commonValues, PdfDecoderInt decode_pdf, PropertiesFile properties) {
        if (args == null) {
            if (Printer.isPrinting()) {
                currentGUI.showMessageDialog(Messages.getMessage("PdfViewerStillPrinting.text"));
            } else {
                Exit.exit(thumbnails, currentGUI, commonValues, decode_pdf, properties);
            }
        }
    }

    public static void exit(GUIThumbnailPanel thumbnails, GUIFactory currentGUI, Values commonValues, PdfDecoderInt decode_pdf, PropertiesFile properties) {
        thumbnails.terminateDrawing();
        SaveForm.handleUnsaveForms(currentGUI, commonValues, decode_pdf);
        if (LogWriter.isRunningFromIDE) {
            int choice = !DevFlags.GUITESTINGINPROGRESS && currentGUI.confirmClose() ? JOptionPane.showConfirmDialog(null, new JLabel(Messages.getMessage("PdfViewerExiting")), Messages.getMessage("PdfViewerprogramExit"), 2, -1) : 0;
            if (choice == 2) {
                return;
            }
            if (decode_pdf.getDisplayView() == 5) {
                decode_pdf.getPages().stopGeneratingPage();
            }
        }
        decode_pdf.closePdfFile();
        try {
            properties.setValue("lastDocumentPage", String.valueOf(commonValues.getCurrentPage()));
            if (properties.getValue("trackViewerSize").equalsIgnoreCase("true")) {
                properties.setValue("startViewerWidth", String.valueOf(((Container)currentGUI.getFrame()).getWidth()));
                properties.setValue("startViewerHeight", String.valueOf(((Container)currentGUI.getFrame()).getHeight()));
            }
            if (properties.getValue("trackScaling").equalsIgnoreCase("true")) {
                properties.setValue("startScaling", String.valueOf(((GUI)currentGUI).getSelectedComboItem(252)));
            }
            if (properties.getValue("trackView").equalsIgnoreCase("true")) {
                properties.setValue("startView", String.valueOf(decode_pdf.getDisplayView()));
            }
            if (properties.getValue("startSideTabOpen").equalsIgnoreCase("true")) {
                properties.setValue("startSideTabOpen", "true");
            }
            if (properties.getValue("trackSelectedSideTab").equalsIgnoreCase("true")) {
                JTabbedPane tabs = (JTabbedPane)currentGUI.getSideTabBar();
                if (DecoderOptions.isRunningOnMac) {
                    properties.setValue("startSelectedSideTab", tabs.getTitleAt(tabs.getSelectedIndex()));
                } else {
                    properties.setValue("startSelectedSideTab", tabs.getIconAt(tabs.getSelectedIndex()).toString());
                }
            }
            if (properties.getValue("trackSideTabExpandedSize").equalsIgnoreCase("true")) {
                properties.setValue("sideTabBarExpandLength", String.valueOf(currentGUI.getSplitDividerLocation()));
            }
            properties.writeDoc();
        }
        catch (Exception e1) {
            LogWriter.writeLog("Exception attempting to Write proterties: " + e1);
        }
        if (DevFlags.GUITESTINGINPROGRESS || !SharedViewer.exitOnClose) {
            ((Container)currentGUI.getFrame()).setVisible(false);
            if (currentGUI.getFrame() instanceof JFrame) {
                ((JFrame)currentGUI.getFrame()).dispose();
            }
            decode_pdf.dispose();
            currentGUI.dispose();
        } else {
            ((Container)currentGUI.getFrame()).setVisible(false);
            if (currentGUI.getFrame() instanceof JFrame) {
                ((JFrame)currentGUI.getFrame()).dispose();
            }
            decode_pdf.dispose();
            currentGUI.dispose();
            System.exit(0);
        }
    }
}

