/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.handlers.DefaultImageHelper;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.commands.generic.GUIExtractSelectionAsImage;
import org.jpedal.examples.viewer.utils.FileFilterer;
import org.jpedal.examples.viewer.utils.IconiseImage;
import org.jpedal.gui.GUIFactory;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class ExtractSelectionAsImage
extends GUIExtractSelectionAsImage {
    public static void execute(Values commonValues, final GUIFactory currentGUI, PdfDecoderInt decode_pdf) {
        int col;
        String propValue;
        ExtractSelectionAsImage.extractSelectedScreenAsImage(commonValues, currentGUI, decode_pdf);
        if (snapShot == null) {
            return;
        }
        Container frame = (Container)currentGUI.getFrame();
        final JDialog displayFrame = new JDialog((Frame)null, true);
        final JPanel image_display = new JPanel();
        displayFrame.setDefaultCloseOperation(2);
        if (commonValues.getModeOfOperation() != 1) {
            displayFrame.setLocationRelativeTo(null);
            displayFrame.setLocation(frame.getLocationOnScreen().x + 10, frame.getLocationOnScreen().y + 10);
        }
        if (!(propValue = currentGUI.getProperties().getValue("replacePdfDisplayBackground")).isEmpty() && propValue.equalsIgnoreCase("true")) {
            propValue = currentGUI.getProperties().getValue("pdfDisplayBackground");
            col = Integer.parseInt(propValue);
            image_display.setBackground(new Color(col));
        } else if (decode_pdf.getDecoderOptions().getDisplayBackgroundColor() != null) {
            col = decode_pdf.getDecoderOptions().getDisplayBackgroundColor().getRGB();
            image_display.setBackground(new Color(col));
        } else if (decode_pdf.useNewGraphicsMode()) {
            image_display.setBackground(new Color(55, 55, 65));
        } else {
            image_display.setBackground(new Color(190, 190, 190));
        }
        IconiseImage icon_image = new IconiseImage(snapShot);
        image_display.add((Component)new JLabel(icon_image), "Center");
        JPanel buttonBar = new JPanel();
        buttonBar.setBackground(image_display.getBackground());
        JButton copy = new JButton(Messages.getMessage("PdfSnapshotPreview.Copy"));
        copy.setFont(new Font("SansSerif", 0, 12));
        buttonBar.add((Component)copy, "East");
        copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                displayFrame.setVisible(false);
                GUIExtractSelectionAsImage.ClipboardImage clipboardImage = new GUIExtractSelectionAsImage.ClipboardImage(snapShot);
                Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
                c.setContents(clipboardImage, null);
            }
        });
        JButton yes = new JButton(Messages.getMessage("PdfSnapshotPreview.Save"));
        yes.setFont(new Font("SansSerif", 0, 12));
        buttonBar.add((Component)yes, "West");
        yes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                displayFrame.setVisible(false);
                boolean finished = false;
                while (!finished) {
                    JFileChooser chooser = new JFileChooser(System.getProperty("user.dir"));
                    FileFilterer defaultOpt = new FileFilterer(new String[]{"png", "png"}, "PNG");
                    chooser.setFileFilter(defaultOpt);
                    chooser.addChoosableFileFilter(new FileFilterer(new String[]{"tif", "tiff"}, "TIFF"));
                    chooser.addChoosableFileFilter(new FileFilterer(new String[]{"jpg", "jpeg"}, "JPEG"));
                    int approved = chooser.showSaveDialog(image_display);
                    if (approved == 0) {
                        int n;
                        File file = chooser.getSelectedFile();
                        StringBuffer fileToSave = new StringBuffer(file.getAbsolutePath());
                        String format = chooser.getFileFilter().getDescription();
                        if (format.equals("All Files")) {
                            format = "TIFF";
                        }
                        if (!fileToSave.toString().toLowerCase().endsWith(('.' + format).toLowerCase())) {
                            fileToSave.append('.').append(format);
                            file = new File(fileToSave.toString());
                        }
                        if (file.exists() && (n = currentGUI.showConfirmDialog(fileToSave.append('\n') + Messages.getMessage("PdfViewerMessage.FileAlreadyExists") + ".\n" + Messages.getMessage("PdfViewerMessage.ConfirmResave"), Messages.getMessage("PdfViewerMessage.Resave"), 0)) == 1) continue;
                        if (snapShot != null) {
                            try {
                                DefaultImageHelper.write(snapShot, format, fileToSave.toString());
                            }
                            catch (IOException ex) {
                                LogWriter.writeLog("Exception in writing image " + ex);
                            }
                        }
                        finished = true;
                        continue;
                    }
                    return;
                }
                displayFrame.dispose();
            }
        });
        JButton no = new JButton(Messages.getMessage("PdfSnapshotPreview.Cancel"));
        no.setFont(new Font("SansSerif", 0, 12));
        buttonBar.add((Component)no, "East");
        no.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                displayFrame.dispose();
            }
        });
        displayFrame.setTitle(Messages.getMessage("PdfViewerMessage.SaveImage"));
        displayFrame.getContentPane().add((Component)image_display, "Center");
        displayFrame.getContentPane().add((Component)buttonBar, "South");
        displayFrame.setResizable(false);
        displayFrame.pack();
        displayFrame.setVisible(true);
    }
}

