/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.commands.generic.GUICopy;
import org.jpedal.examples.viewer.commands.generic.GUIExtractText;
import org.jpedal.exception.PdfException;
import org.jpedal.gui.GUIFactory;
import org.jpedal.objects.PdfPageData;
import org.jpedal.utils.Messages;

public class ExtractText
extends GUIExtractText {
    public static void execute(Object[] args, GUIFactory currentGUI, PdfDecoderInt decode_pdf, Values commonValues) {
        if (args == null) {
            ExtractText.extractSelectedText(currentGUI, decode_pdf, commonValues);
        }
    }

    private static void extractSelectedText(final GUIFactory currentGUI, final PdfDecoderInt decode_pdf, final Values commonValues) {
        if (!decode_pdf.isExtractionAllowed()) {
            currentGUI.showMessageDialog("Not allowed");
            return;
        }
        final int[][] highlights = decode_pdf.getTextLines().getHighlightedAreasAs2DArray(commonValues.getCurrentPage());
        if (highlights == null) {
            currentGUI.showMessageDialog((Object)"There is no text selected.\nPlease highlight the text you wish to extract.", "No Text selected", 0);
            return;
        }
        JScrollPane examplePane = new JScrollPane();
        final JPanel display_value = new JPanel();
        final ButtonGroup group = new ButtonGroup();
        final JRadioButton text = new JRadioButton("Extract as Text");
        final JRadioButton xml = new JRadioButton("Extract  as  XML");
        final JRadioButton rectangleGrouping = new JRadioButton(Messages.getMessage("PdfViewerRect.label"));
        final JRadioButton tableGrouping = new JRadioButton(Messages.getMessage("PdfViewerTable.label"));
        final JRadioButton wordListExtraction = new JRadioButton(Messages.getMessage("PdfViewerWordList.label"));
        final SpringLayout layout = new SpringLayout();
        final JFrame extractionFrame = new JFrame(Messages.getMessage("PdfViewerCoords.message") + ' ' + commonValues.m_x1 + " , " + commonValues.m_y1 + " , " + (commonValues.m_x2 - commonValues.m_x1) + " , " + (commonValues.m_y2 - commonValues.m_y1));
        extractionFrame.setDefaultCloseOperation(2);
        JLabel demoMessage = new JLabel("                         ");
        ButtonGroup type = new ButtonGroup();
        Object[] options = new Object[]{Messages.getMessage("PdfViewerHelpMenu.text"), Messages.getMessage("PdfViewerCancel.text"), Messages.getMessage("PdfViewerextract.text")};
        JButton help = new JButton((String)options[0]);
        JButton cancel = new JButton((String)options[1]);
        JButton extract = new JButton((String)options[2]);
        display_value.setLayout(layout);
        final Runnable r = new Runnable(){

            @Override
            public void run() {
                Enumeration<AbstractButton> en = group.getElements();
                while (en.hasMoreElements()) {
                    AbstractButton button = en.nextElement();
                    if (!button.isSelected()) continue;
                    Component[] com = display_value.getComponents();
                    for (int i = 0; i != com.length; ++i) {
                        if (!(com[i] instanceof JScrollPane)) continue;
                        display_value.remove(com[i]);
                    }
                    try {
                        JScrollPane scroll = ExtractText.updateExtractionExample(decode_pdf, commonValues, currentGUI, button, xml.isSelected());
                        if (scroll != null) {
                            layout.putConstraint("East", (Component)scroll, -5, "East", (Component)display_value);
                            layout.putConstraint("North", (Component)scroll, 5, "South", (Component)tableGrouping);
                            display_value.add(scroll);
                            break;
                        }
                        JLabel noExample = new JLabel("No Example Available");
                        Font exampleFont = noExample.getFont();
                        exampleFont = exampleFont.deriveFont(exampleFont.getStyle(), 20.0f);
                        noExample.setFont(exampleFont);
                        noExample.setForeground(Color.RED);
                        layout.putConstraint("East", (Component)noExample, -75, "East", (Component)display_value);
                        layout.putConstraint("North", (Component)noExample, 50, "South", (Component)tableGrouping);
                        display_value.add(noExample);
                    }
                    catch (PdfException ex) {
                        Logger.getLogger(ExtractText.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    break;
                }
                display_value.updateUI();
            }
        };
        demoMessage.setFont(new Font("SansSerif", 1, 10));
        demoMessage.setForeground(Color.red);
        layout.putConstraint("West", (Component)demoMessage, 5, "West", (Component)display_value);
        layout.putConstraint("South", (Component)demoMessage, -5, "South", (Component)display_value);
        display_value.add(demoMessage);
        rectangleGrouping.setSelected(true);
        rectangleGrouping.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                xml.setText("Extract  as  XML");
                text.setText("Extract as Text");
                SwingUtilities.invokeLater(r);
            }
        });
        group.add(rectangleGrouping);
        rectangleGrouping.setToolTipText(Messages.getMessage("PdfViewerRect.message"));
        layout.putConstraint("West", (Component)rectangleGrouping, 10, "West", (Component)display_value);
        layout.putConstraint("North", (Component)rectangleGrouping, 5, "North", (Component)display_value);
        display_value.add(rectangleGrouping);
        tableGrouping.setSelected(true);
        tableGrouping.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                xml.setText("Extract as XHTML");
                text.setText("Extract as CSV");
                SwingUtilities.invokeLater(r);
            }
        });
        group.add(tableGrouping);
        tableGrouping.setToolTipText(Messages.getMessage("PdfViewerTable.message"));
        layout.putConstraint("West", (Component)tableGrouping, 50, "East", (Component)rectangleGrouping);
        layout.putConstraint("North", (Component)tableGrouping, 5, "North", (Component)display_value);
        display_value.add(tableGrouping);
        wordListExtraction.setSelected(true);
        wordListExtraction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                xml.setText("Extract  as  XML");
                text.setText("Extract as Text");
                SwingUtilities.invokeLater(r);
            }
        });
        group.add(wordListExtraction);
        wordListExtraction.setToolTipText(Messages.getMessage("PdfViewerWordList.message"));
        layout.putConstraint("East", (Component)wordListExtraction, -5, "East", (Component)display_value);
        layout.putConstraint("North", (Component)wordListExtraction, 5, "North", (Component)display_value);
        display_value.add(wordListExtraction);
        examplePane.setPreferredSize(new Dimension(315, 150));
        examplePane.setMinimumSize(new Dimension(315, 150));
        layout.putConstraint("East", (Component)examplePane, -5, "East", (Component)display_value);
        layout.putConstraint("North", (Component)examplePane, 5, "South", (Component)tableGrouping);
        display_value.add(examplePane);
        type.add(xml);
        type.add(text);
        xml.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(r);
            }
        });
        text.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(r);
            }
        });
        text.setSelected(true);
        layout.putConstraint("West", (Component)xml, 5, "West", (Component)display_value);
        layout.putConstraint("South", (Component)xml, -5, "North", (Component)extract);
        display_value.add(xml);
        layout.putConstraint("East", (Component)text, -5, "East", (Component)display_value);
        layout.putConstraint("South", (Component)text, -5, "North", (Component)extract);
        display_value.add(text);
        layout.putConstraint("South", (Component)extract, -5, "North", (Component)demoMessage);
        layout.putConstraint("East", (Component)extract, -5, "East", (Component)display_value);
        display_value.add(extract);
        layout.putConstraint("South", (Component)cancel, -5, "North", (Component)demoMessage);
        layout.putConstraint("East", (Component)cancel, -5, "West", (Component)extract);
        display_value.add(cancel);
        layout.putConstraint("South", (Component)help, -5, "North", (Component)demoMessage);
        layout.putConstraint("East", (Component)help, -5, "West", (Component)cancel);
        display_value.add(help);
        help.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTextArea info = new JTextArea(Messages.getMessage("PdfViewerGroupingInfo.message"));
                currentGUI.showMessageDialog(info);
            }
        });
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                extractionFrame.setVisible(false);
                extractionFrame.dispose();
            }
        });
        extract.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                block22: {
                    try {
                        String finalValue = "";
                        boolean isXML = true;
                        PdfPageData page_data = decode_pdf.getPdfPageData();
                        int cropX = page_data.getCropBoxX(commonValues.getCurrentPage());
                        int cropY = page_data.getCropBoxY(commonValues.getCurrentPage());
                        int cropW = page_data.getCropBoxWidth(commonValues.getCurrentPage());
                        int cropH = page_data.getCropBoxHeight(commonValues.getCurrentPage());
                        if (highlights != null) {
                            for (int t = 0; t != highlights.length; ++t) {
                                int temp;
                                String extractedText = "";
                                highlights[t] = GUICopy.adjustHighlightForExtraction(highlights[t]);
                                int t_x1 = highlights[t][0];
                                int t_x2 = highlights[t][0] + highlights[t][2];
                                int t_y1 = highlights[t][1] + highlights[t][3];
                                int t_y2 = highlights[t][1];
                                if (t_y1 < t_y2) {
                                    temp = t_y2;
                                    t_y2 = t_y1;
                                    t_y1 = temp;
                                }
                                if (t_x1 > t_x2) {
                                    temp = t_x2;
                                    t_x2 = t_x1;
                                    t_x1 = temp;
                                }
                                if (t_x1 < cropX) {
                                    t_x1 = cropX;
                                }
                                if (t_x1 > cropW - cropX) {
                                    t_x1 = cropW - cropX;
                                }
                                if (t_x2 < cropX) {
                                    t_x2 = cropX;
                                }
                                if (t_x2 > cropW - cropX) {
                                    t_x2 = cropW - cropX;
                                }
                                if (t_y1 < cropY) {
                                    t_y1 = cropY;
                                }
                                if (t_y1 > cropH - cropY) {
                                    t_y1 = cropH - cropY;
                                }
                                if (t_y2 < cropY) {
                                    t_y2 = cropY;
                                }
                                if (t_y2 > cropH - cropY) {
                                    t_y2 = cropH - cropY;
                                }
                                if (rectangleGrouping.isSelected()) {
                                    extractedText = ExtractText.extractTextRectangle(commonValues, decode_pdf, currentGUI, xml.isSelected(), t_x1, t_x2, t_y1, t_y2) + '\r' + '\n';
                                } else if (tableGrouping.isSelected()) {
                                    extractedText = ExtractText.extractTextTable(commonValues, decode_pdf, xml.isSelected(), t_x1, t_x2, t_y1, t_y2);
                                } else if (wordListExtraction.isSelected()) {
                                    extractedText = ExtractText.extractTextList(decode_pdf, commonValues, currentGUI, xml.isSelected(), t_x1, t_x2, t_y1, t_y2);
                                }
                                finalValue = finalValue + extractedText;
                            }
                        }
                        if (finalValue == null) break block22;
                        JScrollPane scroll = new JScrollPane();
                        try {
                            JTextPane text_pane = new JTextPane();
                            scroll = ExtractText.createPane(text_pane, finalValue, true);
                        }
                        catch (BadLocationException e1) {
                            e1.printStackTrace();
                        }
                        scroll.setHorizontalScrollBarPolicy(31);
                        scroll.setVerticalScrollBarPolicy(20);
                        scroll.setPreferredSize(new Dimension(400, 400));
                        final JDialog displayFrame = new JDialog((Frame)null, true);
                        displayFrame.setDefaultCloseOperation(2);
                        if (commonValues.getModeOfOperation() != 1) {
                            Container frame = (Container)currentGUI.getFrame();
                            displayFrame.setLocation(frame.getLocationOnScreen().x + 10, frame.getLocationOnScreen().y + 10);
                        }
                        displayFrame.setSize(450, 450);
                        displayFrame.setTitle(Messages.getMessage("PdfViewerExtractedText.menu"));
                        displayFrame.getContentPane().setLayout(new BorderLayout());
                        displayFrame.getContentPane().add((Component)scroll, "Center");
                        JPanel buttonBar = new JPanel();
                        buttonBar.setLayout(new BorderLayout());
                        displayFrame.getContentPane().add((Component)buttonBar, "South");
                        JButton yes = new JButton(Messages.getMessage("PdfViewerMenu.return"));
                        yes.setFont(new Font("SansSerif", 0, 12));
                        buttonBar.add((Component)yes, "West");
                        yes.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                displayFrame.dispose();
                            }
                        });
                        JButton no = new JButton(Messages.getMessage("PdfViewerFileMenuExit.text"));
                        no.setFont(new Font("SansSerif", 0, 12));
                        buttonBar.add((Component)no, "East");
                        no.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                displayFrame.dispose();
                            }
                        });
                        displayFrame.setVisible(true);
                    }
                    catch (PdfException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        extractionFrame.getContentPane().add((Component)display_value, "Center");
        extractionFrame.setSize(350, 300);
        SwingUtilities.invokeLater(r);
        extractionFrame.setLocationRelativeTo((Container)currentGUI.getFrame());
        extractionFrame.setResizable(false);
        extractionFrame.setVisible(true);
    }

    private static JScrollPane createPane(JTextPane text_pane, String content, boolean useXML) throws BadLocationException {
        text_pane.setEditable(true);
        text_pane.setFont(new Font("Lucida", 0, 14));
        text_pane.setToolTipText(Messages.getMessage("PdfViewerTooltip.text"));
        Document doc = text_pane.getDocument();
        text_pane.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(), Messages.getMessage("PdfViewerTitle.text")));
        text_pane.setForeground(Color.black);
        SimpleAttributeSet token_attribute = new SimpleAttributeSet();
        SimpleAttributeSet text_attribute = new SimpleAttributeSet();
        SimpleAttributeSet plain_attribute = new SimpleAttributeSet();
        StyleConstants.setForeground(token_attribute, Color.blue);
        StyleConstants.setForeground(text_attribute, Color.black);
        StyleConstants.setForeground(plain_attribute, Color.black);
        int pointer = 0;
        if (useXML && content != null) {
            StringTokenizer data_As_tokens = new StringTokenizer(content, "<>", true);
            while (data_As_tokens.hasMoreTokens()) {
                String next_item = data_As_tokens.nextToken();
                if (next_item.equals("<") && data_As_tokens.hasMoreTokens()) {
                    String current_token = next_item + data_As_tokens.nextToken() + data_As_tokens.nextToken();
                    doc.insertString(pointer, current_token, token_attribute);
                    pointer += current_token.length();
                    continue;
                }
                doc.insertString(pointer, next_item, text_attribute);
                pointer += next_item.length();
            }
        } else {
            doc.insertString(pointer, content, plain_attribute);
        }
        JScrollPane text_scroll = new JScrollPane();
        text_scroll.getViewport().add(text_pane);
        text_scroll.setHorizontalScrollBarPolicy(31);
        text_scroll.setVerticalScrollBarPolicy(20);
        return text_scroll;
    }

    private static JScrollPane updateExtractionExample(PdfDecoderInt decode_pdf, Values commonValues, GUIFactory currentGUI, AbstractButton button, boolean xml) throws PdfException {
        JScrollPane scroll = new JScrollPane();
        String finalString = "";
        PdfPageData page_data = decode_pdf.getPdfPageData();
        int cropX = page_data.getCropBoxX(commonValues.getCurrentPage());
        int cropY = page_data.getCropBoxY(commonValues.getCurrentPage());
        int cropW = page_data.getCropBoxWidth(commonValues.getCurrentPage());
        int cropH = page_data.getCropBoxHeight(commonValues.getCurrentPage());
        int[][] highlights = decode_pdf.getTextLines().getHighlightedAreasAs2DArray(commonValues.getCurrentPage());
        if (highlights != null) {
            for (int t = 0; t != highlights.length; ++t) {
                int temp;
                if (highlights[t] == null) continue;
                highlights[t] = GUICopy.adjustHighlightForExtraction(highlights[t]);
                int t_x1 = highlights[t][0];
                int t_x2 = highlights[t][0] + highlights[t][2];
                int t_y1 = highlights[t][1] + highlights[t][3];
                int t_y2 = highlights[t][1];
                if (t_y1 < t_y2) {
                    temp = t_y2;
                    t_y2 = t_y1;
                    t_y1 = temp;
                }
                if (t_x1 > t_x2) {
                    temp = t_x2;
                    t_x2 = t_x1;
                    t_x1 = temp;
                }
                if (t_x1 < cropX) {
                    t_x1 = cropX;
                }
                if (t_x1 > cropX + cropW) {
                    t_x1 = cropX + cropW;
                }
                if (t_x2 < cropX) {
                    t_x2 = cropX;
                }
                if (t_x2 > cropX + cropW) {
                    t_x2 = cropX + cropW;
                }
                if (t_y1 < cropY) {
                    t_y1 = cropY;
                }
                if (t_y1 > cropY + cropH) {
                    t_y1 = cropY + cropH;
                }
                if (t_y2 < cropY) {
                    t_y2 = cropY;
                }
                if (t_y2 > cropY + cropH) {
                    t_y2 = cropY + cropH;
                }
                if (button.getText().equals("Table")) {
                    finalString = finalString + ExtractText.extractTextTable(commonValues, decode_pdf, xml, t_x1, t_x2, t_y1, t_y2);
                }
                if (button.getText().equals("Rectangle")) {
                    finalString = finalString + ExtractText.extractTextRectangle(commonValues, decode_pdf, currentGUI, xml, t_x1, t_x2, t_y1, t_y2) + ' ';
                }
                if (!button.getText().equals("WordList")) continue;
                finalString = finalString + ExtractText.extractTextList(decode_pdf, commonValues, currentGUI, xml, t_x1, t_x2, t_y1, t_y2);
            }
        }
        if (!finalString.isEmpty()) {
            try {
                scroll = ExtractText.createPane(new JTextPane(), finalString, xml);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            scroll.setPreferredSize(new Dimension(315, 150));
            scroll.setMinimumSize(new Dimension(315, 150));
            Component[] coms = scroll.getComponents();
            for (int i = 0; i != coms.length; ++i) {
                if (!(scroll.getComponent(i) instanceof JViewport)) continue;
                JViewport view = (JViewport)scroll.getComponent(i);
                Component[] coms1 = view.getComponents();
                for (int j = 0; j != coms1.length; ++j) {
                    if (!(coms1[j] instanceof JTextPane)) continue;
                    ((JTextPane)coms1[j]).setEditable(false);
                }
            }
            return scroll;
        }
        return null;
    }
}

