/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands;

import java.awt.Container;
import java.awt.Dimension;
import javafx.application.Platform;
import javafx.stage.Stage;
import javax.swing.SwingUtilities;
import org.jpedal.PdfDecoderInt;
import org.jpedal.display.Display;
import org.jpedal.examples.viewer.SharedViewer;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.gui.GUI;
import org.jpedal.examples.viewer.gui.generic.GUISearchWindow;
import org.jpedal.examples.viewer.utils.PropertiesFile;
import org.jpedal.gui.GUIFactory;

class ModeChange {
    ModeChange() {
    }

    static void changeModeInSwing(final int mode, final PdfDecoderInt decode_pdf, final GUIFactory currentGUI, final Values commonValues, PropertiesFile properties, GUISearchWindow searchFrame) {
        if (SwingUtilities.isEventDispatchThread()) {
            currentGUI.setDisplayView(mode, 2);
            ModeChange.chooseMode(decode_pdf, commonValues, currentGUI);
            currentGUI.getButtons().hideRedundentNavButtons(currentGUI);
            if (decode_pdf.getDisplayView() == 5) {
                ModeChange.selectCurrentGui(currentGUI);
            } else {
                ((GUI)currentGUI).setSelectedComboIndex(251, 0);
                ((Container)currentGUI.getFrame()).setMinimumSize(new Dimension(0, 0));
            }
        } else {
            currentGUI.setCommandInThread(true);
            Runnable doPaintComponent = new Runnable(){

                @Override
                public void run() {
                    currentGUI.setDisplayView(mode, 2);
                    ModeChange.chooseMode(decode_pdf, commonValues, currentGUI);
                    currentGUI.getButtons().hideRedundentNavButtons(currentGUI);
                    if (decode_pdf.getDisplayView() == 5) {
                        ModeChange.selectCurrentGui(currentGUI);
                    } else {
                        ((GUI)currentGUI).setSelectedComboIndex(251, 0);
                        ((Container)currentGUI.getFrame()).setMinimumSize(new Dimension(0, 0));
                    }
                    currentGUI.setExecutingCommand(false);
                }
            };
            SwingUtilities.invokeLater(doPaintComponent);
        }
    }

    static void changeModeInJavaFX(final int mode, final PdfDecoderInt decode_pdf, final GUIFactory currentGUI, Values commonValues, PropertiesFile properties, GUISearchWindow searchFrame) {
        if (Platform.isFxApplicationThread()) {
            currentGUI.setDisplayView(mode, 2);
            currentGUI.getButtons().hideRedundentNavButtons(currentGUI);
            ((GUI)currentGUI).setSelectedComboIndex(251, 0);
            Stage stage = (Stage)currentGUI.getFrame();
            if (stage != null) {
                ((Stage)currentGUI.getFrame()).setMinWidth(0.0);
                ((Stage)currentGUI.getFrame()).setMinHeight(0.0);
            }
        } else {
            currentGUI.setCommandInThread(true);
            Runnable doPaintComponent = new Runnable(){

                @Override
                public void run() {
                    currentGUI.setDisplayView(mode, 2);
                    currentGUI.getButtons().hideRedundentNavButtons(currentGUI);
                    if (decode_pdf.getDisplayView() == 5) {
                        ModeChange.selectCurrentGui(currentGUI);
                    } else {
                        ((GUI)currentGUI).setSelectedComboIndex(251, 0);
                        ((Stage)currentGUI.getFrame()).setMinWidth(0.0);
                        ((Stage)currentGUI.getFrame()).setMinHeight(0.0);
                    }
                }
            };
            Platform.runLater((Runnable)doPaintComponent);
        }
    }

    static void chooseMode(PdfDecoderInt decode_pdf, Values commonValues, GUIFactory currentGUI) {
        if (decode_pdf.getDisplayView() == 4) {
            int p = commonValues.getCurrentPage();
            if (decode_pdf.getPages().getBoolean(Display.BoolValue.SEPARATE_COVER) && (p & 1) == 1 && p != 1) {
                --p;
            } else if (!decode_pdf.getPages().getBoolean(Display.BoolValue.SEPARATE_COVER) && (p & 1) == 0) {
                --p;
            }
            commonValues.setCurrentPage(p);
            currentGUI.setPage(p);
            currentGUI.decodePage();
        } else if (decode_pdf.getDisplayView() == 3) {
            int p = commonValues.getCurrentPage();
            if ((p & 1) == 1 && p != 1) {
                --p;
            }
            commonValues.setCurrentPage(p);
            currentGUI.setPage(p);
        }
    }

    static void selectCurrentGui(GUIFactory currentGUI) {
        currentGUI.decodePage();
        if (((GUI)currentGUI).getSelectedComboIndex(252) != 0) {
            ((GUI)currentGUI).setSelectedComboIndex(252, 0);
            ((GUI)currentGUI).getSelectedComboItem(252);
        }
        if (((GUI)currentGUI).getSelectedComboIndex(252) == 0) {
            int w = currentGUI.getPdfDecoder().getPdfPageData().getCropBoxWidth(currentGUI.getValues().getCurrentPage()) / 2;
            int h = currentGUI.getPdfDecoder().getPdfPageData().getCropBoxHeight(currentGUI.getValues().getCurrentPage()) / 2;
            if (w > 800) {
                w = 800;
            }
            if (h > 600) {
                h = 600;
            }
            if (SharedViewer.isFX()) {
                ((Stage)currentGUI.getFrame()).setMinWidth((double)w);
                ((Stage)currentGUI.getFrame()).setMinHeight((double)h);
            } else {
                ((Container)currentGUI.getFrame()).setMinimumSize(new Dimension(w, h));
            }
        }
    }
}

