/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands;

import java.awt.Color;
import java.awt.Container;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import org.jpedal.JDeliHelper;
import org.jpedal.PdfDecoderInt;
import org.jpedal.display.GUIThumbnailPanel;
import org.jpedal.examples.viewer.Commands;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.commands.Exit;
import org.jpedal.examples.viewer.commands.Images;
import org.jpedal.examples.viewer.commands.PageNavigator;
import org.jpedal.examples.viewer.commands.SaveForm;
import org.jpedal.examples.viewer.gui.GUI;
import org.jpedal.examples.viewer.gui.generic.GUISearchWindow;
import org.jpedal.examples.viewer.gui.popups.DownloadProgress;
import org.jpedal.examples.viewer.gui.popups.ErrorDialog;
import org.jpedal.examples.viewer.utils.FileFilterer;
import org.jpedal.examples.viewer.utils.Printer;
import org.jpedal.examples.viewer.utils.PropertiesFile;
import org.jpedal.exception.PdfException;
import org.jpedal.gui.GUIFactory;
import org.jpedal.io.TiffHelper;
import org.jpedal.linear.LinearThread;
import org.jpedal.objects.PdfFileInformation;
import org.jpedal.objects.raw.OutlineObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class OpenFile {
    public static boolean isPDf;
    private static InputStream inputStream;

    public static void executeOpenURL(Object[] args, Values commonValues, GUISearchWindow searchFrame, GUIFactory currentGUI, PdfDecoderInt decode_pdf, PropertiesFile properties, GUIThumbnailPanel thumbnails) {
        inputStream = null;
        if (args == null) {
            SaveForm.handleUnsaveForms(currentGUI, commonValues, decode_pdf);
            String newFile = OpenFile.selectURL(commonValues, searchFrame, currentGUI, decode_pdf, properties, thumbnails);
            if (newFile != null) {
                commonValues.setSelectedFile(newFile);
                commonValues.setFileIsURL(true);
            }
        } else {
            currentGUI.resetNavBar();
            String newFile = (String)args[0];
            if (newFile != null) {
                commonValues.setSelectedFile(newFile);
                commonValues.setFileIsURL(true);
                boolean failed = false;
                try {
                    URL testExists = new URL(newFile);
                    URLConnection conn = testExists.openConnection();
                    if (conn.getContent() == null) {
                        failed = true;
                    }
                }
                catch (Exception e) {
                    failed = true;
                    LogWriter.writeLog("Unable to open as URL " + newFile + ' ' + e);
                }
                if (failed) {
                    newFile = null;
                }
                if (newFile != null) {
                    commonValues.setFileSize(0L);
                    currentGUI.setViewerTitle(null);
                    if (!Values.isProcessing()) {
                        thumbnails.terminateDrawing();
                        decode_pdf.flushObjectValues(true);
                        decode_pdf.resetViewableArea();
                        currentGUI.stopThumbnails();
                        if (!currentGUI.isSingle()) {
                            currentGUI.openNewMultiplePage(commonValues.getSelectedFile(), commonValues);
                        }
                        try {
                            OpenFile.openFile(commonValues.getSelectedFile(), commonValues, searchFrame, currentGUI, decode_pdf, properties, thumbnails);
                            while (Values.isProcessing()) {
                                Thread.sleep(1000L);
                            }
                        }
                        catch (InterruptedException e) {
                            LogWriter.writeLog("Exception attempting to open file: " + e);
                        }
                    }
                } else {
                    decode_pdf.repaint();
                }
            }
        }
    }

    public static void executeOpenFile(Object[] args, Values commonValues, GUISearchWindow searchFrame, GUIFactory currentGUI, PdfDecoderInt decode_pdf, PropertiesFile properties, GUIThumbnailPanel thumbnails) {
        inputStream = null;
        if (args == null) {
            SaveForm.handleUnsaveForms(currentGUI, commonValues, decode_pdf);
            if (Printer.isPrinting()) {
                currentGUI.showMessageDialog(Messages.getMessage("PdfViewerPrintWait.message"));
            } else if (Values.isProcessing()) {
                currentGUI.showMessageDialog(Messages.getMessage("PdfViewerDecodeWait.message"));
            } else {
                OpenFile.selectFile(commonValues, searchFrame, currentGUI, decode_pdf, properties, thumbnails);
                commonValues.setFileIsURL(false);
            }
        } else if (args.length == 2 && args[0] instanceof byte[] && args[1] instanceof String) {
            byte[] data = (byte[])args[0];
            String filename = (String)args[1];
            commonValues.setFileSize(data.length);
            commonValues.setSelectedFile(filename);
            currentGUI.setViewerTitle(null);
            if (commonValues.getSelectedFile() != null && !Values.isProcessing()) {
                decode_pdf.resetViewableArea();
                try {
                    String memFlag;
                    isPDf = true;
                    commonValues.setMultiTiff(false);
                    String hiresFlag = System.getProperty("org.jpedal.hires");
                    if (DecoderOptions.hires || hiresFlag != null) {
                        commonValues.setUseHiresImage(true);
                    }
                    if ((memFlag = System.getProperty("org.jpedal.memory")) != null) {
                        commonValues.setUseHiresImage(false);
                    }
                    thumbnails.resetToDefault();
                    currentGUI.reinitThumbnails();
                    currentGUI.setNoPagesDecoded();
                    if (searchFrame != null) {
                        searchFrame.removeSearchWindow(false);
                        searchFrame.resetSearchWindow();
                    }
                    commonValues.maxViewY = 0;
                    currentGUI.setQualityBoxVisible(isPDf);
                    commonValues.setCurrentPage(1);
                    if (currentGUI.isSingle()) {
                        decode_pdf.closePdfFile();
                    }
                    decode_pdf.openPdfArray(data);
                    currentGUI.updateStatusMessage("opening file");
                    boolean fileCanBeOpened = true;
                    if (decode_pdf.isEncrypted() && !decode_pdf.isFileViewable()) {
                        fileCanBeOpened = false;
                        String password = System.getProperty("org.jpedal.password");
                        if (password == null) {
                            password = currentGUI.showInputDialog(Messages.getMessage("PdfViewerPassword.message"));
                        }
                        if (password != null) {
                            decode_pdf.setEncryptionPassword(password);
                            if (decode_pdf.isFileViewable()) {
                                fileCanBeOpened = true;
                            }
                        }
                        if (!fileCanBeOpened) {
                            currentGUI.showMessageDialog(Messages.getMessage("PdfViewerPasswordRequired.message"));
                        }
                    }
                    if (fileCanBeOpened) {
                        if (properties.getValue("Recentdocuments").equals("true")) {
                            properties.addRecentDocument(commonValues.getSelectedFile());
                            currentGUI.getRecentDocument().updateRecentDocuments(properties.getRecentDocuments());
                        }
                        currentGUI.getRecentDocument().addToFileList(commonValues.getSelectedFile());
                        commonValues.setCurrentPage(1);
                    }
                    OpenFile.processPage(commonValues, decode_pdf, currentGUI, thumbnails);
                }
                catch (PdfException e) {
                    LogWriter.writeLog("Exception attempting to open file: " + e);
                }
            }
        } else if (args.length >= 1) {
            if (args[0] instanceof InputStream) {
                inputStream = (InputStream)args[0];
                String newFile = "InputStream-" + System.currentTimeMillis() + ".pdf";
                commonValues.setSelectedFile(newFile);
                commonValues.setFileIsURL(true);
                if (inputStream != null) {
                    try {
                        commonValues.setFileSize(0L);
                        currentGUI.setViewerTitle(null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (!Values.isProcessing()) {
                        thumbnails.terminateDrawing();
                        decode_pdf.flushObjectValues(true);
                        decode_pdf.resetViewableArea();
                        currentGUI.stopThumbnails();
                        try {
                            OpenFile.openFile(commonValues.getSelectedFile(), commonValues, searchFrame, currentGUI, decode_pdf, properties, thumbnails);
                            while (Values.isProcessing()) {
                                Thread.sleep(1000L);
                            }
                        }
                        catch (InterruptedException e) {
                            LogWriter.writeLog("Exception attempting to open file: " + e);
                        }
                    }
                } else {
                    decode_pdf.repaint();
                }
            } else {
                File file;
                if (args[0] instanceof File) {
                    file = (File)args[0];
                } else if (args[0] instanceof String) {
                    String filename = (String)args[0];
                    char[] str = filename.toCharArray();
                    if (str[1] == ':' || str[0] == '\\' || str[0] == '/') {
                        file = new File(filename);
                    } else {
                        String parent = new File(commonValues.getSelectedFile()).getParent();
                        file = new File(parent, filename);
                        try {
                            file = file.getCanonicalFile();
                        }
                        catch (IOException e) {
                            file = new File(parent, filename);
                            LogWriter.writeLog("Exception in IO " + e);
                        }
                    }
                } else {
                    file = null;
                }
                if (file != null) {
                    try {
                        commonValues.setInputDir(file.getParentFile().getCanonicalPath());
                        OpenFile.open(file.getAbsolutePath(), commonValues, searchFrame, currentGUI, decode_pdf, properties, thumbnails);
                        String bookmarkPage = null;
                        if (args.length > 1 && args[1] instanceof String) {
                            String bookmark = (String)args[1];
                            bookmarkPage = decode_pdf.getIO().convertNameToRef(bookmark);
                        }
                        if (bookmarkPage != null) {
                            OutlineObject namedDest = new OutlineObject(bookmarkPage);
                            decode_pdf.getIO().readObject(namedDest);
                            decode_pdf.getFormRenderer().getActionHandler().gotoDest(namedDest, 3, 339034948);
                        }
                        while (Values.isProcessing()) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException e) {
                                LogWriter.writeLog("Exception attempting to open file: " + e);
                            }
                        }
                    }
                    catch (IOException e1) {
                        LogWriter.writeLog("Exception attempting to open file: " + e1);
                    }
                } else {
                    decode_pdf.repaint();
                    currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.NoSelection"));
                }
            }
        }
    }

    public static void open(String file, Values commonValues, GUISearchWindow searchFrame, GUIFactory currentGUI, PdfDecoderInt decode_pdf, PropertiesFile properties, GUIThumbnailPanel thumbnails) {
        currentGUI.removePageListener();
        currentGUI.setDisplayView(1, decode_pdf.getPageAlignment());
        boolean isURL = file.startsWith("http:") || file.startsWith("file:");
        try {
            if (!isURL) {
                commonValues.setFileIsURL(false);
                commonValues.setFileSize(new File(file).length() >> 10);
            } else {
                commonValues.setFileIsURL(true);
            }
            commonValues.setSelectedFile(file);
            currentGUI.setViewerTitle(null);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " getting paths");
        }
        File testFile = new File(commonValues.getSelectedFile());
        if (!isURL && !testFile.exists()) {
            currentGUI.showMessageDialog(Messages.getMessage("PdfViewerFile.text") + commonValues.getSelectedFile() + Messages.getMessage("PdfViewerNotExist"));
        } else if (commonValues.getSelectedFile() != null && !Values.isProcessing()) {
            if (currentGUI.isSingle()) {
                decode_pdf.flushObjectValues(true);
            } else {
                decode_pdf = currentGUI.openNewMultiplePage(commonValues.getSelectedFile(), commonValues);
            }
            decode_pdf.resetViewableArea();
            OpenFile.openFile(commonValues.getSelectedFile(), commonValues, searchFrame, currentGUI, decode_pdf, properties, thumbnails);
        }
        decode_pdf.getDecoderOptions().setDisplayView(-1);
        currentGUI.setDisplayView(decode_pdf.getDecoderOptions().getPageMode(), decode_pdf.getPageAlignment());
    }

    public static void openFile(String selectedFile, Values commonValues, GUISearchWindow searchFrame, final GUIFactory currentGUI, PdfDecoderInt decode_pdf, PropertiesFile properties, GUIThumbnailPanel thumbnails) {
        String memFlag;
        isPDf = false;
        commonValues.setMultiTiff(false);
        String hiresFlag = System.getProperty("org.jpedal.hires");
        if (DecoderOptions.hires || hiresFlag != null) {
            commonValues.setUseHiresImage(true);
        }
        if ((memFlag = System.getProperty("org.jpedal.memory")) != null) {
            commonValues.setUseHiresImage(false);
        }
        thumbnails.resetToDefault();
        currentGUI.setNoPagesDecoded();
        if (searchFrame != null) {
            searchFrame.removeSearchWindow(false);
        }
        commonValues.maxViewY = 0;
        String ending = selectedFile.toLowerCase().trim();
        commonValues.setPDF(ending.endsWith(".pdf") || ending.endsWith(".fdf"));
        if (ending.endsWith(".pdf") || ending.endsWith(".fdf")) {
            isPDf = true;
        }
        if (!commonValues.isPDF()) {
            if (SwingUtilities.isEventDispatchThread()) {
                currentGUI.setDisplayView(1, 2);
            } else {
                Runnable doPaintComponent = new Runnable(){

                    @Override
                    public void run() {
                        currentGUI.setDisplayView(1, 2);
                    }
                };
                SwingUtilities.invokeLater(doPaintComponent);
            }
        }
        currentGUI.setQualityBoxVisible(commonValues.isPDF());
        commonValues.setCurrentPage(1);
        try {
            boolean fileCanBeOpened = OpenFile.openUpFile(commonValues.getSelectedFile(), commonValues, searchFrame, currentGUI, decode_pdf, properties, thumbnails);
            if (fileCanBeOpened) {
                OpenFile.processPage(commonValues, decode_pdf, currentGUI, thumbnails);
            } else {
                currentGUI.setViewerTitle(Messages.getMessage("PdfViewer.NoFile"));
                decode_pdf.getDynamicRenderer().flush();
                decode_pdf.getPages().refreshDisplay();
                currentGUI.scaleAndRotate();
                commonValues.setPageCount(1);
                commonValues.setCurrentPage(1);
            }
        }
        catch (Exception e) {
            LogWriter.writeLog(Messages.getMessage("PdfViewerError.Exception") + ' ' + e + ' ' + Messages.getMessage("PdfViewerError.DecodeFile"));
        }
    }

    public static boolean openUpFile(String selectedFile, final Values commonValues, GUISearchWindow searchFrame, final GUIFactory currentGUI, final PdfDecoderInt decode_pdf, PropertiesFile properties, final GUIThumbnailPanel thumbnails) throws PdfException {
        commonValues.maxViewY = 0;
        searchFrame.resetSearchWindow();
        commonValues.setMultiTiff(false);
        boolean fileCanBeOpened = true;
        if (currentGUI.isSingle()) {
            decode_pdf.closePdfFile();
        }
        try {
            if (commonValues.isPDF()) {
                block45: {
                    if (inputStream != null || selectedFile.startsWith("http") || selectedFile.startsWith("file:") || selectedFile.startsWith("jar:")) {
                        try {
                            boolean isLinearized = false;
                            if (inputStream != null) {
                                isLinearized = true;
                            } else if (commonValues.getModeOfOperation() != 1) {
                                isLinearized = Commands.isPDFLinearized(commonValues.getSelectedFile());
                            }
                            if (!isLinearized) {
                                if (commonValues.getSelectedFile().startsWith("jar:")) {
                                    InputStream is = Commands.class.getClass().getResourceAsStream(commonValues.getSelectedFile().substring(4));
                                    decode_pdf.openPdfFileFromInputStream(is, false);
                                } else {
                                    final DownloadProgress dlp = new DownloadProgress(commonValues.getSelectedFile());
                                    Thread t = new Thread(){

                                        @Override
                                        public void run() {
                                            while (dlp.isDownloading()) {
                                                currentGUI.setDownloadProgress("download", dlp.getProgress());
                                                try {
                                                    Thread.sleep(500L);
                                                }
                                                catch (InterruptedException e) {
                                                    LogWriter.writeLog("Exception attempting to open file: " + e);
                                                }
                                            }
                                        }
                                    };
                                    t.setDaemon(true);
                                    t.start();
                                    dlp.startDownload();
                                    File tempFile = dlp.getFile();
                                    decode_pdf.openPdfFile(tempFile.getCanonicalPath());
                                }
                                break block45;
                            }
                            currentGUI.setViewerTitle("Loading linearized PDF " + commonValues.getSelectedFile());
                            if (inputStream != null) {
                                decode_pdf.openPdfFileFromInputStream(inputStream, true);
                            } else {
                                decode_pdf.openPdfFileFromURL(commonValues.getSelectedFile(), true);
                            }
                            PdfObject linearObj = (PdfObject)decode_pdf.getJPedalObject(2004845231);
                            int linearfileLength = linearObj.getInt(28);
                            StringBuilder message = new StringBuilder("Downloading ");
                            if ((linearfileLength /= 1024) < 1024) {
                                message.append(linearfileLength).append(" kB");
                            } else {
                                message.append(linearfileLength /= 1024).append(" M");
                            }
                            final String fMessage = message.toString();
                            Thread fullReaderer = new Thread(){

                                @Override
                                public void run() {
                                    LinearThread linearizedBackgroundReaderer = (LinearThread)decode_pdf.getJPedalObject(-1276915978);
                                    while (linearizedBackgroundReaderer != null && linearizedBackgroundReaderer.isAlive()) {
                                        try {
                                            Thread.sleep(1000L);
                                        }
                                        catch (InterruptedException e) {
                                            e.printStackTrace();
                                        }
                                        currentGUI.setDownloadProgress(fMessage, linearizedBackgroundReaderer.getPercentageLoaded());
                                    }
                                    currentGUI.setDownloadProgress(fMessage, 100);
                                    OpenFile.processPage(commonValues, decode_pdf, currentGUI, thumbnails);
                                }
                            };
                            fullReaderer.setDaemon(true);
                            fullReaderer.start();
                        }
                        catch (Exception e) {
                            currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.UrlError") + " file=" + selectedFile + '\n' + e.getMessage());
                            decode_pdf.closePdfFile();
                            fileCanBeOpened = false;
                        }
                    } else {
                        boolean test = false;
                        try {
                            decode_pdf.openPdfFile(commonValues.getSelectedFile());
                        }
                        catch (RuntimeException e) {
                            String message = e.getMessage() != null && e.getMessage().contains("bouncycastle") ? e.getMessage() : "Exception in code " + e.getMessage() + " please send to IDRsolutions";
                            currentGUI.showMessageDialog(message);
                            LogWriter.writeLog("Exception " + e.getMessage());
                        }
                        if (decode_pdf.getPageCount() > 1) {
                            currentGUI.getButtons().setPageLayoutButtonsEnabled(true);
                        }
                    }
                }
                currentGUI.reinitThumbnails();
            } else {
                boolean isURL;
                decode_pdf.resetForNonPDFPage(1);
                PageNavigator.setLastPageDecoded(1);
                boolean isTiff = selectedFile.toLowerCase().contains(".tif");
                boolean bl = isURL = selectedFile.startsWith("http:") || selectedFile.startsWith("file:");
                if (isTiff) {
                    try {
                        PageNavigator.setTiffHelper(new TiffHelper(commonValues.getSelectedFile()));
                        int pageCount = PageNavigator.getTiffHelper().getTiffPageCount();
                        commonValues.setTiffImageToLoad(0);
                        if (pageCount > 1) {
                            decode_pdf.resetForNonPDFPage(pageCount);
                            commonValues.setPageCount(pageCount);
                            PageNavigator.setLastPageDecoded(1);
                            commonValues.setMultiTiff(true);
                            commonValues.setMultiTiff(true);
                        }
                        PageNavigator.drawMultiPageTiff(commonValues, decode_pdf);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        LogWriter.writeLog("Exception " + e + Messages.getMessage("PdfViewerError.Loading") + commonValues.getSelectedFile());
                    }
                } else {
                    String fName = selectedFile.toLowerCase();
                    if (fName.endsWith(".jpx") || fName.endsWith(".jp2") || fName.endsWith(".j2k")) {
                        File f = new File(selectedFile);
                        byte[] jpxRawData = new byte[(int)f.length()];
                        try {
                            FileInputStream fis = new FileInputStream(f);
                            fis.read(jpxRawData);
                            BufferedImage img = JDeliHelper.JPEG2000ToRGBImage(jpxRawData);
                            commonValues.setBufferedImg(img);
                        }
                        catch (Exception ex) {
                            LogWriter.writeLog("Exception " + ex + "loading " + commonValues.getSelectedFile());
                        }
                    } else {
                        try {
                            if (isURL) {
                                commonValues.setBufferedImg(ImageIO.read(new URL(selectedFile)));
                            } else {
                                commonValues.setBufferedImg(ImageIO.read(new File(selectedFile)));
                            }
                        }
                        catch (Exception e) {
                            LogWriter.writeLog("Exception " + e + "loading " + commonValues.getSelectedFile());
                        }
                    }
                }
            }
            currentGUI.updateStatusMessage("opening file");
            if (fileCanBeOpened && decode_pdf.isEncrypted() && !decode_pdf.isFileViewable()) {
                fileCanBeOpened = false;
                String password = System.getProperty("org.jpedal.password");
                if (password == null) {
                    password = currentGUI.showInputDialog(Messages.getMessage("PdfViewerPassword.message"));
                }
                if (password != null) {
                    decode_pdf.setEncryptionPassword(password);
                    if (decode_pdf.isFileViewable()) {
                        fileCanBeOpened = true;
                    }
                }
                if (!fileCanBeOpened) {
                    currentGUI.showMessageDialog(Messages.getMessage("PdfViewerPasswordRequired.message"));
                }
            }
            currentGUI.setBookmarks(true);
            if (fileCanBeOpened) {
                if (properties.getValue("Recentdocuments").equals("true")) {
                    properties.addRecentDocument(commonValues.getSelectedFile());
                    currentGUI.getRecentDocument().updateRecentDocuments(properties.getRecentDocuments());
                }
                currentGUI.getRecentDocument().addToFileList(commonValues.getSelectedFile());
                commonValues.setCurrentPage(1);
            }
        }
        catch (PdfException e) {
            LogWriter.writeLog("Exception " + e + " opening file");
            if (currentGUI.isSingle()) {
                if (GUI.showMessages) {
                    ErrorDialog.showError(e, Messages.getMessage("PdfViewerOpenerror"), (Container)currentGUI.getFrame(), commonValues.getSelectedFile());
                }
                Exit.exit(thumbnails, currentGUI, commonValues, decode_pdf, properties);
            }
            throw e;
        }
        if (!decode_pdf.isOpen() && commonValues.isPDF() && decode_pdf.getJPedalObject(2004845231) == null) {
            return false;
        }
        return fileCanBeOpened;
    }

    public static void selectFile(Values commonValues, GUISearchWindow searchFrame, GUIFactory currentGUI, PdfDecoderInt decode_pdf, PropertiesFile properties, GUIThumbnailPanel thumbnails) {
        if (searchFrame != null) {
            searchFrame.removeSearchWindow(false);
        }
        JFileChooser chooser = new JFileChooser(commonValues.getInputDir());
        chooser.setName("chooser");
        if (commonValues.getSelectedFile() != null) {
            chooser.setSelectedFile(new File(commonValues.getSelectedFile()));
        }
        chooser.setFileSelectionMode(0);
        String[] pdf = new String[]{"pdf"};
        String[] fdf = new String[]{"fdf"};
        String[] png = new String[]{"png", "tif", "tiff", "jpg", "jpeg"};
        chooser.addChoosableFileFilter(new FileFilterer(png, "Images (Tiff, Jpeg,Png)"));
        chooser.addChoosableFileFilter(new FileFilterer(fdf, "fdf (*.fdf)"));
        chooser.addChoosableFileFilter(new FileFilterer(pdf, "Pdf (*.pdf)"));
        int state = chooser.showOpenDialog((Container)currentGUI.getFrame());
        File file = chooser.getSelectedFile();
        if (file != null && state == 0) {
            boolean isValid;
            String ext = file.getName().toLowerCase();
            boolean bl = isValid = ext.endsWith(".pdf") || ext.endsWith(".fdf") || ext.endsWith(".tif") || ext.endsWith(".tiff") || ext.endsWith(".png") || ext.endsWith(".jpg") || ext.endsWith(".jpeg");
            if (isValid) {
                try {
                    commonValues.setInputDir(chooser.getCurrentDirectory().getCanonicalPath());
                    OpenFile.open(file.getAbsolutePath(), commonValues, searchFrame, currentGUI, decode_pdf, properties, thumbnails);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            } else {
                decode_pdf.repaint();
                currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NotValidPdfWarning"));
            }
        } else {
            decode_pdf.repaint();
            currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.NoSelection"));
        }
    }

    public static void processPage(Values commonValues, PdfDecoderInt decode_pdf, GUIFactory currentGUI, GUIThumbnailPanel thumbnails) {
        if (commonValues.isPDF() && (decode_pdf.isOpen() || !commonValues.isPDF() || decode_pdf.getJPedalObject(2004845231) != null)) {
            PdfFileInformation currentFileInformation = decode_pdf.getFileInformationData();
            decode_pdf.setRenderMode(3);
            String[] values = currentFileInformation.getFieldValues();
            String[] fields = PdfFileInformation.getFieldNames();
            String[] ocr = new String[]{"TeleForm", "dgn2pdf"};
            for (int i = 0; i < fields.length; ++i) {
                if (!fields[i].equals("Creator") && !fields[i].equals("Producer")) continue;
                for (String anOcr : ocr) {
                    if (!values[i].equals(anOcr)) continue;
                    decode_pdf.setRenderMode(2);
                }
                if (!values[i].equals("ABBYY FineReader 8.0 Professional Edition")) continue;
                decode_pdf.setRenderMode(35);
            }
            boolean currentProcessingStatus = Values.isProcessing();
            Values.setProcessing(true);
            if (commonValues.isUseHiresImage()) {
                decode_pdf.useHiResScreenDisplay(true);
                ((GUI)currentGUI).setSelectedComboIndex(250, 1);
            } else {
                decode_pdf.useHiResScreenDisplay(false);
                ((GUI)currentGUI).setSelectedComboIndex(250, 0);
            }
            Values.setProcessing(currentProcessingStatus);
        }
        if (commonValues.isPDF()) {
            commonValues.setPageCount(decode_pdf.getPageCount());
        } else if (!commonValues.isMultiTiff()) {
            commonValues.setPageCount(1);
            decode_pdf.useHiResScreenDisplay(true);
        }
        if (commonValues.getPageCount() < commonValues.getCurrentPage()) {
            commonValues.setCurrentPage(commonValues.getPageCount());
            System.err.println(commonValues.getCurrentPage() + " out of range. Opening on last page");
            LogWriter.writeLog(commonValues.getCurrentPage() + " out of range. Opening on last page");
        }
        decode_pdf.setExtractionMode(1, currentGUI.getScaling());
        currentGUI.setPageNumber();
        currentGUI.resetRotationBox();
        if (commonValues.isPDF()) {
            currentGUI.decodePage();
        } else {
            currentGUI.scaleAndRotate();
            decode_pdf.setPDFBorder(BorderFactory.createLineBorder(Color.black, 1));
            Images.decodeImage(DecoderOptions.hires, decode_pdf, currentGUI, thumbnails, commonValues);
            Values.setProcessing(false);
        }
    }

    private static String selectURL(Values commonValues, GUISearchWindow searchFrame, GUIFactory currentGUI, PdfDecoderInt decode_pdf, PropertiesFile properties, GUIThumbnailPanel thumbnails) {
        String selectedFile = currentGUI.showInputDialog(Messages.getMessage("PdfViewerMessage.RequestURL"));
        if (selectedFile != null) {
            selectedFile = selectedFile.trim();
        }
        if (!(selectedFile == null || selectedFile.trim().startsWith("http://") || selectedFile.trim().startsWith("https://") || selectedFile.trim().startsWith("file:/"))) {
            currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.URLMustContain"));
            selectedFile = null;
        }
        if (selectedFile != null) {
            boolean isValid;
            boolean bl = isValid = selectedFile.endsWith(".pdf") || selectedFile.endsWith(".fdf") || selectedFile.endsWith(".tif") || selectedFile.endsWith(".tiff") || selectedFile.endsWith(".png") || selectedFile.endsWith(".jpg") || selectedFile.endsWith(".jpeg");
            if (!isValid) {
                currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NotValidPdfWarning"));
                selectedFile = null;
            }
        }
        if (selectedFile != null) {
            commonValues.setSelectedFile(selectedFile);
            boolean failed = false;
            try {
                URL testExists = new URL(selectedFile);
                URLConnection conn = testExists.openConnection();
                if (conn.getContent() == null) {
                    failed = true;
                }
            }
            catch (Exception e) {
                failed = true;
                LogWriter.writeLog("Exception in handling URL " + e);
            }
            if (failed) {
                selectedFile = null;
                currentGUI.showMessageDialog("URL " + selectedFile + ' ' + Messages.getMessage("PdfViewerError.DoesNotExist"));
            }
        }
        if (selectedFile != null) {
            try {
                commonValues.setFileSize(0L);
                currentGUI.setViewerTitle(null);
            }
            catch (Exception e) {
                System.err.println(Messages.getMessage("PdfViewerError.Exception") + ' ' + e + ' ' + Messages.getMessage("PdfViewerError.GettingPaths"));
            }
            if (selectedFile != null && !Values.isProcessing()) {
                thumbnails.terminateDrawing();
                decode_pdf.flushObjectValues(true);
                decode_pdf.resetViewableArea();
                currentGUI.stopThumbnails();
                if (!currentGUI.isSingle()) {
                    currentGUI.openNewMultiplePage(commonValues.getSelectedFile(), commonValues);
                }
                OpenFile.openFile(commonValues.getSelectedFile(), commonValues, searchFrame, currentGUI, decode_pdf, properties, thumbnails);
            }
        } else {
            decode_pdf.repaint();
            currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.NoSelection"));
        }
        return selectedFile;
    }
}

