/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands;

import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jpedal.PdfDecoderInt;
import org.jpedal.display.GUIDisplay;
import org.jpedal.examples.viewer.SharedViewer;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.commands.ModeChange;
import org.jpedal.examples.viewer.gui.GUI;
import org.jpedal.examples.viewer.gui.generic.GUISearchWindow;
import org.jpedal.examples.viewer.utils.PropertiesFile;
import org.jpedal.gui.GUIFactory;
import org.jpedal.utils.BrowserLauncher;
import org.jpedal.utils.JavaFXHelper;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class PageFlow {
    public static void execute(Object[] args, final GUIFactory currentGUI, Values commonValues, PdfDecoderInt decode_pdf, PropertiesFile properties, GUISearchWindow searchFrame) {
        if (!decode_pdf.isOpen() || decode_pdf.getDisplayView() == 5) {
            return;
        }
        searchFrame.removeSearchWindow(false);
        if (args == null) {
            if (commonValues.getModeOfOperation() != 1) {
                if (!JavaFXHelper.isJavaFXAvailable()) {
                    String flag = System.getProperty("org.jpedal.suppressViewerPopups");
                    boolean suppressViewerPopups = false;
                    if (flag != null && flag.equalsIgnoreCase("true")) {
                        suppressViewerPopups = true;
                    }
                    String propValue = properties.getValue("showpageflowmessage");
                    if (!suppressViewerPopups && properties != null && !propValue.isEmpty() && propValue.equals("true")) {
                        final JPanel a = new JPanel();
                        a.setLayout(new BoxLayout(a, 1));
                        JLabel m1 = new JLabel(Messages.getMessage("PdfViewer.PageFlowJarsNeeded.Message"));
                        m1.setHorizontalTextPosition(0);
                        a.add(m1);
                        MouseAdapter linkListener = new MouseAdapter(){

                            @Override
                            public void mouseEntered(MouseEvent e) {
                                if (GUIDisplay.allowChangeCursor) {
                                    a.setCursor(new Cursor(12));
                                }
                            }

                            @Override
                            public void mouseExited(MouseEvent e) {
                                if (GUIDisplay.allowChangeCursor) {
                                    a.setCursor(new Cursor(0));
                                }
                            }

                            @Override
                            public void mouseClicked(MouseEvent e) {
                                try {
                                    BrowserLauncher.openURL(Messages.getMessage("PdfViewer.PageFlowJarsNeeded.Link"));
                                }
                                catch (Exception e1) {
                                    LogWriter.writeLog("Exception " + e1.getMessage());
                                    currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.ErrorWebsite"));
                                }
                            }
                        };
                        JLabel link = new JLabel("<html><u>" + Messages.getMessage("PdfViewer.PageFlowJarsNeeded.Download") + "</u></html>");
                        link.setForeground(Color.BLUE);
                        link.addMouseListener(linkListener);
                        link.setHorizontalAlignment(0);
                        a.add(link);
                        Object[] options = new Object[]{Messages.getMessage("PdfViewer.PageFlowJarsNeeded.Continue")};
                        JOptionPane.showOptionDialog((Container)currentGUI.getFrame(), a, Messages.getMessage("PdfViewer.PageFlowJarsNeeded.Title"), -1, -1, null, options, options[0]);
                        return;
                    }
                }
                currentGUI.getCombo(252).setEnabled(false);
                currentGUI.getButtons().getButton(29).setEnabled(false);
                currentGUI.getButtons().getButton(13).setEnabled(false);
                currentGUI.getButtons().alignLayoutMenuOption(5);
                if (SharedViewer.isFX()) {
                    ModeChange.changeModeInJavaFX(5, decode_pdf, currentGUI, commonValues, properties, searchFrame);
                } else {
                    ModeChange.changeModeInSwing(5, decode_pdf, currentGUI, commonValues, properties, searchFrame);
                }
            } else {
                if (commonValues.getModeOfOperation() == 1) {
                    currentGUI.showMessageDialog("PageFlow temporarily disabled for Applet");
                }
                currentGUI.getButtons().alignLayoutMenuOption(1);
                if (SwingUtilities.isEventDispatchThread()) {
                    currentGUI.setDisplayView(1, 2);
                    currentGUI.getButtons().hideRedundentNavButtons(currentGUI);
                    ((GUI)currentGUI).setSelectedComboIndex(251, 0);
                } else {
                    currentGUI.setCommandInThread(true);
                    Runnable doPaintComponent = new Runnable(){

                        @Override
                        public void run() {
                            currentGUI.setDisplayView(1, 2);
                            currentGUI.getButtons().hideRedundentNavButtons(currentGUI);
                            ((GUI)currentGUI).setSelectedComboIndex(251, 0);
                            currentGUI.setExecutingCommand(false);
                        }
                    };
                    SwingUtilities.invokeLater(doPaintComponent);
                }
            }
            currentGUI.getCombo(251).setEnabled(false);
        }
    }
}

