/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands;

import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.viewer.Commands;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.gui.generic.GUISearchList;
import org.jpedal.examples.viewer.gui.generic.GUISearchWindow;
import org.jpedal.gui.GUIFactory;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;
import org.jpedal.utils.repositories.generic.Vector_Rectangle_Int;

public class PreviousResult {
    public static Object execute(Object[] args, Values commonValues, GUIFactory currentGUI, PdfDecoderInt decode_pdf, GUISearchWindow searchFrame) {
        Integer status = null;
        GUISearchList results = null;
        if (args == null) {
            results = searchFrame.getResults(commonValues.getCurrentPage());
            int index = results.getSelectedIndex();
            if (index < 0) {
                index = 0;
                results.setSelectedIndex(index);
            }
            Integer currPage = commonValues.getCurrentPage();
            if (index == 0 || results.getResultCount() == 0) {
                int currentPage = commonValues.getCurrentPage() - 1;
                if (currentPage < 1) {
                    currentPage = commonValues.getPageCount();
                }
                results = searchFrame.getResults(currentPage);
                while (results.getResultCount() < 1 && currentPage > 0 && searchFrame.getViewStyle() == 2) {
                    results = searchFrame.getResults(currentPage);
                    --currentPage;
                }
                if (results.getResultCount() < 1 && currentPage == 0) {
                    results = searchFrame.getResults(currentPage);
                    status = Commands.SEARCH_RETURNED_TO_START;
                    for (currentPage = commonValues.getPageCount(); results.getResultCount() < 1 && currentPage >= commonValues.getCurrentPage() && searchFrame.getViewStyle() == 2; --currentPage) {
                        results = searchFrame.getResults(currentPage);
                    }
                }
                index = results.getResultCount() - 1;
                if (results.getResultCount() < 1) {
                    status = Commands.SEARCH_NOT_FOUND;
                }
            } else {
                --index;
            }
            currentGUI.setResults(results);
            results.setSelectedIndex(index);
            if (!Values.isProcessing()) {
                float scaling = currentGUI.getScaling();
                int id = results.getSelectedIndex();
                if (!commonValues.getAllHighlightsShown()) {
                    decode_pdf.getTextLines().clearHighlights();
                }
                if (id != -1) {
                    Integer key = id;
                    Object newPage = results.getTextPages().get(key);
                    if (newPage != null) {
                        int nextPage = (Integer)newPage;
                        if (commonValues.getCurrentPage() != nextPage) {
                            commonValues.setCurrentPage(nextPage);
                            currentGUI.resetStatusMessage(Messages.getMessage("PdfViewer.LoadingPage") + ' ' + commonValues.getCurrentPage());
                            decode_pdf.setPageParameters(scaling, commonValues.getCurrentPage());
                            currentGUI.decodePage();
                        }
                        while (Values.isProcessing()) {
                            try {
                                Thread.sleep(5000L);
                            }
                            catch (Exception e) {
                                LogWriter.writeLog("Attempting to set propeties values " + e);
                            }
                        }
                        if (currPage != nextPage && commonValues.getAllHighlightsShown()) {
                            Vector_Rectangle_Int storageVector = new Vector_Rectangle_Int();
                            for (int k = 0; k != results.getResultCount(); ++k) {
                                Integer kInteger = k;
                                if ((Integer)results.getTextPages().get(kInteger) != nextPage) continue;
                                Object h = searchFrame.getTextRectangles().get(kInteger);
                                if (h instanceof int[]) {
                                    storageVector.addElement((int[])h);
                                }
                                if (!(h instanceof int[][])) continue;
                                int[][] areas = (int[][])h;
                                for (int i = 0; i != areas.length; ++i) {
                                    storageVector.addElement(areas[i]);
                                }
                            }
                            storageVector.trim();
                            int[][] finalHighlight = storageVector.get();
                            decode_pdf.getTextLines().addHighlights(finalHighlight, true, nextPage);
                        }
                        if (!commonValues.getAllHighlightsShown()) {
                            Object highlight = results.textAreas().get(key);
                            if (highlight instanceof int[]) {
                                decode_pdf.getTextLines().addHighlights(new int[][]{(int[])highlight}, true, nextPage);
                            } else {
                                decode_pdf.getTextLines().addHighlights((int[][])highlight, true, nextPage);
                            }
                        }
                        decode_pdf.getPages().refreshDisplay();
                        decode_pdf.repaintPane(commonValues.getCurrentPage());
                    }
                }
            }
            currentGUI.getButtons().hideRedundentNavButtons(currentGUI);
        }
        if (commonValues.getCurrentPage() == searchFrame.getFirstPageWithResults() && results.getSelectedIndex() == 0) {
            status = Commands.FIRST_DOCUMENT_SEARCH_RESULT_NOW_SHOWN;
        }
        return status;
    }
}

