/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands;

import java.io.File;
import javax.swing.JFileChooser;
import org.jpedal.DevFlags;
import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.utils.FileFilterer;
import org.jpedal.examples.viewer.utils.ItextFunctions;
import org.jpedal.gui.GUIFactory;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.objects.acroforms.ReturnValues;
import org.jpedal.utils.Messages;

public class SaveForm {
    public static void execute(Object[] args, GUIFactory currentGUI, PdfDecoderInt decode_pdf, Values commonValues) {
        if (args == null) {
            SaveForm.saveChangedForm(currentGUI, decode_pdf, commonValues);
        }
    }

    public static void saveChangedForm(GUIFactory currentGUI, PdfDecoderInt decode_pdf, Values commonValues) {
        AcroRenderer formRenderer = decode_pdf.getFormRenderer();
        if (formRenderer == null) {
            return;
        }
        Object[] names = formRenderer.getFormComponents(null, ReturnValues.FORM_NAMES, -1);
        if (names == null) {
            currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NoFields"));
        } else {
            String fileToSave = "";
            boolean finished = false;
            while (!finished) {
                JFileChooser chooser = new JFileChooser(commonValues.getInputDir());
                chooser.setSelectedFile(new File(commonValues.getInputDir() + '/' + commonValues.getSelectedFile()));
                chooser.addChoosableFileFilter(new FileFilterer(new String[]{"pdf"}, "Pdf (*.pdf)"));
                chooser.addChoosableFileFilter(new FileFilterer(new String[]{"fdf"}, "fdf (*.fdf)"));
                chooser.setFileSelectionMode(0);
                int approved = chooser.showSaveDialog(null);
                if (approved == 0) {
                    int n;
                    File file = chooser.getSelectedFile();
                    fileToSave = file.getAbsolutePath();
                    if (!fileToSave.endsWith(".pdf")) {
                        fileToSave = fileToSave + ".pdf";
                        file = new File(fileToSave);
                    }
                    if (fileToSave.equals(commonValues.getSelectedFile())) {
                        currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.SaveError"));
                        continue;
                    }
                    if (file.exists() && (n = currentGUI.showConfirmDialog(fileToSave + '\n' + Messages.getMessage("PdfViewerMessage.FileAlreadyExists") + ".\n" + Messages.getMessage("PdfViewerMessage.ConfirmResave"), Messages.getMessage("PdfViewerMessage.Resave"), 0)) == 1) continue;
                    finished = true;
                    continue;
                }
                return;
            }
            ItextFunctions itextFunctions = new ItextFunctions(currentGUI, commonValues.getSelectedFile(), decode_pdf);
            ItextFunctions.saveFormsData(fileToSave);
            commonValues.setFormsChanged(false);
            currentGUI.setViewerTitle(null);
        }
    }

    public static void handleUnsaveForms(GUIFactory currentGUI, Values commonValues, PdfDecoderInt decode_pdf) {
        int n;
        if (!DevFlags.GUITESTINGINPROGRESS && commonValues.isFormsChanged() && (n = currentGUI.showConfirmDialog(Messages.getMessage("PdfViewerFormsUnsavedOptions.message"), Messages.getMessage("PdfViewerFormsUnsavedWarning.message"), 0)) == 0) {
            SaveForm.saveChangedForm(currentGUI, decode_pdf, commonValues);
        }
        commonValues.setFormsChanged(false);
    }
}

