/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands;

import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.viewer.Values;
import org.jpedal.gui.GUIFactory;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.utils.Messages;

public class SelectAll {
    public static void execute(GUIFactory currentGUI, PdfDecoderInt decode_pdf, Values commonValues) {
        if (decode_pdf.getDisplayView() == 1) {
            int width;
            int height;
            int coordY;
            int coordX;
            int[][] allHighlights = decode_pdf.getTextLines().getLineAreasAs2DArray(commonValues.getCurrentPage());
            if (allHighlights != null) {
                int top = 0;
                int bottom = 0;
                for (int r = 0; r != allHighlights.length; ++r) {
                    if (allHighlights[r][1] > allHighlights[top][1]) {
                        top = r;
                    }
                    if (allHighlights[r][1] >= allHighlights[bottom][1]) continue;
                    bottom = r;
                }
                coordX = allHighlights[top][0];
                coordY = allHighlights[top][1] + allHighlights[top][3] / 2;
                height = allHighlights[bottom][1] + allHighlights[bottom][3] / 2 - coordY;
                width = allHighlights[bottom][0] + allHighlights[bottom][2] - coordX;
                decode_pdf.getTextLines().clearHighlights();
                decode_pdf.getTextLines().addHighlights(allHighlights, true, commonValues.getCurrentPage());
            } else {
                height = decode_pdf.getPdfPageData().getCropBoxHeight(commonValues.getCurrentPage());
                width = decode_pdf.getPdfPageData().getCropBoxWidth(commonValues.getCurrentPage());
                coordX = decode_pdf.getPdfPageData().getCropBoxX(commonValues.getCurrentPage());
                coordY = decode_pdf.getPdfPageData().getCropBoxY(commonValues.getCurrentPage());
            }
            commonValues.m_x1 = coordX;
            commonValues.m_x2 = coordX + width;
            commonValues.m_y1 = coordY;
            commonValues.m_y2 = coordY + height;
            int[] currentRectangle = new int[]{coordX, coordY, width, height};
            decode_pdf.updateCursorBoxOnScreen(null, 0);
            decode_pdf.getPages().setHighlightedImage(null);
            decode_pdf.updateCursorBoxOnScreen(currentRectangle, DecoderOptions.highlightColor.getRGB());
            decode_pdf.repaintPane(commonValues.getCurrentPage());
        } else {
            currentGUI.showMessageDialog(Messages.getMessage("PageLayoutMessage.SinglePageOnly"));
        }
    }
}

