/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands.javafx;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.handlers.DefaultImageHelper;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.commands.generic.GUIExtractSelectionAsImage;
import org.jpedal.examples.viewer.gui.javafx.dialog.FXDialog;
import org.jpedal.gui.GUIFactory;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class JavaFXExtractSelectionAsImage
extends GUIExtractSelectionAsImage {
    protected static final int BUTTONWIDTH = 55;

    public static void execute(Values commonValues, GUIFactory currentGUI, PdfDecoderInt decode_pdf) {
        String style;
        HBox imgBox;
        JavaFXExtractSelectionAsImage.extractSelectedScreenAsImage(commonValues, currentGUI, decode_pdf);
        VBox pane = new VBox();
        final FXDialog dialog = new FXDialog((Stage)currentGUI.getFrame(), Modality.APPLICATION_MODAL, (Pane)pane);
        dialog.setTitle(Messages.getMessage("PdfViewerMessage.SaveImage"));
        dialog.setResizeable(false);
        if (snapShot != null) {
            int r;
            int col;
            imgBox = new HBox();
            imgBox.setAlignment(Pos.CENTER);
            String propValue = currentGUI.getProperties().getValue("replacePdfDisplayBackground");
            if (!propValue.isEmpty() && propValue.equalsIgnoreCase("true")) {
                propValue = currentGUI.getProperties().getValue("pdfDisplayBackground");
                col = Integer.parseInt(propValue);
                r = col >> 16 & 0xFF;
                int g = col >> 8 & 0xFF;
                int b = col & 0xFF;
                style = "-fx-background-color:rgb(" + r + ',' + g + ',' + b + ");";
            } else if (decode_pdf.getDecoderOptions().getDisplayBackgroundColor() != null) {
                col = decode_pdf.getDecoderOptions().getDisplayBackgroundColor().getRGB();
                r = col >> 16 & 0xFF;
                int g = col >> 8 & 0xFF;
                int b = col & 0xFF;
                style = "-fx-background-color:rgb(" + r + ',' + g + ',' + b + ");";
            } else {
                style = decode_pdf.useNewGraphicsMode() ? "-fx-background-color:#555565;" : "-fx-background-color:#190190190;";
            }
        } else {
            return;
        }
        ImageView imv1 = new ImageView();
        imv1.setImage((Image)SwingFXUtils.toFXImage((BufferedImage)snapShot, null));
        dialog.setWidth(imv1.getImage().getWidth());
        dialog.setHeight(imv1.getImage().getHeight() + 50.0);
        imgBox.getChildren().add((Object)imv1);
        imgBox.setPadding(new Insets(5.0));
        imgBox.setStyle(style);
        pane.getChildren().add((Object)imgBox);
        HBox btnBox = new HBox();
        Button copyBtn = new Button(Messages.getMessage("PdfSnapshotPreview.Copy"));
        Button saveBtn = new Button(Messages.getMessage("PdfSnapshotPreview.Save"));
        Button cancelBtn = new Button(Messages.getMessage("PdfSnapshotPreview.Cancel"));
        btnBox.getChildren().addAll((Object[])new Node[]{copyBtn, saveBtn, cancelBtn});
        btnBox.setAlignment(Pos.BOTTOM_CENTER);
        btnBox.setSpacing(5.0);
        btnBox.setPadding(new Insets(5.0));
        if (style != null) {
            btnBox.setStyle(style);
        }
        copyBtn.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        saveBtn.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        cancelBtn.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        pane.getChildren().add((Object)btnBox);
        dialog.getDialog().sizeToScene();
        copyBtn.setPrefWidth(55.0);
        copyBtn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                dialog.getDialog().hide();
                GUIExtractSelectionAsImage.ClipboardImage clipboardImage = new GUIExtractSelectionAsImage.ClipboardImage(snapShot);
                Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
                c.setContents(clipboardImage, null);
            }
        });
        saveBtn.setPrefWidth(55.0);
        saveBtn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                dialog.getDialog().hide();
                FileChooser chooser = new FileChooser();
                chooser.setTitle("Open PDF file");
                chooser.setInitialDirectory(new File(System.getProperty("user.dir")));
                FileChooser.ExtensionFilter extFilter1 = new FileChooser.ExtensionFilter("TIFF (*.tif)", new String[]{"*.tif", "*.tiff"});
                chooser.getExtensionFilters().add((Object)extFilter1);
                FileChooser.ExtensionFilter extFilter2 = new FileChooser.ExtensionFilter("JPEG (*.jpg)", new String[]{"*.jpg", "*.jpeg"});
                chooser.getExtensionFilters().add((Object)extFilter2);
                File outputFile = chooser.showSaveDialog((Window)dialog.getDialog());
                if (outputFile != null) {
                    StringBuilder outName = new StringBuilder(outputFile.getAbsolutePath());
                    FileChooser.ExtensionFilter filter = chooser.getSelectedExtensionFilter();
                    String format = "tif";
                    if (filter.getDescription().toLowerCase().contains("jp")) {
                        format = "jpg";
                    }
                    if (!outName.toString().toLowerCase().endsWith(('.' + format).toLowerCase())) {
                        outName.append('.').append(format);
                    }
                    if (snapShot != null) {
                        try {
                            DefaultImageHelper.write(snapShot, format, outName.toString());
                        }
                        catch (IOException ex) {
                            LogWriter.writeLog("Exception in writing image " + ex);
                        }
                    }
                }
            }
        });
        cancelBtn.setPrefWidth(55.0);
        cancelBtn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                dialog.close();
            }
        });
        dialog.show();
    }
}

