/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands.javafx;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextArea;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.commands.generic.GUICopy;
import org.jpedal.examples.viewer.commands.generic.GUIExtractText;
import org.jpedal.examples.viewer.gui.javafx.dialog.FXDialog;
import org.jpedal.gui.GUIFactory;
import org.jpedal.objects.PdfPageData;
import org.jpedal.utils.Messages;

public class JavaFXExtractText
extends GUIExtractText {
    public static void execute(Object[] args, GUIFactory currentGUI, PdfDecoderInt decode_pdf, Values commonValues) {
        if (args == null) {
            JavaFXExtractText.extractSelectedText(currentGUI, decode_pdf, commonValues);
        }
    }

    private static void extractSelectedText(final GUIFactory currentGUI, final PdfDecoderInt decode_pdf, final Values commonValues) {
        if (!decode_pdf.isExtractionAllowed()) {
            currentGUI.showMessageDialog("Not allowed");
            return;
        }
        int[][] highlights = decode_pdf.getTextLines().getHighlightedAreasAs2DArray(commonValues.getCurrentPage());
        if (highlights == null) {
            currentGUI.showMessageDialog((Object)"There is no text selected.\nPlease highlight the text you wish to extract.", "No Text selected", 0);
            return;
        }
        BorderPane border = new BorderPane();
        final FXDialog textExtractionOptions = new FXDialog((Stage)currentGUI.getFrame(), Modality.APPLICATION_MODAL, (Parent)border, 300.0, 300.0);
        textExtractionOptions.setTitle("Text Extraction Options");
        HBox radButtons = new HBox();
        RadioButton rectangle = new RadioButton("Rectangle");
        rectangle.setId("rectangleExtraction");
        RadioButton table = new RadioButton("Table");
        table.setId("tableExtraction");
        RadioButton wordList = new RadioButton("WordList");
        wordList.setId("wordListExtraction");
        radButtons.getChildren().addAll((Object[])new Node[]{rectangle, table, wordList});
        table.setPadding(new Insets(0.0, 0.0, 0.0, 20.0));
        wordList.setPadding(new Insets(0.0, 0.0, 0.0, 45.0));
        border.setTop((Node)radButtons);
        final TextArea selection = new TextArea();
        border.setCenter((Node)selection);
        VBox allBottom = new VBox();
        HBox bottomButtons = new HBox(15.0);
        HBox bottomRadioButtons = new HBox();
        final RadioButton extractAsXML = new RadioButton("Extract as XML");
        RadioButton extractAsText = new RadioButton("Extract as Text");
        Button help = new Button("Help");
        Button cancel = new Button("Cancel");
        cancel.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                textExtractionOptions.close();
            }
        });
        Button extractButton = new Button("Extract");
        extractButton.setVisible(true);
        Region spacer = new Region();
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        bottomRadioButtons.getChildren().addAll((Object[])new Node[]{extractAsXML, spacer, extractAsText});
        bottomButtons.setAlignment(Pos.BOTTOM_RIGHT);
        bottomButtons.getChildren().addAll((Object[])new Node[]{help, cancel, extractButton});
        allBottom.getChildren().addAll((Object[])new Node[]{bottomRadioButtons, bottomButtons});
        extractAsXML.setPadding(new Insets(0.0, 0.0, 0.0, 10.0));
        extractAsText.setPadding(new Insets(0.0, 10.0, 13.0, 0.0));
        bottomButtons.setPadding(new Insets(0.0, 5.0, 10.0, 0.0));
        help.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                currentGUI.showMessageDialog(Messages.getMessage("PdfViewerGroupingInfo.message"));
            }
        });
        final ToggleGroup formatGroup = new ToggleGroup();
        rectangle.setSelected(true);
        formatGroup.getToggles().addAll((Object[])new Toggle[]{rectangle, table, wordList});
        ChangeListener<Toggle> updateSelectionListener = new ChangeListener<Toggle>(){

            public void changed(ObservableValue<? extends Toggle> ov, Toggle old_toggle, Toggle new_toggle) {
                selection.setText(JavaFXExtractText.updateSelection(formatGroup.getSelectedToggle(), extractAsXML.isSelected(), decode_pdf, commonValues, currentGUI));
            }
        };
        formatGroup.selectedToggleProperty().addListener((ChangeListener)updateSelectionListener);
        ToggleGroup extractionGroup = new ToggleGroup();
        extractAsText.setSelected(true);
        extractionGroup.getToggles().addAll((Object[])new Toggle[]{extractAsXML, extractAsText});
        extractionGroup.selectedToggleProperty().addListener((ChangeListener)updateSelectionListener);
        extractButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                JavaFXExtractText.createExtractionWindow(formatGroup.getSelectedToggle(), extractAsXML.isSelected(), decode_pdf, commonValues, currentGUI);
            }
        });
        selection.setText(JavaFXExtractText.updateSelection(formatGroup.getSelectedToggle(), extractAsXML.isSelected(), decode_pdf, commonValues, currentGUI));
        border.setBottom((Node)allBottom);
        BorderPane.setMargin((Node)selection, (Insets)new Insets(10.0, 10.0, 10.0, 10.0));
        BorderPane.setMargin((Node)radButtons, (Insets)new Insets(10.0, 10.0, 10.0, 10.0));
        BorderPane.setMargin((Node)bottomRadioButtons, (Insets)new Insets(10.0, 10.0, 10.0, 10.0));
        BorderPane.setMargin((Node)bottomButtons, (Insets)new Insets(10.0, 10.0, 10.0, 10.0));
        textExtractionOptions.show();
    }

    private static String updateSelection(Toggle selected, boolean isXML, PdfDecoderInt decode_pdf, Values commonValues, GUIFactory currentGUI) {
        StringBuilder finalValue = new StringBuilder("");
        try {
            PdfPageData page_data = decode_pdf.getPdfPageData();
            int cropX = page_data.getCropBoxX(commonValues.getCurrentPage());
            int cropY = page_data.getCropBoxY(commonValues.getCurrentPage());
            int cropW = page_data.getCropBoxWidth(commonValues.getCurrentPage());
            int cropH = page_data.getCropBoxHeight(commonValues.getCurrentPage());
            int[][] highlights = decode_pdf.getTextLines().getHighlightedAreasAs2DArray(commonValues.getCurrentPage());
            if (highlights != null) {
                for (int t = 0; t != highlights.length; ++t) {
                    int temp;
                    String extractedText = "";
                    if (highlights[t] == null) continue;
                    highlights[t] = GUICopy.adjustHighlightForExtraction(highlights[t]);
                    int t_x1 = highlights[t][0];
                    int t_x2 = highlights[t][0] + highlights[t][2];
                    int t_y1 = highlights[t][1] + highlights[t][3];
                    int t_y2 = highlights[t][1];
                    if (t_y1 < t_y2) {
                        temp = t_y2;
                        t_y2 = t_y1;
                        t_y1 = temp;
                    }
                    if (t_x1 > t_x2) {
                        temp = t_x2;
                        t_x2 = t_x1;
                        t_x1 = temp;
                    }
                    if (t_x1 < cropX) {
                        t_x1 = cropX;
                    }
                    if (t_x1 > cropX + cropW) {
                        t_x1 = cropX + cropW;
                    }
                    if (t_x2 < cropX) {
                        t_x2 = cropX;
                    }
                    if (t_x2 > cropX + cropW) {
                        t_x2 = cropX + cropW;
                    }
                    if (t_y1 < cropY) {
                        t_y1 = cropY;
                    }
                    if (t_y1 > cropY + cropH) {
                        t_y1 = cropY + cropH;
                    }
                    if (t_y2 < cropY) {
                        t_y2 = cropY;
                    }
                    if (t_y2 > cropY + cropH) {
                        t_y2 = cropY + cropH;
                    }
                    if ("rectangleExtraction".equals(((RadioButton)selected).getId())) {
                        extractedText = JavaFXExtractText.extractTextRectangle(commonValues, decode_pdf, currentGUI, isXML, t_x1, t_x2, t_y1, t_y2) + '\r' + '\n';
                    } else if ("tableExtraction".equals(((RadioButton)selected).getId())) {
                        extractedText = JavaFXExtractText.extractTextTable(commonValues, decode_pdf, isXML, t_x1, t_x2, t_y1, t_y2);
                    } else if ("wordListExtraction".equals(((RadioButton)selected).getId())) {
                        extractedText = JavaFXExtractText.extractTextList(decode_pdf, commonValues, currentGUI, isXML, t_x1, t_x2, t_y1, t_y2);
                    }
                    finalValue.append(extractedText);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return finalValue.toString();
    }

    private static void createExtractionWindow(Toggle selected, boolean isXML, PdfDecoderInt decode_pdf, Values commonValues, GUIFactory currentGUI) {
        Stage extractionDialog = new Stage();
        TextArea ta = new TextArea();
        Scene scene = new Scene((Parent)ta);
        extractionDialog.setTitle("Extracted Text");
        extractionDialog.setScene(scene);
        ta.setText(JavaFXExtractText.updateSelection(selected, isXML, decode_pdf, commonValues, currentGUI));
        extractionDialog.show();
    }
}

