/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands.javafx;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javafx.application.Platform;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.imageio.ImageIO;
import org.jpedal.PdfDecoderInt;
import org.jpedal.display.GUIThumbnailPanel;
import org.jpedal.examples.viewer.Commands;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.commands.Images;
import org.jpedal.examples.viewer.commands.OpenFile;
import org.jpedal.examples.viewer.commands.SaveForm;
import org.jpedal.examples.viewer.commands.javafx.JavaFXExit;
import org.jpedal.examples.viewer.commands.javafx.JavaFXPageNavigator;
import org.jpedal.examples.viewer.commands.javafx.MultiPages;
import org.jpedal.examples.viewer.gui.GUI;
import org.jpedal.examples.viewer.gui.generic.GUISearchWindow;
import org.jpedal.examples.viewer.gui.popups.DownloadProgress;
import org.jpedal.examples.viewer.utils.Printer;
import org.jpedal.examples.viewer.utils.PropertiesFile;
import org.jpedal.exception.PdfException;
import org.jpedal.gui.GUIFactory;
import org.jpedal.io.TiffHelper;
import org.jpedal.linear.LinearThread;
import org.jpedal.objects.PdfFileInformation;
import org.jpedal.objects.raw.OutlineObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class JavaFXOpenFile {
    private static File file;
    private static InputStream inputStream;
    private static boolean isPDf;

    public static void executeOpenFile(Object[] args, GUIFactory currentGUI, GUISearchWindow searchFrame, PropertiesFile properties, GUIThumbnailPanel thumbnails, PdfDecoderInt decode_pdf, Values commonValues) {
        currentGUI.removePageListener();
        currentGUI.setDisplayView(1, decode_pdf.getPageAlignment());
        inputStream = null;
        if (args == null) {
            SaveForm.handleUnsaveForms(currentGUI, commonValues, decode_pdf);
            if (Printer.isPrinting()) {
                currentGUI.showMessageDialog(Messages.getMessage("PdfViewerPrintWait.message"));
            } else if (Values.isProcessing()) {
                currentGUI.showMessageDialog(Messages.getMessage("PdfViewerDecodeWait.message"));
            } else {
                JavaFXOpenFile.selectFile(commonValues, searchFrame, currentGUI, decode_pdf, properties, thumbnails);
                commonValues.setFileIsURL(false);
            }
        } else if (args.length == 2 && args[0] instanceof byte[] && args[1] instanceof String) {
            byte[] data = (byte[])args[0];
            String filename = (String)args[1];
            commonValues.setFileSize(data.length);
            commonValues.setSelectedFile(filename);
            currentGUI.setViewerTitle(null);
            if (commonValues.getSelectedFile() != null && !Values.isProcessing()) {
                decode_pdf.resetViewableArea();
                try {
                    String memFlag;
                    isPDf = true;
                    commonValues.setMultiTiff(false);
                    String hiresFlag = System.getProperty("org.jpedal.hires");
                    if (DecoderOptions.hires || hiresFlag != null) {
                        commonValues.setUseHiresImage(true);
                    }
                    if ((memFlag = System.getProperty("org.jpedal.memory")) != null) {
                        commonValues.setUseHiresImage(false);
                    }
                    thumbnails.resetToDefault();
                    currentGUI.setNoPagesDecoded();
                    if (searchFrame != null) {
                        searchFrame.removeSearchWindow(false);
                    }
                    commonValues.maxViewY = 0;
                    currentGUI.setQualityBoxVisible(isPDf);
                    commonValues.setCurrentPage(1);
                    if (currentGUI.isSingle()) {
                        decode_pdf.closePdfFile();
                    }
                    decode_pdf.openPdfArray(data);
                    currentGUI.updateStatusMessage("opening file");
                    boolean fileCanBeOpened = true;
                    if (decode_pdf.isEncrypted() && !decode_pdf.isFileViewable()) {
                        fileCanBeOpened = false;
                        String password = System.getProperty("org.jpedal.password");
                        if (password == null) {
                            password = currentGUI.showInputDialog(Messages.getMessage("PdfViewerPassword.message"));
                        }
                        if (password != null) {
                            decode_pdf.setEncryptionPassword(password);
                            if (decode_pdf.isFileViewable()) {
                                fileCanBeOpened = true;
                            }
                        }
                        if (!fileCanBeOpened) {
                            currentGUI.showMessageDialog(Messages.getMessage("PdfViewerPasswordRequired.message"));
                        }
                    }
                    if (fileCanBeOpened) {
                        if (properties.getValue("Recentdocuments").equals("true")) {
                            properties.addRecentDocument(commonValues.getSelectedFile());
                            currentGUI.getRecentDocument().updateRecentDocuments(properties.getRecentDocuments());
                        }
                        currentGUI.getRecentDocument().addToFileList(commonValues.getSelectedFile());
                        commonValues.setCurrentPage(1);
                    }
                    JavaFXOpenFile.processPage(commonValues, decode_pdf, currentGUI, thumbnails);
                }
                catch (PdfException e) {
                    LogWriter.writeLog("Exception attempting to open file: " + e);
                }
            }
        } else if (args.length >= 1) {
            if (args[0] instanceof InputStream) {
                inputStream = (InputStream)args[0];
                String newFile = "InputStream-" + System.currentTimeMillis() + ".pdf";
                commonValues.setSelectedFile(newFile);
                commonValues.setFileIsURL(true);
                if (inputStream != null) {
                    try {
                        commonValues.setFileSize(0L);
                        currentGUI.setViewerTitle(null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (!Values.isProcessing()) {
                        thumbnails.terminateDrawing();
                        decode_pdf.flushObjectValues(true);
                        decode_pdf.resetViewableArea();
                        currentGUI.stopThumbnails();
                        try {
                            JavaFXOpenFile.openFile(commonValues.getSelectedFile(), commonValues, searchFrame, currentGUI, decode_pdf, properties, thumbnails);
                            while (Values.isProcessing()) {
                                Thread.sleep(1000L);
                            }
                        }
                        catch (InterruptedException e) {
                            LogWriter.writeLog("Exception attempting to open file: " + e);
                        }
                    }
                }
            } else {
                File file;
                if (args[0] instanceof File) {
                    file = (File)args[0];
                } else if (args[0] instanceof String) {
                    String filename = (String)args[0];
                    char[] str = filename.toCharArray();
                    if (str[1] == ':' || str[0] == '\\' || str[0] == '/') {
                        file = new File(filename);
                    } else {
                        String parent = new File(commonValues.getSelectedFile()).getParent();
                        file = new File(parent, filename);
                        try {
                            file = file.getCanonicalFile();
                        }
                        catch (Exception e) {
                            LogWriter.writeLog("Exception in opening file " + e);
                            file = new File(parent, filename);
                        }
                    }
                } else {
                    file = null;
                }
                if (file != null) {
                    try {
                        commonValues.setInputDir(file.getParentFile().getCanonicalPath());
                        JavaFXOpenFile.open(file.getAbsolutePath(), commonValues, searchFrame, currentGUI, decode_pdf, properties, thumbnails);
                        String bookmarkPage = null;
                        if (args.length > 1 && args[1] instanceof String) {
                            String bookmark = (String)args[1];
                            bookmarkPage = decode_pdf.getIO().convertNameToRef(bookmark);
                        }
                        if (bookmarkPage != null) {
                            OutlineObject namedDest = new OutlineObject(bookmarkPage);
                            decode_pdf.getIO().readObject(namedDest);
                            decode_pdf.getFormRenderer().getActionHandler().gotoDest(namedDest, 3, 339034948);
                        }
                        while (Values.isProcessing()) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    catch (IOException e1) {
                        LogWriter.writeLog("Exception attempting to open file: " + e1);
                    }
                } else {
                    currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.NoSelection"));
                }
            }
        }
    }

    public static void executeOpenURL(Object[] args, Values commonValues, GUISearchWindow searchFrame, GUIFactory currentGUI, PdfDecoderInt decode_pdf, PropertiesFile properties, GUIThumbnailPanel thumbnails) {
        inputStream = null;
        if (args == null) {
            SaveForm.handleUnsaveForms(currentGUI, commonValues, decode_pdf);
            String newFile = JavaFXOpenFile.selectURL(commonValues, searchFrame, currentGUI, decode_pdf, properties, thumbnails);
            if (newFile != null) {
                commonValues.setSelectedFile(newFile);
                commonValues.setFileIsURL(true);
            }
        } else {
            currentGUI.resetNavBar();
            String newFile = (String)args[0];
            if (newFile != null) {
                commonValues.setSelectedFile(newFile);
                commonValues.setFileIsURL(true);
                boolean failed = false;
                try {
                    URL testExists = new URL(newFile);
                    URLConnection conn = testExists.openConnection();
                    if (conn.getContent() == null) {
                        failed = true;
                    }
                }
                catch (Exception e) {
                    failed = true;
                    LogWriter.writeLog("Unable to open as URL " + newFile + ' ' + e);
                }
                if (failed) {
                    newFile = null;
                }
                if (newFile != null) {
                    commonValues.setFileSize(0L);
                    currentGUI.setViewerTitle(null);
                    if (!Values.isProcessing()) {
                        thumbnails.terminateDrawing();
                        decode_pdf.flushObjectValues(true);
                        decode_pdf.resetViewableArea();
                        currentGUI.stopThumbnails();
                        try {
                            OpenFile.openFile(commonValues.getSelectedFile(), commonValues, searchFrame, currentGUI, decode_pdf, properties, thumbnails);
                            while (Values.isProcessing()) {
                                Thread.sleep(1000L);
                            }
                        }
                        catch (InterruptedException e) {
                            LogWriter.writeLog("Exception attempting to open file: " + e);
                        }
                    }
                }
            }
        }
    }

    public static void openFile(String selectedFile, Values commonValues, GUISearchWindow searchFrame, final GUIFactory currentGUI, PdfDecoderInt decode_pdf, PropertiesFile properties, GUIThumbnailPanel thumbnails) {
        String memFlag;
        isPDf = false;
        commonValues.setMultiTiff(false);
        String hiresFlag = System.getProperty("org.jpedal.hires");
        if (DecoderOptions.hires || hiresFlag != null) {
            commonValues.setUseHiresImage(true);
        }
        if ((memFlag = System.getProperty("org.jpedal.memory")) != null) {
            commonValues.setUseHiresImage(false);
        }
        thumbnails.resetToDefault();
        currentGUI.setNoPagesDecoded();
        if (searchFrame != null) {
            searchFrame.removeSearchWindow(false);
        }
        commonValues.maxViewY = 0;
        String ending = selectedFile.toLowerCase().trim();
        commonValues.setPDF(ending.endsWith(".pdf") || ending.endsWith(".fdf"));
        if (ending.endsWith(".pdf") || ending.endsWith(".fdf")) {
            isPDf = true;
        }
        if (!commonValues.isPDF()) {
            if (Platform.isFxApplicationThread()) {
                currentGUI.setDisplayView(1, 2);
            } else {
                Runnable doPaintComponent = new Runnable(){

                    @Override
                    public void run() {
                        currentGUI.setDisplayView(1, 2);
                    }
                };
                Platform.runLater((Runnable)doPaintComponent);
            }
        }
        currentGUI.setQualityBoxVisible(commonValues.isPDF());
        commonValues.setCurrentPage(1);
        try {
            boolean fileCanBeOpened = JavaFXOpenFile.openUpFile(commonValues.getSelectedFile(), commonValues, searchFrame, currentGUI, decode_pdf, properties, thumbnails);
            if (fileCanBeOpened) {
                JavaFXOpenFile.processPage(commonValues, decode_pdf, currentGUI, thumbnails);
            } else {
                currentGUI.setViewerTitle(Messages.getMessage("PdfViewer.NoFile"));
                decode_pdf.getDynamicRenderer().flush();
                decode_pdf.getPages().refreshDisplay();
                currentGUI.scaleAndRotate();
                commonValues.setPageCount(1);
                commonValues.setCurrentPage(1);
            }
        }
        catch (Exception e) {
            LogWriter.writeLog(Messages.getMessage("PdfViewerError.Exception") + ' ' + e + ' ' + Messages.getMessage("PdfViewerError.DecodeFile"));
        }
    }

    public static void open(String file, Values commonValues, GUISearchWindow searchFrame, GUIFactory currentGUI, PdfDecoderInt decode_pdf, PropertiesFile properties, GUIThumbnailPanel thumbnails) {
        boolean isURL = file.startsWith("http:") || file.startsWith("file:");
        try {
            if (!isURL) {
                commonValues.setFileIsURL(false);
                commonValues.setFileSize(new File(file).length() >> 10);
            } else {
                commonValues.setFileIsURL(true);
            }
            commonValues.setSelectedFile(file);
            currentGUI.setViewerTitle(null);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " getting paths");
        }
        File testFile = new File(commonValues.getSelectedFile());
        if (!isURL && !testFile.exists()) {
            currentGUI.showMessageDialog(Messages.getMessage("PdfViewerFile.text") + commonValues.getSelectedFile() + Messages.getMessage("PdfViewerNotExist"));
        } else if (commonValues.getSelectedFile() != null && !Values.isProcessing()) {
            if (currentGUI.isSingle()) {
                decode_pdf.flushObjectValues(true);
            } else {
                decode_pdf = MultiPages.openNewMultiplePage(currentGUI, commonValues);
            }
            JavaFXOpenFile.openFile(commonValues.getSelectedFile(), commonValues, searchFrame, currentGUI, decode_pdf, properties, thumbnails);
        }
    }

    public static void processPage(Values commonValues, PdfDecoderInt decode_pdf, GUIFactory currentGUI, GUIThumbnailPanel thumbnails) {
        if (commonValues.isPDF() && (decode_pdf.isOpen() || !commonValues.isPDF() || decode_pdf.getJPedalObject(2004845231) != null)) {
            PdfFileInformation currentFileInformation = decode_pdf.getFileInformationData();
            decode_pdf.setRenderMode(3);
            String[] values = currentFileInformation.getFieldValues();
            String[] fields = PdfFileInformation.getFieldNames();
            String[] ocr = new String[]{"TeleForm", "dgn2pdf"};
            for (int i = 0; i < fields.length; ++i) {
                if (!fields[i].equals("Creator") && !fields[i].equals("Producer")) continue;
                for (String anOcr : ocr) {
                    if (!values[i].equals(anOcr)) continue;
                    decode_pdf.setRenderMode(2);
                }
                if (!values[i].equals("ABBYY FineReader 8.0 Professional Edition")) continue;
                decode_pdf.setRenderMode(35);
            }
            boolean currentProcessingStatus = Values.isProcessing();
            Values.setProcessing(true);
            if (commonValues.isUseHiresImage()) {
                decode_pdf.useHiResScreenDisplay(true);
                ((GUI)currentGUI).setSelectedComboIndex(250, 1);
            } else {
                decode_pdf.useHiResScreenDisplay(false);
                ((GUI)currentGUI).setSelectedComboIndex(250, 0);
            }
            Values.setProcessing(currentProcessingStatus);
        }
        if (commonValues.isPDF()) {
            commonValues.setPageCount(decode_pdf.getPageCount());
        } else if (!commonValues.isMultiTiff()) {
            commonValues.setPageCount(1);
            decode_pdf.useHiResScreenDisplay(true);
        }
        if (commonValues.getPageCount() < commonValues.getCurrentPage()) {
            commonValues.setCurrentPage(commonValues.getPageCount());
            System.err.println(commonValues.getCurrentPage() + " out of range. Opening on last page");
            LogWriter.writeLog(commonValues.getCurrentPage() + " out of range. Opening on last page");
        }
        decode_pdf.setExtractionMode(1, currentGUI.getScaling());
        currentGUI.setPageNumber();
        currentGUI.resetRotationBox();
        if (commonValues.isPDF()) {
            currentGUI.decodePage();
        } else {
            currentGUI.scaleAndRotate();
            Images.decodeImage(DecoderOptions.hires, decode_pdf, currentGUI, thumbnails, commonValues);
            Values.setProcessing(false);
        }
    }

    public static boolean openUpFile(String selectedFile, final Values commonValues, GUISearchWindow searchFrame, final GUIFactory currentGUI, final PdfDecoderInt decode_pdf, PropertiesFile properties, final GUIThumbnailPanel thumbnails) throws PdfException {
        commonValues.maxViewY = 0;
        searchFrame.resetSearchWindow();
        commonValues.setMultiTiff(false);
        boolean fileCanBeOpened = true;
        if (currentGUI.isSingle()) {
            decode_pdf.closePdfFile();
        }
        try {
            if (commonValues.isPDF()) {
                block41: {
                    if (inputStream != null || selectedFile.startsWith("http") || selectedFile.startsWith("file:") || selectedFile.startsWith("jar:")) {
                        try {
                            boolean isLinearized = false;
                            if (inputStream != null) {
                                isLinearized = true;
                            } else if (commonValues.getModeOfOperation() != 1) {
                                isLinearized = JavaFXOpenFile.isPDFLinearized(commonValues.getSelectedFile());
                            }
                            if (!isLinearized) {
                                if (commonValues.getSelectedFile().startsWith("jar:")) {
                                    InputStream is = Commands.class.getClass().getResourceAsStream(commonValues.getSelectedFile().substring(4));
                                    decode_pdf.openPdfFileFromInputStream(is, false);
                                } else {
                                    final DownloadProgress dlp = new DownloadProgress(commonValues.getSelectedFile());
                                    Thread t = new Thread(){

                                        @Override
                                        public void run() {
                                            while (dlp.isDownloading()) {
                                                if (Platform.isFxApplicationThread()) {
                                                    currentGUI.setDownloadProgress("download", dlp.getProgress());
                                                } else {
                                                    Platform.runLater((Runnable)new Runnable(){

                                                        @Override
                                                        public void run() {
                                                            currentGUI.setDownloadProgress("download", dlp.getProgress());
                                                        }
                                                    });
                                                }
                                                try {
                                                    Thread.sleep(500L);
                                                }
                                                catch (Exception e) {
                                                    LogWriter.writeLog("Exception attempting to open file: " + e);
                                                }
                                            }
                                        }
                                    };
                                    t.setDaemon(true);
                                    t.start();
                                    dlp.startDownload();
                                    File tempFile = dlp.getFile();
                                    decode_pdf.openPdfFile(tempFile.getCanonicalPath());
                                }
                                break block41;
                            }
                            currentGUI.setViewerTitle("Loading linearized PDF " + commonValues.getSelectedFile());
                            if (inputStream != null) {
                                decode_pdf.openPdfFileFromInputStream(inputStream, true);
                            } else {
                                decode_pdf.openPdfFileFromURL(commonValues.getSelectedFile(), true);
                            }
                            PdfObject linearObj = (PdfObject)decode_pdf.getJPedalObject(2004845231);
                            int linearfileLength = linearObj.getInt(28);
                            StringBuilder message = new StringBuilder("Downloading ");
                            if ((linearfileLength /= 1024) < 1024) {
                                message.append(linearfileLength).append(" kB");
                            } else {
                                message.append(linearfileLength /= 1024).append(" M");
                            }
                            final String fMessage = message.toString();
                            Thread fullReaderer = new Thread(){

                                @Override
                                public void run() {
                                    LinearThread linearizedBackgroundReaderer = (LinearThread)decode_pdf.getJPedalObject(-1276915978);
                                    while (linearizedBackgroundReaderer != null && linearizedBackgroundReaderer.isAlive()) {
                                        try {
                                            Thread.sleep(1000L);
                                        }
                                        catch (InterruptedException e) {
                                            e.printStackTrace();
                                        }
                                        currentGUI.setDownloadProgress(fMessage, linearizedBackgroundReaderer.getPercentageLoaded());
                                    }
                                    currentGUI.setDownloadProgress(fMessage, 100);
                                    JavaFXOpenFile.processPage(commonValues, decode_pdf, currentGUI, thumbnails);
                                }
                            };
                            fullReaderer.setDaemon(true);
                            fullReaderer.start();
                        }
                        catch (Exception e) {
                            currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.UrlError") + " file=" + selectedFile + '\n' + e.getMessage());
                            decode_pdf.closePdfFile();
                            fileCanBeOpened = false;
                        }
                    } else {
                        try {
                            decode_pdf.openPdfFile(commonValues.getSelectedFile());
                        }
                        catch (RuntimeException e) {
                            String message = e.getMessage() != null && e.getMessage().contains("bouncycastle") ? e.getMessage() : "Exception in code " + e.getMessage() + " please send to IDRsolutions";
                            currentGUI.showMessageDialog(message);
                            LogWriter.writeLog("Exception " + e.getMessage());
                        }
                        if (decode_pdf.getPageCount() <= 1) {
                            currentGUI.getButtons().setPageLayoutButtonsEnabled(false);
                        }
                    }
                }
                currentGUI.reinitThumbnails();
            } else {
                boolean isURL;
                decode_pdf.resetForNonPDFPage(1);
                JavaFXPageNavigator.setLastPageDecoded(1);
                boolean isTiff = selectedFile.toLowerCase().contains(".tif");
                boolean bl = isURL = selectedFile.startsWith("http:") || selectedFile.startsWith("file:");
                if (isTiff) {
                    try {
                        JavaFXPageNavigator.setTiffHelper(new TiffHelper(commonValues.getSelectedFile()));
                        int pageCount = JavaFXPageNavigator.getTiffHelper().getTiffPageCount();
                        commonValues.setTiffImageToLoad(0);
                        if (pageCount > 1) {
                            decode_pdf.resetForNonPDFPage(pageCount);
                            commonValues.setPageCount(pageCount);
                            JavaFXPageNavigator.setLastPageDecoded(1);
                            commonValues.setMultiTiff(true);
                            commonValues.setMultiTiff(true);
                        }
                        JavaFXPageNavigator.drawMultiPageTiff(commonValues, decode_pdf);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        LogWriter.writeLog("Exception " + e + Messages.getMessage("PdfViewerError.Loading") + commonValues.getSelectedFile());
                    }
                } else {
                    try {
                        if (isURL) {
                            commonValues.setBufferedImg(ImageIO.read(new URL(selectedFile)));
                        } else {
                            commonValues.setBufferedImg(ImageIO.read(new File(selectedFile)));
                        }
                    }
                    catch (Exception e) {
                        LogWriter.writeLog("Exception " + e + "loading " + commonValues.getSelectedFile());
                    }
                }
            }
            currentGUI.updateStatusMessage("opening file");
            if (fileCanBeOpened && decode_pdf.isEncrypted() && !decode_pdf.isFileViewable()) {
                fileCanBeOpened = false;
                String password = System.getProperty("org.jpedal.password");
                if (password == null) {
                    password = currentGUI.showInputDialog(Messages.getMessage("PdfViewerPassword.message"));
                }
                if (password != null) {
                    decode_pdf.setEncryptionPassword(password);
                    if (decode_pdf.isFileViewable()) {
                        fileCanBeOpened = true;
                    }
                }
                if (!fileCanBeOpened) {
                    currentGUI.showMessageDialog(Messages.getMessage("PdfViewerPasswordRequired.message"));
                }
            }
            currentGUI.setBookmarks(true);
            if (fileCanBeOpened) {
                if (properties.getValue("Recentdocuments").equals("true")) {
                    properties.addRecentDocument(commonValues.getSelectedFile());
                    currentGUI.getRecentDocument().updateRecentDocuments(properties.getRecentDocuments());
                }
                currentGUI.getRecentDocument().addToFileList(commonValues.getSelectedFile());
                commonValues.setCurrentPage(1);
            }
        }
        catch (PdfException e) {
            LogWriter.writeLog("Exception " + e + " opening file");
            if (currentGUI.isSingle()) {
                if (GUI.showMessages) {
                    System.out.println("ErrorDialog in JavaFXOpenFile.java needs JavaFX Rewrite of Error Dialog class");
                }
                JavaFXExit.exit(thumbnails, currentGUI, commonValues, decode_pdf, properties);
            }
            throw e;
        }
        if (!decode_pdf.isOpen() && commonValues.isPDF() && decode_pdf.getJPedalObject(2004845231) == null) {
            return false;
        }
        return fileCanBeOpened;
    }

    public static void selectFile(Values commonValues, GUISearchWindow searchFrame, GUIFactory currentGUI, PdfDecoderInt decode_pdf, PropertiesFile properties, GUIThumbnailPanel thumbnails) {
        File existDirectory;
        if (searchFrame != null) {
            searchFrame.removeSearchWindow(false);
        }
        FileChooser chooser = new FileChooser();
        chooser.setTitle("Open PDF file");
        if (file != null && (existDirectory = file.getParentFile()).exists()) {
            chooser.setInitialDirectory(existDirectory);
        }
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("PDF files (*.pdf)", new String[]{"*.pdf"});
        chooser.getExtensionFilters().add((Object)extFilter);
        file = chooser.showOpenDialog((Window)((Stage)currentGUI.getFrame()));
        if (file != null) {
            boolean isValid;
            String ext = file.getName().toLowerCase();
            boolean bl = isValid = ext.endsWith(".pdf") || ext.endsWith(".fdf") || ext.endsWith(".tif") || ext.endsWith(".tiff") || ext.endsWith(".png") || ext.endsWith(".jpg") || ext.endsWith(".jpeg");
            if (isValid) {
                try {
                    commonValues.setInputDir(file.getCanonicalPath());
                    JavaFXOpenFile.open(file.getAbsolutePath(), commonValues, searchFrame, currentGUI, decode_pdf, properties, thumbnails);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            } else {
                currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NotValidPdfWarning"));
            }
        } else {
            currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.NoSelection"));
        }
    }

    public static final boolean isPDFLinearized(String pdfUrl) {
        if (pdfUrl.startsWith("jar")) {
            return false;
        }
        boolean isLinear = false;
        try {
            URL url = new URL(pdfUrl);
            InputStream is = url.openStream();
            byte[] buffer = new byte[128];
            is.read(buffer);
            is.close();
            int len = buffer.length;
            for (int i = 0; i < len; ++i) {
                if (buffer[i] != 47 || buffer[i + 1] != 76 || buffer[i + 2] != 105 || buffer[i + 3] != 110 || buffer[i + 4] != 101 || buffer[i + 5] != 97 || buffer[i + 6] != 114) continue;
                isLinear = true;
                i = len;
            }
        }
        catch (IOException e) {
            LogWriter.writeLog("[PDF] Exception " + e + " scanning URL " + pdfUrl);
        }
        return isLinear;
    }

    private static String selectURL(Values commonValues, GUISearchWindow searchFrame, GUIFactory currentGUI, PdfDecoderInt decode_pdf, PropertiesFile properties, GUIThumbnailPanel thumbnails) {
        String selectedFile = currentGUI.showInputDialog(Messages.getMessage("PdfViewerMessage.RequestURL"));
        if (selectedFile != null) {
            selectedFile = selectedFile.trim();
        }
        if (!(selectedFile == null || selectedFile.trim().startsWith("http://") || selectedFile.trim().startsWith("https://") || selectedFile.trim().startsWith("file:/"))) {
            currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.URLMustContain"));
            selectedFile = null;
        }
        if (selectedFile != null) {
            boolean isValid;
            boolean bl = isValid = selectedFile.endsWith(".pdf") || selectedFile.endsWith(".fdf") || selectedFile.endsWith(".tif") || selectedFile.endsWith(".tiff") || selectedFile.endsWith(".png") || selectedFile.endsWith(".jpg") || selectedFile.endsWith(".jpeg");
            if (!isValid) {
                currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NotValidPdfWarning"));
                selectedFile = null;
            }
        }
        if (selectedFile != null) {
            commonValues.setSelectedFile(selectedFile);
            boolean failed = false;
            try {
                URL testExists = new URL(selectedFile);
                URLConnection conn = testExists.openConnection();
                if (conn.getContent() == null) {
                    failed = true;
                }
            }
            catch (Exception e) {
                failed = true;
                LogWriter.writeLog("Exception in handling URL " + e);
            }
            if (failed) {
                selectedFile = null;
                currentGUI.showMessageDialog("URL " + selectedFile + ' ' + Messages.getMessage("PdfViewerError.DoesNotExist"));
            }
        }
        if (selectedFile != null) {
            try {
                commonValues.setFileSize(0L);
                currentGUI.setViewerTitle(null);
            }
            catch (Exception e) {
                System.err.println(Messages.getMessage("PdfViewerError.Exception") + ' ' + e + ' ' + Messages.getMessage("PdfViewerError.GettingPaths"));
            }
            if (selectedFile != null && !Values.isProcessing()) {
                thumbnails.terminateDrawing();
                decode_pdf.flushObjectValues(true);
                if (!currentGUI.isSingle()) {
                    MultiPages.openNewMultiplePage(currentGUI, commonValues);
                }
                OpenFile.openFile(commonValues.getSelectedFile(), commonValues, searchFrame, currentGUI, decode_pdf, properties, thumbnails);
            }
        } else {
            decode_pdf.repaintPane(decode_pdf.getPageNumber());
            currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.NoSelection"));
        }
        return selectedFile;
    }
}

