/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui;

import org.jpedal.examples.viewer.gui.GUI;
import org.jpedal.examples.viewer.gui.generic.GUIButton;
import org.jpedal.examples.viewer.gui.generic.GUIButtons;
import org.jpedal.examples.viewer.gui.generic.GUIMenuItems;
import org.jpedal.examples.viewer.utils.PropertiesFile;
import org.jpedal.gui.GUIFactory;
import org.jpedal.utils.Messages;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GUIModifier {
    private static void setButtonEnabledAndVisible(GUIButtons buttons, int type, boolean set) {
        GUIButton button = buttons.getButton(type);
        if (button != null) {
            button.setEnabled(set);
            button.setVisible(set);
        }
    }

    private static void removeUnwantedTabs(int tabCount, GUIFactory currentGUI, boolean set, String title) {
        for (int i = 0; i < tabCount; ++i) {
            if (!currentGUI.getSidebarTabTitleAt(i).equals(currentGUI.getTitles(title)) || set) continue;
            currentGUI.removeSidebarTabAt(i);
            break;
        }
    }

    private static void loadNodeList(NodeList tags, GUIFactory currentGUI) {
        for (int i = 0; i != tags.getLength(); ++i) {
            Node value;
            Node node = tags.item(i);
            String name = tags.item(i).getNodeName();
            if (name.startsWith("#")) continue;
            if (node.hasAttributes() && (value = node.getAttributes().getNamedItem("value")) != null) {
                if (value.getNodeValue().equalsIgnoreCase("true")) {
                    GUIModifier.alterProperty(name, true, currentGUI);
                } else if (value.getNodeValue().equalsIgnoreCase("false")) {
                    GUIModifier.alterProperty(name, false, currentGUI);
                }
            }
            if (!node.hasChildNodes()) continue;
            GUIModifier.loadNodeList(node.getChildNodes(), currentGUI);
        }
    }

    public static void load(PropertiesFile properties, GUIFactory currentGUI) {
        String value = properties.getValue("sideTabBarCollapseLength");
        if (value != null && !value.isEmpty()) {
            int iValue = Integer.parseInt(value);
            currentGUI.setStartSize(iValue);
        }
        if ((value = properties.getValue("sideTabBarExpandLength")) != null && !value.isEmpty()) {
            GUI.expandedSize = Integer.parseInt(value);
            currentGUI.reinitialiseTabs(false);
        }
        NodeList tags = properties.getChildren("*");
        GUIModifier.loadNodeList(tags, currentGUI);
    }

    private static boolean alterSectionProperties(String value, boolean set, GUIFactory currentGUI, boolean isSingle) {
        int propertyCode = value.hashCode();
        boolean used = true;
        switch (propertyCode) {
            case -1288571785: {
                currentGUI.getMenuItems().setMenuItem(300, set, set);
                break;
            }
            case -1997587036: {
                currentGUI.getButtons().setEnabled(set);
                currentGUI.getButtons().setVisible(set);
                break;
            }
            case -1964157927: {
                break;
            }
            case -570400414: {
                currentGUI.enableNavigationBar(set, set);
                break;
            }
            case -291765390: {
                if (isSingle) {
                    if (!set) {
                        currentGUI.setupSplitPaneDivider(0, set);
                    } else {
                        currentGUI.setupSplitPaneDivider(5, set);
                    }
                }
            }
            default: {
                used = false;
            }
        }
        return used;
    }

    private static boolean alterNavButtonProperties(String value, boolean set, GUIFactory currentGUI) {
        int propertyCode = value.hashCode();
        boolean used = true;
        switch (propertyCode) {
            case 1059672251: {
                GUIModifier.setButtonEnabledAndVisible(currentGUI.getButtons(), 50, set);
                break;
            }
            case 1380437777: {
                GUIModifier.setButtonEnabledAndVisible(currentGUI.getButtons(), 51, set);
                break;
            }
            case 515502578: {
                GUIModifier.setButtonEnabledAndVisible(currentGUI.getButtons(), 52, set);
                break;
            }
            case -1183571602: {
                currentGUI.enablePageCounter(GUI.PageCounter.ALL, set, set);
                break;
            }
            case 830895376: {
                GUIModifier.setButtonEnabledAndVisible(currentGUI.getButtons(), 53, set);
                break;
            }
            case -469761361: {
                GUIModifier.setButtonEnabledAndVisible(currentGUI.getButtons(), 54, set);
                break;
            }
            case 63127649: {
                GUIModifier.setButtonEnabledAndVisible(currentGUI.getButtons(), 55, set);
                break;
            }
            default: {
                used = false;
            }
        }
        return used;
    }

    private static boolean alterDisplayButtonProperties(String value, boolean set, GUIFactory currentGUI) {
        int propertyCode = value.hashCode();
        boolean used = true;
        switch (propertyCode) {
            case -1897980781: {
                currentGUI.getButtons().getButton(57).setVisible(set);
                break;
            }
            case 473819674: {
                currentGUI.getButtons().getButton(58).setVisible(set);
                break;
            }
            case 1992490804: {
                currentGUI.getButtons().getButton(59).setVisible(set);
                break;
            }
            case 1722020517: {
                currentGUI.getButtons().getButton(60).setVisible(set);
                break;
            }
            case 1943135464: {
                currentGUI.getButtons().getButton(61).setVisible(set);
                break;
            }
            case 1279272588: {
                currentGUI.enableMemoryBar(set, set);
                break;
            }
            default: {
                used = false;
            }
        }
        return used;
    }

    private static boolean alterOptionPaneProperties(String value, boolean set, GUIFactory currentGUI) {
        int propertyCode = value.hashCode();
        boolean used = true;
        switch (propertyCode) {
            case 1227109243: {
                currentGUI.getCombo(252).setEnabled(set);
                currentGUI.getCombo(252).setVisibility(set);
                break;
            }
            case -1359743132: {
                currentGUI.getCombo(251).setEnabled(set);
                currentGUI.getCombo(251).setVisibility(set);
                break;
            }
            case 1227511014: {
                currentGUI.getCombo(250).setEnabled(set);
                currentGUI.getCombo(250).setVisibility(set);
                break;
            }
            case -2080788011: {
                currentGUI.enableStatusBar(set, set);
                break;
            }
            case -676468659: {
                currentGUI.enableDownloadBar(set, set);
                break;
            }
            default: {
                used = false;
            }
        }
        return used;
    }

    private static boolean alterButtonBarProperties(String value, boolean set, GUIFactory currentGUI) {
        int propertyCode = value.hashCode();
        boolean used = true;
        switch (propertyCode) {
            case -1792397928: {
                GUIModifier.setButtonEnabledAndVisible(currentGUI.getButtons(), 10, set);
                break;
            }
            case 1765018623: {
                GUIModifier.setButtonEnabledAndVisible(currentGUI.getButtons(), 6, set);
                break;
            }
            case 715064058: {
                GUIModifier.setButtonEnabledAndVisible(currentGUI.getButtons(), 12, set);
                break;
            }
            case 255067717: {
                GUIModifier.setButtonEnabledAndVisible(currentGUI.getButtons(), 9, set);
                break;
            }
            case -1141287713: {
                GUIModifier.setButtonEnabledAndVisible(currentGUI.getButtons(), 1, set);
                break;
            }
            case 1865770518: {
                GUIModifier.setButtonEnabledAndVisible(currentGUI.getButtons(), 13, set);
                break;
            }
            case 1486773674: {
                GUIModifier.setButtonEnabledAndVisible(currentGUI.getButtons(), 63, set);
                break;
            }
            case -1547539123: {
                GUIModifier.setButtonEnabledAndVisible(currentGUI.getButtons(), 64, set);
                break;
            }
            case -649945645: {
                GUIModifier.setButtonEnabledAndVisible(currentGUI.getButtons(), 998, set);
                break;
            }
            case 0x7477E4: {
                GUIModifier.setButtonEnabledAndVisible(currentGUI.getButtons(), 997, set);
                break;
            }
            case -2082069944: {
                currentGUI.enableCursor(set, set);
                break;
            }
            case -655864550: {
                GUIModifier.setButtonEnabledAndVisible(currentGUI.getButtons(), 29, set);
                break;
            }
            default: {
                used = false;
            }
        }
        return used;
    }

    private static boolean alterSideBarProperties(String value, boolean set, GUIFactory currentGUI) {
        int propertyCode = value.hashCode();
        boolean used = true;
        int tabCount = currentGUI.getSidebarTabCount();
        if (tabCount != 0) {
            switch (propertyCode) {
                case 861124230: {
                    GUIModifier.removeUnwantedTabs(tabCount, currentGUI, set, Messages.getMessage("PdfViewerJPanel.thumbnails"));
                    break;
                }
                case 2116514968: {
                    GUIModifier.removeUnwantedTabs(tabCount, currentGUI, set, Messages.getMessage("PdfViewerJPanel.bookmarks"));
                    break;
                }
                case 340454131: {
                    GUIModifier.removeUnwantedTabs(tabCount, currentGUI, set, Messages.getMessage("PdfViewerJPanel.layers"));
                    break;
                }
                case -1855474982: {
                    GUIModifier.removeUnwantedTabs(tabCount, currentGUI, set, Messages.getMessage("PdfViewerJPanel.signatures"));
                    break;
                }
                default: {
                    used = false;
                }
            }
        }
        return used;
    }

    private static void alterMenuBarProperties(String value, boolean set, GUIFactory currentGUI, boolean isSingle) {
        boolean skipOthers = GUIModifier.alterFileMenuItemProperties(value, set, currentGUI, currentGUI.getMenuItems());
        if (!skipOthers) {
            skipOthers = GUIModifier.alterEditMenuItemProperties(value, set, currentGUI.getMenuItems());
        }
        if (!skipOthers) {
            skipOthers = GUIModifier.alterViewMenuItemProperties(value, set, isSingle, currentGUI.getMenuItems());
        }
        if (!skipOthers) {
            skipOthers = GUIModifier.alterWindowMenuItemProperties(value, set, currentGUI.getMenuItems());
        }
        if (!skipOthers) {
            skipOthers = GUIModifier.alterExportMenuItemProperties(value, set, currentGUI.getMenuItems());
        }
        if (!skipOthers) {
            skipOthers = GUIModifier.alterHelpMenuItemProperties(value, set, currentGUI.getMenuItems());
        }
        if (skipOthers) {
            currentGUI.getButtons().checkButtonSeparators();
        }
    }

    private static boolean alterEditMenuItemProperties(String value, boolean set, GUIMenuItems menuItems) {
        int propertyCode = value.hashCode();
        boolean used = true;
        switch (propertyCode) {
            case 1666467497: {
                menuItems.setMenuItem(310, set, set);
                break;
            }
            case 2106261: {
                menuItems.setMenuItem(25, set, set);
                break;
            }
            case 287994629: {
                menuItems.setMenuItem(26, set, set);
                break;
            }
            case -2022608988: {
                menuItems.setMenuItem(27, set, set);
                break;
            }
            case -637237544: {
                menuItems.setMenuItem(24, set, set);
                break;
            }
            default: {
                used = false;
            }
        }
        return used;
    }

    private static boolean alterViewMenuItemProperties(String value, boolean set, boolean isSingle, GUIMenuItems menuItems) {
        boolean skipOthers = GUIModifier.alterPageNavMenuItemProperties(value, set, menuItems);
        if (!skipOthers) {
            skipOthers = GUIModifier.alterPageDisplayMenuItemProperties(value, set, isSingle, menuItems);
        }
        if (!skipOthers) {
            skipOthers = GUIModifier.alterDisplayOptionMenuItemProperties(value, set, menuItems);
        }
        return skipOthers;
    }

    private static boolean alterPageNavMenuItemProperties(String value, boolean set, GUIMenuItems menuItems) {
        int propertyCode = value.hashCode();
        boolean used = true;
        switch (propertyCode) {
            case 1260277188: {
                menuItems.setMenuItem(312, set, set);
                break;
            }
            case -1954937470: {
                menuItems.setMenuItem(311, set, set);
                break;
            }
            case 2137816351: {
                menuItems.setMenuItem(50, set, set);
                break;
            }
            case -2108555242: {
                menuItems.setMenuItem(52, set, set);
                break;
            }
            case -973032780: {
                menuItems.setMenuItem(53, set, set);
                break;
            }
            case -1393942971: {
                menuItems.setMenuItem(55, set, set);
                break;
            }
            case 2225539: {
                menuItems.setMenuItem(56, set, set);
                break;
            }
            case -1193154254: {
                menuItems.setMenuItem(16, set, set);
                break;
            }
            case -81326802: {
                menuItems.setMenuItem(17, set, set);
                break;
            }
            default: {
                used = false;
            }
        }
        return used;
    }

    private static boolean alterPageDisplayMenuItemProperties(String value, boolean set, boolean isSingle, GUIMenuItems menuItems) {
        int propertyCode = value.hashCode();
        boolean used = true;
        switch (propertyCode) {
            case -536713320: {
                if (!isSingle) break;
                menuItems.setMenuItem(309, set, set);
                break;
            }
            case -1818398616: {
                if (!isSingle) break;
                menuItems.setMenuItem(57, set, set);
                break;
            }
            case -1922388177: {
                if (!isSingle) break;
                menuItems.setMenuItem(58, set, set);
                break;
            }
            case 2096675834: {
                if (!isSingle) break;
                menuItems.setMenuItem(60, set, set);
                break;
            }
            case 574889929: {
                if (!isSingle) break;
                menuItems.setMenuItem(59, set, set);
                break;
            }
            case 923688061: {
                if (!isSingle || !menuItems.isMenuItemExist(61)) break;
                menuItems.setMenuItem(61, set, set);
                break;
            }
            default: {
                used = false;
            }
        }
        return used;
    }

    private static boolean alterDisplayOptionMenuItemProperties(String value, boolean set, GUIMenuItems menuItems) {
        int propertyCode = value.hashCode();
        boolean used = true;
        switch (propertyCode) {
            case -797784096: {
                if (!menuItems.isMenuItemExist(30)) break;
                menuItems.setMenuItem(30, set, set);
                break;
            }
            case 1837830281: {
                if (!menuItems.isMenuItemExist(31)) break;
                menuItems.setMenuItem(31, set, set);
                break;
            }
            case 2103531483: {
                menuItems.setMenuItem(62, set, set);
                break;
            }
            case -315597228: {
                if (!menuItems.isMenuItemExist(32)) break;
                menuItems.setMenuItem(32, set, set);
                break;
            }
            default: {
                used = false;
            }
        }
        return used;
    }

    private static boolean alterWindowMenuItemProperties(String value, boolean set, GUIMenuItems menuItems) {
        int propertyCode = value.hashCode();
        boolean used = true;
        switch (propertyCode) {
            case -439170673: {
                if (!menuItems.isMenuItemExist(308)) break;
                menuItems.setMenuItem(308, set, set);
                break;
            }
            case -2075484524: {
                if (!menuItems.isMenuItemExist(308)) break;
                menuItems.setMenuItem(21, set, set);
                break;
            }
            case 2606798: {
                if (!menuItems.isMenuItemExist(308)) break;
                menuItems.setMenuItem(22, set, set);
                break;
            }
            default: {
                used = false;
            }
        }
        return used;
    }

    private static boolean alterExportMenuItemProperties(String value, boolean set, GUIMenuItems menuItems) {
        int propertyCode = value.hashCode();
        boolean used = true;
        switch (propertyCode) {
            case -2092531885: {
                menuItems.setMenuItem(307, set, set);
                break;
            }
            case 945359185: {
                menuItems.setMenuItem(306, set, set);
                break;
            }
            case -344552410: {
                menuItems.setMenuItem(305, set, set);
                break;
            }
            case 78697: {
                menuItems.setMenuItem(510, set, set);
                break;
            }
            case 66818036: {
                menuItems.setMenuItem(511, set, set);
                break;
            }
            case 1278509400: {
                menuItems.setMenuItem(304, set, set);
                break;
            }
            case -2101383528: {
                menuItems.setMenuItem(3, set, set);
                break;
            }
            case 2603341: {
                menuItems.setMenuItem(4, set, set);
                break;
            }
            case 1990057295: {
                menuItems.setMenuItem(2, set, set);
                break;
            }
            case -1535366133: {
                menuItems.setMenuItem(303, set, set);
                break;
            }
            case -747513047: {
                menuItems.setMenuItem(502, set, set);
                break;
            }
            case 561177817: {
                menuItems.setMenuItem(503, set, set);
                break;
            }
            case 516897424: {
                menuItems.setMenuItem(504, set, set);
                break;
            }
            case -835190423: {
                menuItems.setMenuItem(506, set, set);
                break;
            }
            case -271216816: {
                menuItems.setMenuItem(507, set, set);
                break;
            }
            case 172270488: {
                menuItems.setMenuItem(508, set, set);
                break;
            }
            case 2109104: {
                menuItems.setMenuItem(301, set, set);
                break;
            }
            default: {
                used = false;
            }
        }
        return used;
    }

    private static boolean alterHelpMenuItemProperties(String value, boolean set, GUIMenuItems menuItems) {
        int propertyCode = value.hashCode();
        boolean used = true;
        switch (propertyCode) {
            case -725339040: {
                menuItems.setMenuItem(998, set, set);
                break;
            }
            case -1886622448: {
                menuItems.setMenuItem(15, set, set);
                break;
            }
            case -715927651: {
                menuItems.setMenuItem(20, set, set);
                break;
            }
            case 63058797: {
                menuItems.setMenuItem(1, set, set);
                break;
            }
            case -987283872: {
                menuItems.setMenuItem(318, set, set);
                break;
            }
            default: {
                used = false;
            }
        }
        return used;
    }

    private static boolean alterFileMenuItemProperties(String value, boolean set, GUIFactory currentGUI, GUIMenuItems menuItems) {
        int propertyCode = value.hashCode();
        boolean used = true;
        switch (propertyCode) {
            case -671103717: {
                menuItems.setMenuItem(317, set, set);
                break;
            }
            case -440213783: {
                menuItems.setMenuItem(316, set, set);
                break;
            }
            case 2464362: {
                menuItems.setMenuItem(10, set, set);
                break;
            }
            case 401480389: {
                menuItems.setMenuItem(14, set, set);
                break;
            }
            case 2569629: {
                menuItems.setMenuItem(5, set, set);
                break;
            }
            case 172731117: {
                if (!menuItems.isMenuItemExist(315)) break;
                menuItems.setMenuItem(315, set, set);
                break;
            }
            case 2189785: {
                menuItems.setMenuItem(12, set, set);
                break;
            }
            case 1358673070: {
                menuItems.setMenuItem(9, set, set);
                break;
            }
            case -542034443: {
                menuItems.setMenuItem(512, set, set);
                break;
            }
            case 77382285: {
                menuItems.setMenuItem(6, set, set);
                break;
            }
            case 240368285: {
                currentGUI.getRecentDocument().enableRecentDocuments(set);
                break;
            }
            case 2174270: {
                menuItems.setMenuItem(7, set, set);
                break;
            }
            default: {
                used = false;
            }
        }
        return used;
    }

    public static void alterProperty(String value, boolean set, GUIFactory currentGUI) {
        boolean skipOthers = GUIModifier.alterSectionProperties(value, set, currentGUI, currentGUI.isSingle());
        if (!skipOthers) {
            skipOthers = GUIModifier.alterNavButtonProperties(value, set, currentGUI);
        }
        if (!skipOthers) {
            skipOthers = GUIModifier.alterDisplayButtonProperties(value, set, currentGUI);
        }
        if (!skipOthers) {
            skipOthers = GUIModifier.alterOptionPaneProperties(value, set, currentGUI);
        }
        if (!skipOthers) {
            skipOthers = GUIModifier.alterButtonBarProperties(value, set, currentGUI);
        }
        if (!skipOthers) {
            skipOthers = GUIModifier.alterSideBarProperties(value, set, currentGUI);
        }
        if (!skipOthers) {
            GUIModifier.alterMenuBarProperties(value, set, currentGUI, currentGUI.isSingle());
        }
    }
}

