/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui;

import java.awt.datatransfer.Transferable;
import java.beans.PropertyVetoException;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import org.jpedal.examples.viewer.Commands;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.gui.BaseTransferHandler;
import org.jpedal.gui.GUIFactory;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;
import org.jpedal.utils.SwingWorker;

public class MultiViewTransferHandler
extends BaseTransferHandler {
    private int fileCount;

    public MultiViewTransferHandler(Values commonValues, GUIFactory currentGUI, Commands currentCommands) {
        super(commonValues, currentGUI, currentCommands);
    }

    @Override
    public boolean importData(JComponent src, Transferable transferable) {
        try {
            Object dragImport = this.getImport(transferable);
            if (dragImport instanceof String) {
                String url = (String)dragImport;
                System.out.println(url);
                String testURL = url.toLowerCase();
                if (testURL.startsWith("http:/")) {
                    this.currentCommands.handleTransferedFile(testURL);
                    return true;
                }
                if (testURL.startsWith("file:/")) {
                    String[] urls = url.split("file:/");
                    LinkedList<File> files = new LinkedList<File>();
                    for (String file : urls) {
                        if (file.isEmpty()) continue;
                        File file2 = new File(new URL("file:/" + file).getFile());
                        System.out.println(file2);
                        files.add(file2);
                    }
                    return this.openFiles(files);
                }
            } else if (dragImport instanceof List) {
                List files = (List)dragImport;
                return this.openFiles(files);
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception attempting to import data " + e);
        }
        return false;
    }

    private boolean openFiles(List files) {
        this.fileCount = 0;
        List flattenedFiles = this.getFlattenedFiles(files, new ArrayList());
        if (this.fileCount == this.commonValues.getMaxMiltiViewers()) {
            this.currentGUI.showMessageDialog((Object)("You have choosen to import more files than your current set maximum (" + this.commonValues.getMaxMiltiViewers() + ").  Only the first " + this.commonValues.getMaxMiltiViewers() + " files will be imported.\nYou can change this value " + "in View | Preferences"), "Maximum number of files reached", 1);
        }
        List[] filterdFiles = MultiViewTransferHandler.filterFiles(flattenedFiles);
        final List allowedFiles = filterdFiles[0];
        List disAllowedFiles = filterdFiles[1];
        int noOfDisAllowedFiles = disAllowedFiles.size();
        int noOfAllowedFiles = allowedFiles.size();
        if (noOfDisAllowedFiles > 0) {
            StringBuilder unOpenableFiles = new StringBuilder();
            for (Object disAllowedFile : disAllowedFiles) {
                String file = (String)disAllowedFile;
                String fileName = new File(file).getName();
                unOpenableFiles.append(fileName).append('\n');
            }
            int result = this.currentGUI.showConfirmDialog("You have selected " + flattenedFiles.size() + " files to open.  The following file(s) cannot be opened\nas they are not valid PDFs " + "or images.\n" + unOpenableFiles + "\nWould you like to open the remaining " + noOfAllowedFiles + " files?", "File Import", 0, 3);
            if (result == 1) {
                return false;
            }
        }
        SwingWorker worker = new SwingWorker(){

            @Override
            public Object construct() {
                for (Object allowedFile : allowedFiles) {
                    String file = (String)allowedFile;
                    try {
                        MultiViewTransferHandler.this.currentCommands.handleTransferedFile(file);
                    }
                    catch (Exception e) {
                        JInternalFrame[] allFrames;
                        int result;
                        LogWriter.writeLog("Exception e " + e.getMessage());
                        if (allowedFiles.size() == 1) {
                            MultiViewTransferHandler.this.currentGUI.showMessageDialog((Object)Messages.getMessage("PdfViewerOpenerror"), MultiViewTransferHandler.this.commonValues.getSelectedFile(), 0);
                            result = 1;
                        } else {
                            result = MultiViewTransferHandler.this.currentGUI.showConfirmDialog(Messages.getMessage("PdfViewerOpenerror") + ". Continue opening remaining files?", MultiViewTransferHandler.this.commonValues.getSelectedFile(), 0, 3);
                        }
                        for (JInternalFrame internalFrame : allFrames = ((JDesktopPane)MultiViewTransferHandler.this.currentGUI.getMultiViewerFrames()).getAllFrames()) {
                            if (!internalFrame.getTitle().equals(MultiViewTransferHandler.this.commonValues.getSelectedFile())) continue;
                            try {
                                internalFrame.setClosed(true);
                            }
                            catch (PropertyVetoException e1) {
                                LogWriter.writeLog("Exception " + e1 + " attempting getframes");
                            }
                            break;
                        }
                        if (result != 1) continue;
                        return null;
                    }
                }
                return null;
            }
        };
        worker.start();
        return true;
    }

    private static List[] filterFiles(List flattenedFiles) {
        LinkedList<String> allowedFiles = new LinkedList<String>();
        LinkedList<String> disAllowedFiles = new LinkedList<String>();
        for (Object flattenedFile : flattenedFiles) {
            boolean isValid;
            String file = (String)flattenedFile;
            String testFile = file.toLowerCase();
            boolean bl = isValid = testFile.endsWith(".pdf") || testFile.endsWith(".fdf") || testFile.endsWith(".tif") || testFile.endsWith(".tiff") || testFile.endsWith(".png") || testFile.endsWith(".jpg") || testFile.endsWith(".jpeg");
            if (isValid) {
                allowedFiles.add(file);
                continue;
            }
            disAllowedFiles.add(file);
        }
        return new List[]{allowedFiles, disAllowedFiles};
    }

    private List getFlattenedFiles(List files, List flattenedFiles) {
        for (Object file1 : files) {
            if (this.fileCount == this.commonValues.getMaxMiltiViewers()) {
                return flattenedFiles;
            }
            File file = (File)file1;
            if (file.isDirectory()) {
                this.getFlattenedFiles(Arrays.asList(file.listFiles()), flattenedFiles);
                continue;
            }
            flattenedFiles.add(file.getAbsolutePath());
            ++this.fileCount;
        }
        return flattenedFiles;
    }
}

