/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui;

import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.imageio.ImageIO;
import org.jpedal.utils.LogWriter;

public class SwingCursor {
    private String iconLocation = "/org/jpedal/examples/viewer/res/";
    private Cursor grabCursor;
    private Cursor grabbingCursor;
    private Cursor panCursor;
    private Cursor panCursorL;
    private Cursor panCursorTL;
    private Cursor panCursorT;
    private Cursor panCursorTR;
    private Cursor panCursorR;
    private Cursor panCursorBR;
    private Cursor panCursorB;
    private Cursor panCursorBL;

    public Cursor getCursor(int type) {
        switch (type) {
            case 1: {
                if (this.grabCursor == null) {
                    Toolkit kit = Toolkit.getDefaultToolkit();
                    Image img = kit.getImage(this.getURLForImage(this.iconLocation + "grab32.png"));
                    this.grabCursor = kit.createCustomCursor(img, new Point(8, 8), "grab");
                }
                return this.grabCursor;
            }
            case 2: {
                if (this.grabbingCursor == null) {
                    Toolkit kit = Toolkit.getDefaultToolkit();
                    Image img = kit.getImage(this.getURLForImage(this.iconLocation + "grabbing32.png"));
                    this.grabbingCursor = kit.createCustomCursor(img, new Point(8, 8), "grabbing");
                }
                return this.grabbingCursor;
            }
            case 4: {
                if (this.panCursor == null) {
                    Toolkit kit = Toolkit.getDefaultToolkit();
                    Image img = kit.getImage(this.getURLForImage(this.iconLocation + "pan32.png"));
                    this.panCursor = kit.createCustomCursor(img, new Point(10, 10), "pan");
                }
                return this.panCursor;
            }
            case 5: {
                if (this.panCursorL == null) {
                    Toolkit kit = Toolkit.getDefaultToolkit();
                    Image img = kit.getImage(this.getURLForImage(this.iconLocation + "panl32.png"));
                    this.panCursorL = kit.createCustomCursor(img, new Point(11, 10), "panl");
                }
                return this.panCursorL;
            }
            case 6: {
                if (this.panCursorTL == null) {
                    Toolkit kit = Toolkit.getDefaultToolkit();
                    Image img = kit.getImage(this.getURLForImage(this.iconLocation + "pantl32.png"));
                    this.panCursorTL = kit.createCustomCursor(img, new Point(10, 10), "pantl");
                }
                return this.panCursorTL;
            }
            case 7: {
                if (this.panCursorT == null) {
                    Toolkit kit = Toolkit.getDefaultToolkit();
                    Image img = kit.getImage(this.getURLForImage(this.iconLocation + "pant32.png"));
                    this.panCursorT = kit.createCustomCursor(img, new Point(10, 11), "pant");
                }
                return this.panCursorT;
            }
            case 8: {
                if (this.panCursorTR == null) {
                    Toolkit kit = Toolkit.getDefaultToolkit();
                    Image img = kit.getImage(this.getURLForImage(this.iconLocation + "pantr32.png"));
                    this.panCursorTR = kit.createCustomCursor(img, new Point(10, 10), "pantr");
                }
                return this.panCursorTR;
            }
            case 9: {
                if (this.panCursorR == null) {
                    Toolkit kit = Toolkit.getDefaultToolkit();
                    Image img = kit.getImage(this.getURLForImage(this.iconLocation + "panr32.png"));
                    this.panCursorR = kit.createCustomCursor(img, new Point(10, 10), "panr");
                }
                return this.panCursorR;
            }
            case 10: {
                if (this.panCursorBR == null) {
                    Toolkit kit = Toolkit.getDefaultToolkit();
                    Image img = kit.getImage(this.getURLForImage(this.iconLocation + "panbr32.png"));
                    this.panCursorBR = kit.createCustomCursor(img, new Point(10, 10), "panbr");
                }
                return this.panCursorBR;
            }
            case 11: {
                if (this.panCursorB == null) {
                    Toolkit kit = Toolkit.getDefaultToolkit();
                    Image img = kit.getImage(this.getURLForImage(this.iconLocation + "panb32.png"));
                    this.panCursorB = kit.createCustomCursor(img, new Point(10, 10), "panb");
                }
                return this.panCursorB;
            }
            case 12: {
                if (this.panCursorBL == null) {
                    Toolkit kit = Toolkit.getDefaultToolkit();
                    Image img = kit.getImage(this.getURLForImage(this.iconLocation + "panbl32.png"));
                    this.panCursorBL = kit.createCustomCursor(img, new Point(10, 10), "panbl");
                }
                return this.panCursorBL;
            }
        }
        return Cursor.getDefaultCursor();
    }

    public void setIconLocation(String location) {
        this.iconLocation = location;
    }

    public URL getURLForImage(String path) {
        path = this.iconLocation + path;
        String file = path.substring(path.lastIndexOf(47) + 1);
        path = path.substring(0, path.indexOf(46)) + ".gif";
        File p = new File(path);
        URL url = this.getClass().getResource(path);
        if (p.exists()) {
            try {
                url = p.toURI().toURL();
            }
            catch (MalformedURLException e) {
                LogWriter.writeLog("Exception attempting get path for image " + e);
            }
        }
        if (url == null) {
            path = path.substring(0, path.indexOf(46)) + ".png";
            p = new File(path);
            url = this.getClass().getResource(path);
            if (p.exists()) {
                try {
                    url = p.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    LogWriter.writeLog("Exception attempting get path for image " + e);
                }
            }
        }
        if (url != null) {
            return url;
        }
        path = "/org/jpedal/examples/viewer/res/" + file;
        url = this.getClass().getResource(path);
        return url;
    }

    public BufferedImage getCursorImageForFX(int type) {
        switch (type) {
            case 1: {
                try {
                    return ImageIO.read(this.getURLForImage("grab32.png"));
                }
                catch (Exception e) {
                    LogWriter.writeLog("Exception in getting image " + e);
                    return null;
                }
            }
            case 2: {
                try {
                    return ImageIO.read(this.getURLForImage("grabbing32.png"));
                }
                catch (Exception e) {
                    LogWriter.writeLog("Exception in getting image " + e);
                    return null;
                }
            }
        }
        return null;
    }
}

