/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.javafx;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Separator;
import javafx.scene.control.ToolBar;
import javafx.scene.input.MouseEvent;
import org.jpedal.display.Display;
import org.jpedal.display.GUIDisplay;
import org.jpedal.examples.viewer.gui.CommandListener;
import org.jpedal.examples.viewer.gui.GUI;
import org.jpedal.examples.viewer.gui.generic.GUIButton;
import org.jpedal.examples.viewer.gui.generic.GUIButtons;
import org.jpedal.examples.viewer.gui.generic.GUIMenuItems;
import org.jpedal.examples.viewer.gui.javafx.JavaFXButton;
import org.jpedal.gui.GUIFactory;

public class JavaFXButtons
implements GUIButtons {
    private ToolBar topButtons = new ToolBar();
    ArrayList<CheckMenuItem> layoutGroup = new ArrayList();
    private GUIButton mouseMode;
    private GUIButton nextSearch;
    private GUIButton previousSearch;
    private GUIButton searchButton;
    private GUIButton openButton;
    private GUIButton printButton;
    private GUIButton docPropButton;
    private GUIButton infoButton;
    private GUIButton snapshotButton;
    private GUIButton singleButton;
    private GUIButton continuousButton;
    private GUIButton continuousFacingButton;
    private GUIButton facingButton;
    private GUIButton pageFlowButton;
    private GUIButton first;
    private GUIButton fback;
    private GUIButton back;
    private GUIButton forward;
    private GUIButton fforward;
    private GUIButton last;
    private GUIButton buyButton;
    private GUIButton helpButton;
    private GUIButton rssButton;
    private boolean isSingle;

    public void init(boolean isSingle) {
        this.isSingle = isSingle;
        this.previousSearch = new JavaFXButton();
        this.nextSearch = new JavaFXButton();
        this.searchButton = new JavaFXButton();
        this.first = new JavaFXButton();
        this.fback = new JavaFXButton();
        this.back = new JavaFXButton();
        this.forward = new JavaFXButton();
        this.fforward = new JavaFXButton();
        this.last = new JavaFXButton();
        this.snapshotButton = new JavaFXButton();
        this.buyButton = new JavaFXButton();
        this.helpButton = new JavaFXButton();
        this.rssButton = new JavaFXButton();
        this.singleButton = new JavaFXButton();
        this.continuousButton = new JavaFXButton();
        this.continuousFacingButton = new JavaFXButton();
        this.facingButton = new JavaFXButton();
        this.pageFlowButton = new JavaFXButton();
        this.openButton = new JavaFXButton();
        this.printButton = new JavaFXButton();
        this.docPropButton = new JavaFXButton();
        this.infoButton = new JavaFXButton();
        this.mouseMode = new JavaFXButton();
        JavaFXButtons.setupButtonStyle();
    }

    @Override
    public GUIButton getButton(int ID2) {
        switch (ID2) {
            case 13: {
                return this.snapshotButton;
            }
            case 997: {
                return this.rssButton;
            }
            case 998: {
                return this.helpButton;
            }
            case 999: {
                return this.buyButton;
            }
            case 1: {
                return this.infoButton;
            }
            case 9: {
                return this.docPropButton;
            }
            case 6: {
                return this.printButton;
            }
            case 10: {
                return this.openButton;
            }
            case 59: {
                return this.continuousFacingButton;
            }
            case 58: {
                return this.continuousButton;
            }
            case 61: {
                return this.pageFlowButton;
            }
            case 60: {
                return this.facingButton;
            }
            case 57: {
                return this.singleButton;
            }
            case 29: {
                return this.mouseMode;
            }
            case 52: {
                return this.back;
            }
            case 50: {
                return this.first;
            }
            case 51: {
                return this.fback;
            }
            case 53: {
                return this.forward;
            }
            case 54: {
                return this.fforward;
            }
            case 55: {
                return this.last;
            }
            case 12: {
                return this.searchButton;
            }
            case 18: {
                return this.previousSearch;
            }
            case 19: {
                return this.nextSearch;
            }
        }
        return null;
    }

    public void dispose() {
        this.searchButton = null;
        this.nextSearch = null;
        this.previousSearch = null;
        this.first = null;
        this.fback = null;
        this.back = null;
        this.forward = null;
        this.fforward = null;
        this.last = null;
        this.singleButton = null;
        this.continuousButton = null;
        this.continuousFacingButton = null;
        this.facingButton = null;
        this.pageFlowButton = null;
        this.snapshotButton = null;
        this.buyButton = null;
        this.helpButton = null;
        this.rssButton = null;
        this.layoutGroup = null;
        if (this.topButtons != null) {
            this.topButtons.getItems().removeAll((Collection)this.topButtons.getItems());
        }
        this.topButtons = null;
    }

    @Override
    public void setBackNavigationButtonsEnabled(boolean flag) {
        this.back.setEnabled(flag);
        this.first.setEnabled(flag);
        this.fback.setEnabled(flag);
    }

    @Override
    public void setForwardNavigationButtonsEnabled(boolean flag) {
        this.forward.setEnabled(flag);
        this.last.setEnabled(flag);
        this.fforward.setEnabled(flag);
    }

    @Override
    public void setPageLayoutButtonsEnabled(boolean flag) {
        if (!this.isSingle) {
            return;
        }
        this.continuousButton.setEnabled(flag);
        this.continuousFacingButton.setEnabled(flag);
        this.facingButton.setEnabled(flag);
        this.pageFlowButton.setEnabled(flag);
        for (int i = 60; i < 62; ++i) {
            if (i == 61) continue;
            this.disableUnimplementedItems(i);
        }
        Iterator<CheckMenuItem> menuOptions = this.layoutGroup.iterator();
        if (menuOptions.hasNext()) {
            CheckMenuItem item = menuOptions.next();
            item.setDisable(false);
            while (menuOptions.hasNext()) {
                item = menuOptions.next();
                item.setDisable(!flag);
            }
        }
    }

    @Override
    public void alignLayoutMenuOption(int mode) {
        int i = 1;
        for (CheckMenuItem item : this.layoutGroup) {
            item.setSelected(i == mode);
            ++i;
        }
    }

    public ArrayList<CheckMenuItem> getLayoutGroup() {
        return this.layoutGroup;
    }

    @Override
    public void checkButtonSeparators() {
        boolean before = false;
        boolean after = false;
        Separator currentSep = null;
        for (int k = 0; k != this.topButtons.getItems().size(); ++k) {
            if (this.topButtons.getItems().get(k) instanceof Separator) {
                if (currentSep == null) {
                    currentSep = (Separator)this.topButtons.getItems().get(k);
                    continue;
                }
                if (!before || !after) {
                    currentSep.setVisible(false);
                } else {
                    currentSep.setVisible(true);
                }
                before = before || after;
                after = false;
                currentSep = (Separator)this.topButtons.getItems().get(k);
                continue;
            }
            if (!((Node)this.topButtons.getItems().get(k)).isVisible()) continue;
            if (currentSep == null) {
                before = true;
                continue;
            }
            after = true;
        }
        if (currentSep != null) {
            if (!before || !after) {
                currentSep.setVisible(false);
            } else {
                currentSep.setVisible(true);
            }
        }
    }

    public ToolBar getTopButtons() {
        return this.topButtons;
    }

    public void addButton(int line, String toolTip, String path, int ID2, final GUIMenuItems fxMenuItems, final GUIFactory currentGUI, CommandListener currentCommandListener, ToolBar pagesToolBar, ToolBar navToolBar) {
        GUIButton newButton = new JavaFXButton();
        switch (ID2) {
            case 998: {
                newButton = this.getButton(998);
                break;
            }
            case 997: {
                newButton = this.getButton(997);
                break;
            }
            case 999: {
                newButton = this.getButton(999);
                break;
            }
            case 50: {
                newButton = this.getButton(50);
                break;
            }
            case 51: {
                newButton = this.getButton(51);
                break;
            }
            case 52: {
                newButton = this.getButton(52);
                break;
            }
            case 53: {
                newButton = this.getButton(53);
                break;
            }
            case 54: {
                newButton = this.getButton(54);
                break;
            }
            case 55: {
                newButton = this.getButton(55);
                break;
            }
            case 13: {
                newButton = this.getButton(13);
                break;
            }
            case 57: {
                newButton = this.getButton(57);
                newButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent t) {
                        fxMenuItems.setMenusForDisplayMode(57, -1);
                    }
                });
                break;
            }
            case 58: {
                newButton = this.getButton(58);
                newButton.setEnabled(false);
                ((JavaFXButton)newButton).setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent t) {
                        fxMenuItems.setMenusForDisplayMode(58, -1);
                    }
                });
                break;
            }
            case 59: {
                newButton = this.getButton(59);
                newButton.setEnabled(false);
                ((JavaFXButton)newButton).setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent t) {
                        fxMenuItems.setMenusForDisplayMode(59, -1);
                    }
                });
                break;
            }
            case 60: {
                newButton = this.getButton(60);
                newButton.setEnabled(false);
                break;
            }
            case 61: {
                newButton = this.getButton(61);
                newButton.setEnabled(false);
                break;
            }
            case 18: {
                newButton = this.getButton(18);
                newButton.setEnabled(false);
                newButton.setName("PREVIOUSRESULT");
                break;
            }
            case 19: {
                newButton = this.getButton(19);
                newButton.setEnabled(false);
                newButton.setName("NEXTRESULT");
                break;
            }
            case 10: {
                newButton = this.getButton(10);
                newButton.setName("open");
                break;
            }
            case 6: {
                newButton = this.getButton(6);
                newButton.setName("print");
                break;
            }
            case 12: {
                newButton = this.getButton(12);
                newButton.setName("search");
                break;
            }
            case 9: {
                newButton = this.getButton(9);
                break;
            }
            case 1: {
                newButton = this.getButton(1);
                break;
            }
            case 29: {
                newButton = this.getButton(29);
                newButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent t) {
                        if (currentGUI.getPdfDecoder().getDisplayView() == 1) {
                            fxMenuItems.setMenusForDisplayMode(29, currentGUI.getCommand().getMouseMode().getMouseMode());
                        }
                    }
                });
                newButton.setName("mousemode");
            }
        }
        newButton.setOnMouseEntered((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent me) {
                if (GUIDisplay.allowChangeCursor) {
                    ((JavaFXButton)me.getSource()).setCursor(Cursor.HAND);
                }
            }
        });
        ((JavaFXButton)newButton).setOnMouseExited((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent me) {
                if (GUIDisplay.allowChangeCursor) {
                    ((JavaFXButton)me.getSource()).setCursor(Cursor.DEFAULT);
                }
            }
        });
        newButton.init(currentGUI.getGUICursor().getURLForImage(path), ID2, toolTip);
        ((JavaFXButton)newButton).setOnAction((EventHandler)currentCommandListener.getCommandListener());
        int mode = currentGUI.getValues().getModeOfOperation();
        if (line == 0 || mode == 4) {
            this.topButtons.getItems().add((Object)((Button)newButton));
        } else if (line == 1) {
            navToolBar.getItems().add((Object)((Button)newButton));
        } else if (line == 2) {
            pagesToolBar.getItems().add((Object)((Button)newButton));
        }
        this.disableUnimplementedItems(ID2);
    }

    @Override
    public void hideRedundentNavButtons(GUIFactory currentGUI) {
        int maxPages = currentGUI.getPdfDecoder().getPageCount();
        if (currentGUI.getValues().isMultiTiff()) {
            maxPages = currentGUI.getValues().getPageCount();
        }
        if ((currentGUI.getPdfDecoder().getDisplayView() == 4 && currentGUI.getPdfDecoder().getPages().getBoolean(Display.BoolValue.SEPARATE_COVER) || currentGUI.getPdfDecoder().getDisplayView() == 3) && (maxPages & 1) == 1) {
            --maxPages;
        }
        if (currentGUI.getValues().getCurrentPage() == 1) {
            this.setBackNavigationButtonsEnabled(false);
            currentGUI.getMenuItems().setBackNavigationItemsEnabled(false);
        } else {
            this.setBackNavigationButtonsEnabled(true);
            currentGUI.getMenuItems().setBackNavigationItemsEnabled(true);
        }
        if (currentGUI.getValues().getCurrentPage() == maxPages) {
            this.setForwardNavigationButtonsEnabled(false);
            currentGUI.getMenuItems().setForwardNavigationItemsEnabled(false);
        } else {
            this.setForwardNavigationButtonsEnabled(true);
            currentGUI.getMenuItems().setForwardNavigationItemsEnabled(true);
        }
        currentGUI.getMenuItems().setGoToNavigationItemEnabled(maxPages != 1);
        if (currentGUI.getThumbnailScrollBar() != null) {
            if (currentGUI.getPdfDecoder().getDisplayView() == 1) {
                currentGUI.setScrollBarPolicy(GUI.ScrollPolicy.VERTICAL_NEVER);
                currentGUI.setScrollBarPolicy(GUI.ScrollPolicy.HORIZONTAL_NEVER);
                currentGUI.setThumbnailScrollBarVisibility(true);
            } else if (currentGUI.getPdfDecoder().getDisplayView() == 5) {
                currentGUI.setScrollBarPolicy(GUI.ScrollPolicy.VERTICAL_NEVER);
                currentGUI.setScrollBarPolicy(GUI.ScrollPolicy.HORIZONTAL_NEVER);
                currentGUI.setThumbnailScrollBarVisibility(false);
            } else {
                currentGUI.setScrollBarPolicy(GUI.ScrollPolicy.VERTICAL_AS_NEEDED);
                currentGUI.setScrollBarPolicy(GUI.ScrollPolicy.HORIZONTAL_AS_NEEDED);
                currentGUI.setThumbnailScrollBarVisibility(false);
            }
        }
    }

    public static void setupButtonStyle() {
    }

    @Override
    public void setVisible(boolean set) {
        this.topButtons.setVisible(set);
    }

    @Override
    public void setEnabled(boolean set) {
        this.topButtons.setDisable(!set);
    }

    public void disableUnimplementedItems(int ID2) {
        boolean debug = false;
        int ALL = -10;
        if (ID2 != -10) {
            switch (ID2) {
                case 6: {
                    this.printButton.setEnabled(false);
                    break;
                }
                case 59: {
                    this.continuousFacingButton.setEnabled(false);
                    break;
                }
                case 61: {
                    this.pageFlowButton.setEnabled(false);
                    break;
                }
                case 58: {
                    this.continuousButton.setEnabled(false);
                }
            }
        } else {
            this.printButton.setEnabled(false);
            this.continuousFacingButton.setEnabled(false);
            this.facingButton.setEnabled(false);
            this.continuousButton.setEnabled(false);
        }
    }
}

