/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.javafx;

import java.util.Map;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.CheckBoxTreeItem;
import javafx.scene.control.Tab;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.CheckBoxTreeCell;
import javafx.scene.layout.BorderPane;
import javafx.util.Callback;
import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.viewer.gui.generic.GUILayersPanel;
import org.jpedal.objects.layers.PdfLayerList;

public class JavaFXLayersPanel
extends Tab
implements GUILayersPanel {
    private final BorderPane content;
    private final TreeItem<String> metaDataRoot;
    private final TreeView<String> layersTree;

    public JavaFXLayersPanel() {
        TreeView metaDataTree = new TreeView();
        this.content = new BorderPane();
        this.layersTree = new TreeView();
        this.metaDataRoot = new TreeItem((Object)"Info");
        metaDataTree.setRoot(this.metaDataRoot);
        metaDataTree.setShowRoot(true);
        metaDataTree.setTooltip(new Tooltip("Double click to see any metadata"));
        metaDataTree.setPrefHeight(60.0);
        this.layersTree.setCellFactory((Callback)new Callback<TreeView<String>, TreeCell<String>>(){

            public TreeCell<String> call(TreeView<String> param) {
                return new LayersCell();
            }
        });
        this.layersTree.setShowRoot(true);
        this.content.setTop((Node)metaDataTree);
        this.content.setCenter(this.layersTree);
        this.setContent((Node)this.content);
    }

    @Override
    public void reinitialise(final PdfLayerList layersObject, final PdfDecoderInt decode_pdf, Object scrollPane, final int currentPage) {
        this.metaDataRoot.getChildren().clear();
        this.layersTree.setRoot(null);
        Map metaData = layersObject.getMetaData();
        for (Object nextKey : metaData.keySet()) {
            Object value = metaData.get(nextKey);
            this.metaDataRoot.getChildren().add((Object)new TreeItem((Object)(nextKey + "=" + value)));
        }
        Object[] layerNames = layersObject.getDisplayTree();
        if (layerNames != null) {
            TreeItem layersRoot = new TreeItem((Object)"Layers");
            JavaFXLayersPanel.addLayersToTree(layerNames, (TreeItem<String>)layersRoot, true, layersObject);
            layersRoot.addEventHandler(CheckBoxTreeItem.checkBoxSelectionChangedEvent(), (EventHandler)new EventHandler<CheckBoxTreeItem.TreeModificationEvent<String>>(){

                public void handle(CheckBoxTreeItem.TreeModificationEvent<String> t) {
                    final CheckBoxTreeItem node = t.getTreeItem();
                    StringBuilder rawName = new StringBuilder((String)node.getValue());
                    TreeItem parent = node.getParent();
                    while (parent.getParent() != null) {
                        rawName.append('\uffff').append(parent.getValue());
                        parent = parent.getParent();
                    }
                    final String name = rawName.toString();
                    if (layersObject.isLayerName(name) && !layersObject.isLocked(name)) {
                        Runnable updateComponent = new Runnable(){

                            @Override
                            public void run() {
                                layersObject.setVisiblity(name, node.isSelected());
                                try {
                                    decode_pdf.decodePage(currentPage);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        };
                        if (Platform.isFxApplicationThread()) {
                            updateComponent.run();
                        } else {
                            Platform.runLater((Runnable)updateComponent);
                        }
                    }
                }
            });
            layersRoot.setExpanded(true);
            this.layersTree.setRoot(layersRoot);
        }
    }

    private static void addLayersToTree(Object[] layerNames, TreeItem<String> topLayer, boolean isEnabled, PdfLayerList layersObject) {
        TreeItem currentNode = topLayer;
        boolean parentEnabled = isEnabled;
        boolean parentIsSelected = true;
        for (Object layerName : layerNames) {
            if (layerName instanceof Object[]) {
                TreeItem oldNode = currentNode;
                JavaFXLayersPanel.addLayersToTree((Object[])layerName, currentNode, isEnabled && parentIsSelected, layersObject);
                currentNode = oldNode;
                isEnabled = parentEnabled;
                continue;
            }
            parentEnabled = isEnabled;
            if (layerName == null) continue;
            String name = layerName instanceof String ? (String)layerName : new String((byte[])layerName);
            String title = name;
            int ptr = name.indexOf(65535);
            if (ptr != -1) {
                title = title.substring(0, ptr);
            }
            if (name.endsWith(" R")) continue;
            if (!layersObject.isLayerName(name)) {
                currentNode = new TreeItem((Object)title);
                topLayer.getChildren().add((Object)currentNode);
                topLayer = currentNode;
                parentIsSelected = true;
                continue;
            }
            if (topLayer == null) continue;
            currentNode = new CheckBoxTreeItem((Object)title);
            topLayer.getChildren().add((Object)currentNode);
            if (layersObject.isVisible(name)) {
                ((CheckBoxTreeItem)currentNode).setSelected(true);
                parentIsSelected = true;
            } else {
                ((CheckBoxTreeItem)currentNode).setSelected(false);
                parentIsSelected = false;
            }
            if (!isEnabled) continue;
            isEnabled = !layersObject.isLocked(name);
        }
    }

    @Override
    public void rescanPdfLayers() {
    }

    @Override
    public void resetLayers() {
    }

    private static class LayersCell
    extends CheckBoxTreeCell<String> {
        private LayersCell() {
        }

        public void updateItem(String item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setGraphic(null);
                this.setText(null);
            } else if (!(this.getTreeItem() instanceof CheckBoxTreeItem)) {
                this.setGraphic(null);
            }
        }
    }
}

