/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.javafx;

import java.io.File;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.scene.Cursor;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import org.jpedal.PdfDecoderFX;
import org.jpedal.display.Display;
import org.jpedal.examples.viewer.Commands;
import org.jpedal.examples.viewer.MouseMode;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.gui.MouseSelector;
import org.jpedal.examples.viewer.gui.generic.GUIMouseHandler;
import org.jpedal.examples.viewer.gui.javafx.JavaFXMouseFunctionality;
import org.jpedal.examples.viewer.gui.javafx.JavaFXMousePageTurn;
import org.jpedal.examples.viewer.gui.javafx.JavaFXMousePanMode;
import org.jpedal.examples.viewer.gui.javafx.JavaFXMouseSelector;
import org.jpedal.exception.PdfException;
import org.jpedal.gui.GUIFactory;
import org.jpedal.io.PdfObjectReader;

public class JavaFXMouseListener
extends MouseSelector
implements GUIMouseHandler {
    private final PdfDecoderFX decode_pdf;
    private final GUIFactory currentGUI;
    private final Values commonValues;
    private final Commands currentCommands;
    final JavaFXMouseSelector selectionFunctions;
    final JavaFXMousePanMode panningFunctions;
    final JavaFXMousePageTurn pageTurnFunctions;
    private boolean dragging;
    private static JavaFXMouseFunctionality customMouseFunctions;
    private double cx;
    private double cy;
    private static final String message = "";
    private MouseMode mouseMode = new MouseMode();

    public JavaFXMouseListener(PdfDecoderFX decode_pdf, GUIFactory currentGUI, Values commonValues, Commands currentCommands) {
        this.decode_pdf = decode_pdf;
        this.currentGUI = currentGUI;
        this.commonValues = commonValues;
        this.currentCommands = currentCommands;
        this.mouseMode = currentCommands.getMouseMode();
        this.selectionFunctions = new JavaFXMouseSelector(decode_pdf, currentGUI, commonValues, currentCommands);
        this.panningFunctions = new JavaFXMousePanMode(decode_pdf);
        this.pageTurnFunctions = new JavaFXMousePageTurn(decode_pdf, currentGUI, commonValues, currentCommands);
    }

    @Override
    public void setupMouse() {
        this.decode_pdf.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent e) {
                JavaFXMouseListener.this.dragging = true;
                JavaFXMouseListener.this.mouseDragged(e);
            }
        });
        this.decode_pdf.setOnMouseMoved((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent e) {
                JavaFXMouseListener.this.mouseMoved(e);
            }
        });
        this.decode_pdf.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent e) {
                if (JavaFXMouseListener.this.dragging) {
                    JavaFXMouseListener.this.dragging = false;
                } else {
                    JavaFXMouseListener.this.mouseClicked(e);
                }
            }
        });
        this.decode_pdf.setOnMouseEntered((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent e) {
                JavaFXMouseListener.this.mouseEntered(e);
            }
        });
        this.decode_pdf.setOnMouseExited((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent e) {
                JavaFXMouseListener.this.mouseExited(e);
            }
        });
        this.decode_pdf.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent e) {
                JavaFXMouseListener.this.dragging = false;
                JavaFXMouseListener.this.mousePressed(e);
            }
        });
        this.decode_pdf.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent e) {
                JavaFXMouseListener.this.mouseReleased(e);
            }
        });
        this.decode_pdf.setOnDragOver((EventHandler)new EventHandler<DragEvent>(){

            public void handle(DragEvent event) {
                JavaFXMouseListener.mouseDragOver(event);
            }
        });
        this.decode_pdf.setOnDragDropped((EventHandler)new EventHandler<DragEvent>(){

            public void handle(DragEvent event) {
                JavaFXMouseListener.this.mouseDragDropped(event);
            }
        });
        this.decode_pdf.setDefaultCursor(Cursor.DEFAULT);
    }

    private void mouseReleased(MouseEvent e) {
        if (e.getButton().equals((Object)MouseButton.MIDDLE)) {
            this.panningFunctions.mouseReleased(e);
        } else {
            switch (this.mouseMode.getMouseMode()) {
                case 0: {
                    this.selectionFunctions.mouseReleased(e);
                    break;
                }
                case 1: {
                    this.panningFunctions.mouseReleased(e);
                }
            }
            if (this.decode_pdf.getPages().getBoolean(Display.BoolValue.TURNOVER_ON) && this.decode_pdf.getDisplayView() == 4) {
                this.pageTurnFunctions.mouseReleased(e);
            }
            if (customMouseFunctions != null) {
                customMouseFunctions.mouseReleased(e);
            }
        }
    }

    public static void setCustomMouseFunctions(JavaFXMouseFunctionality cmf) {
        customMouseFunctions = cmf;
    }

    private void mouseDragDropped(DragEvent e) {
        Dragboard db = e.getDragboard();
        boolean success = false;
        if (db.hasFiles()) {
            success = true;
            final File file = (File)db.getFiles().get(0);
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        JavaFXMouseListener.this.currentCommands.handleTransferedFile(file.getAbsolutePath());
                    }
                    catch (PdfException ex) {
                        ex.printStackTrace();
                    }
                }
            });
        }
        e.setDropCompleted(success);
        e.consume();
    }

    private static void mouseDragOver(DragEvent e) {
        Dragboard db = e.getDragboard();
        boolean isAccepted = ((File)db.getFiles().get(0)).getName().toLowerCase().endsWith(".pdf");
        if (db.hasFiles()) {
            if (isAccepted) {
                e.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
            }
        } else {
            e.consume();
        }
    }

    private void mouseClicked(MouseEvent e) {
        switch (this.mouseMode.getMouseMode()) {
            case 0: {
                if (!this.decode_pdf.isOpen()) break;
                this.selectionFunctions.mouseClicked(e);
                break;
            }
        }
        if (this.decode_pdf.getPages().getBoolean(Display.BoolValue.TURNOVER_ON) && this.decode_pdf.getDisplayView() == 4) {
            this.pageTurnFunctions.mouseClicked(e);
        }
        if (customMouseFunctions != null) {
            customMouseFunctions.mouseClicked(e);
        }
    }

    private void mouseEntered(MouseEvent e) {
        this.currentGUI.enableMemoryBar(true, false);
        this.currentGUI.enableCursor(true, true);
        this.currentGUI.setMultibox(new int[]{1, 1});
        switch (this.mouseMode.getMouseMode()) {
            case 0: {
                break;
            }
        }
        if (this.decode_pdf.getPages().getBoolean(Display.BoolValue.TURNOVER_ON) && this.decode_pdf.getDisplayView() == 4) {
            this.pageTurnFunctions.mouseEntered(e);
        }
        if (customMouseFunctions != null) {
            customMouseFunctions.mouseEntered(e);
        }
    }

    private void mousePressed(MouseEvent e) {
        if (e.getButton().equals((Object)MouseButton.MIDDLE)) {
            this.panningFunctions.mousePressed(e);
        } else {
            switch (this.mouseMode.getMouseMode()) {
                case 0: {
                    this.selectionFunctions.mousePressed(e);
                    break;
                }
                case 1: {
                    this.panningFunctions.mousePressed(e);
                }
            }
            if (this.decode_pdf.getPages().getBoolean(Display.BoolValue.TURNOVER_ON) && this.decode_pdf.getDisplayView() == 4) {
                this.pageTurnFunctions.mousePressed(e);
            }
            if (customMouseFunctions != null) {
                customMouseFunctions.mousePressed(e);
            }
        }
    }

    private void mouseMoved(MouseEvent e) {
        int x = (int)e.getX();
        int y = (int)e.getY();
        this.updateCoords(x, y);
        switch (this.mouseMode.getMouseMode()) {
            case 0: {
                if (!this.currentCommands.extractingAsImage && this.decode_pdf.isOpen()) {
                    int pagenumber = this.decode_pdf.getPageNumber();
                    int crx = this.decode_pdf.getPdfPageData().getCropBoxX(pagenumber);
                    int cry = this.decode_pdf.getPdfPageData().getCropBoxY(pagenumber);
                    this.getObjectUnderneath((int)this.cx + crx, (int)this.cy + cry);
                }
                this.selectionFunctions.mouseMoved(e);
                break;
            }
        }
        if (this.decode_pdf.getPages().getBoolean(Display.BoolValue.TURNOVER_ON) && this.decode_pdf.getDisplayView() == 4) {
            this.pageTurnFunctions.mouseMoved(e);
        }
        if (customMouseFunctions != null) {
            customMouseFunctions.mouseMoved(e);
        }
    }

    private void mouseDragged(MouseEvent e) {
        if (e.getButton().equals((Object)MouseButton.MIDDLE)) {
            this.panningFunctions.mouseDragged(e);
        } else {
            switch (this.mouseMode.getMouseMode()) {
                case 0: {
                    this.selectionFunctions.mouseDragged(e);
                    break;
                }
                case 1: {
                    this.panningFunctions.mouseDragged(e);
                }
            }
            if (this.decode_pdf.getPages().getBoolean(Display.BoolValue.TURNOVER_ON) && this.decode_pdf.getDisplayView() == 4) {
                this.pageTurnFunctions.mouseDragged(e);
            }
            if (customMouseFunctions != null) {
                customMouseFunctions.mouseDragged(e);
            }
        }
    }

    private void mouseExited(MouseEvent e) {
        this.currentGUI.enableCursor(true, false);
        this.currentGUI.enableMemoryBar(true, true);
        this.currentGUI.setMultibox(new int[]{1, 0});
        switch (this.mouseMode.getMouseMode()) {
            case 0: {
                this.selectionFunctions.mouseExited(e);
                break;
            }
        }
        if (this.decode_pdf.getPages().getBoolean(Display.BoolValue.TURNOVER_ON) && this.decode_pdf.getDisplayView() == 4) {
            this.pageTurnFunctions.mouseExited(e);
        }
        if (customMouseFunctions != null) {
            customMouseFunctions.mouseExited(e);
        }
    }

    public double[] getCursorLocation() {
        return new double[]{this.cx, this.cy};
    }

    public void checkLinks(boolean mouseClicked, PdfObjectReader pdfObjectReader) {
        this.pageTurnFunctions.checkLinks(mouseClicked, pdfObjectReader, this.cx, this.cy);
    }

    public void updateCordsFromFormComponent(MouseEvent e) {
        double x = (int)e.getX();
        double y = (int)e.getY();
        this.updateCoords(x, y);
    }

    public void updateCoords(double x, double y) {
        this.cx = x;
        this.cy = y;
        if (this.decode_pdf.getDisplayView() != 1) {
            if (this.decode_pdf.getDisplayView() == 4 || this.decode_pdf.getDisplayView() == 2 || this.decode_pdf.getDisplayView() == 3) {
                int xOffset;
                if (this.decode_pdf.getDisplayView() == 4 && this.decode_pdf.getPageNumber() < this.decode_pdf.getPageCount() && this.cx >= (double)(xOffset = this.decode_pdf.getPdfPageData().getCropBoxWidth(this.decode_pdf.getPageNumber()))) {
                    this.cx -= (double)xOffset;
                }
            } else {
                this.cx = 0.0;
                this.cy = 0.0;
            }
        }
        int pagenumber = this.decode_pdf.getPageNumber();
        int crx = this.decode_pdf.getPdfPageData().getCropBoxX(pagenumber);
        int cry = this.decode_pdf.getPdfPageData().getCropBoxY(pagenumber);
        Bounds pdfBounds = this.decode_pdf.getBoundsInLocal();
        if (Values.isProcessing() || this.commonValues.getSelectedFile() == null) {
            this.currentGUI.setCoordText("  X:  Y:   ");
        } else if (this.cx >= 0.0 && this.cy >= 0.0 && this.cx <= pdfBounds.getMaxX() - (double)this.currentGUI.getDropShadowDepth() && this.cy <= pdfBounds.getMaxY() - (double)this.currentGUI.getDropShadowDepth()) {
            this.currentGUI.setCoordText("  X: " + (this.cx + (double)crx) + " Y: " + (this.cy + (double)cry) + ' ' + ' ' + message);
        }
    }

    protected void scrollAndUpdateCoords(MouseEvent e) {
        int x = (int)e.getX();
        int y = (int)e.getY();
        this.updateCoords(x, y);
    }

    private void getObjectUnderneath(int x, int y) {
        if (this.decode_pdf.getDisplayView() == 1) {
            int type = this.decode_pdf.getDynamicRenderer().getObjectUnderneath(x, y);
            switch (type) {
                case -1: {
                    this.decode_pdf.setCursor(Cursor.DEFAULT);
                    break;
                }
                case 1: {
                    this.decode_pdf.setCursor(Cursor.TEXT);
                    break;
                }
                case 3: {
                    this.decode_pdf.setCursor(Cursor.CROSSHAIR);
                    break;
                }
                case 4: {
                    this.decode_pdf.setCursor(Cursor.TEXT);
                    break;
                }
                case 5: {
                    this.decode_pdf.setCursor(Cursor.TEXT);
                    break;
                }
                case 6: {
                    this.decode_pdf.setCursor(Cursor.TEXT);
                }
            }
        }
    }

    @Override
    public void dispose() {
    }
}

